/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.oauth.mockserver.server;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.RSAKey;
import io.confluent.security.auth.oauth.mockserver.common.RSAKeyProvider;
import io.confluent.security.auth.oauth.mockserver.common.ServerFailedToConnectException;
import io.confluent.security.auth.oauth.mockserver.common.SupportedAlgorithms;
import io.confluent.security.auth.oauth.mockserver.server.AuthServerRequestHandler;
import io.confluent.security.auth.oauth.mockserver.server.CommonHttp;
import io.confluent.security.auth.oauth.mockserver.server.URLEndpoints;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.SelfSignedCertificate;
import io.vertx.core.net.TrustOptions;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jose4j.json.internal.json_simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockOAuthServer
extends AbstractVerticle {
    private static final Logger log = LoggerFactory.getLogger(MockOAuthServer.class);
    public SelfSignedCertificate certificate = SelfSignedCertificate.create();
    public static Map<String, RSAKey> keys = new HashMap<String, RSAKey>();
    private final Map<String, String> clients = new HashMap<String, String>();
    HttpServer authServer;
    private int authServerPort;
    ServerSocket serverSocket = null;

    public int getAuthServerPort() {
        return this.authServerPort;
    }

    private int getFreePort() throws IOException {
        ServerSocket serverSocket = new ServerSocket(0);
        int freePort = serverSocket.getLocalPort();
        serverSocket.close();
        return freePort;
    }

    public void startServer() throws Exception {
        this.startServer(this.getFreePort());
    }

    public void startServer(boolean connect) throws Exception {
        this.startServer(this.getFreePort(), connect);
    }

    public void startServer(int authPort) throws Exception {
        this.startServer(authPort, false);
    }

    public void startServer(int authPort, boolean connect) throws Exception {
        this.authServerPort = authPort < 65000 ? authPort : this.getFreePort();
        this.vertx = Vertx.vertx();
        this.vertx.deployVerticle((Verticle)new MockOAuthServer());
        this.startAuthServer();
        if (connect) {
            this.connectToServer();
        }
        this.getSigKey(SupportedAlgorithms.RS256, "Confluent");
    }

    protected void startAuthServer() {
        HttpServerOptions serverOptions = new HttpServerOptions().setSsl(true).setKeyCertOptions((KeyCertOptions)this.certificate.keyCertOptions()).setTrustOptions((TrustOptions)this.certificate.trustOptions());
        this.authServer = this.vertx.createHttpServer(serverOptions).requestHandler((Handler)new AuthServerRequestHandler(this));
        this.authServer.listen(this.authServerPort, "localhost");
    }

    public void stopServer() {
        this.authServer.close();
    }

    synchronized RSAKey getSigKey(SupportedAlgorithms algorithms, String kid) throws Exception {
        if (keys.containsKey(kid) && keys.get(kid).getAlgorithm().equals((Object)algorithms.getAlgorithm())) {
            return keys.get(kid);
        }
        RSAKey key = (RSAKey)RSAKeyProvider.getRSAKey(algorithms, kid);
        keys.put(kid, key);
        return key;
    }

    public Map<String, JWK> getKeys() {
        HashMap<String, JWK> publicKeys = new HashMap<String, JWK>();
        keys.forEach((keyID, key) -> publicKeys.put((String)keyID, (JWK)new RSAKey.Builder(key.toPublicJWK()).build()));
        return publicKeys;
    }

    void createOrUpdateClient(String clientId, String secret) {
        this.clients.put(clientId, secret);
    }

    Map<String, String> getClients() {
        return Collections.unmodifiableMap(this.clients);
    }

    public JSONObject getConfig() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"auth-server-port", (Object)this.authServerPort);
        jsonObject.put((Object)"token-url", (Object)URLEndpoints.getTokenURL(this.authServerPort));
        jsonObject.put((Object)"jwks-url", (Object)URLEndpoints.getJwksURL(this.authServerPort));
        return jsonObject;
    }

    public void connectToServer() throws ServerFailedToConnectException {
        int[] sleepDurations = new int[]{250, 500, 0};
        try {
            for (int counter = 0; counter < 3; ++counter) {
                try {
                    CommonHttp.sendGET(URLEndpoints.getJwksURL(this.authServerPort));
                    return;
                }
                catch (Exception e) {
                    Thread.sleep(sleepDurations[counter]);
                    continue;
                }
            }
        }
        catch (InterruptedException e) {
            log.error("Sleep interrupted! Retry connecting to the server");
        }
        log.error("The MockOAuthServer failed to connect even after multiple attempts. Server will be crashed now!");
        this.stopServer();
        throw new ServerFailedToConnectException("MockOAuthServer has issues in connecting");
    }
}

