/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.protobuf.events.catalog.v1;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import io.confluent.protobuf.events.catalog.v1.ConnectMetadataOrBuilder;
import io.confluent.protobuf.events.catalog.v1.Metadata;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;

public final class ConnectMetadata
extends GeneratedMessageV3
implements ConnectMetadataOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int CLUSTER_ID_FIELD_NUMBER = 1;
    private volatile Object clusterId_ = "";
    public static final int NAME_FIELD_NUMBER = 2;
    private volatile Object name_ = "";
    public static final int KAFKA_CLUSTER_ID_FIELD_NUMBER = 3;
    private volatile Object kafkaClusterId_ = "";
    public static final int CLASS_FIELD_NUMBER = 4;
    private volatile Object class__ = "";
    public static final int TYPE_FIELD_NUMBER = 5;
    private int type_ = 0;
    public static final int STATUS_FIELD_NUMBER = 6;
    private int status_ = 0;
    public static final int TASKS_MAX_FIELD_NUMBER = 7;
    private int tasksMax_ = 0;
    public static final int TOPICS_FIELD_NUMBER = 8;
    private LazyStringArrayList topics_ = LazyStringArrayList.emptyList();
    public static final int CREATE_TIME_FIELD_NUMBER = 9;
    private Timestamp createTime_;
    public static final int UPDATE_TIME_FIELD_NUMBER = 10;
    private Timestamp updateTime_;
    public static final int KAFKA_AUTH_MODE_FIELD_NUMBER = 11;
    private int kafkaAuthMode_ = 0;
    public static final int KAFKA_SERVICE_ACCOUNT_ID_FIELD_NUMBER = 12;
    private volatile Object kafkaServiceAccountId_ = "";
    public static final int KAFKA_API_KEY_FIELD_NUMBER = 13;
    private volatile Object kafkaApiKey_ = "";
    public static final int DLQ_TOPIC_FIELD_NUMBER = 14;
    private volatile Object dlqTopic_ = "";
    public static final int INPUT_FORMAT_FIELD_NUMBER = 15;
    private volatile Object inputFormat_ = "";
    public static final int OUTPUT_FORMAT_FIELD_NUMBER = 16;
    private volatile Object outputFormat_ = "";
    public static final int SOURCE_SCHEMA_FIELD_NUMBER = 17;
    private volatile Object sourceSchema_ = "";
    public static final int SOURCE_ENDPOINT_FIELD_NUMBER = 18;
    private volatile Object sourceEndpoint_ = "";
    public static final int OWNER_FIELD_NUMBER = 19;
    private volatile Object owner_ = "";
    private byte memoizedIsInitialized = (byte)-1;
    private static final ConnectMetadata DEFAULT_INSTANCE = new ConnectMetadata();
    private static final Parser<ConnectMetadata> PARSER = new AbstractParser<ConnectMetadata>(){

        public ConnectMetadata parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = ConnectMetadata.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private ConnectMetadata(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private ConnectMetadata() {
        this.clusterId_ = "";
        this.name_ = "";
        this.kafkaClusterId_ = "";
        this.class__ = "";
        this.type_ = 0;
        this.status_ = 0;
        this.topics_ = LazyStringArrayList.emptyList();
        this.kafkaAuthMode_ = 0;
        this.kafkaServiceAccountId_ = "";
        this.kafkaApiKey_ = "";
        this.dlqTopic_ = "";
        this.inputFormat_ = "";
        this.outputFormat_ = "";
        this.sourceSchema_ = "";
        this.sourceEndpoint_ = "";
        this.owner_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new ConnectMetadata();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return Metadata.internal_static_catalog_v1_ConnectMetadata_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return Metadata.internal_static_catalog_v1_ConnectMetadata_fieldAccessorTable.ensureFieldAccessorsInitialized(ConnectMetadata.class, Builder.class);
    }

    @Override
    public String getClusterId() {
        Object ref = this.clusterId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.clusterId_ = s;
        return s;
    }

    @Override
    public ByteString getClusterIdBytes() {
        Object ref = this.clusterId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.clusterId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getKafkaClusterId() {
        Object ref = this.kafkaClusterId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.kafkaClusterId_ = s;
        return s;
    }

    @Override
    public ByteString getKafkaClusterIdBytes() {
        Object ref = this.kafkaClusterId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.kafkaClusterId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getClass_() {
        Object ref = this.class__;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.class__ = s;
        return s;
    }

    @Override
    public ByteString getClass_Bytes() {
        Object ref = this.class__;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.class__ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getTypeValue() {
        return this.type_;
    }

    @Override
    public ConnectorType getType() {
        ConnectorType result = ConnectorType.forNumber(this.type_);
        return result == null ? ConnectorType.UNRECOGNIZED : result;
    }

    @Override
    public int getStatusValue() {
        return this.status_;
    }

    @Override
    public ConnectorStatus getStatus() {
        ConnectorStatus result = ConnectorStatus.forNumber(this.status_);
        return result == null ? ConnectorStatus.UNRECOGNIZED : result;
    }

    @Override
    public int getTasksMax() {
        return this.tasksMax_;
    }

    public ProtocolStringList getTopicsList() {
        return this.topics_;
    }

    @Override
    public int getTopicsCount() {
        return this.topics_.size();
    }

    @Override
    public String getTopics(int index) {
        return this.topics_.get(index);
    }

    @Override
    public ByteString getTopicsBytes(int index) {
        return this.topics_.getByteString(index);
    }

    @Override
    public boolean hasCreateTime() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public Timestamp getCreateTime() {
        return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
    }

    @Override
    public TimestampOrBuilder getCreateTimeOrBuilder() {
        return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
    }

    @Override
    public boolean hasUpdateTime() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public Timestamp getUpdateTime() {
        return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
    }

    @Override
    public TimestampOrBuilder getUpdateTimeOrBuilder() {
        return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
    }

    @Override
    public int getKafkaAuthModeValue() {
        return this.kafkaAuthMode_;
    }

    @Override
    public KafkaAuthMode getKafkaAuthMode() {
        KafkaAuthMode result = KafkaAuthMode.forNumber(this.kafkaAuthMode_);
        return result == null ? KafkaAuthMode.UNRECOGNIZED : result;
    }

    @Override
    public String getKafkaServiceAccountId() {
        Object ref = this.kafkaServiceAccountId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.kafkaServiceAccountId_ = s;
        return s;
    }

    @Override
    public ByteString getKafkaServiceAccountIdBytes() {
        Object ref = this.kafkaServiceAccountId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.kafkaServiceAccountId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getKafkaApiKey() {
        Object ref = this.kafkaApiKey_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.kafkaApiKey_ = s;
        return s;
    }

    @Override
    public ByteString getKafkaApiKeyBytes() {
        Object ref = this.kafkaApiKey_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.kafkaApiKey_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getDlqTopic() {
        Object ref = this.dlqTopic_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.dlqTopic_ = s;
        return s;
    }

    @Override
    public ByteString getDlqTopicBytes() {
        Object ref = this.dlqTopic_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.dlqTopic_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getInputFormat() {
        Object ref = this.inputFormat_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.inputFormat_ = s;
        return s;
    }

    @Override
    public ByteString getInputFormatBytes() {
        Object ref = this.inputFormat_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.inputFormat_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getOutputFormat() {
        Object ref = this.outputFormat_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.outputFormat_ = s;
        return s;
    }

    @Override
    public ByteString getOutputFormatBytes() {
        Object ref = this.outputFormat_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.outputFormat_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getSourceSchema() {
        Object ref = this.sourceSchema_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.sourceSchema_ = s;
        return s;
    }

    @Override
    public ByteString getSourceSchemaBytes() {
        Object ref = this.sourceSchema_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.sourceSchema_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getSourceEndpoint() {
        Object ref = this.sourceEndpoint_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.sourceEndpoint_ = s;
        return s;
    }

    @Override
    public ByteString getSourceEndpointBytes() {
        Object ref = this.sourceEndpoint_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.sourceEndpoint_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getOwner() {
        Object ref = this.owner_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.owner_ = s;
        return s;
    }

    @Override
    public ByteString getOwnerBytes() {
        Object ref = this.owner_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.owner_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.clusterId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.clusterId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.kafkaClusterId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.kafkaClusterId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.class__)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.class__);
        }
        if (this.type_ != ConnectorType.SOURCE.getNumber()) {
            output.writeEnum(5, this.type_);
        }
        if (this.status_ != ConnectorStatus.NONE.getNumber()) {
            output.writeEnum(6, this.status_);
        }
        if (this.tasksMax_ != 0) {
            output.writeInt32(7, this.tasksMax_);
        }
        for (int i = 0; i < this.topics_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)8, (Object)this.topics_.getRaw(i));
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(9, (MessageLite)this.getCreateTime());
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(10, (MessageLite)this.getUpdateTime());
        }
        if (this.kafkaAuthMode_ != KafkaAuthMode.KAFKA_API_KEY.getNumber()) {
            output.writeEnum(11, this.kafkaAuthMode_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.kafkaServiceAccountId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)12, (Object)this.kafkaServiceAccountId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.kafkaApiKey_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)13, (Object)this.kafkaApiKey_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.dlqTopic_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)14, (Object)this.dlqTopic_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.inputFormat_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)15, (Object)this.inputFormat_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.outputFormat_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)16, (Object)this.outputFormat_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.sourceSchema_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)17, (Object)this.sourceSchema_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.sourceEndpoint_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)18, (Object)this.sourceEndpoint_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.owner_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)19, (Object)this.owner_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.clusterId_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.clusterId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.kafkaClusterId_)) {
            size += GeneratedMessageV3.computeStringSize((int)3, (Object)this.kafkaClusterId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.class__)) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.class__);
        }
        if (this.type_ != ConnectorType.SOURCE.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)5, (int)this.type_);
        }
        if (this.status_ != ConnectorStatus.NONE.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)6, (int)this.status_);
        }
        if (this.tasksMax_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)7, (int)this.tasksMax_);
        }
        int dataSize = 0;
        for (int i = 0; i < this.topics_.size(); ++i) {
            dataSize += ConnectMetadata.computeStringSizeNoTag((Object)this.topics_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getTopicsList().size();
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)this.getCreateTime());
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)10, (MessageLite)this.getUpdateTime());
        }
        if (this.kafkaAuthMode_ != KafkaAuthMode.KAFKA_API_KEY.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)11, (int)this.kafkaAuthMode_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.kafkaServiceAccountId_)) {
            size += GeneratedMessageV3.computeStringSize((int)12, (Object)this.kafkaServiceAccountId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.kafkaApiKey_)) {
            size += GeneratedMessageV3.computeStringSize((int)13, (Object)this.kafkaApiKey_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.dlqTopic_)) {
            size += GeneratedMessageV3.computeStringSize((int)14, (Object)this.dlqTopic_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.inputFormat_)) {
            size += GeneratedMessageV3.computeStringSize((int)15, (Object)this.inputFormat_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.outputFormat_)) {
            size += GeneratedMessageV3.computeStringSize((int)16, (Object)this.outputFormat_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.sourceSchema_)) {
            size += GeneratedMessageV3.computeStringSize((int)17, (Object)this.sourceSchema_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.sourceEndpoint_)) {
            size += GeneratedMessageV3.computeStringSize((int)18, (Object)this.sourceEndpoint_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.owner_)) {
            size += GeneratedMessageV3.computeStringSize((int)19, (Object)this.owner_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ConnectMetadata)) {
            return super.equals(obj);
        }
        ConnectMetadata other = (ConnectMetadata)obj;
        if (!this.getClusterId().equals(other.getClusterId())) {
            return false;
        }
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getKafkaClusterId().equals(other.getKafkaClusterId())) {
            return false;
        }
        if (!this.getClass_().equals(other.getClass_())) {
            return false;
        }
        if (this.type_ != other.type_) {
            return false;
        }
        if (this.status_ != other.status_) {
            return false;
        }
        if (this.getTasksMax() != other.getTasksMax()) {
            return false;
        }
        if (!this.getTopicsList().equals(other.getTopicsList())) {
            return false;
        }
        if (this.hasCreateTime() != other.hasCreateTime()) {
            return false;
        }
        if (this.hasCreateTime() && !this.getCreateTime().equals((Object)other.getCreateTime())) {
            return false;
        }
        if (this.hasUpdateTime() != other.hasUpdateTime()) {
            return false;
        }
        if (this.hasUpdateTime() && !this.getUpdateTime().equals((Object)other.getUpdateTime())) {
            return false;
        }
        if (this.kafkaAuthMode_ != other.kafkaAuthMode_) {
            return false;
        }
        if (!this.getKafkaServiceAccountId().equals(other.getKafkaServiceAccountId())) {
            return false;
        }
        if (!this.getKafkaApiKey().equals(other.getKafkaApiKey())) {
            return false;
        }
        if (!this.getDlqTopic().equals(other.getDlqTopic())) {
            return false;
        }
        if (!this.getInputFormat().equals(other.getInputFormat())) {
            return false;
        }
        if (!this.getOutputFormat().equals(other.getOutputFormat())) {
            return false;
        }
        if (!this.getSourceSchema().equals(other.getSourceSchema())) {
            return false;
        }
        if (!this.getSourceEndpoint().equals(other.getSourceEndpoint())) {
            return false;
        }
        if (!this.getOwner().equals(other.getOwner())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + ConnectMetadata.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getClusterId().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getName().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getKafkaClusterId().hashCode();
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getClass_().hashCode();
        hash = 37 * hash + 5;
        hash = 53 * hash + this.type_;
        hash = 37 * hash + 6;
        hash = 53 * hash + this.status_;
        hash = 37 * hash + 7;
        hash = 53 * hash + this.getTasksMax();
        if (this.getTopicsCount() > 0) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getTopicsList().hashCode();
        }
        if (this.hasCreateTime()) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getCreateTime().hashCode();
        }
        if (this.hasUpdateTime()) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getUpdateTime().hashCode();
        }
        hash = 37 * hash + 11;
        hash = 53 * hash + this.kafkaAuthMode_;
        hash = 37 * hash + 12;
        hash = 53 * hash + this.getKafkaServiceAccountId().hashCode();
        hash = 37 * hash + 13;
        hash = 53 * hash + this.getKafkaApiKey().hashCode();
        hash = 37 * hash + 14;
        hash = 53 * hash + this.getDlqTopic().hashCode();
        hash = 37 * hash + 15;
        hash = 53 * hash + this.getInputFormat().hashCode();
        hash = 37 * hash + 16;
        hash = 53 * hash + this.getOutputFormat().hashCode();
        hash = 37 * hash + 17;
        hash = 53 * hash + this.getSourceSchema().hashCode();
        hash = 37 * hash + 18;
        hash = 53 * hash + this.getSourceEndpoint().hashCode();
        hash = 37 * hash + 19;
        hash = 53 * hash + this.getOwner().hashCode();
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static ConnectMetadata parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (ConnectMetadata)PARSER.parseFrom(data);
    }

    public static ConnectMetadata parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ConnectMetadata)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ConnectMetadata parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (ConnectMetadata)PARSER.parseFrom(data);
    }

    public static ConnectMetadata parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ConnectMetadata)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ConnectMetadata parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (ConnectMetadata)PARSER.parseFrom(data);
    }

    public static ConnectMetadata parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ConnectMetadata)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ConnectMetadata parseFrom(InputStream input) throws IOException {
        return (ConnectMetadata)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static ConnectMetadata parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ConnectMetadata)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ConnectMetadata parseDelimitedFrom(InputStream input) throws IOException {
        return (ConnectMetadata)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static ConnectMetadata parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ConnectMetadata)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ConnectMetadata parseFrom(CodedInputStream input) throws IOException {
        return (ConnectMetadata)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static ConnectMetadata parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ConnectMetadata)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return ConnectMetadata.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ConnectMetadata prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static ConnectMetadata getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<ConnectMetadata> parser() {
        return PARSER;
    }

    public Parser<ConnectMetadata> getParserForType() {
        return PARSER;
    }

    public ConnectMetadata getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements ConnectMetadataOrBuilder {
        private int bitField0_;
        private Object clusterId_ = "";
        private Object name_ = "";
        private Object kafkaClusterId_ = "";
        private Object class__ = "";
        private int type_ = 0;
        private int status_ = 0;
        private int tasksMax_;
        private LazyStringArrayList topics_ = LazyStringArrayList.emptyList();
        private Timestamp createTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> createTimeBuilder_;
        private Timestamp updateTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> updateTimeBuilder_;
        private int kafkaAuthMode_ = 0;
        private Object kafkaServiceAccountId_ = "";
        private Object kafkaApiKey_ = "";
        private Object dlqTopic_ = "";
        private Object inputFormat_ = "";
        private Object outputFormat_ = "";
        private Object sourceSchema_ = "";
        private Object sourceEndpoint_ = "";
        private Object owner_ = "";

        public static final Descriptors.Descriptor getDescriptor() {
            return Metadata.internal_static_catalog_v1_ConnectMetadata_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return Metadata.internal_static_catalog_v1_ConnectMetadata_fieldAccessorTable.ensureFieldAccessorsInitialized(ConnectMetadata.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getCreateTimeFieldBuilder();
                this.getUpdateTimeFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.clusterId_ = "";
            this.name_ = "";
            this.kafkaClusterId_ = "";
            this.class__ = "";
            this.type_ = 0;
            this.status_ = 0;
            this.tasksMax_ = 0;
            this.topics_ = LazyStringArrayList.emptyList();
            this.createTime_ = null;
            if (this.createTimeBuilder_ != null) {
                this.createTimeBuilder_.dispose();
                this.createTimeBuilder_ = null;
            }
            this.updateTime_ = null;
            if (this.updateTimeBuilder_ != null) {
                this.updateTimeBuilder_.dispose();
                this.updateTimeBuilder_ = null;
            }
            this.kafkaAuthMode_ = 0;
            this.kafkaServiceAccountId_ = "";
            this.kafkaApiKey_ = "";
            this.dlqTopic_ = "";
            this.inputFormat_ = "";
            this.outputFormat_ = "";
            this.sourceSchema_ = "";
            this.sourceEndpoint_ = "";
            this.owner_ = "";
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return Metadata.internal_static_catalog_v1_ConnectMetadata_descriptor;
        }

        public ConnectMetadata getDefaultInstanceForType() {
            return ConnectMetadata.getDefaultInstance();
        }

        public ConnectMetadata build() {
            ConnectMetadata result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public ConnectMetadata buildPartial() {
            ConnectMetadata result = new ConnectMetadata(this);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartial0(ConnectMetadata result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.clusterId_ = this.clusterId_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.name_ = this.name_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.kafkaClusterId_ = this.kafkaClusterId_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.class__ = this.class__;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.type_ = this.type_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.status_ = this.status_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.tasksMax_ = this.tasksMax_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                this.topics_.makeImmutable();
                result.topics_ = this.topics_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 0x100) != 0) {
                result.createTime_ = this.createTimeBuilder_ == null ? this.createTime_ : (Timestamp)this.createTimeBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.updateTime_ = this.updateTimeBuilder_ == null ? this.updateTime_ : (Timestamp)this.updateTimeBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.kafkaAuthMode_ = this.kafkaAuthMode_;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.kafkaServiceAccountId_ = this.kafkaServiceAccountId_;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.kafkaApiKey_ = this.kafkaApiKey_;
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result.dlqTopic_ = this.dlqTopic_;
            }
            if ((from_bitField0_ & 0x4000) != 0) {
                result.inputFormat_ = this.inputFormat_;
            }
            if ((from_bitField0_ & 0x8000) != 0) {
                result.outputFormat_ = this.outputFormat_;
            }
            if ((from_bitField0_ & 0x10000) != 0) {
                result.sourceSchema_ = this.sourceSchema_;
            }
            if ((from_bitField0_ & 0x20000) != 0) {
                result.sourceEndpoint_ = this.sourceEndpoint_;
            }
            if ((from_bitField0_ & 0x40000) != 0) {
                result.owner_ = this.owner_;
            }
            ConnectMetadata connectMetadata = result;
            connectMetadata.bitField0_ = connectMetadata.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof ConnectMetadata) {
                return this.mergeFrom((ConnectMetadata)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(ConnectMetadata other) {
            if (other == ConnectMetadata.getDefaultInstance()) {
                return this;
            }
            if (!other.getClusterId().isEmpty()) {
                this.clusterId_ = other.clusterId_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (!other.getKafkaClusterId().isEmpty()) {
                this.kafkaClusterId_ = other.kafkaClusterId_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (!other.getClass_().isEmpty()) {
                this.class__ = other.class__;
                this.bitField0_ |= 8;
                this.onChanged();
            }
            if (other.type_ != 0) {
                this.setTypeValue(other.getTypeValue());
            }
            if (other.status_ != 0) {
                this.setStatusValue(other.getStatusValue());
            }
            if (other.getTasksMax() != 0) {
                this.setTasksMax(other.getTasksMax());
            }
            if (!other.topics_.isEmpty()) {
                if (this.topics_.isEmpty()) {
                    this.topics_ = other.topics_;
                    this.bitField0_ |= 0x80;
                } else {
                    this.ensureTopicsIsMutable();
                    this.topics_.addAll((Collection)other.topics_);
                }
                this.onChanged();
            }
            if (other.hasCreateTime()) {
                this.mergeCreateTime(other.getCreateTime());
            }
            if (other.hasUpdateTime()) {
                this.mergeUpdateTime(other.getUpdateTime());
            }
            if (other.kafkaAuthMode_ != 0) {
                this.setKafkaAuthModeValue(other.getKafkaAuthModeValue());
            }
            if (!other.getKafkaServiceAccountId().isEmpty()) {
                this.kafkaServiceAccountId_ = other.kafkaServiceAccountId_;
                this.bitField0_ |= 0x800;
                this.onChanged();
            }
            if (!other.getKafkaApiKey().isEmpty()) {
                this.kafkaApiKey_ = other.kafkaApiKey_;
                this.bitField0_ |= 0x1000;
                this.onChanged();
            }
            if (!other.getDlqTopic().isEmpty()) {
                this.dlqTopic_ = other.dlqTopic_;
                this.bitField0_ |= 0x2000;
                this.onChanged();
            }
            if (!other.getInputFormat().isEmpty()) {
                this.inputFormat_ = other.inputFormat_;
                this.bitField0_ |= 0x4000;
                this.onChanged();
            }
            if (!other.getOutputFormat().isEmpty()) {
                this.outputFormat_ = other.outputFormat_;
                this.bitField0_ |= 0x8000;
                this.onChanged();
            }
            if (!other.getSourceSchema().isEmpty()) {
                this.sourceSchema_ = other.sourceSchema_;
                this.bitField0_ |= 0x10000;
                this.onChanged();
            }
            if (!other.getSourceEndpoint().isEmpty()) {
                this.sourceEndpoint_ = other.sourceEndpoint_;
                this.bitField0_ |= 0x20000;
                this.onChanged();
            }
            if (!other.getOwner().isEmpty()) {
                this.owner_ = other.owner_;
                this.bitField0_ |= 0x40000;
                this.onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block27: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block27;
                        }
                        case 10: {
                            this.clusterId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block27;
                        }
                        case 18: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block27;
                        }
                        case 26: {
                            this.kafkaClusterId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block27;
                        }
                        case 34: {
                            this.class__ = input.readStringRequireUtf8();
                            this.bitField0_ |= 8;
                            continue block27;
                        }
                        case 40: {
                            this.type_ = input.readEnum();
                            this.bitField0_ |= 0x10;
                            continue block27;
                        }
                        case 48: {
                            this.status_ = input.readEnum();
                            this.bitField0_ |= 0x20;
                            continue block27;
                        }
                        case 56: {
                            this.tasksMax_ = input.readInt32();
                            this.bitField0_ |= 0x40;
                            continue block27;
                        }
                        case 66: {
                            String s = input.readStringRequireUtf8();
                            this.ensureTopicsIsMutable();
                            this.topics_.add((Object)s);
                            continue block27;
                        }
                        case 74: {
                            input.readMessage((MessageLite.Builder)this.getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x100;
                            continue block27;
                        }
                        case 82: {
                            input.readMessage((MessageLite.Builder)this.getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x200;
                            continue block27;
                        }
                        case 88: {
                            this.kafkaAuthMode_ = input.readEnum();
                            this.bitField0_ |= 0x400;
                            continue block27;
                        }
                        case 98: {
                            this.kafkaServiceAccountId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x800;
                            continue block27;
                        }
                        case 106: {
                            this.kafkaApiKey_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x1000;
                            continue block27;
                        }
                        case 114: {
                            this.dlqTopic_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x2000;
                            continue block27;
                        }
                        case 122: {
                            this.inputFormat_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x4000;
                            continue block27;
                        }
                        case 130: {
                            this.outputFormat_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x8000;
                            continue block27;
                        }
                        case 138: {
                            this.sourceSchema_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10000;
                            continue block27;
                        }
                        case 146: {
                            this.sourceEndpoint_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x20000;
                            continue block27;
                        }
                        case 154: {
                            this.owner_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x40000;
                            continue block27;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getClusterId() {
            Object ref = this.clusterId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.clusterId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getClusterIdBytes() {
            Object ref = this.clusterId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.clusterId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setClusterId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.clusterId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearClusterId() {
            this.clusterId_ = ConnectMetadata.getDefaultInstance().getClusterId();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setClusterIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ConnectMetadata.checkByteStringIsUtf8((ByteString)value);
            this.clusterId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = ConnectMetadata.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ConnectMetadata.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public String getKafkaClusterId() {
            Object ref = this.kafkaClusterId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.kafkaClusterId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getKafkaClusterIdBytes() {
            Object ref = this.kafkaClusterId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.kafkaClusterId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setKafkaClusterId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.kafkaClusterId_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearKafkaClusterId() {
            this.kafkaClusterId_ = ConnectMetadata.getDefaultInstance().getKafkaClusterId();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setKafkaClusterIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ConnectMetadata.checkByteStringIsUtf8((ByteString)value);
            this.kafkaClusterId_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public String getClass_() {
            Object ref = this.class__;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.class__ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getClass_Bytes() {
            Object ref = this.class__;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.class__ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setClass_(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.class__ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearClass_() {
            this.class__ = ConnectMetadata.getDefaultInstance().getClass_();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder setClass_Bytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ConnectMetadata.checkByteStringIsUtf8((ByteString)value);
            this.class__ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public int getTypeValue() {
            return this.type_;
        }

        public Builder setTypeValue(int value) {
            this.type_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public ConnectorType getType() {
            ConnectorType result = ConnectorType.forNumber(this.type_);
            return result == null ? ConnectorType.UNRECOGNIZED : result;
        }

        public Builder setType(ConnectorType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x10;
            this.type_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearType() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.type_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getStatusValue() {
            return this.status_;
        }

        public Builder setStatusValue(int value) {
            this.status_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public ConnectorStatus getStatus() {
            ConnectorStatus result = ConnectorStatus.forNumber(this.status_);
            return result == null ? ConnectorStatus.UNRECOGNIZED : result;
        }

        public Builder setStatus(ConnectorStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x20;
            this.status_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearStatus() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.status_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getTasksMax() {
            return this.tasksMax_;
        }

        public Builder setTasksMax(int value) {
            this.tasksMax_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearTasksMax() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.tasksMax_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureTopicsIsMutable() {
            if (!this.topics_.isModifiable()) {
                this.topics_ = new LazyStringArrayList((LazyStringList)this.topics_);
            }
            this.bitField0_ |= 0x80;
        }

        public ProtocolStringList getTopicsList() {
            this.topics_.makeImmutable();
            return this.topics_;
        }

        @Override
        public int getTopicsCount() {
            return this.topics_.size();
        }

        @Override
        public String getTopics(int index) {
            return this.topics_.get(index);
        }

        @Override
        public ByteString getTopicsBytes(int index) {
            return this.topics_.getByteString(index);
        }

        public Builder setTopics(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureTopicsIsMutable();
            this.topics_.set(index, value);
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder addTopics(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureTopicsIsMutable();
            this.topics_.add((Object)value);
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder addAllTopics(Iterable<String> values) {
            this.ensureTopicsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.topics_);
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearTopics() {
            this.topics_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFF7F;
            this.onChanged();
            return this;
        }

        public Builder addTopicsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ConnectMetadata.checkByteStringIsUtf8((ByteString)value);
            this.ensureTopicsIsMutable();
            this.topics_.add(value);
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasCreateTime() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public Timestamp getCreateTime() {
            if (this.createTimeBuilder_ == null) {
                return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
            }
            return (Timestamp)this.createTimeBuilder_.getMessage();
        }

        public Builder setCreateTime(Timestamp value) {
            if (this.createTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.createTime_ = value;
            } else {
                this.createTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder setCreateTime(Timestamp.Builder builderForValue) {
            if (this.createTimeBuilder_ == null) {
                this.createTime_ = builderForValue.build();
            } else {
                this.createTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder mergeCreateTime(Timestamp value) {
            if (this.createTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0 && this.createTime_ != null && this.createTime_ != Timestamp.getDefaultInstance()) {
                    this.getCreateTimeBuilder().mergeFrom(value);
                } else {
                    this.createTime_ = value;
                }
            } else {
                this.createTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.createTime_ != null) {
                this.bitField0_ |= 0x100;
                this.onChanged();
            }
            return this;
        }

        public Builder clearCreateTime() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.createTime_ = null;
            if (this.createTimeBuilder_ != null) {
                this.createTimeBuilder_.dispose();
                this.createTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getCreateTimeBuilder() {
            this.bitField0_ |= 0x100;
            this.onChanged();
            return (Timestamp.Builder)this.getCreateTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getCreateTimeOrBuilder() {
            if (this.createTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.createTimeBuilder_.getMessageOrBuilder();
            }
            return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getCreateTimeFieldBuilder() {
            if (this.createTimeBuilder_ == null) {
                this.createTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCreateTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.createTime_ = null;
            }
            return this.createTimeBuilder_;
        }

        @Override
        public boolean hasUpdateTime() {
            return (this.bitField0_ & 0x200) != 0;
        }

        @Override
        public Timestamp getUpdateTime() {
            if (this.updateTimeBuilder_ == null) {
                return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
            }
            return (Timestamp)this.updateTimeBuilder_.getMessage();
        }

        public Builder setUpdateTime(Timestamp value) {
            if (this.updateTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.updateTime_ = value;
            } else {
                this.updateTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder setUpdateTime(Timestamp.Builder builderForValue) {
            if (this.updateTimeBuilder_ == null) {
                this.updateTime_ = builderForValue.build();
            } else {
                this.updateTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder mergeUpdateTime(Timestamp value) {
            if (this.updateTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x200) != 0 && this.updateTime_ != null && this.updateTime_ != Timestamp.getDefaultInstance()) {
                    this.getUpdateTimeBuilder().mergeFrom(value);
                } else {
                    this.updateTime_ = value;
                }
            } else {
                this.updateTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.updateTime_ != null) {
                this.bitField0_ |= 0x200;
                this.onChanged();
            }
            return this;
        }

        public Builder clearUpdateTime() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.updateTime_ = null;
            if (this.updateTimeBuilder_ != null) {
                this.updateTimeBuilder_.dispose();
                this.updateTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getUpdateTimeBuilder() {
            this.bitField0_ |= 0x200;
            this.onChanged();
            return (Timestamp.Builder)this.getUpdateTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getUpdateTimeOrBuilder() {
            if (this.updateTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.updateTimeBuilder_.getMessageOrBuilder();
            }
            return this.updateTime_ == null ? Timestamp.getDefaultInstance() : this.updateTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getUpdateTimeFieldBuilder() {
            if (this.updateTimeBuilder_ == null) {
                this.updateTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getUpdateTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.updateTime_ = null;
            }
            return this.updateTimeBuilder_;
        }

        @Override
        public int getKafkaAuthModeValue() {
            return this.kafkaAuthMode_;
        }

        public Builder setKafkaAuthModeValue(int value) {
            this.kafkaAuthMode_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        @Override
        public KafkaAuthMode getKafkaAuthMode() {
            KafkaAuthMode result = KafkaAuthMode.forNumber(this.kafkaAuthMode_);
            return result == null ? KafkaAuthMode.UNRECOGNIZED : result;
        }

        public Builder setKafkaAuthMode(KafkaAuthMode value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x400;
            this.kafkaAuthMode_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearKafkaAuthMode() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.kafkaAuthMode_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getKafkaServiceAccountId() {
            Object ref = this.kafkaServiceAccountId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.kafkaServiceAccountId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getKafkaServiceAccountIdBytes() {
            Object ref = this.kafkaServiceAccountId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.kafkaServiceAccountId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setKafkaServiceAccountId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.kafkaServiceAccountId_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder clearKafkaServiceAccountId() {
            this.kafkaServiceAccountId_ = ConnectMetadata.getDefaultInstance().getKafkaServiceAccountId();
            this.bitField0_ &= 0xFFFFF7FF;
            this.onChanged();
            return this;
        }

        public Builder setKafkaServiceAccountIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ConnectMetadata.checkByteStringIsUtf8((ByteString)value);
            this.kafkaServiceAccountId_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        @Override
        public String getKafkaApiKey() {
            Object ref = this.kafkaApiKey_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.kafkaApiKey_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getKafkaApiKeyBytes() {
            Object ref = this.kafkaApiKey_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.kafkaApiKey_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setKafkaApiKey(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.kafkaApiKey_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder clearKafkaApiKey() {
            this.kafkaApiKey_ = ConnectMetadata.getDefaultInstance().getKafkaApiKey();
            this.bitField0_ &= 0xFFFFEFFF;
            this.onChanged();
            return this;
        }

        public Builder setKafkaApiKeyBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ConnectMetadata.checkByteStringIsUtf8((ByteString)value);
            this.kafkaApiKey_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        @Override
        public String getDlqTopic() {
            Object ref = this.dlqTopic_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.dlqTopic_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDlqTopicBytes() {
            Object ref = this.dlqTopic_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.dlqTopic_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDlqTopic(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.dlqTopic_ = value;
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder clearDlqTopic() {
            this.dlqTopic_ = ConnectMetadata.getDefaultInstance().getDlqTopic();
            this.bitField0_ &= 0xFFFFDFFF;
            this.onChanged();
            return this;
        }

        public Builder setDlqTopicBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ConnectMetadata.checkByteStringIsUtf8((ByteString)value);
            this.dlqTopic_ = value;
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        @Override
        public String getInputFormat() {
            Object ref = this.inputFormat_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.inputFormat_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getInputFormatBytes() {
            Object ref = this.inputFormat_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.inputFormat_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setInputFormat(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.inputFormat_ = value;
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder clearInputFormat() {
            this.inputFormat_ = ConnectMetadata.getDefaultInstance().getInputFormat();
            this.bitField0_ &= 0xFFFFBFFF;
            this.onChanged();
            return this;
        }

        public Builder setInputFormatBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ConnectMetadata.checkByteStringIsUtf8((ByteString)value);
            this.inputFormat_ = value;
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        @Override
        public String getOutputFormat() {
            Object ref = this.outputFormat_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.outputFormat_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getOutputFormatBytes() {
            Object ref = this.outputFormat_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.outputFormat_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setOutputFormat(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.outputFormat_ = value;
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        public Builder clearOutputFormat() {
            this.outputFormat_ = ConnectMetadata.getDefaultInstance().getOutputFormat();
            this.bitField0_ &= 0xFFFF7FFF;
            this.onChanged();
            return this;
        }

        public Builder setOutputFormatBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ConnectMetadata.checkByteStringIsUtf8((ByteString)value);
            this.outputFormat_ = value;
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        @Override
        public String getSourceSchema() {
            Object ref = this.sourceSchema_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.sourceSchema_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getSourceSchemaBytes() {
            Object ref = this.sourceSchema_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.sourceSchema_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setSourceSchema(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.sourceSchema_ = value;
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder clearSourceSchema() {
            this.sourceSchema_ = ConnectMetadata.getDefaultInstance().getSourceSchema();
            this.bitField0_ &= 0xFFFEFFFF;
            this.onChanged();
            return this;
        }

        public Builder setSourceSchemaBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ConnectMetadata.checkByteStringIsUtf8((ByteString)value);
            this.sourceSchema_ = value;
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        @Override
        public String getSourceEndpoint() {
            Object ref = this.sourceEndpoint_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.sourceEndpoint_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getSourceEndpointBytes() {
            Object ref = this.sourceEndpoint_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.sourceEndpoint_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setSourceEndpoint(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.sourceEndpoint_ = value;
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public Builder clearSourceEndpoint() {
            this.sourceEndpoint_ = ConnectMetadata.getDefaultInstance().getSourceEndpoint();
            this.bitField0_ &= 0xFFFDFFFF;
            this.onChanged();
            return this;
        }

        public Builder setSourceEndpointBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ConnectMetadata.checkByteStringIsUtf8((ByteString)value);
            this.sourceEndpoint_ = value;
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        @Override
        public String getOwner() {
            Object ref = this.owner_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.owner_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getOwnerBytes() {
            Object ref = this.owner_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.owner_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setOwner(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.owner_ = value;
            this.bitField0_ |= 0x40000;
            this.onChanged();
            return this;
        }

        public Builder clearOwner() {
            this.owner_ = ConnectMetadata.getDefaultInstance().getOwner();
            this.bitField0_ &= 0xFFFBFFFF;
            this.onChanged();
            return this;
        }

        public Builder setOwnerBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ConnectMetadata.checkByteStringIsUtf8((ByteString)value);
            this.owner_ = value;
            this.bitField0_ |= 0x40000;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum KafkaAuthMode implements ProtocolMessageEnum
    {
        KAFKA_API_KEY(0),
        SERVICE_ACCOUNT(1),
        UNRECOGNIZED(-1);

        public static final int KAFKA_API_KEY_VALUE = 0;
        public static final int SERVICE_ACCOUNT_VALUE = 1;
        private static final Internal.EnumLiteMap<KafkaAuthMode> internalValueMap;
        private static final KafkaAuthMode[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static KafkaAuthMode valueOf(int value) {
            return KafkaAuthMode.forNumber(value);
        }

        public static KafkaAuthMode forNumber(int value) {
            switch (value) {
                case 0: {
                    return KAFKA_API_KEY;
                }
                case 1: {
                    return SERVICE_ACCOUNT;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<KafkaAuthMode> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)KafkaAuthMode.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return KafkaAuthMode.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)ConnectMetadata.getDescriptor().getEnumTypes().get(2);
        }

        public static KafkaAuthMode valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != KafkaAuthMode.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private KafkaAuthMode(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<KafkaAuthMode>(){

                public KafkaAuthMode findValueByNumber(int number) {
                    return KafkaAuthMode.forNumber(number);
                }
            };
            VALUES = KafkaAuthMode.values();
        }
    }

    public static enum ConnectorStatus implements ProtocolMessageEnum
    {
        NONE(0),
        PROVISIONING(1),
        RUNNING(2),
        DEGRADED(3),
        FAILED(4),
        PAUSED(5),
        DELETED(6),
        UNRECOGNIZED(-1);

        public static final int NONE_VALUE = 0;
        public static final int PROVISIONING_VALUE = 1;
        public static final int RUNNING_VALUE = 2;
        public static final int DEGRADED_VALUE = 3;
        public static final int FAILED_VALUE = 4;
        public static final int PAUSED_VALUE = 5;
        public static final int DELETED_VALUE = 6;
        private static final Internal.EnumLiteMap<ConnectorStatus> internalValueMap;
        private static final ConnectorStatus[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static ConnectorStatus valueOf(int value) {
            return ConnectorStatus.forNumber(value);
        }

        public static ConnectorStatus forNumber(int value) {
            switch (value) {
                case 0: {
                    return NONE;
                }
                case 1: {
                    return PROVISIONING;
                }
                case 2: {
                    return RUNNING;
                }
                case 3: {
                    return DEGRADED;
                }
                case 4: {
                    return FAILED;
                }
                case 5: {
                    return PAUSED;
                }
                case 6: {
                    return DELETED;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<ConnectorStatus> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)ConnectorStatus.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return ConnectorStatus.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)ConnectMetadata.getDescriptor().getEnumTypes().get(1);
        }

        public static ConnectorStatus valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != ConnectorStatus.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private ConnectorStatus(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<ConnectorStatus>(){

                public ConnectorStatus findValueByNumber(int number) {
                    return ConnectorStatus.forNumber(number);
                }
            };
            VALUES = ConnectorStatus.values();
        }
    }

    public static enum ConnectorType implements ProtocolMessageEnum
    {
        SOURCE(0),
        SINK(1),
        UNRECOGNIZED(-1);

        public static final int SOURCE_VALUE = 0;
        public static final int SINK_VALUE = 1;
        private static final Internal.EnumLiteMap<ConnectorType> internalValueMap;
        private static final ConnectorType[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static ConnectorType valueOf(int value) {
            return ConnectorType.forNumber(value);
        }

        public static ConnectorType forNumber(int value) {
            switch (value) {
                case 0: {
                    return SOURCE;
                }
                case 1: {
                    return SINK;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<ConnectorType> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)ConnectorType.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return ConnectorType.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)ConnectMetadata.getDescriptor().getEnumTypes().get(0);
        }

        public static ConnectorType valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != ConnectorType.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private ConnectorType(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<ConnectorType>(){

                public ConnectorType findValueByNumber(int number) {
                    return ConnectorType.forNumber(number);
                }
            };
            VALUES = ConnectorType.values();
        }
    }
}

