/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.metadata.ConfluentKeyValueStreamEntryRecord;
import org.apache.kafka.common.metadata.ConfluentKeyValueStreamTopicRecord;
import org.apache.kafka.image.node.ConfluentKeyValueStreamsImageNode;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.server.immutable.ImmutableMap;

public class ConfluentKeyValueStreamsImage {
    public static final ConfluentKeyValueStreamsImage EMPTY = new ConfluentKeyValueStreamsImage(Collections.emptyMap(), Collections.emptyMap());
    private final ImmutableMap<Short, Map<String, String>> topicTypeKv;
    private final ImmutableMap<Short, Map<Short, Long>> topicTypeOffset;

    public ConfluentKeyValueStreamsImage(Map<Short, Map<String, String>> kv, Map<Short, Map<Short, Long>> offset) {
        this.topicTypeKv = ImmutableMap.from(kv);
        this.topicTypeOffset = ImmutableMap.from(offset);
    }

    public Map<Short, Map<String, String>> topicTypeKv() {
        return this.topicTypeKv;
    }

    public Map<Short, Map<Short, Long>> topicTypeOffset() {
        return this.topicTypeOffset;
    }

    public boolean isEmpty() {
        return this.topicTypeKv.isEmpty() && this.topicTypeOffset.isEmpty();
    }

    public void write(ImageWriter writer, ImageWriterOptions options) {
        for (Map.Entry topicKvEntry : this.topicTypeKv.entrySet()) {
            short topicType = (Short)topicKvEntry.getKey();
            Map kv = (Map)topicKvEntry.getValue();
            Map offset = (Map)this.topicTypeOffset.get((Object)topicType);
            for (Map.Entry entry : kv.entrySet()) {
                ConfluentKeyValueStreamEntryRecord recordEntry = new ConfluentKeyValueStreamEntryRecord().setType(topicType).setEntryKey((String)entry.getKey()).setEntryValue((String)entry.getValue());
                writer.write(0, recordEntry);
            }
            ArrayList<ConfluentKeyValueStreamTopicRecord.Partition> partitions = new ArrayList<ConfluentKeyValueStreamTopicRecord.Partition>();
            for (Map.Entry entry3 : offset.entrySet()) {
                partitions.add(new ConfluentKeyValueStreamTopicRecord.Partition().setId((Short)entry3.getKey()).setOffset((Long)entry3.getValue()));
            }
            ConfluentKeyValueStreamTopicRecord confluentKeyValueStreamTopicRecord = new ConfluentKeyValueStreamTopicRecord().setType(topicType).setPartitions(partitions);
            writer.write(0, confluentKeyValueStreamTopicRecord);
        }
    }

    public int hashCode() {
        return Objects.hash(this.topicTypeKv, this.topicTypeOffset);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConfluentKeyValueStreamsImage)) {
            return false;
        }
        ConfluentKeyValueStreamsImage other = (ConfluentKeyValueStreamsImage)o;
        return this.topicTypeKv.equals(other.topicTypeKv) && this.topicTypeOffset.equals(other.topicTypeOffset);
    }

    public String toString() {
        return new ConfluentKeyValueStreamsImageNode(this).stringify();
    }
}

