/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.image.node.TopicsImageByLinkIdUuidNode;
import org.apache.kafka.server.immutable.ImmutableMap;

public class TopicsImageByLinkIdNode
implements MetadataNode {
    public static final String NAME = "byLinkId";
    private final TopicsImage image;

    public TopicsImageByLinkIdNode(TopicsImage image) {
        this.image = image;
    }

    @Override
    public Collection<String> childNames() {
        ArrayList<String> children = new ArrayList<String>();
        this.image.topicsByLinkId().keySet().forEach(linkId -> children.add(linkId.toString()));
        return children;
    }

    @Override
    public MetadataNode child(String name) {
        Uuid id;
        try {
            id = Uuid.fromString((String)name);
        }
        catch (Exception e) {
            return null;
        }
        ImmutableMap linkedTopics = (ImmutableMap)this.image.topicsByLinkId().get((Object)id);
        if (linkedTopics == null) {
            return null;
        }
        return new TopicsImageByLinkIdUuidNode(this.image, (ImmutableMap<Uuid, TopicImage>)linkedTopics);
    }
}

