/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.common.errors.AuthorizerNotReadyException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.Resource;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.metadata.authorizer.AclLoader;
import org.apache.kafka.metadata.authorizer.AclMutator;
import org.apache.kafka.metadata.authorizer.AuthorizeVisitor;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.metadata.authorizer.DefaultRule;
import org.apache.kafka.metadata.authorizer.MatchingAclRule;
import org.apache.kafka.metadata.authorizer.MatchingRule;
import org.apache.kafka.metadata.authorizer.PrefixNode;
import org.apache.kafka.metadata.authorizer.ResourceAcls;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAuthorizerConstants;
import org.apache.kafka.metadata.authorizer.SuperUserRule;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.immutable.ImmutableMap;
import org.apache.kafka.server.immutable.ImmutableNavigableMap;
import org.apache.kafka.server.immutable.ImmutableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardAuthorizerData {
    final Logger log;
    final Logger auditLog;
    final AclMutator aclMutator;
    final boolean loadingComplete;
    private final Set<String> superUsers;
    private final DefaultRule noAclRule;
    private final ImmutableMap<Uuid, ConfluentStandardAcl> aclsById;
    private final ImmutableMap<ResourceTypeKey, ImmutableNavigableMap<StandardAcl, AclLinks>> activeAclsByResourceType;
    private final ImmutableMap<ResourceTypeKey, ImmutableNavigableMap<StandardAcl, AclLinks>> inactiveAclsByResourceType;
    private final ImmutableMap<ResourceType, ImmutableMap<KafkaPrincipal, PrefixNode>> prefixAcls;
    private final ImmutableMap<KafkaPrincipal, ImmutableMap<Resource, ResourceAcls>> literalAcls;

    private static Logger createLogger(int nodeId) {
        return new LogContext("[StandardAuthorizer " + nodeId + "] ").logger(StandardAuthorizerData.class);
    }

    private static Logger auditLogger() {
        return LoggerFactory.getLogger((String)"kafka.authorizer.logger");
    }

    static StandardAuthorizerData createEmpty() {
        return new StandardAuthorizerData(StandardAuthorizerData.createLogger(-1), null, false, Collections.emptySet(), DefaultRule.DENIED, (ImmutableMap<Uuid, ConfluentStandardAcl>)ImmutableMap.empty(), (ImmutableMap<ResourceTypeKey, ImmutableNavigableMap<StandardAcl, AclLinks>>)ImmutableMap.empty(), (ImmutableMap<ResourceTypeKey, ImmutableNavigableMap<StandardAcl, AclLinks>>)ImmutableMap.empty(), (ImmutableMap<ResourceType, ImmutableMap<KafkaPrincipal, PrefixNode>>)ImmutableMap.empty(), (ImmutableMap<KafkaPrincipal, ImmutableMap<Resource, ResourceAcls>>)ImmutableMap.empty());
    }

    private StandardAuthorizerData(Logger log, AclMutator aclMutator, boolean loadingComplete, Set<String> superUsers, DefaultRule noAclRule, ImmutableMap<Uuid, ConfluentStandardAcl> aclsById, ImmutableMap<ResourceTypeKey, ImmutableNavigableMap<StandardAcl, AclLinks>> activeAclsByResourceType, ImmutableMap<ResourceTypeKey, ImmutableNavigableMap<StandardAcl, AclLinks>> inactiveAclsByResourceType, ImmutableMap<ResourceType, ImmutableMap<KafkaPrincipal, PrefixNode>> prefixAcls, ImmutableMap<KafkaPrincipal, ImmutableMap<Resource, ResourceAcls>> literalAcls) {
        this.log = log;
        this.auditLog = StandardAuthorizerData.auditLogger();
        this.aclMutator = aclMutator;
        this.loadingComplete = loadingComplete;
        this.superUsers = superUsers;
        this.noAclRule = noAclRule;
        this.aclsById = aclsById;
        this.activeAclsByResourceType = activeAclsByResourceType;
        this.inactiveAclsByResourceType = inactiveAclsByResourceType;
        this.prefixAcls = prefixAcls;
        this.literalAcls = literalAcls;
    }

    StandardAuthorizerData copyWithNewAclMutator(AclMutator newAclMutator) {
        return new StandardAuthorizerData(this.log, newAclMutator, this.loadingComplete, this.superUsers, this.noAclRule, this.aclsById, this.activeAclsByResourceType, this.inactiveAclsByResourceType, this.prefixAcls, this.literalAcls);
    }

    StandardAuthorizerData copyWithNewLoadingComplete(boolean newLoadingComplete) {
        return new StandardAuthorizerData(this.log, this.aclMutator, newLoadingComplete, this.superUsers, this.noAclRule, this.aclsById, this.activeAclsByResourceType, this.inactiveAclsByResourceType, this.prefixAcls, this.literalAcls);
    }

    StandardAuthorizerData copyWithNewConfig(int nodeId, Set<String> newSuperUsers, AuthorizationResult newDefaultResult) {
        return new StandardAuthorizerData(StandardAuthorizerData.createLogger(nodeId), this.aclMutator, this.loadingComplete, newSuperUsers, new DefaultRule(newDefaultResult), this.aclsById, this.activeAclsByResourceType, this.inactiveAclsByResourceType, this.prefixAcls, this.literalAcls);
    }

    StandardAuthorizerData copyWithAclSnapshot(Map<Uuid, ConfluentStandardAcl> snapshot) {
        AclLoader loader = new AclLoader(snapshot);
        AclLoader.Result result = loader.build();
        return new StandardAuthorizerData(this.log, this.aclMutator, this.loadingComplete, this.superUsers, this.noAclRule, result.newAclsById(), result.newAclsByResource(), result.newInactiveAclsByResource(), result.newPrefixed(), result.newLiterals());
    }

    StandardAuthorizerData copyWithAclChanges(Map<Uuid, Optional<ConfluentStandardAcl>> aclChanges) {
        AclLoader loader = new AclLoader(this.aclsById, this.activeAclsByResourceType, this.inactiveAclsByResourceType, this.prefixAcls, this.literalAcls, aclChanges);
        AclLoader.Result result = loader.build();
        return new StandardAuthorizerData(this.log, this.aclMutator, this.loadingComplete, this.superUsers, this.noAclRule, result.newAclsById(), result.newAclsByResource(), result.newInactiveAclsByResource(), result.newPrefixed(), result.newLiterals());
    }

    Set<String> superUsers() {
        return this.superUsers;
    }

    AuthorizationResult defaultResult() {
        return this.noAclRule.result();
    }

    int aclCount() {
        return this.aclsById.size();
    }

    ConfluentStandardAcl getAcl(Uuid id) {
        return (ConfluentStandardAcl)this.aclsById.get((Object)id);
    }

    AuthorizationResult authorize(AuthorizableRequestContext requestContext, Action action) {
        if (action.resourcePattern().patternType() != PatternType.LITERAL) {
            throw new IllegalArgumentException("Only literal resources are supported. Got: " + String.valueOf(action.resourcePattern().patternType()));
        }
        return this.doAuthorize(requestContext, action, principal -> this.findAuthorizationRule(StandardAuthorizerData.matchingPrincipals(principal), requestContext.clientAddress().getHostAddress(), action));
    }

    AuthorizationResult authorizeByResourceType(AuthorizableRequestContext requestContext, AclOperation op, ResourceType resourceType) {
        Action action = new Action(op, new ResourcePattern(resourceType, "NONE", PatternType.UNKNOWN), 0, true, true);
        return this.doAuthorize(requestContext, action, principal -> this.findAuthorizationByResourceTypeRule(StandardAuthorizerData.matchingPrincipals(principal), requestContext.clientAddress().getHostAddress(), op, resourceType));
    }

    AuthorizationResult doAuthorize(AuthorizableRequestContext requestContext, Action action, Function<KafkaPrincipal, MatchingRule> ruleSupplier) {
        MatchingRule rule;
        KafkaPrincipal principal = StandardAuthorizerData.baseKafkaPrincipal(requestContext);
        if (this.superUsers.contains(principal.toString())) {
            rule = SuperUserRule.INSTANCE;
        } else {
            if (!this.loadingComplete) {
                this.log.debug("Raising AuthorizerNotReadyException because loading is not complete yet.");
                throw new AuthorizerNotReadyException();
            }
            rule = ruleSupplier.apply(principal);
            if (rule == null) {
                rule = DefaultRule.DENIED;
            }
        }
        rule.logAuditMessage(this.auditLog, principal, requestContext, action);
        return rule.result();
    }

    MatchingRule findAuthorizationRule(Set<KafkaPrincipal> matchingPrincipals, String host, Action action) {
        PrefixNode prefixNode;
        KafkaPrincipal principal;
        ResourceAcls literalResourceAcls;
        ResourceType resourceType = action.resourcePattern().resourceType();
        String resourceName = action.resourcePattern().name();
        AuthorizeVisitor visitor = new AuthorizeVisitor(resourceName, action.operation(), host);
        Resource literalResource = new Resource(resourceType, action.resourcePattern().name());
        Iterator<KafkaPrincipal> iterator = matchingPrincipals.iterator();
        while (iterator.hasNext() && ((literalResourceAcls = (ResourceAcls)((ImmutableMap)this.literalAcls.getOrDefault((Object)(principal = iterator.next()), (Object)ImmutableMap.empty())).get((Object)literalResource)) == null || literalResourceAcls.walk(visitor)) && ((prefixNode = (PrefixNode)((ImmutableMap)this.prefixAcls.getOrDefault((Object)resourceType, (Object)ImmutableMap.empty())).get((Object)principal)) == null || prefixNode.walk(visitor))) {
        }
        Optional<StandardAcl> matchingAclOpt = visitor.matchingAcl();
        MatchingRule bestRule = matchingAclOpt.isPresent() ? new MatchingAclRule(matchingAclOpt.get(), matchingAclOpt.get().permissionType() == AclPermissionType.ALLOW ? AuthorizationResult.ALLOWED : AuthorizationResult.DENIED) : (this.noAclRule.result() == AuthorizationResult.ALLOWED && !this.hasAclForResource(resourceType, resourceName) ? this.noAclRule : DefaultRule.DENIED);
        return bestRule;
    }

    private boolean hasAclForResource(ResourceType resourceType, String resourceName) {
        for (Map.Entry entry : this.activeAclsByResourceType.entrySet()) {
            StandardAcl wildcardExemplar;
            if (((ResourceTypeKey)entry.getKey()).resourceType != resourceType) continue;
            ImmutableNavigableMap acls = (ImmutableNavigableMap)entry.getValue();
            Iterator iterator = acls.tailMap((Object)(wildcardExemplar = new StandardAcl(resourceType, "*", PatternType.LITERAL, "", "", AclOperation.UNKNOWN, AclPermissionType.UNKNOWN))).keySet().iterator();
            if (iterator.hasNext() && ((StandardAcl)iterator.next()).resourceName().equals("*")) {
                return true;
            }
            StandardAcl literalExemplar = new StandardAcl(resourceType, resourceName, PatternType.LITERAL, "", "", AclOperation.UNKNOWN, AclPermissionType.UNKNOWN);
            iterator = acls.tailMap((Object)literalExemplar).keySet().iterator();
            if (iterator.hasNext() && ((StandardAcl)iterator.next()).resourceName().equals(resourceName)) {
                return true;
            }
            StandardAcl prefixStartExemplar = new StandardAcl(resourceType, resourceName, PatternType.PREFIXED, "", "", AclOperation.UNKNOWN, AclPermissionType.UNKNOWN);
            String endResourceName = resourceName.isEmpty() ? "" : resourceName.substring(0, 1);
            StandardAcl prefixEndExemplar = new StandardAcl(resourceType, endResourceName, PatternType.PREFIXED, "", "", AclOperation.UNKNOWN, AclPermissionType.UNKNOWN);
            Optional<Map.Entry> first = acls.tailMap((Object)prefixStartExemplar).headMap(prefixEndExemplar).entrySet().stream().filter(e -> resourceName.startsWith(((StandardAcl)e.getKey()).resourceName())).findFirst();
            if (!first.isPresent()) continue;
            return true;
        }
        return false;
    }

    private MatchingRule findAuthorizationByResourceTypeRule(Set<KafkaPrincipal> matchingPrincipals, String host, AclOperation operation, ResourceType resourceType) {
        List<StandardAcl> matchingAcls = this.findRulesByResourceType(matchingPrincipals, host, operation, resourceType);
        HashMap<String, StandardAcl> denyLiterals = new HashMap<String, StandardAcl>();
        HashMap<String, StandardAcl> denyPrefixes = new HashMap<String, StandardAcl>();
        HashMap<String, StandardAcl> allowLiterals = new HashMap<String, StandardAcl>();
        HashMap<String, StandardAcl> allowPrefixes = new HashMap<String, StandardAcl>();
        matchingAcls.forEach(standardAcl -> {
            String resourceName = standardAcl.resourceName();
            if (standardAcl.patternType() == PatternType.LITERAL) {
                if (standardAcl.permissionType() == AclPermissionType.ALLOW) {
                    allowLiterals.put(resourceName, (StandardAcl)standardAcl);
                } else {
                    denyLiterals.put(resourceName, (StandardAcl)standardAcl);
                }
            } else if (standardAcl.permissionType() == AclPermissionType.ALLOW) {
                allowPrefixes.put(resourceName, (StandardAcl)standardAcl);
            } else {
                denyPrefixes.put(resourceName, (StandardAcl)standardAcl);
            }
        });
        return this.findDominantMatchingAcl(denyLiterals, denyPrefixes, allowLiterals, allowPrefixes);
    }

    private MatchingRule findDominantMatchingAcl(Map<String, StandardAcl> denyLiterals, Map<String, StandardAcl> denyPrefixes, Map<String, StandardAcl> allowLiterals, Map<String, StandardAcl> allowPrefixes) {
        StandardAcl matchingAcl = null;
        if (denyLiterals.containsKey("*")) {
            matchingAcl = denyLiterals.get("*");
        } else if (allowLiterals.containsKey("*")) {
            matchingAcl = allowLiterals.get("*");
        } else if (this.noAclRule.result() == AuthorizationResult.ALLOWED) {
            return this.noAclRule;
        }
        if (matchingAcl == null) {
            for (Map.Entry<String, StandardAcl> allowLiteral : allowLiterals.entrySet()) {
                if (denyLiterals.containsKey(allowLiteral.getKey()) || this.hasDominatedDeny(allowLiteral.getKey(), denyPrefixes.keySet())) continue;
                matchingAcl = allowLiteral.getValue();
                break;
            }
        }
        if (matchingAcl == null) {
            for (Map.Entry<String, StandardAcl> allowPrefix : allowPrefixes.entrySet()) {
                if (this.hasDominatedDeny(allowPrefix.getKey(), denyPrefixes.keySet())) continue;
                matchingAcl = allowPrefix.getValue();
                break;
            }
        }
        if (matchingAcl == null) {
            return this.noAclRule;
        }
        AuthorizationResult result = matchingAcl.permissionType() == AclPermissionType.ALLOW ? AuthorizationResult.ALLOWED : AuthorizationResult.DENIED;
        return new MatchingAclRule(matchingAcl, result);
    }

    private boolean hasDominatedDeny(String allowedName, Set<String> deniedPrefixes) {
        StringBuilder sb = new StringBuilder();
        for (char ch : allowedName.toCharArray()) {
            sb.append(ch);
            if (!deniedPrefixes.contains(sb.toString())) continue;
            return true;
        }
        return false;
    }

    List<StandardAcl> findRulesByResourceType(Set<KafkaPrincipal> matchingPrincipals, String host, AclOperation operation, ResourceType resourceType) {
        ArrayList<StandardAcl> matchingAcls = new ArrayList<StandardAcl>();
        for (KafkaPrincipal principal : matchingPrincipals) {
            for (String h : Arrays.asList(host, "*")) {
                for (AclOperation op : Arrays.asList(operation, AclOperation.ALL)) {
                    matchingAcls.addAll(((ImmutableNavigableMap)this.activeAclsByResourceType.getOrDefault((Object)new ResourceTypeKey(resourceType, principal, h, op), (Object)ImmutableNavigableMap.empty())).keySet());
                }
            }
        }
        return matchingAcls;
    }

    private static KafkaPrincipal baseKafkaPrincipal(AuthorizableRequestContext context) {
        KafkaPrincipal sessionPrincipal = context.principal();
        return sessionPrincipal.getClass().equals(KafkaPrincipal.class) ? sessionPrincipal : new KafkaPrincipal(sessionPrincipal.getPrincipalType(), sessionPrincipal.getName());
    }

    private static Set<KafkaPrincipal> matchingPrincipals(KafkaPrincipal principal) {
        return Set.of(principal, StandardAuthorizerConstants.WILDCARD_KAFKA_PRINCIPAL);
    }

    Iterable<AclBinding> acls(AclBindingFilter filter) {
        return this.acls(filter, AclState.ACTIVE);
    }

    Iterable<AclBinding> acls(AclBindingFilter filter, AclState aclState) {
        if (aclState == AclState.ANY) {
            Iterable<AclBinding> activeAcls = this.acls(filter, AclState.ACTIVE);
            Iterable<AclBinding> inactiveAcls = this.acls(filter, AclState.DELETED);
            ArrayList<AclBinding> allAcls = new ArrayList<AclBinding>();
            activeAcls.forEach(allAcls::add);
            inactiveAcls.forEach(allAcls::add);
            return allAcls;
        }
        ImmutableMap<ResourceTypeKey, ImmutableNavigableMap<StandardAcl, AclLinks>> cacheToCheck = aclState == AclState.ACTIVE ? this.activeAclsByResourceType : this.inactiveAclsByResourceType;
        return cacheToCheck.values().stream().map(Map::entrySet).flatMap(Collection::stream).map(entry -> ((StandardAcl)entry.getKey()).toBinding(((AclLinks)entry.getValue()).aclBindingLinksIds())).filter(arg_0 -> ((AclBindingFilter)filter).matches(arg_0)).collect(Collectors.toList());
    }

    boolean validateAclCaches() {
        return this.validateAclsByIdAndResource() && this.validateLiteralsAndPrefixed();
    }

    private boolean validateAclsByIdAndResource() {
        HashSet<StandardAcl> aclsByIdStandardAclSet = new HashSet<StandardAcl>();
        for (ConfluentStandardAcl confluentStandardAcl : this.aclsById.values()) {
            AclLinks aclLinks;
            StandardAcl standardAcl = confluentStandardAcl.standardAcl();
            Uuid linkId = confluentStandardAcl.clusterLinkId().orElse(Uuid.ZERO_UUID);
            if (confluentStandardAcl.aclState() == AclState.ACTIVE ? (aclLinks = (AclLinks)((ImmutableNavigableMap)this.activeAclsByResourceType.getOrDefault((Object)ResourceTypeKey.fromStandardAcl(standardAcl), (Object)ImmutableNavigableMap.empty())).get((Object)standardAcl)) == null || linkId != Uuid.ZERO_UUID && !aclLinks.aclBindingLinksIds().contains(linkId) : (aclLinks = (AclLinks)((ImmutableNavigableMap)this.inactiveAclsByResourceType.getOrDefault((Object)ResourceTypeKey.fromStandardAcl(standardAcl), (Object)ImmutableNavigableMap.empty())).get((Object)standardAcl)) == null || linkId != Uuid.ZERO_UUID && !aclLinks.aclBindingLinksIds().contains(linkId)) {
                return false;
            }
            aclsByIdStandardAclSet.add(standardAcl);
        }
        ImmutableMap allAclsByResource = ImmutableMap.empty();
        this.activeAclsByResourceType.forEach((key, value) -> allAclsByResource.updated(key, value));
        this.inactiveAclsByResourceType.forEach((key, value) -> allAclsByResource.updated(key, value));
        AtomicLong misplacedAclCount = new AtomicLong();
        Set extraAcls = allAclsByResource.entrySet().stream().map(entry -> {
            misplacedAclCount.addAndGet(((ImmutableNavigableMap)entry.getValue()).keySet().stream().filter(acl -> !ResourceTypeKey.fromStandardAcl(acl).equals(entry.getKey())).count());
            return (ImmutableNavigableMap)entry.getValue();
        }).map(Map::keySet).flatMap(Collection::stream).filter(acl -> !aclsByIdStandardAclSet.contains(acl)).collect(Collectors.toSet());
        return misplacedAclCount.get() == 0L && extraAcls.isEmpty();
    }

    private boolean validateLiteralsAndPrefixed() {
        HashSet literalFromAclsByResource = new HashSet();
        HashSet prefixedFromAclsByResource = new HashSet();
        this.activeAclsByResourceType.values().stream().map(Map::keySet).flatMap(Collection::stream).forEach(acl -> {
            if (acl.isWildcardOrPrefix()) {
                prefixedFromAclsByResource.add(acl);
            } else {
                literalFromAclsByResource.add(acl);
            }
        });
        AtomicInteger misplacedAclCount = new AtomicInteger();
        Set literals = this.literalAcls.entrySet().stream().map(entry -> {
            KafkaPrincipal principal = (KafkaPrincipal)entry.getKey();
            ImmutableMap resourceAcls = (ImmutableMap)entry.getValue();
            resourceAcls.forEach((resource, acls) -> {
                if (!acls.validateAclCache(principal, (Resource)resource)) {
                    misplacedAclCount.incrementAndGet();
                }
            });
            return resourceAcls;
        }).map(Map::values).flatMap(Collection::stream).map(ResourceAcls::acls).flatMap(Collection::stream).collect(Collectors.toSet());
        if (!literalFromAclsByResource.containsAll(literals) || !literals.containsAll(literalFromAclsByResource)) {
            return false;
        }
        Set prefixed = this.prefixAcls.entrySet().stream().map(entry -> {
            ResourceType resourceType = (ResourceType)entry.getKey();
            ImmutableMap principalPrefixed = (ImmutableMap)entry.getValue();
            principalPrefixed.forEach((principal, prefixNode) -> {
                if (!prefixNode.validateAclCache((KafkaPrincipal)principal, resourceType, "*")) {
                    misplacedAclCount.incrementAndGet();
                }
            });
            return principalPrefixed.values();
        }).flatMap(Collection::stream).map(PrefixNode::acls).flatMap(Collection::stream).collect(Collectors.toSet());
        return prefixed.equals(prefixedFromAclsByResource);
    }

    static class ResourceTypeKey {
        private final ResourceType resourceType;
        private final KafkaPrincipal principal;
        private final String host;
        private final AclOperation operation;

        static ResourceTypeKey fromStandardAcl(StandardAcl acl) {
            return new ResourceTypeKey(acl.resourceType(), acl.kafkaPrincipal(), acl.host(), acl.operation());
        }

        ResourceTypeKey(ResourceType resourceType, KafkaPrincipal principal, String host, AclOperation operation) {
            this.resourceType = resourceType;
            this.principal = principal;
            this.host = host;
            this.operation = operation;
        }

        public int hashCode() {
            return Objects.hash(this.resourceType, this.principal, this.host, this.operation);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ResourceTypeKey)) {
                return false;
            }
            ResourceTypeKey other = (ResourceTypeKey)o;
            return Objects.equals(this.resourceType, other.resourceType) && Objects.equals(this.principal, other.principal) && Objects.equals(this.host, other.host) && Objects.equals(this.operation, other.operation);
        }

        public String toString() {
            return "(resourceType=" + String.valueOf(this.resourceType) + "principal=" + String.valueOf(this.principal) + "host=" + this.host + "operation=" + String.valueOf(this.operation) + ")";
        }
    }

    public static class AclLinks {
        final StandardAcl acl;
        final ImmutableSet<Uuid> linkIds;

        public AclLinks(StandardAcl acl, ImmutableSet<Uuid> linkIds) {
            this.acl = acl;
            this.linkIds = linkIds;
        }

        public AclLinks copyAndAddLinkId(Optional<Uuid> linkId) {
            if (this.linkIds.contains((Object)linkId.orElse(Uuid.ZERO_UUID))) {
                throw new IllegalStateException("aclsByResource already contains " + String.valueOf(linkId) + " for " + String.valueOf(this.acl));
            }
            ImmutableSet newLinkIds = this.linkIds.added((Object)linkId.orElse(Uuid.ZERO_UUID));
            return new AclLinks(this.acl, (ImmutableSet<Uuid>)newLinkIds);
        }

        public AclLinks copyAndRemoveLinkId(Optional<Uuid> linkId) {
            if (!this.linkIds.contains((Object)linkId.orElse(Uuid.ZERO_UUID))) {
                throw new RuntimeException("Link ID for ACL " + String.valueOf(this.acl) + " not found in aclsByResource");
            }
            ImmutableSet newLinkIds = this.linkIds.removed((Object)linkId.orElse(Uuid.ZERO_UUID));
            return new AclLinks(this.acl, (ImmutableSet<Uuid>)newLinkIds);
        }

        public boolean isEmpty() {
            return this.linkIds.isEmpty();
        }

        public Collection<Uuid> aclBindingLinksIds() {
            ArrayList<Uuid> copy = new ArrayList<Uuid>((Collection<Uuid>)this.linkIds);
            if (copy.size() == 1 && ((Uuid)copy.get(0)).equals((Object)Uuid.ZERO_UUID)) {
                return Collections.emptyList();
            }
            return copy;
        }
    }
}

