/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.confluent.ksql.execution.expression.tree.ArithmeticBinaryExpression;
import io.confluent.ksql.execution.expression.tree.ArithmeticUnaryExpression;
import io.confluent.ksql.execution.expression.tree.BetweenPredicate;
import io.confluent.ksql.execution.expression.tree.BooleanLiteral;
import io.confluent.ksql.execution.expression.tree.Cast;
import io.confluent.ksql.execution.expression.tree.ComparisonExpression;
import io.confluent.ksql.execution.expression.tree.CreateArrayExpression;
import io.confluent.ksql.execution.expression.tree.CreateMapExpression;
import io.confluent.ksql.execution.expression.tree.CreateStructExpression;
import io.confluent.ksql.execution.expression.tree.DecimalLiteral;
import io.confluent.ksql.execution.expression.tree.DereferenceExpression;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.expression.tree.InListExpression;
import io.confluent.ksql.execution.expression.tree.InPredicate;
import io.confluent.ksql.execution.expression.tree.IntervalUnit;
import io.confluent.ksql.execution.expression.tree.IsNotNullPredicate;
import io.confluent.ksql.execution.expression.tree.IsNullPredicate;
import io.confluent.ksql.execution.expression.tree.LambdaFunctionCall;
import io.confluent.ksql.execution.expression.tree.LambdaVariable;
import io.confluent.ksql.execution.expression.tree.LikePredicate;
import io.confluent.ksql.execution.expression.tree.Literal;
import io.confluent.ksql.execution.expression.tree.LogicalBinaryExpression;
import io.confluent.ksql.execution.expression.tree.NotExpression;
import io.confluent.ksql.execution.expression.tree.NullLiteral;
import io.confluent.ksql.execution.expression.tree.QualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.SearchedCaseExpression;
import io.confluent.ksql.execution.expression.tree.SimpleCaseExpression;
import io.confluent.ksql.execution.expression.tree.StringLiteral;
import io.confluent.ksql.execution.expression.tree.SubscriptExpression;
import io.confluent.ksql.execution.expression.tree.Type;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.WhenClause;
import io.confluent.ksql.execution.windows.HoppingWindowExpression;
import io.confluent.ksql.execution.windows.KsqlWindowExpression;
import io.confluent.ksql.execution.windows.SessionWindowExpression;
import io.confluent.ksql.execution.windows.TumblingWindowExpression;
import io.confluent.ksql.execution.windows.WindowTimeClause;
import io.confluent.ksql.metastore.TypeRegistry;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.FunctionName;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.AssertTable;
import io.confluent.ksql.parser.ColumnReferenceParser;
import io.confluent.ksql.parser.DropType;
import io.confluent.ksql.parser.Node;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.OutputRefinement;
import io.confluent.ksql.parser.SqlBaseBaseVisitor;
import io.confluent.ksql.parser.SqlBaseParser;
import io.confluent.ksql.parser.properties.with.CreateSourceAsProperties;
import io.confluent.ksql.parser.properties.with.CreateSourceProperties;
import io.confluent.ksql.parser.properties.with.InsertIntoProperties;
import io.confluent.ksql.parser.tree.AliasedRelation;
import io.confluent.ksql.parser.tree.AllColumns;
import io.confluent.ksql.parser.tree.AlterOption;
import io.confluent.ksql.parser.tree.AlterSource;
import io.confluent.ksql.parser.tree.AlterSystemProperty;
import io.confluent.ksql.parser.tree.AssertSchema;
import io.confluent.ksql.parser.tree.AssertStatement;
import io.confluent.ksql.parser.tree.AssertStream;
import io.confluent.ksql.parser.tree.AssertTombstone;
import io.confluent.ksql.parser.tree.AssertTopic;
import io.confluent.ksql.parser.tree.AssertValues;
import io.confluent.ksql.parser.tree.ColumnConstraints;
import io.confluent.ksql.parser.tree.CreateConnector;
import io.confluent.ksql.parser.tree.CreateStream;
import io.confluent.ksql.parser.tree.CreateStreamAsSelect;
import io.confluent.ksql.parser.tree.CreateTable;
import io.confluent.ksql.parser.tree.CreateTableAsSelect;
import io.confluent.ksql.parser.tree.DefineVariable;
import io.confluent.ksql.parser.tree.DescribeConnector;
import io.confluent.ksql.parser.tree.DescribeFunction;
import io.confluent.ksql.parser.tree.DescribeStreams;
import io.confluent.ksql.parser.tree.DescribeTables;
import io.confluent.ksql.parser.tree.DropConnector;
import io.confluent.ksql.parser.tree.DropStream;
import io.confluent.ksql.parser.tree.DropTable;
import io.confluent.ksql.parser.tree.Explain;
import io.confluent.ksql.parser.tree.GroupBy;
import io.confluent.ksql.parser.tree.InsertInto;
import io.confluent.ksql.parser.tree.InsertValues;
import io.confluent.ksql.parser.tree.Join;
import io.confluent.ksql.parser.tree.JoinOn;
import io.confluent.ksql.parser.tree.JoinedSource;
import io.confluent.ksql.parser.tree.ListConnectorPlugins;
import io.confluent.ksql.parser.tree.ListConnectors;
import io.confluent.ksql.parser.tree.ListFunctions;
import io.confluent.ksql.parser.tree.ListProperties;
import io.confluent.ksql.parser.tree.ListQueries;
import io.confluent.ksql.parser.tree.ListStreams;
import io.confluent.ksql.parser.tree.ListTables;
import io.confluent.ksql.parser.tree.ListTopics;
import io.confluent.ksql.parser.tree.ListTypes;
import io.confluent.ksql.parser.tree.ListVariables;
import io.confluent.ksql.parser.tree.PartitionBy;
import io.confluent.ksql.parser.tree.PauseQuery;
import io.confluent.ksql.parser.tree.PrintTopic;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.RegisterType;
import io.confluent.ksql.parser.tree.Relation;
import io.confluent.ksql.parser.tree.ResumeQuery;
import io.confluent.ksql.parser.tree.Select;
import io.confluent.ksql.parser.tree.SelectItem;
import io.confluent.ksql.parser.tree.SetProperty;
import io.confluent.ksql.parser.tree.ShowColumns;
import io.confluent.ksql.parser.tree.SingleColumn;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.parser.tree.Statements;
import io.confluent.ksql.parser.tree.StructAll;
import io.confluent.ksql.parser.tree.Table;
import io.confluent.ksql.parser.tree.TableElement;
import io.confluent.ksql.parser.tree.TableElements;
import io.confluent.ksql.parser.tree.TerminateQuery;
import io.confluent.ksql.parser.tree.UndefineVariable;
import io.confluent.ksql.parser.tree.UnsetProperty;
import io.confluent.ksql.parser.tree.WindowExpression;
import io.confluent.ksql.parser.tree.WithinExpression;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.schema.Operator;
import io.confluent.ksql.schema.ksql.SqlTypeParser;
import io.confluent.ksql.schema.ksql.SystemColumns;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import io.confluent.ksql.serde.RefinementInfo;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.Pair;
import io.confluent.ksql.util.ParserUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class AstBuilder {
    private final TypeRegistry typeRegistry;

    public AstBuilder(TypeRegistry typeRegistry) {
        this.typeRegistry = Objects.requireNonNull(typeRegistry, "typeRegistry");
    }

    public Statement buildStatement(ParserRuleContext parseTree) {
        return (Statement)((Object)this.build(Optional.of(AstBuilder.getSources((ParseTree)parseTree)), parseTree));
    }

    public Expression buildExpression(ParserRuleContext parseTree) {
        return (Expression)this.build(Optional.empty(), parseTree);
    }

    public WindowExpression buildWindowExpression(ParserRuleContext parseTree) {
        return (WindowExpression)((Object)this.build(Optional.empty(), parseTree));
    }

    public AssertStatement buildAssertStatement(ParserRuleContext parseTree) {
        return (AssertStatement)((Object)this.build(Optional.empty(), parseTree));
    }

    private <T extends Node> T build(Optional<Set<SourceName>> sources, ParserRuleContext parseTree) {
        return (T)((Node)new Visitor(sources, this.typeRegistry).visit((ParseTree)parseTree));
    }

    private static Set<SourceName> getSources(ParseTree parseTree) {
        try {
            SourceAccumulator accumulator = new SourceAccumulator();
            accumulator.visit(parseTree);
            return accumulator.getSources();
        }
        catch (StackOverflowError e) {
            throw new KsqlException("Error processing statement: Statement is too large to parse. This may be caused by having too many nested expressions in the statement.");
        }
    }

    private static void disallowLimitClause(Query query, String streamOrTable) throws KsqlException {
        if (query.getLimit().isPresent()) {
            String errorMessage = String.format("CREATE %s AS SELECT statements don't support LIMIT clause.", streamOrTable);
            throw new KsqlException(errorMessage);
        }
    }

    private static final class Visitor
    extends SqlBaseBaseVisitor<Node> {
        private static final String DEFAULT_WINDOW_NAME = "StreamWindow";
        private final Optional<Set<SourceName>> sources;
        private final SqlTypeParser typeParser;
        private final Set<String> lambdaArgs;
        private boolean buildingPersistentQuery = false;

        Visitor(Optional<Set<SourceName>> sources, TypeRegistry typeRegistry) {
            this.sources = Objects.requireNonNull(sources, "sources").map(ImmutableSet::copyOf);
            this.typeParser = SqlTypeParser.create(typeRegistry);
            this.lambdaArgs = new HashSet<String>();
        }

        @Override
        public Node visitStatements(SqlBaseParser.StatementsContext context) {
            ArrayList<Statement> statementList = new ArrayList<Statement>();
            for (SqlBaseParser.SingleStatementContext stmtContext : context.singleStatement()) {
                Statement statement = (Statement)this.visitSingleStatement(stmtContext);
                statementList.add(statement);
            }
            return new Statements(ParserUtil.getLocation(context), statementList);
        }

        @Override
        public Node visitSingleStatement(SqlBaseParser.SingleStatementContext context) {
            return (Node)this.visit((ParseTree)context.statement());
        }

        @Override
        public Node visitSingleExpression(SqlBaseParser.SingleExpressionContext context) {
            return (Node)this.visit((ParseTree)context.expression());
        }

        private Map<String, Literal> processTableProperties(SqlBaseParser.TablePropertiesContext tablePropertiesContext) {
            ImmutableMap.Builder properties = ImmutableMap.builder();
            if (tablePropertiesContext != null) {
                for (SqlBaseParser.TablePropertyContext prop : tablePropertiesContext.tableProperty()) {
                    if (prop.identifier() != null) {
                        properties.put((Object)ParserUtil.getIdentifierText(prop.identifier()), (Object)((Literal)this.visit((ParseTree)prop.literal())));
                        continue;
                    }
                    properties.put((Object)ParserUtil.unquote(prop.STRING().getText(), "'"), (Object)((Literal)this.visit((ParseTree)prop.literal())));
                }
            }
            return properties.build();
        }

        @Override
        public Node visitCreateTable(SqlBaseParser.CreateTableContext context) {
            ImmutableList elements = context.tableElements() == null ? ImmutableList.of() : this.visit(context.tableElements().tableElement(), TableElement.class);
            Map<String, Literal> properties = this.processTableProperties(context.tableProperties());
            return new CreateTable(ParserUtil.getLocation(context), ParserUtil.getSourceName(context.sourceName()), TableElements.of((List<TableElement>)elements), context.REPLACE() != null, context.EXISTS() != null, CreateSourceProperties.from(properties), context.SOURCE() != null);
        }

        @Override
        public Node visitCreateStream(SqlBaseParser.CreateStreamContext context) {
            ImmutableList elements = context.tableElements() == null ? ImmutableList.of() : this.visit(context.tableElements().tableElement(), TableElement.class);
            Map<String, Literal> properties = this.processTableProperties(context.tableProperties());
            return new CreateStream(ParserUtil.getLocation(context), ParserUtil.getSourceName(context.sourceName()), TableElements.of((List<TableElement>)elements), context.REPLACE() != null, context.EXISTS() != null, CreateSourceProperties.from(properties), context.SOURCE() != null);
        }

        @Override
        public Node visitCreateStreamAs(SqlBaseParser.CreateStreamAsContext context) {
            Map<String, Literal> properties = this.processTableProperties(context.tableProperties());
            Query query = this.withinPersistentQuery(() -> this.visitQuery(context.query()));
            AstBuilder.disallowLimitClause(query, "STREAM");
            return new CreateStreamAsSelect(ParserUtil.getLocation(context), ParserUtil.getSourceName(context.sourceName()), query, context.EXISTS() != null, context.REPLACE() != null, CreateSourceAsProperties.from(properties));
        }

        @Override
        public Node visitCreateTableAs(SqlBaseParser.CreateTableAsContext context) {
            Map<String, Literal> properties = this.processTableProperties(context.tableProperties());
            Query query = this.withinPersistentQuery(() -> this.visitQuery(context.query()));
            AstBuilder.disallowLimitClause(query, "TABLE");
            return new CreateTableAsSelect(ParserUtil.getLocation(context), ParserUtil.getSourceName(context.sourceName()), query, context.EXISTS() != null, context.REPLACE() != null, CreateSourceAsProperties.from(properties));
        }

        @Override
        public Node visitCreateConnector(SqlBaseParser.CreateConnectorContext context) {
            Map<String, Literal> properties = this.processTableProperties(context.tableProperties());
            String name = ParserUtil.getIdentifierText(context.identifier());
            CreateConnector.Type type = context.SOURCE() != null ? CreateConnector.Type.SOURCE : CreateConnector.Type.SINK;
            return new CreateConnector(ParserUtil.getLocation(context), name, properties, type, context.EXISTS() != null);
        }

        @Override
        public Node visitInsertInto(SqlBaseParser.InsertIntoContext context) {
            SourceName targetName = ParserUtil.getSourceName(context.sourceName());
            Query query = this.withinPersistentQuery(() -> this.visitQuery(context.query()));
            Map<String, Literal> properties = this.processTableProperties(context.tableProperties());
            return new InsertInto(ParserUtil.getLocation(context), targetName, query, InsertIntoProperties.from(properties));
        }

        @Override
        public Node visitInsertValues(SqlBaseParser.InsertValuesContext context) {
            SourceName targetName = ParserUtil.getSourceName(context.sourceName());
            Optional<NodeLocation> targetLocation = ParserUtil.getLocation(context.sourceName());
            Object columns = context.columns() != null ? context.columns().identifier().stream().map(ParserUtil::getIdentifierText).map(ColumnName::of).collect(Collectors.toList()) : ImmutableList.of();
            return new InsertValues(targetLocation, targetName, (List<ColumnName>)columns, this.visit(context.values().valueExpression(), Expression.class));
        }

        @Override
        public Node visitDropTable(SqlBaseParser.DropTableContext context) {
            return new DropTable(ParserUtil.getLocation(context), ParserUtil.getSourceName(context.sourceName()), context.EXISTS() != null, context.DELETE() != null);
        }

        @Override
        public Node visitDropStream(SqlBaseParser.DropStreamContext context) {
            return new DropStream(ParserUtil.getLocation(context), ParserUtil.getSourceName(context.sourceName()), context.EXISTS() != null, context.DELETE() != null);
        }

        @Override
        public Node visitDropConnector(SqlBaseParser.DropConnectorContext context) {
            return new DropConnector(ParserUtil.getLocation(context), context.EXISTS() != null, ParserUtil.getIdentifierText(context.identifier()));
        }

        @Override
        public Query visitQuery(SqlBaseParser.QueryContext context) {
            boolean pullQuery;
            Relation from = (Relation)((Object)this.visit((ParseTree)context.from));
            Select select = new Select(ParserUtil.getLocation(context.SELECT()), this.visit(context.selectItem(), SelectItem.class));
            boolean bl = pullQuery = context.EMIT() == null && !this.buildingPersistentQuery;
            Optional<OutputRefinement> outputRefinement = pullQuery ? Optional.empty() : (this.buildingPersistentQuery ? Optional.of(Optional.ofNullable(context.resultMaterialization()).map(rm -> rm.FINAL() == null ? OutputRefinement.CHANGES : OutputRefinement.FINAL).orElse(OutputRefinement.CHANGES)) : Optional.of(context.resultMaterialization().CHANGES() == null ? OutputRefinement.FINAL : OutputRefinement.CHANGES));
            Optional<RefinementInfo> refinementInfo = outputRefinement.map(RefinementInfo::of);
            OptionalInt limit = Visitor.getLimit(context.limitClause());
            return new Query(ParserUtil.getLocation(context), select, from, this.visitIfPresent(context.windowExpression(), WindowExpression.class), this.visitIfPresent(context.where, Expression.class), this.visitIfPresent(context.groupBy(), GroupBy.class), this.visitIfPresent(context.partitionBy(), PartitionBy.class), this.visitIfPresent(context.having, Expression.class), refinementInfo, pullQuery, limit);
        }

        @Override
        public Node visitWindowExpression(SqlBaseParser.WindowExpressionContext ctx) {
            String windowName = DEFAULT_WINDOW_NAME;
            if (ctx.IDENTIFIER() != null) {
                windowName = ctx.IDENTIFIER().getText();
            }
            windowName = windowName.toUpperCase();
            if (ctx.tumblingWindowExpression() != null) {
                TumblingWindowExpression tumblingWindowExpression = (TumblingWindowExpression)this.visitTumblingWindowExpression(ctx.tumblingWindowExpression());
                return new WindowExpression(ParserUtil.getLocation(ctx.tumblingWindowExpression()), windowName, (KsqlWindowExpression)tumblingWindowExpression);
            }
            if (ctx.hoppingWindowExpression() != null) {
                HoppingWindowExpression hoppingWindowExpression = (HoppingWindowExpression)this.visitHoppingWindowExpression(ctx.hoppingWindowExpression());
                return new WindowExpression(ParserUtil.getLocation(ctx.hoppingWindowExpression()), windowName, (KsqlWindowExpression)hoppingWindowExpression);
            }
            if (ctx.sessionWindowExpression() != null) {
                SessionWindowExpression sessionWindowExpression = (SessionWindowExpression)this.visitSessionWindowExpression(ctx.sessionWindowExpression());
                return new WindowExpression(ParserUtil.getLocation(ctx.sessionWindowExpression()), windowName, (KsqlWindowExpression)sessionWindowExpression);
            }
            throw new KsqlException("Window description is not correct.");
        }

        private static WindowTimeClause getTimeClause(SqlBaseParser.NumberContext number, SqlBaseParser.WindowUnitContext unitCtx) {
            return new WindowTimeClause(Long.parseLong(number.getText()), WindowExpression.getWindowUnit(unitCtx.getText().toUpperCase()));
        }

        private static Optional<WindowTimeClause> gracePeriodClause(SqlBaseParser.GracePeriodClauseContext graceCtx) {
            return graceCtx != null ? Optional.of(Visitor.getTimeClause(graceCtx.number(), graceCtx.windowUnit())) : Optional.empty();
        }

        private static Optional<WindowTimeClause> retentionClause(SqlBaseParser.RetentionClauseContext retentionCtx) {
            return retentionCtx != null ? Optional.of(Visitor.getTimeClause(retentionCtx.number(), retentionCtx.windowUnit())) : Optional.empty();
        }

        @Override
        public Node visitHoppingWindowExpression(SqlBaseParser.HoppingWindowExpressionContext ctx) {
            List<SqlBaseParser.NumberContext> numberList = ctx.number();
            List<SqlBaseParser.WindowUnitContext> windowUnits = ctx.windowUnit();
            return new HoppingWindowExpression(ParserUtil.getLocation(ctx), Visitor.getTimeClause(numberList.get(0), windowUnits.get(0)), Visitor.getTimeClause(numberList.get(1), windowUnits.get(1)), Visitor.retentionClause(ctx.retentionClause()), Visitor.gracePeriodClause(ctx.gracePeriodClause()));
        }

        @Override
        public Node visitTumblingWindowExpression(SqlBaseParser.TumblingWindowExpressionContext ctx) {
            return new TumblingWindowExpression(ParserUtil.getLocation(ctx), Visitor.getTimeClause(ctx.number(), ctx.windowUnit()), Visitor.retentionClause(ctx.retentionClause()), Visitor.gracePeriodClause(ctx.gracePeriodClause()));
        }

        @Override
        public Node visitSessionWindowExpression(SqlBaseParser.SessionWindowExpressionContext ctx) {
            return new SessionWindowExpression(ParserUtil.getLocation(ctx), Visitor.getTimeClause(ctx.number(), ctx.windowUnit()), Visitor.retentionClause(ctx.retentionClause()), Visitor.gracePeriodClause(ctx.gracePeriodClause()));
        }

        private static Node visitWithinExpression(SqlBaseParser.WithinExpressionContext ctx) {
            Optional<WindowTimeClause> gracePeriod;
            Pair<Long, TimeUnit> afterSize;
            Pair<Long, TimeUnit> beforeSize;
            if (ctx instanceof SqlBaseParser.SingleJoinWindowContext) {
                SqlBaseParser.SingleJoinWindowContext singleWithin = (SqlBaseParser.SingleJoinWindowContext)ctx;
                afterSize = beforeSize = Visitor.getSizeAndUnitFromJoinWindowSize(singleWithin.joinWindowSize());
                gracePeriod = Visitor.gracePeriodClause(singleWithin.gracePeriodClause());
            } else if (ctx instanceof SqlBaseParser.JoinWindowWithBeforeAndAfterContext) {
                SqlBaseParser.JoinWindowWithBeforeAndAfterContext beforeAndAfterJoinWindow = (SqlBaseParser.JoinWindowWithBeforeAndAfterContext)ctx;
                beforeSize = Visitor.getSizeAndUnitFromJoinWindowSize(beforeAndAfterJoinWindow.joinWindowSize(0));
                afterSize = Visitor.getSizeAndUnitFromJoinWindowSize(beforeAndAfterJoinWindow.joinWindowSize(1));
                gracePeriod = Visitor.gracePeriodClause(beforeAndAfterJoinWindow.gracePeriodClause());
            } else {
                throw new RuntimeException("Expecting either a single join window, ie \"WITHIN 10 seconds\" or \"WITHIN 10 seconds GRACE PERIOD 2 seconds\", or a join window with before and after specified, ie. \"WITHIN (10 seconds, 20 seconds)\" or WITHIN (10 seconds, 20 seconds) GRACE PERIOD 5 seconds");
            }
            return new WithinExpression(ParserUtil.getLocation(ctx), (Long)beforeSize.left, (Long)afterSize.left, (TimeUnit)((Object)beforeSize.right), (TimeUnit)((Object)afterSize.right), gracePeriod);
        }

        private static Pair<Long, TimeUnit> getSizeAndUnitFromJoinWindowSize(SqlBaseParser.JoinWindowSizeContext joinWindowSize) {
            return new Pair((Object)Long.parseLong(joinWindowSize.number().getText()), (Object)WindowExpression.getWindowUnit(joinWindowSize.windowUnit().getText().toUpperCase()));
        }

        @Override
        public Node visitGroupBy(SqlBaseParser.GroupByContext ctx) {
            List<Expression> expressions = this.visit(ctx.valueExpression(), Expression.class);
            return new GroupBy(ParserUtil.getLocation(ctx), expressions);
        }

        @Override
        public Node visitPartitionBy(SqlBaseParser.PartitionByContext ctx) {
            List<Expression> expressions = this.visit(ctx.valueExpression(), Expression.class);
            return new PartitionBy(ParserUtil.getLocation(ctx), expressions);
        }

        @Override
        public Node visitSelectAll(SqlBaseParser.SelectAllContext context) {
            Optional<SourceName> prefix = Optional.ofNullable(context.identifier()).map(ParserUtil::getIdentifierText).map(SourceName::of);
            prefix.ifPresent(this::throwOnUnknownNameOrAlias);
            return new AllColumns(ParserUtil.getLocation(context), prefix);
        }

        @Override
        public Node visitSelectSingle(SqlBaseParser.SelectSingleContext context) {
            Expression selectItem = (Expression)this.visit((ParseTree)context.expression());
            if (context.identifier() != null) {
                return new SingleColumn(ParserUtil.getLocation(context), selectItem, Optional.of(ColumnName.of((String)ParserUtil.getIdentifierText(context.identifier()))));
            }
            return new SingleColumn(ParserUtil.getLocation(context), selectItem, Optional.empty());
        }

        @Override
        public Node visitLambda(SqlBaseParser.LambdaContext context) {
            List arguments = context.identifier().stream().map(ParserUtil::getIdentifierText).collect(Collectors.toList());
            HashSet<String> previousLambdaArgs = new HashSet<String>(this.lambdaArgs);
            this.lambdaArgs.addAll(arguments);
            Expression body = (Expression)this.visit((ParseTree)context.expression());
            this.lambdaArgs.clear();
            this.lambdaArgs.addAll(previousLambdaArgs);
            return new LambdaFunctionCall(ParserUtil.getLocation(context), arguments, body);
        }

        @Override
        public Node visitListTopics(SqlBaseParser.ListTopicsContext context) {
            return new ListTopics(ParserUtil.getLocation(context), context.ALL() != null, context.EXTENDED() != null);
        }

        @Override
        public Node visitListStreams(SqlBaseParser.ListStreamsContext context) {
            return new ListStreams(ParserUtil.getLocation(context), context.EXTENDED() != null);
        }

        @Override
        public Node visitListTables(SqlBaseParser.ListTablesContext context) {
            return new ListTables(ParserUtil.getLocation(context), context.EXTENDED() != null);
        }

        @Override
        public Node visitListQueries(SqlBaseParser.ListQueriesContext context) {
            return new ListQueries(ParserUtil.getLocation(context), context.EXTENDED() != null);
        }

        @Override
        public Node visitListFunctions(SqlBaseParser.ListFunctionsContext ctx) {
            return new ListFunctions(ParserUtil.getLocation(ctx));
        }

        @Override
        public Node visitListConnectors(SqlBaseParser.ListConnectorsContext ctx) {
            ListConnectors.Scope scope = ctx.SOURCE() != null ? ListConnectors.Scope.SOURCE : (ctx.SINK() != null ? ListConnectors.Scope.SINK : ListConnectors.Scope.ALL);
            return new ListConnectors(ParserUtil.getLocation(ctx), scope);
        }

        @Override
        public Node visitListConnectorPlugins(SqlBaseParser.ListConnectorPluginsContext ctx) {
            return new ListConnectorPlugins(ParserUtil.getLocation(ctx));
        }

        @Override
        public Node visitDropType(SqlBaseParser.DropTypeContext ctx) {
            return new DropType(ParserUtil.getLocation(ctx), ParserUtil.getIdentifierText(ctx.identifier()), ctx.EXISTS() != null);
        }

        @Override
        public Node visitAlterSource(SqlBaseParser.AlterSourceContext ctx) {
            return new AlterSource(ParserUtil.getSourceName(ctx.sourceName()), ctx.STREAM() != null ? DataSource.DataSourceType.KSTREAM : DataSource.DataSourceType.KTABLE, ctx.alterOption().stream().map(gf -> (AlterOption)((Object)((Object)this.visit((ParseTree)gf)))).collect(Collectors.toList()));
        }

        @Override
        public Node visitAlterOption(SqlBaseParser.AlterOptionContext ctx) {
            return new AlterOption(ParserUtil.getIdentifierText(ctx.identifier()), this.typeParser.getType(ctx.type()));
        }

        @Override
        public Node visitListTypes(SqlBaseParser.ListTypesContext ctx) {
            return new ListTypes(ParserUtil.getLocation(ctx));
        }

        @Override
        public Node visitPauseQuery(SqlBaseParser.PauseQueryContext context) {
            Optional<NodeLocation> location = ParserUtil.getLocation(context);
            return context.ALL() != null ? PauseQuery.all(location) : PauseQuery.query(location, new QueryId(ParserUtil.getIdentifierText(false, context.identifier())));
        }

        @Override
        public Node visitResumeQuery(SqlBaseParser.ResumeQueryContext context) {
            Optional<NodeLocation> location = ParserUtil.getLocation(context);
            return context.ALL() != null ? ResumeQuery.all(location) : ResumeQuery.query(location, new QueryId(ParserUtil.getIdentifierText(false, context.identifier())));
        }

        @Override
        public Node visitTerminateQuery(SqlBaseParser.TerminateQueryContext context) {
            Optional<NodeLocation> location = ParserUtil.getLocation(context);
            return context.ALL() != null ? TerminateQuery.all(location) : TerminateQuery.query(location, new QueryId(ParserUtil.getIdentifierText(false, context.identifier())));
        }

        @Override
        public Node visitShowColumns(SqlBaseParser.ShowColumnsContext context) {
            if (context.sourceName().identifier() instanceof SqlBaseParser.UnquotedIdentifierContext && context.sourceName().getText().toUpperCase().equals("TABLES")) {
                return new DescribeTables(ParserUtil.getLocation(context), context.EXTENDED() != null);
            }
            return new ShowColumns(ParserUtil.getLocation(context), ParserUtil.getSourceName(context.sourceName()), context.EXTENDED() != null);
        }

        @Override
        public Node visitListProperties(SqlBaseParser.ListPropertiesContext context) {
            return new ListProperties(ParserUtil.getLocation(context));
        }

        @Override
        public Node visitListVariables(SqlBaseParser.ListVariablesContext context) {
            return new ListVariables(ParserUtil.getLocation(context));
        }

        @Override
        public Node visitSetProperty(SqlBaseParser.SetPropertyContext context) {
            String propertyName = ParserUtil.unquote(context.STRING(0).getText(), "'");
            String propertyValue = ParserUtil.unquote(context.STRING(1).getText(), "'");
            return new SetProperty(ParserUtil.getLocation(context), propertyName, propertyValue);
        }

        @Override
        public Node visitAlterSystemProperty(SqlBaseParser.AlterSystemPropertyContext context) {
            String propertyName = ParserUtil.unquote(context.STRING(0).getText(), "'");
            String propertyValue = ParserUtil.unquote(context.STRING(1).getText(), "'");
            return new AlterSystemProperty(ParserUtil.getLocation(context), propertyName, propertyValue);
        }

        @Override
        public Node visitUnsetProperty(SqlBaseParser.UnsetPropertyContext context) {
            String propertyName = ParserUtil.unquote(context.STRING().getText(), "'");
            return new UnsetProperty(ParserUtil.getLocation(context), propertyName);
        }

        @Override
        public Node visitDefineVariable(SqlBaseParser.DefineVariableContext context) {
            String variableName = context.variableName().getText();
            String variableValue = ParserUtil.unquote(context.variableValue().getText(), "'");
            return new DefineVariable(ParserUtil.getLocation(context), variableName, variableValue);
        }

        @Override
        public Node visitUndefineVariable(SqlBaseParser.UndefineVariableContext context) {
            String variableName = context.variableName().getText();
            return new UndefineVariable(ParserUtil.getLocation(context), variableName);
        }

        @Override
        public Node visitPrintTopic(SqlBaseParser.PrintTopicContext context) {
            boolean fromBeginning = context.printClause().FROM() != null;
            String topicName = this.getResourceName(context.resourceName());
            SqlBaseParser.IntervalClauseContext intervalContext = context.printClause().intervalClause();
            OptionalInt interval = intervalContext == null ? OptionalInt.empty() : OptionalInt.of(ParserUtil.processIntegerNumber(intervalContext.number(), "INTERVAL"));
            OptionalInt limit = Visitor.getLimit(context.printClause().limitClause());
            return new PrintTopic(ParserUtil.getLocation(context), topicName, fromBeginning, interval, limit);
        }

        private String getResourceName(SqlBaseParser.ResourceNameContext context) {
            if (context.STRING() != null) {
                return ParserUtil.unquote(context.STRING().getText(), "'");
            }
            return ParserUtil.getIdentifierText(true, context.identifier());
        }

        @Override
        public Node visitLogicalNot(SqlBaseParser.LogicalNotContext context) {
            return new NotExpression(ParserUtil.getLocation(context), (Expression)this.visit((ParseTree)context.booleanExpression()));
        }

        @Override
        public Node visitLogicalBinary(SqlBaseParser.LogicalBinaryContext context) {
            return new LogicalBinaryExpression(ParserUtil.getLocation(context.operator), Visitor.getLogicalBinaryOperator(context.operator), (Expression)this.visit((ParseTree)context.left), (Expression)this.visit((ParseTree)context.right));
        }

        @Override
        public Node visitJoinRelation(SqlBaseParser.JoinRelationContext joinRelationContext) {
            AliasedRelation left = (AliasedRelation)((Object)this.visit((ParseTree)joinRelationContext.left));
            ImmutableList rights = (ImmutableList)joinRelationContext.joinedSource().stream().map(this::visitJoinedSource).collect(ImmutableList.toImmutableList());
            return new Join(ParserUtil.getLocation(joinRelationContext), left, (List<JoinedSource>)rights);
        }

        @Override
        public JoinedSource visitJoinedSource(SqlBaseParser.JoinedSourceContext context) {
            JoinedSource.Type joinType;
            if (context.joinCriteria().ON() == null) {
                throw new KsqlException("Invalid join criteria specified. KSQL only supports joining on column values. For example `... left JOIN right on left.col = right.col ...`. Tables can only be joined on the Table's key column. KSQL will repartition streams if the column in the join criteria is not the key column.");
            }
            JoinOn criteria = new JoinOn((Expression)this.visit((ParseTree)context.joinCriteria().booleanExpression()));
            SqlBaseParser.JoinTypeContext joinTypeContext = context.joinType();
            if (joinTypeContext instanceof SqlBaseParser.LeftJoinContext) {
                joinType = JoinedSource.Type.LEFT;
            } else if (joinTypeContext instanceof SqlBaseParser.RightJoinContext) {
                joinType = JoinedSource.Type.RIGHT;
            } else if (joinTypeContext instanceof SqlBaseParser.OuterJoinContext) {
                joinType = JoinedSource.Type.OUTER;
            } else if (joinTypeContext instanceof SqlBaseParser.InnerJoinContext) {
                joinType = JoinedSource.Type.INNER;
            } else {
                throw new KsqlException("Invalid join type - " + joinTypeContext.getText());
            }
            WithinExpression withinExpression = null;
            if (context.joinWindow() != null) {
                withinExpression = (WithinExpression)Visitor.visitWithinExpression(context.joinWindow().withinExpression());
            }
            AliasedRelation right = (AliasedRelation)((Object)this.visit((ParseTree)context.aliasedRelation()));
            return new JoinedSource(ParserUtil.getLocation(context), right, joinType, criteria, Optional.ofNullable(withinExpression));
        }

        @Override
        public Node visitAliasedRelation(SqlBaseParser.AliasedRelationContext context) {
            Relation child = (Relation)((Object)this.visit((ParseTree)context.relationPrimary()));
            return new AliasedRelation(ParserUtil.getLocation(context), child, switch (context.children.size()) {
                case 1 -> {
                    Table table = (Table)((Object)this.visit((ParseTree)context.relationPrimary()));
                    yield table.getName();
                }
                case 2 -> ParserUtil.getSourceName((SqlBaseParser.SourceNameContext)((Object)context.children.get(1)));
                case 3 -> ParserUtil.getSourceName((SqlBaseParser.SourceNameContext)((Object)context.children.get(2)));
                default -> throw new IllegalArgumentException("AliasedRelationContext must have between 1 and 3 children, but has:" + context.children.size());
            });
        }

        @Override
        public Node visitTableName(SqlBaseParser.TableNameContext context) {
            return new Table(ParserUtil.getLocation(context), ParserUtil.getSourceName(context.sourceName()));
        }

        @Override
        public Node visitPredicated(SqlBaseParser.PredicatedContext context) {
            if (context.predicate() != null) {
                return (Node)this.visit((ParseTree)context.predicate());
            }
            return (Node)this.visit((ParseTree)context.valueExpression);
        }

        @Override
        public Node visitComparison(SqlBaseParser.ComparisonContext context) {
            return new ComparisonExpression(ParserUtil.getLocation(context.comparisonOperator()), Visitor.getComparisonOperator(((TerminalNode)context.comparisonOperator().getChild(0)).getSymbol()), (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.right));
        }

        @Override
        public Node visitDistinctFrom(SqlBaseParser.DistinctFromContext context) {
            ComparisonExpression expression = new ComparisonExpression(ParserUtil.getLocation(context), ComparisonExpression.Type.IS_DISTINCT_FROM, (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.right));
            if (context.NOT() != null) {
                expression = new NotExpression(ParserUtil.getLocation(context), (Expression)expression);
            }
            return expression;
        }

        @Override
        public Node visitBetween(SqlBaseParser.BetweenContext context) {
            BetweenPredicate expression = new BetweenPredicate(ParserUtil.getLocation(context), (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.lower), (Expression)this.visit((ParseTree)context.upper));
            if (context.NOT() != null) {
                expression = new NotExpression(ParserUtil.getLocation(context), (Expression)expression);
            }
            return expression;
        }

        @Override
        public Node visitNullPredicate(SqlBaseParser.NullPredicateContext context) {
            Expression child = (Expression)this.visit((ParseTree)context.value);
            if (context.NOT() == null) {
                return new IsNullPredicate(ParserUtil.getLocation(context), child);
            }
            return new IsNotNullPredicate(ParserUtil.getLocation(context), child);
        }

        @Override
        public Node visitLike(SqlBaseParser.LikeContext context) {
            Optional<String> escape = Optional.ofNullable(context.escape).map(Token::getText).map(s -> ParserUtil.unquote(s, "'"));
            escape.ifPresent(s -> {
                if (s.length() != 1) {
                    throw new KsqlException(String.valueOf(ParserUtil.getLocation(context.escape)) + ": Expected single character escape but got: " + s);
                }
            });
            LikePredicate result = new LikePredicate(ParserUtil.getLocation(context), (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.pattern), escape.map(s -> Character.valueOf(s.charAt(0))));
            if (context.NOT() == null) {
                return result;
            }
            return new NotExpression(ParserUtil.getLocation(context), (Expression)result);
        }

        @Override
        public Node visitInList(SqlBaseParser.InListContext context) {
            InPredicate result = new InPredicate(ParserUtil.getLocation(context), (Expression)this.visit((ParseTree)context.value), new InListExpression(ParserUtil.getLocation(context), this.visit(context.expression(), Expression.class)));
            if (context.NOT() != null) {
                result = new NotExpression(ParserUtil.getLocation(context), (Expression)result);
            }
            return result;
        }

        @Override
        public Node visitArithmeticUnary(SqlBaseParser.ArithmeticUnaryContext context) {
            Expression child = (Expression)this.visit((ParseTree)context.valueExpression());
            switch (context.operator.getType()) {
                case 160: {
                    return ArithmeticUnaryExpression.negative(ParserUtil.getLocation(context), (Expression)child);
                }
                case 159: {
                    return ArithmeticUnaryExpression.positive(ParserUtil.getLocation(context), (Expression)child);
                }
            }
            throw new UnsupportedOperationException("Unsupported sign: " + context.operator.getText());
        }

        @Override
        public Node visitArithmeticBinary(SqlBaseParser.ArithmeticBinaryContext context) {
            return new ArithmeticBinaryExpression(ParserUtil.getLocation(context.operator), Visitor.getArithmeticBinaryOperator(context.operator), (Expression)this.visit((ParseTree)context.left), (Expression)this.visit((ParseTree)context.right));
        }

        @Override
        public Node visitConcatenation(SqlBaseParser.ConcatenationContext context) {
            return new FunctionCall(ParserUtil.getLocation(context.CONCAT()), FunctionName.of((String)"concat"), (List)ImmutableList.of((Object)((Expression)this.visit((ParseTree)context.left)), (Object)((Expression)this.visit((ParseTree)context.right))));
        }

        @Override
        public Node visitTimeZoneString(SqlBaseParser.TimeZoneStringContext context) {
            return new StringLiteral(ParserUtil.getLocation(context), ParserUtil.unquote(context.STRING().getText(), "'"));
        }

        @Override
        public Node visitParenthesizedExpression(SqlBaseParser.ParenthesizedExpressionContext context) {
            return (Node)this.visit((ParseTree)context.expression());
        }

        @Override
        public Node visitCast(SqlBaseParser.CastContext context) {
            return new Cast(ParserUtil.getLocation(context), (Expression)this.visit((ParseTree)context.expression()), this.typeParser.getType(context.type()));
        }

        @Override
        public Node visitArrayConstructor(SqlBaseParser.ArrayConstructorContext context) {
            ImmutableList.Builder values = ImmutableList.builder();
            for (SqlBaseParser.ExpressionContext exp : context.expression()) {
                values.add((Object)((Expression)this.visit((ParseTree)exp)));
            }
            return new CreateArrayExpression(ParserUtil.getLocation(context), (List)values.build());
        }

        @Override
        public Node visitMapConstructor(SqlBaseParser.MapConstructorContext context) {
            ImmutableMap.Builder values = ImmutableMap.builder();
            List<SqlBaseParser.ExpressionContext> expression = context.expression();
            for (int i = 0; i < expression.size(); i += 2) {
                values.put((Object)((Expression)this.visit((ParseTree)expression.get(i))), (Object)((Expression)this.visit((ParseTree)expression.get(i + 1))));
            }
            return new CreateMapExpression(ParserUtil.getLocation(context), (Map)values.build());
        }

        @Override
        public Node visitStructConstructor(SqlBaseParser.StructConstructorContext context) {
            ImmutableList.Builder fields = ImmutableList.builder();
            for (int i = 0; i < context.identifier().size(); ++i) {
                fields.add((Object)new CreateStructExpression.Field(ParserUtil.getIdentifierText(context.identifier(i)), (Expression)this.visit((ParseTree)context.expression(i))));
            }
            return new CreateStructExpression(ParserUtil.getLocation(context), (List)fields.build());
        }

        @Override
        public Node visitSubscript(SqlBaseParser.SubscriptContext context) {
            return new SubscriptExpression(ParserUtil.getLocation(context), (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.index));
        }

        @Override
        public Node visitDereference(SqlBaseParser.DereferenceContext context) {
            String fieldName = ParserUtil.getIdentifierText(context.identifier());
            Expression baseExpression = (Expression)this.visit((ParseTree)context.base);
            return new DereferenceExpression(ParserUtil.getLocation(context), baseExpression, fieldName);
        }

        @Override
        public Node visitSelectStructAll(SqlBaseParser.SelectStructAllContext context) {
            Expression baseExpression = (Expression)this.visit((ParseTree)context.base);
            return new StructAll(ParserUtil.getLocation(context), baseExpression);
        }

        @Override
        public Node visitColumnReference(SqlBaseParser.ColumnReferenceContext context) {
            UnqualifiedColumnReferenceExp column = ColumnReferenceParser.resolve(context);
            if (this.lambdaArgs.contains(column.toString())) {
                return new LambdaVariable(column.toString());
            }
            return column;
        }

        @Override
        public Node visitQualifiedColumnReference(SqlBaseParser.QualifiedColumnReferenceContext context) {
            QualifiedColumnReferenceExp columnReferenceExp = ColumnReferenceParser.resolve(context);
            this.throwOnUnknownNameOrAlias(columnReferenceExp.getQualifier());
            return columnReferenceExp;
        }

        @Override
        public Node visitSimpleCase(SqlBaseParser.SimpleCaseContext context) {
            return new SimpleCaseExpression(ParserUtil.getLocation(context), (Expression)this.visit((ParseTree)context.valueExpression()), this.visit(context.whenClause(), WhenClause.class), this.visitIfPresent(context.elseExpression, Expression.class));
        }

        @Override
        public Node visitSearchedCase(SqlBaseParser.SearchedCaseContext context) {
            return new SearchedCaseExpression(ParserUtil.getLocation(context), this.visit(context.whenClause(), WhenClause.class), this.visitIfPresent(context.elseExpression, Expression.class));
        }

        @Override
        public Node visitWhenClause(SqlBaseParser.WhenClauseContext context) {
            return new WhenClause(ParserUtil.getLocation(context), (Expression)this.visit((ParseTree)context.condition), (Expression)this.visit((ParseTree)context.result));
        }

        @Override
        public Node visitFunctionCall(SqlBaseParser.FunctionCallContext context) {
            List<Expression> expressionList = this.visit(context.functionArgument(), Expression.class);
            expressionList.addAll(this.visit(context.lambdaFunction(), Expression.class));
            return new FunctionCall(ParserUtil.getLocation(context), FunctionName.of((String)ParserUtil.getIdentifierText(context.identifier())), expressionList);
        }

        @Override
        public Node visitFunctionArgument(SqlBaseParser.FunctionArgumentContext context) {
            if (context.windowUnit() != null) {
                return this.visitWindowUnit(context.windowUnit());
            }
            return (Node)this.visit((ParseTree)context.expression());
        }

        @Override
        public Node visitWindowUnit(SqlBaseParser.WindowUnitContext context) {
            return new IntervalUnit(WindowExpression.getWindowUnit(context.getText().toUpperCase()));
        }

        @Override
        public Node visitTableElement(SqlBaseParser.TableElementContext context) {
            Type type = this.typeParser.getType(context.type());
            ColumnConstraints constraints = ParserUtil.getColumnConstraints(context.columnConstraints());
            if (constraints.isHeaders()) {
                this.throwOnIncorrectHeaderColumnType(type.getSqlType(), constraints.getHeaderKey());
            }
            return new TableElement(ParserUtil.getLocation(context), ColumnName.of((String)ParserUtil.getIdentifierText(context.identifier())), type, constraints);
        }

        private void throwOnIncorrectHeaderColumnType(SqlType type, Optional<String> headerKey) {
            if (headerKey.isPresent()) {
                if (type != SqlTypes.BYTES) {
                    throw new KsqlException(String.format("Invalid type for HEADER('%s') column: expected BYTES, got %s", headerKey.get(), type));
                }
            } else if (!type.toString().equals(SystemColumns.HEADERS_TYPE.toString())) {
                throw new KsqlException("Invalid type for HEADERS column: expected " + String.valueOf(SystemColumns.HEADERS_TYPE) + ", got " + String.valueOf(type));
            }
        }

        @Override
        public Node visitNullLiteral(SqlBaseParser.NullLiteralContext context) {
            return new NullLiteral(ParserUtil.getLocation(context));
        }

        @Override
        public Node visitStringLiteral(SqlBaseParser.StringLiteralContext context) {
            return new StringLiteral(ParserUtil.getLocation(context), ParserUtil.unquote(context.STRING().getText(), "'"));
        }

        @Override
        public Node visitTypeConstructor(SqlBaseParser.TypeConstructorContext context) {
            String type = ParserUtil.getIdentifierText(context.identifier());
            String value = ParserUtil.unquote(context.STRING().getText(), "'");
            Optional<NodeLocation> location = ParserUtil.getLocation(context);
            if (type.equals("DECIMAL")) {
                return new DecimalLiteral(location, new BigDecimal(value));
            }
            throw new KsqlException("Unknown type: " + type + ", location:" + String.valueOf(location));
        }

        @Override
        public Node visitIntegerLiteral(SqlBaseParser.IntegerLiteralContext context) {
            return ParserUtil.visitIntegerLiteral(context);
        }

        @Override
        public Node visitFloatLiteral(SqlBaseParser.FloatLiteralContext context) {
            return ParserUtil.parseFloatLiteral(context);
        }

        @Override
        public Node visitDecimalLiteral(SqlBaseParser.DecimalLiteralContext context) {
            return ParserUtil.parseDecimalLiteral(context);
        }

        @Override
        public Node visitBooleanValue(SqlBaseParser.BooleanValueContext context) {
            return new BooleanLiteral(ParserUtil.getLocation(context), context.getText());
        }

        @Override
        public Node visitExplain(SqlBaseParser.ExplainContext ctx) {
            SqlBaseParser.IdentifierContext queryIdentifier = ctx.identifier();
            Optional<String> queryId = Optional.ofNullable(queryIdentifier).map(ParserUtil::getIdentifierText);
            Optional<Statement> statement = Optional.ofNullable(ctx.statement()).map(s -> (Statement)((Object)((Object)this.visit((ParseTree)s))));
            return new Explain(ParserUtil.getLocation(ctx), queryId, statement);
        }

        @Override
        public Node visitDescribeFunction(SqlBaseParser.DescribeFunctionContext ctx) {
            return new DescribeFunction(ParserUtil.getLocation(ctx), ctx.identifier().getText());
        }

        @Override
        public Node visitDescribeConnector(SqlBaseParser.DescribeConnectorContext ctx) {
            return new DescribeConnector(ParserUtil.getLocation(ctx), ParserUtil.getIdentifierText(ctx.identifier()));
        }

        @Override
        public Node visitDescribeStreams(SqlBaseParser.DescribeStreamsContext context) {
            return new DescribeStreams(ParserUtil.getLocation(context), context.EXTENDED() != null);
        }

        protected Node defaultResult() {
            return null;
        }

        protected Node aggregateResult(Node aggregate, Node nextResult) {
            if (nextResult == null) {
                throw new UnsupportedOperationException("not yet implemented");
            }
            if (aggregate == null) {
                return nextResult;
            }
            throw new UnsupportedOperationException("not yet implemented");
        }

        @Override
        public Node visitRegisterType(SqlBaseParser.RegisterTypeContext context) {
            return new RegisterType(ParserUtil.getLocation(context), ParserUtil.getIdentifierText(context.identifier()), this.typeParser.getType(context.type()), context.EXISTS() != null);
        }

        @Override
        public Node visitAssertTopic(SqlBaseParser.AssertTopicContext context) {
            return new AssertTopic(ParserUtil.getLocation(context), this.getResourceName(context.resourceName()), (Map<String, Literal>)(context.WITH() == null ? ImmutableMap.of() : this.processTableProperties(context.tableProperties())), context.timeout() == null ? Optional.empty() : Optional.of(Visitor.getTimeClause(context.timeout().number(), context.timeout().windowUnit())), context.EXISTS() == null);
        }

        @Override
        public Node visitAssertSchema(SqlBaseParser.AssertSchemaContext context) {
            Optional<Integer> id;
            if (context.resourceName() == null && context.literal() == null) {
                throw new KsqlException("ASSERT SCHEMA statements much include a subject name or an id");
            }
            if (context.literal() == null) {
                id = Optional.empty();
            } else {
                Object value = ((Literal)this.visit((ParseTree)context.literal())).getValue();
                if (value instanceof Integer) {
                    id = Optional.of((Integer)value);
                } else {
                    throw new KsqlException("ID must be an integer");
                }
            }
            return new AssertSchema(ParserUtil.getLocation(context), context.resourceName() == null ? Optional.empty() : Optional.of(this.getResourceName(context.resourceName())), id, context.timeout() == null ? Optional.empty() : Optional.of(Visitor.getTimeClause(context.timeout().number(), context.timeout().windowUnit())), context.EXISTS() == null);
        }

        @Override
        public Node visitAssertValues(SqlBaseParser.AssertValuesContext context) {
            SourceName targetName = ParserUtil.getSourceName(context.sourceName());
            Optional<NodeLocation> targetLocation = ParserUtil.getLocation(context.sourceName());
            Object columns = context.columns() != null ? context.columns().identifier().stream().map(ParserUtil::getIdentifierText).map(ColumnName::of).collect(Collectors.toList()) : ImmutableList.of();
            InsertValues insertValues = new InsertValues(targetLocation, targetName, (List<ColumnName>)columns, this.visit(context.values().valueExpression(), Expression.class));
            return new AssertValues(targetLocation, insertValues);
        }

        @Override
        public Node visitAssertTombstone(SqlBaseParser.AssertTombstoneContext context) {
            SourceName targetName = ParserUtil.getSourceName(context.sourceName());
            Optional<NodeLocation> targetLocation = ParserUtil.getLocation(context.sourceName());
            Object keyColumns = context.columns() != null ? context.columns().identifier().stream().map(ParserUtil::getIdentifierText).map(ColumnName::of).collect(Collectors.toList()) : ImmutableList.of();
            InsertValues insertValues = new InsertValues(targetLocation, targetName, (List<ColumnName>)keyColumns, this.visit(context.values().valueExpression(), Expression.class));
            return new AssertTombstone(targetLocation, insertValues);
        }

        @Override
        public Node visitAssertStream(SqlBaseParser.AssertStreamContext context) {
            ImmutableList elements = context.tableElements() == null ? ImmutableList.of() : this.visit(context.tableElements().tableElement(), TableElement.class);
            Map<String, Literal> properties = this.processTableProperties(context.tableProperties());
            CreateStream createStream = new CreateStream(ParserUtil.getLocation(context), ParserUtil.getSourceName(context.sourceName()), TableElements.of((List<TableElement>)elements), false, false, CreateSourceProperties.from(properties), false);
            return new AssertStream(ParserUtil.getLocation(context), createStream);
        }

        @Override
        public Node visitAssertTable(SqlBaseParser.AssertTableContext context) {
            ImmutableList elements = context.tableElements() == null ? ImmutableList.of() : this.visit(context.tableElements().tableElement(), TableElement.class);
            Map<String, Literal> properties = this.processTableProperties(context.tableProperties());
            CreateTable createTable = new CreateTable(ParserUtil.getLocation(context), ParserUtil.getSourceName(context.sourceName()), TableElements.of((List<TableElement>)elements), false, false, CreateSourceProperties.from(properties), false);
            return new AssertTable(ParserUtil.getLocation(context), createTable);
        }

        private void throwOnUnknownNameOrAlias(SourceName name) {
            if (this.sources.isPresent() && !this.sources.get().contains(name)) {
                throw new KsqlException("'" + name.text() + "' is not a valid stream/table name or alias.");
            }
        }

        private <T> Optional<T> visitIfPresent(ParserRuleContext context, Class<T> clazz) {
            return Optional.ofNullable(context).map(arg_0 -> ((Visitor)this).visit(arg_0)).map(clazz::cast);
        }

        private <T> List<T> visit(List<? extends ParserRuleContext> contexts, Class<T> clazz) {
            return contexts.stream().map(arg_0 -> ((Visitor)this).visit(arg_0)).map(clazz::cast).collect(Collectors.toList());
        }

        private static Operator getArithmeticBinaryOperator(Token operator) {
            switch (operator.getType()) {
                case 159: {
                    return Operator.ADD;
                }
                case 160: {
                    return Operator.SUBTRACT;
                }
                case 161: {
                    return Operator.MULTIPLY;
                }
                case 162: {
                    return Operator.DIVIDE;
                }
                case 163: {
                    return Operator.MODULUS;
                }
            }
            throw new UnsupportedOperationException("Unsupported operator: " + operator.getText());
        }

        private static ComparisonExpression.Type getComparisonOperator(Token symbol) {
            switch (symbol.getType()) {
                case 153: {
                    return ComparisonExpression.Type.EQUAL;
                }
                case 154: {
                    return ComparisonExpression.Type.NOT_EQUAL;
                }
                case 155: {
                    return ComparisonExpression.Type.LESS_THAN;
                }
                case 156: {
                    return ComparisonExpression.Type.LESS_THAN_OR_EQUAL;
                }
                case 157: {
                    return ComparisonExpression.Type.GREATER_THAN;
                }
                case 158: {
                    return ComparisonExpression.Type.GREATER_THAN_OR_EQUAL;
                }
            }
            throw new IllegalArgumentException("Unsupported operator: " + symbol.getText());
        }

        private static LogicalBinaryExpression.Type getLogicalBinaryOperator(Token token) {
            switch (token.getType()) {
                case 26: {
                    return LogicalBinaryExpression.Type.AND;
                }
                case 25: {
                    return LogicalBinaryExpression.Type.OR;
                }
            }
            throw new IllegalArgumentException("Unsupported operator: " + token.getText());
        }

        private static OptionalInt getLimit(SqlBaseParser.LimitClauseContext limitContext) {
            return limitContext == null ? OptionalInt.empty() : OptionalInt.of(ParserUtil.processIntegerNumber(limitContext.number(), "LIMIT"));
        }

        private <T> T withinPersistentQuery(Supplier<T> task) {
            if (this.buildingPersistentQuery) {
                throw new UnsupportedOperationException("Nested query building not supported yet");
            }
            try {
                this.buildingPersistentQuery = true;
                T t = task.get();
                return t;
            }
            finally {
                this.buildingPersistentQuery = false;
            }
        }
    }

    private static class SourceAccumulator
    extends SqlBaseBaseVisitor<Void> {
        final Set<SourceName> sources = new HashSet<SourceName>();

        private SourceAccumulator() {
        }

        public Set<SourceName> getSources() {
            return ImmutableSet.copyOf(this.sources);
        }

        @Override
        public Void visitAliasedRelation(SqlBaseParser.AliasedRelationContext context) {
            super.visitAliasedRelation(context);
            switch (context.children.size()) {
                case 1: {
                    break;
                }
                case 2: {
                    this.sources.add(ParserUtil.getSourceName((SqlBaseParser.SourceNameContext)((Object)context.children.get(1))));
                    break;
                }
                case 3: {
                    this.sources.add(ParserUtil.getSourceName((SqlBaseParser.SourceNameContext)((Object)context.children.get(2))));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("AliasedRelationContext must have between 1 and 3 children, but has:" + context.children.size());
                }
            }
            return null;
        }

        @Override
        public Void visitTableName(SqlBaseParser.TableNameContext context) {
            this.sources.add(ParserUtil.getSourceName(context.sourceName()));
            return null;
        }
    }
}

