/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser;

import io.confluent.ksql.parser.tree.AliasedRelation;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.CreateStreamAsSelect;
import io.confluent.ksql.parser.tree.CreateTableAsSelect;
import io.confluent.ksql.parser.tree.Explain;
import io.confluent.ksql.parser.tree.GroupBy;
import io.confluent.ksql.parser.tree.InsertInto;
import io.confluent.ksql.parser.tree.Join;
import io.confluent.ksql.parser.tree.JoinedSource;
import io.confluent.ksql.parser.tree.PartitionBy;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.Select;
import io.confluent.ksql.parser.tree.SelectItem;
import io.confluent.ksql.parser.tree.SingleColumn;
import io.confluent.ksql.parser.tree.Statements;

public abstract class DefaultTraversalVisitor<R, C>
extends AstVisitor<R, C> {
    @Override
    protected R visitStatements(Statements node, C context) {
        node.getStatements().forEach(stmt -> this.process((AstNode)((Object)stmt), context));
        return this.visitNode(node, context);
    }

    @Override
    protected R visitQuery(Query node, C context) {
        this.process(node.getSelect(), context);
        this.process(node.getFrom(), context);
        if (node.getGroupBy().isPresent()) {
            this.process(node.getGroupBy().get(), context);
        }
        return null;
    }

    @Override
    protected R visitSelect(Select node, C context) {
        for (SelectItem item : node.getSelectItems()) {
            this.process(item, context);
        }
        return null;
    }

    @Override
    protected R visitSingleColumn(SingleColumn node, C context) {
        return null;
    }

    @Override
    protected R visitAliasedRelation(AliasedRelation node, C context) {
        return this.process(node.getRelation(), context);
    }

    @Override
    protected R visitJoin(Join node, C context) {
        this.process(node.getLeft(), context);
        node.getRights().forEach(join -> this.process((AstNode)((Object)join), context));
        return null;
    }

    @Override
    protected R visitJoinedSource(JoinedSource joinedSource, C context) {
        this.process(joinedSource.getRelation(), context);
        return null;
    }

    @Override
    protected R visitPartitionBy(PartitionBy node, C context) {
        return null;
    }

    @Override
    protected R visitGroupBy(GroupBy node, C context) {
        return null;
    }

    @Override
    protected R visitInsertInto(InsertInto node, C context) {
        this.process(node.getQuery(), context);
        return null;
    }

    @Override
    protected R visitCreateStreamAsSelect(CreateStreamAsSelect node, C context) {
        this.process(node.getQuery(), context);
        return null;
    }

    @Override
    protected R visitCreateTableAsSelect(CreateTableAsSelect node, C context) {
        this.process(node.getQuery(), context);
        return null;
    }

    @Override
    protected R visitExplain(Explain node, C context) {
        node.getStatement().ifPresent(s -> this.process((AstNode)((Object)s), context));
        return null;
    }
}

