/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AlterOption;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.ExecutableDdlStatement;
import io.confluent.ksql.parser.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class AlterSource
extends Statement
implements ExecutableDdlStatement {
    private final SourceName name;
    private final DataSource.DataSourceType dataSourceType;
    private final ImmutableList<AlterOption> alterOptions;

    public AlterSource(SourceName name, DataSource.DataSourceType dataSourceType, List<AlterOption> alterOptions) {
        this(Optional.empty(), name, dataSourceType, alterOptions);
    }

    public AlterSource(Optional<NodeLocation> location, SourceName name, DataSource.DataSourceType dataSourceType, List<AlterOption> alterOptions) {
        super(location);
        this.name = name;
        this.dataSourceType = dataSourceType;
        this.alterOptions = ImmutableList.copyOf(alterOptions);
    }

    public SourceName getName() {
        return this.name;
    }

    public DataSource.DataSourceType getDataSourceType() {
        return this.dataSourceType;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="alterOptions is ImmutableList")
    public List<AlterOption> getAlterOptions() {
        return this.alterOptions;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAlterSource(this, context);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dataSourceType, this.alterOptions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlterSource that = (AlterSource)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.dataSourceType, that.dataSourceType) && Objects.equals(this.alterOptions, that.alterOptions);
    }

    public String toString() {
        return "AlterSource{name=" + String.valueOf(this.getName()) + ", dataSourceType=" + String.valueOf(this.getDataSourceType()) + ", alterOptions=" + String.valueOf(this.getAlterOptions()) + "}";
    }
}

