/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.properties.with.CreateSourceAsProperties;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.QueryContainer;
import io.confluent.ksql.parser.tree.Sink;
import io.confluent.ksql.parser.tree.Statement;
import java.util.Objects;
import java.util.Optional;

public abstract class CreateAsSelect
extends Statement
implements QueryContainer {
    private final SourceName name;
    private final Query query;
    private final boolean orReplace;
    private final boolean notExists;
    private final CreateSourceAsProperties properties;

    CreateAsSelect(Optional<NodeLocation> location, SourceName name, Query query, boolean orReplace, boolean notExists, CreateSourceAsProperties properties) {
        super(location);
        this.name = Objects.requireNonNull(name, "name");
        this.query = Objects.requireNonNull(query, "query");
        this.orReplace = orReplace;
        this.notExists = notExists;
        this.properties = Objects.requireNonNull(properties, "properties");
    }

    CreateAsSelect(CreateAsSelect other, CreateSourceAsProperties properties) {
        this(other.getLocation(), other.name, other.query, other.orReplace, other.notExists, properties);
    }

    public abstract CreateAsSelect copyWith(CreateSourceAsProperties var1);

    public SourceName getName() {
        return this.name;
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    public boolean isNotExists() {
        return this.notExists;
    }

    public boolean isOrReplace() {
        return this.orReplace;
    }

    public CreateSourceAsProperties getProperties() {
        return this.properties;
    }

    @Override
    public Sink getSink() {
        return Sink.of(this.getName(), true, this.isOrReplace(), this.getProperties());
    }

    @Override
    public Optional<String> getQueryId() {
        return Optional.empty();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.query, this.properties, this.notExists, this.getClass()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateAsSelect o = (CreateAsSelect)obj;
        return Objects.equals(this.name, o.name) && Objects.equals((Object)this.query, (Object)o.query) && Objects.equals(this.notExists, o.notExists) && Objects.equals(this.orReplace, o.orReplace) && Objects.equals(this.properties, o.properties);
    }

    public String toString() {
        return "CreateAsSelect{name=" + String.valueOf(this.name) + ", query=" + String.valueOf((Object)this.query) + ", notExists=" + this.notExists + ", orReplace =" + this.orReplace + ", properties=" + String.valueOf(this.properties) + "}";
    }
}

