/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.execution.expression.tree.Literal;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.Statement;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class CreateConnector
extends Statement {
    private final String name;
    private final ImmutableMap<String, Literal> config;
    private final Type type;
    private final boolean notExists;

    public CreateConnector(Optional<NodeLocation> location, String name, Map<String, Literal> config, Type type, boolean notExists) {
        super(location);
        this.name = Objects.requireNonNull(name, "name");
        this.config = ImmutableMap.copyOf(Objects.requireNonNull(config, "config"));
        this.type = Objects.requireNonNull(type, "type");
        this.notExists = notExists;
    }

    public CreateConnector(String name, Map<String, Literal> config, Type type, boolean notExists) {
        this(Optional.empty(), name, config, type, notExists);
    }

    public String getName() {
        return this.name;
    }

    public boolean ifNotExists() {
        return this.notExists;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="config is ImmutableMap")
    public Map<String, Literal> getConfig() {
        return this.config;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CreateConnector that = (CreateConnector)((Object)o);
        return Objects.equals(this.name, that.name) && Objects.equals(this.config, that.config) && Objects.equals(this.notExists, that.notExists) && Objects.equals((Object)this.type, (Object)that.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.config, this.type, this.notExists});
    }

    public String toString() {
        return "CreateConnector{name='" + this.name + "', config=" + String.valueOf(this.config) + ", type=" + String.valueOf((Object)this.type) + ", notExists" + this.notExists + "}";
    }

    public static enum Type {
        SOURCE,
        SINK;

    }
}

