/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.JoinCriteria;
import io.confluent.ksql.parser.tree.Relation;
import io.confluent.ksql.parser.tree.WithinExpression;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class JoinedSource
extends Relation {
    private final Relation relation;
    private final Type type;
    private final JoinCriteria criteria;
    private final Optional<WithinExpression> withinExpression;

    public JoinedSource(Optional<NodeLocation> location, Relation relation, Type type, JoinCriteria criteria, Optional<WithinExpression> withinExpression) {
        super(location);
        this.relation = Objects.requireNonNull(relation, "relation");
        this.type = Objects.requireNonNull(type, "type");
        this.criteria = Objects.requireNonNull(criteria, "criteria");
        this.withinExpression = Objects.requireNonNull(withinExpression, "withinExpression");
    }

    public Relation getRelation() {
        return this.relation;
    }

    public Type getType() {
        return this.type;
    }

    public JoinCriteria getCriteria() {
        return this.criteria;
    }

    public Optional<WithinExpression> getWithinExpression() {
        return this.withinExpression;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitJoinedSource(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        JoinedSource that = (JoinedSource)((Object)o);
        return Objects.equals((Object)this.relation, (Object)that.relation) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.criteria, that.criteria) && Objects.equals(this.withinExpression, that.withinExpression);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.relation, this.type, this.criteria, this.withinExpression});
    }

    public String toString() {
        return "JoinedSource{relation=" + String.valueOf((Object)this.relation) + ", type=" + String.valueOf((Object)this.type) + ", criteria=" + String.valueOf(this.criteria) + ", withinExpression=" + String.valueOf(this.withinExpression) + "}";
    }

    public static enum Type {
        INNER("INNER"),
        LEFT("LEFT OUTER"),
        RIGHT("RIGHT OUTER"),
        OUTER("FULL OUTER");

        private final String formattedText;

        private Type(String formattedText) {
            this.formattedText = Objects.requireNonNull(formattedText, "formattedText");
        }

        public String getFormatted() {
            return this.formattedText;
        }
    }
}

