/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.query.QueryId;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class ResumeQuery
extends Statement {
    public static final String ALL_QUERIES = "ALL";
    private final Optional<QueryId> queryId;

    public static ResumeQuery all(Optional<NodeLocation> location) {
        return new ResumeQuery(location, Optional.empty());
    }

    public static ResumeQuery query(Optional<NodeLocation> location, QueryId queryId) {
        return new ResumeQuery(location, Optional.of(queryId));
    }

    private ResumeQuery(Optional<NodeLocation> location, Optional<QueryId> queryId) {
        super(location);
        this.queryId = Objects.requireNonNull(queryId, "queryId");
    }

    public Optional<QueryId> getQueryId() {
        return this.queryId;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitResumeQuery(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ResumeQuery that = (ResumeQuery)((Object)o);
        return Objects.equals(this.queryId, that.queryId);
    }

    public int hashCode() {
        return Objects.hash(this.queryId);
    }

    public String toString() {
        return "ResumeQuery{queryId=" + String.valueOf(this.queryId) + "}";
    }
}

