/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.properties.with.CreateSourceAsProperties;
import java.util.Objects;

@Immutable
public final class Sink {
    private final SourceName name;
    private final CreateSourceAsProperties properties;
    private final boolean replaces;
    private final boolean createSink;

    public static Sink of(SourceName name, boolean createSink, boolean replaces, CreateSourceAsProperties properties) {
        return new Sink(name, createSink, replaces, properties);
    }

    private Sink(SourceName name, boolean createSink, boolean replaces, CreateSourceAsProperties properties) {
        this.name = Objects.requireNonNull(name, "name");
        this.properties = Objects.requireNonNull(properties, "properties");
        this.replaces = replaces;
        this.createSink = createSink;
    }

    public SourceName getName() {
        return this.name;
    }

    public boolean shouldCreateSink() {
        return this.createSink;
    }

    public boolean shouldReplace() {
        return this.replaces;
    }

    public CreateSourceAsProperties getProperties() {
        return this.properties;
    }
}

