/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Type;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.ColumnConstraints;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class TableElement
extends AstNode {
    private final ColumnName name;
    private final Type type;
    private final ColumnConstraints constraints;

    public TableElement(ColumnName name, Type type) {
        this(name, type, ColumnConstraints.NO_COLUMN_CONSTRAINTS);
    }

    public TableElement(ColumnName name, Type type, ColumnConstraints constraints) {
        this(Optional.empty(), name, type, constraints);
    }

    public TableElement(Optional<NodeLocation> location, ColumnName name, Type type, ColumnConstraints constraints) {
        super(location);
        this.name = Objects.requireNonNull(name, "name");
        this.type = Objects.requireNonNull(type, "type");
        this.constraints = Objects.requireNonNull(constraints, "constraints");
    }

    public ColumnName getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public ColumnConstraints getConstraints() {
        return this.constraints;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTableElement(this, context);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        TableElement o = (TableElement)((Object)obj);
        return Objects.equals(this.name, o.name) && Objects.equals(this.type, o.type) && Objects.equals(this.constraints, o.constraints);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.constraints);
    }

    public String toString() {
        return "TableElement{name='" + String.valueOf(this.name) + "', type=" + String.valueOf(this.type) + ", constraints=" + String.valueOf(this.constraints) + "}";
    }
}

