/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.dekregistry.client;

import io.confluent.dekregistry.client.DekRegistryClient;
import io.confluent.dekregistry.client.MockDekRegistryClient;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;

public final class MockDekRegistryClientFactory {
    private static final String MOCK_URL_PREFIX = "mock://";
    private static final Map<String, DekRegistryClient> SCOPED_CLIENTS = new HashMap<String, DekRegistryClient>();

    private MockDekRegistryClientFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DekRegistryClient getClientForScope(String scope, Map<String, ?> configs) {
        Map<String, DekRegistryClient> map = SCOPED_CLIENTS;
        synchronized (map) {
            if (!SCOPED_CLIENTS.containsKey(scope)) {
                SCOPED_CLIENTS.put(scope, new MockDekRegistryClient(configs));
            }
        }
        return SCOPED_CLIENTS.get(scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropScope(String scope) {
        Map<String, DekRegistryClient> map = SCOPED_CLIENTS;
        synchronized (map) {
            SCOPED_CLIENTS.remove(scope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<String, DekRegistryClient> map = SCOPED_CLIENTS;
        synchronized (map) {
            SCOPED_CLIENTS.clear();
        }
    }

    public static String validateAndMaybeGetMockScope(List<String> urls) {
        LinkedList<String> mockScopes = new LinkedList<String>();
        for (String url : urls) {
            if (!url.startsWith(MOCK_URL_PREFIX)) continue;
            mockScopes.add(url.substring(MOCK_URL_PREFIX.length()));
        }
        if (mockScopes.isEmpty()) {
            return null;
        }
        if (mockScopes.size() > 1) {
            throw new ConfigException("Only one mock scope is permitted for 'schema.registry.url'. Got: " + String.valueOf(urls));
        }
        if (urls.size() > mockScopes.size()) {
            throw new ConfigException("Cannot mix mock and real urls for 'schema.registry.url'. Got: " + String.valueOf(urls));
        }
        return (String)mockScopes.get(0);
    }
}

