/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.client;

import io.confluent.kafka.secretregistry.client.SecretMetadata;
import io.confluent.kafka.secretregistry.client.SecretRegistryClient;
import io.confluent.kafka.secretregistry.client.rest.RestService;
import io.confluent.kafka.secretregistry.client.rest.entities.Secret;
import io.confluent.kafka.secretregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.secretregistry.client.security.basicauth.BasicAuthCredentialProvider;
import io.confluent.kafka.secretregistry.client.security.basicauth.BasicAuthCredentialProviderFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class CachedSecretRegistryClient
implements SecretRegistryClient {
    private final RestService restService;
    private final int identityMapCapacity;
    private final Map<String, Map<String, Map<Integer, String>>> cache;
    static final Map<String, String> DEFAULT_REQUEST_PROPERTIES = new HashMap<String, String>();

    public CachedSecretRegistryClient(String baseUrl, int identityMapCapacity) {
        this(new RestService(baseUrl), identityMapCapacity);
    }

    public CachedSecretRegistryClient(List<String> baseUrls, int identityMapCapacity) {
        this(new RestService(baseUrls), identityMapCapacity);
    }

    public CachedSecretRegistryClient(RestService restService, int identityMapCapacity) {
        this(restService, identityMapCapacity, null);
    }

    public CachedSecretRegistryClient(String baseUrl, int identityMapCapacity, Map<String, ?> originals) {
        this(baseUrl, identityMapCapacity, originals, null);
    }

    public CachedSecretRegistryClient(List<String> baseUrls, int identityMapCapacity, Map<String, ?> originals) {
        this(baseUrls, identityMapCapacity, originals, null);
    }

    public CachedSecretRegistryClient(RestService restService, int identityMapCapacity, Map<String, ?> configs) {
        this(restService, identityMapCapacity, configs, null);
    }

    public CachedSecretRegistryClient(String baseUrl, int identityMapCapacity, Map<String, ?> originals, Map<String, String> httpHeaders) {
        this(new RestService(baseUrl), identityMapCapacity, originals, httpHeaders);
    }

    public CachedSecretRegistryClient(List<String> baseUrls, int identityMapCapacity, Map<String, ?> originals, Map<String, String> httpHeaders) {
        this(new RestService(baseUrls), identityMapCapacity, originals, httpHeaders);
    }

    public CachedSecretRegistryClient(RestService restService, int identityMapCapacity, Map<String, ?> configs, Map<String, String> httpHeaders) {
        this.identityMapCapacity = identityMapCapacity;
        this.cache = new HashMap<String, Map<String, Map<Integer, String>>>();
        this.restService = restService;
        this.configureRestService(configs, httpHeaders);
    }

    private void configureRestService(Map<String, ?> configs, Map<String, String> httpHeaders) {
        String credentialSourceConfig;
        if (httpHeaders != null) {
            this.restService.setHttpHeaders(httpHeaders);
        }
        if (configs != null && (credentialSourceConfig = (String)configs.get("basic.auth.credentials.source")) != null && !credentialSourceConfig.isEmpty()) {
            BasicAuthCredentialProvider basicAuthCredentialProvider = BasicAuthCredentialProviderFactory.getBasicAuthCredentialProvider(credentialSourceConfig, configs);
            this.restService.setBasicAuthCredentialProvider(basicAuthCredentialProvider);
        }
    }

    @Override
    public synchronized int register(String path, String key, String secret) throws IOException, RestClientException {
        return this.restService.registerSecret(secret, path, key);
    }

    @Override
    public Collection<String> listAllPaths() throws IOException, RestClientException {
        return this.restService.listAllPaths();
    }

    @Override
    public Collection<String> listAllKeys(String path) throws IOException, RestClientException {
        return this.restService.listAllKeys(path);
    }

    @Override
    public Collection<Integer> listAllVersions(String path, String key) throws IOException, RestClientException {
        return this.restService.listAllVersions(path, key);
    }

    public List<SecretMetadata> getAllLatest(String path) throws IOException, RestClientException {
        return this.restService.getAllLatest(path).stream().map(SecretMetadata::new).collect(Collectors.toList());
    }

    public List<SecretMetadata> getAllVersions(String path, String key) throws IOException, RestClientException {
        return this.restService.getAllVersions(path, key).stream().map(SecretMetadata::new).collect(Collectors.toList());
    }

    @Override
    public SecretMetadata getLatestSecretMetadata(String path, String key) throws IOException, RestClientException {
        Secret secret = this.restService.getLatestVersion(path, key);
        return secret != null ? new SecretMetadata(secret) : null;
    }

    @Override
    public SecretMetadata getSecretMetadata(String path, String key, int version) throws IOException, RestClientException {
        Secret secret = this.restService.getVersion(path, key, version);
        return secret != null ? new SecretMetadata(secret) : null;
    }

    @Override
    public void deletePath(String path) throws IOException, RestClientException {
        this.deletePath(DEFAULT_REQUEST_PROPERTIES, path);
    }

    @Override
    public void deletePath(Map<String, String> requestProperties, String path) throws IOException, RestClientException {
        Objects.requireNonNull(path, "path");
        this.restService.deletePath(requestProperties, path);
    }

    @Override
    public void deleteKey(String path, String key) throws IOException, RestClientException {
        this.deleteKey(DEFAULT_REQUEST_PROPERTIES, path, key);
    }

    @Override
    public void deleteKey(Map<String, String> requestProperties, String path, String key) throws IOException, RestClientException {
        Objects.requireNonNull(path, "path");
        this.restService.deleteKey(requestProperties, path, key);
    }

    @Override
    public void deleteVersion(String path, String key, String version) throws IOException, RestClientException {
        this.deleteVersion(DEFAULT_REQUEST_PROPERTIES, path, key, version);
    }

    @Override
    public void deleteVersion(Map<String, String> requestProperties, String path, String key, String version) throws IOException, RestClientException {
        this.restService.deleteVersion(requestProperties, path, key, version);
    }

    @Override
    public void reset() {
        this.cache.clear();
    }

    static {
        DEFAULT_REQUEST_PROPERTIES.put("Content-Type", "application/vnd.secretregistry.v1+json");
    }
}

