/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.client;

import io.confluent.kafka.secretregistry.client.CachedSecretRegistryClient;
import io.confluent.kafka.secretregistry.client.SecretMetadata;
import io.confluent.kafka.secretregistry.client.SecretRegistryClient;
import io.confluent.kafka.secretregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MockSecretRegistryClient
implements SecretRegistryClient {
    private final Map<String, Map<String, Map<Integer, String>>> cache = new ConcurrentHashMap<String, Map<String, Map<Integer, String>>>();

    @Override
    public synchronized int register(String path, String key, String secret) throws IOException, RestClientException {
        Map keys = this.cache.computeIfAbsent(path, k -> new ConcurrentHashMap());
        Map versions = keys.computeIfAbsent(key, k -> new ConcurrentHashMap());
        int version = versions.size() + 1;
        versions.put(version, secret);
        return version;
    }

    @Override
    public Collection<String> listAllPaths() throws IOException, RestClientException {
        return this.cache.keySet();
    }

    @Override
    public Collection<String> listAllKeys(String path) throws IOException, RestClientException {
        return this.cache.getOrDefault(path, Collections.emptyMap()).keySet();
    }

    @Override
    public Collection<Integer> listAllVersions(String path, String key) throws IOException, RestClientException {
        return this.cache.getOrDefault(path, Collections.emptyMap()).getOrDefault(key, Collections.emptyMap()).keySet();
    }

    public List<SecretMetadata> getAllLatest(String path) throws IOException, RestClientException {
        return this.cache.getOrDefault(path, Collections.emptyMap()).entrySet().stream().map(e -> {
            String key = (String)e.getKey();
            Map versions = (Map)e.getValue();
            return versions.entrySet().stream().max((e1, e2) -> ((Integer)e1.getKey()).compareTo((Integer)e2.getKey())).map(o -> new SecretMetadata(path, key, (Integer)o.getKey(), (String)o.getValue()));
        }).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toList());
    }

    public List<SecretMetadata> getAllVersions(String path, String key) throws IOException, RestClientException {
        return this.cache.getOrDefault(path, Collections.emptyMap()).getOrDefault(key, Collections.emptyMap()).entrySet().stream().map(e -> new SecretMetadata(path, key, (Integer)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
    }

    @Override
    public SecretMetadata getLatestSecretMetadata(String path, String key) throws IOException, RestClientException {
        return this.cache.getOrDefault(path, Collections.emptyMap()).getOrDefault(key, Collections.emptyMap()).entrySet().stream().max((e1, e2) -> ((Integer)e1.getKey()).compareTo((Integer)e2.getKey())).map(o -> new SecretMetadata(path, key, (Integer)o.getKey(), (String)o.getValue())).orElse(null);
    }

    @Override
    public SecretMetadata getSecretMetadata(String path, String key, int version) throws IOException, RestClientException {
        String secret = this.cache.getOrDefault(path, Collections.emptyMap()).getOrDefault(key, Collections.emptyMap()).getOrDefault(version, null);
        return secret != null ? new SecretMetadata(path, key, version, secret) : null;
    }

    @Override
    public void deletePath(String path) throws IOException, RestClientException {
        this.deletePath(CachedSecretRegistryClient.DEFAULT_REQUEST_PROPERTIES, path);
    }

    @Override
    public void deletePath(Map<String, String> requestProperties, String path) throws IOException, RestClientException {
        this.cache.remove(path);
    }

    @Override
    public void deleteKey(String path, String key) throws IOException, RestClientException {
        this.deleteKey(CachedSecretRegistryClient.DEFAULT_REQUEST_PROPERTIES, path, key);
    }

    @Override
    public void deleteKey(Map<String, String> requestProperties, String path, String key) throws IOException, RestClientException {
        ((Map)this.cache.getOrDefault(path, new HashMap())).remove(key);
    }

    @Override
    public void deleteVersion(String path, String key, String version) throws IOException, RestClientException {
        this.deleteVersion(CachedSecretRegistryClient.DEFAULT_REQUEST_PROPERTIES, path, key, version);
    }

    @Override
    public void deleteVersion(Map<String, String> requestProperties, String path, String key, String version) throws IOException, RestClientException {
        ((Map)((Map)this.cache.getOrDefault(path, new HashMap())).getOrDefault(key, new HashMap())).remove(version);
    }

    @Override
    public void reset() {
        this.cache.clear();
    }
}

