/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.tools;

import io.confluent.common.utils.AbstractPerformanceTest;
import io.confluent.common.utils.PerformanceStats;
import io.confluent.kafka.secretregistry.client.CachedSecretRegistryClient;
import io.confluent.kafka.secretregistry.client.rest.RestService;
import io.confluent.kafka.secretregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;

public class SecretRegistryClientPerformance
extends AbstractPerformanceTest {
    long targetRegisteredSecrets;
    long targetSecretsPerSec;
    String baseUrl;
    RestService restService;
    String path;
    String key;
    long registeredSecrets = 0L;
    long successfullyRegisteredSecrets = 0L;
    CachedSecretRegistryClient client;

    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            System.out.println("Usage: java " + SecretRegistryClientPerformance.class.getName() + " secret_registry_url path key num_secrets target_secrets_per_sec");
            System.exit(1);
        }
        String baseUrl = args[0];
        String path = args[1];
        String key = args[2];
        int numSecrets = Integer.parseInt(args[3]);
        int targetSecretsPerSec = Integer.parseInt(args[4]);
        SecretRegistryClientPerformance perf = new SecretRegistryClientPerformance(baseUrl, path, key, numSecrets, targetSecretsPerSec);
        perf.run(targetSecretsPerSec);
        perf.close();
    }

    public SecretRegistryClientPerformance(String baseUrl, String path, String key, long numSecrets, long targetSecretsPerSec) throws Exception {
        super(numSecrets);
        this.baseUrl = baseUrl;
        this.restService = new RestService(baseUrl);
        this.path = path;
        this.key = key;
        this.targetRegisteredSecrets = numSecrets;
        this.targetSecretsPerSec = targetSecretsPerSec;
        this.client = new CachedSecretRegistryClient(this.restService, Integer.MAX_VALUE);
    }

    private static String makeSecret(long num) {
        String secretString = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f" + num + "\"}]}";
        return secretString;
    }

    protected void doIteration(PerformanceStats.Callback cb) {
        String secret = SecretRegistryClientPerformance.makeSecret(this.registeredSecrets);
        try {
            this.client.register(this.path, this.key, secret);
            ++this.successfullyRegisteredSecrets;
        }
        catch (IOException e) {
            System.out.println("Problem registering secret: " + e.getMessage());
        }
        catch (RestClientException e) {
            System.out.println("Problem registering secret: " + e.getMessage());
        }
        ++this.registeredSecrets;
        cb.onCompletion(1, 0L);
    }

    protected void close() {
        if ((double)this.successfullyRegisteredSecrets / (double)this.targetRegisteredSecrets < 0.99) {
            throw new RuntimeException("Too many secret registration errors: " + this.successfullyRegisteredSecrets + " registered successfully out of " + this.targetRegisteredSecrets + " attempted");
        }
    }

    protected boolean finished(int iteration) {
        return this.targetRegisteredSecrets == this.registeredSecrets;
    }

    protected boolean runningFast(int iteration, float elapsed) {
        return (float)iteration / elapsed > (float)this.targetSecretsPerSec;
    }
}

