/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.kafka.schemaregistry.rest.MutableRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.ThreadContext;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHeaderHandler
extends Handler.Wrapper {
    public static final String X_REQUEST_ID_HEADER = "X-Request-ID";
    public static final String X_FORWARDED_FOR_HEADER = "X-Forwarded-For";
    private static final Logger log = LoggerFactory.getLogger(RequestHeaderHandler.class);

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        ThreadContext.clearAll();
        MutableRequest mutableRequest = new MutableRequest(request);
        this.addXRequestIdToRequest(mutableRequest, response);
        this.addXForwardedForToRequest(mutableRequest, request);
        return super.handle((Request)mutableRequest, response, callback);
    }

    protected void addXRequestIdToRequest(MutableRequest mutableRequest, Response response) {
        ArrayList<String> inputHeaders = Collections.list(mutableRequest.getHeaders(X_REQUEST_ID_HEADER));
        String requestId = this.getRequestId(inputHeaders);
        mutableRequest.putHeader(X_REQUEST_ID_HEADER, requestId);
        response.getHeaders().add(X_REQUEST_ID_HEADER, requestId);
        ThreadContext.put((String)"requestId", (String)requestId);
    }

    protected void addXForwardedForToRequest(MutableRequest mutableRequest, Request request) {
        if (request.getHeaders().get("X-Forward") == null) {
            mutableRequest.putHeader(X_FORWARDED_FOR_HEADER, this.getRemoteAddr(request));
        }
        log.info("Forwarded for header in RequestHeaderHandler: {}", (Object)mutableRequest.getHeader(X_FORWARDED_FOR_HEADER));
    }

    protected String getRequestId(List<String> headers) {
        if (headers.size() == 1 && StringUtil.isNotBlank((String)headers.get(0))) {
            return headers.get(0);
        }
        return UUID.randomUUID().toString();
    }

    protected String getRemoteAddr(Request request) {
        return Request.getRemoteAddr((Request)request);
    }
}

