/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.roledefinitions;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.confluent.security.roledefinitions.AccessPolicy;
import io.confluent.security.roledefinitions.BindingScopes;
import io.confluent.security.roledefinitions.InvalidRoleDefinitionException;
import io.confluent.security.roledefinitions.Role;
import io.confluent.security.roledefinitions.Roles;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class RbacRoles {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String CP_POLICY_FILE = "cp_rbac_roles.json";
    private static final String CP_HIERARCHY_FILE = "cp_hierarchy.json";
    private static final String CLOUD_HIERARCHY_FILE = "cloud_hierarchy.json";
    private static final String CLOUD_CONTROL_PLANE_POLICY_FILE = "cloud_rbac_roles.json";
    private static final String CLOUD_KAFKA_POLICY_FILE = "cloud_kafka_rbac_roles.json";
    private static final String CLOUD_SDS_SR_POLICY_FILE = "cloud_sds_schema_registry_rbac_roles.json";
    private static final String CLOUD_CATALOG_SR_RESOURCE_POLICY_FILE = "cloud_catalog_sr_resource_roles.json";
    private static final String CLOUD_CATALOG_KAFKA_RESOURCE_POLICY_FILE = "cloud_catalog_kafka_resource_roles.json";
    private static final String CLOUD_SDS_KSQL_POLICY_FILE = "cloud_sds_ksql_rbac_roles.json";
    private static final List<String> CORE_CLOUD_POLICY_FILES;
    private BindingScopes bindingScopes;
    private final Map<String, Role> roles;
    private static final BindingScopes CP_BINDING_SCOPES;
    public static final BindingScopes CLOUD_BINDING_SCOPES;

    public static ObjectMapper objectMapper() {
        return OBJECT_MAPPER;
    }

    public RbacRoles(List<Role> roles, LinkedHashMap<String, Object> bindingScopes) {
        this.bindingScopes = new BindingScopes(bindingScopes);
        this.roles = new HashMap<String, Role>();
        roles.forEach(this::addRole);
    }

    public RbacRoles(List<Role> roles, BindingScopes bindingScopes) {
        this.bindingScopes = bindingScopes;
        this.roles = new HashMap<String, Role>();
        roles.forEach(this::addRole);
    }

    public Role role(String roleName, String namespace) {
        Role role = this.roles.get(roleName);
        if (role != null && role.isInNamespace(namespace)) {
            return role;
        }
        return null;
    }

    public Role role(String roleName) {
        return this.roles.get(roleName);
    }

    public Collection<Role> roles(String namespace) {
        return this.roles.values().stream().filter(role -> role.isInNamespace(namespace)).collect(Collectors.toList());
    }

    public Collection<Role> roles() {
        return new ArrayList<Role>(this.roles.values());
    }

    public Map<String, Role> rolesMap() {
        return this.roles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RbacRoles)) {
            return false;
        }
        RbacRoles that = (RbacRoles)o;
        return Objects.equals(this.roles, that.roles);
    }

    public int hashCode() {
        return Objects.hash(this.roles);
    }

    final void addRole(Role role) {
        for (Collection<AccessPolicy> accessPoliciesByScope : role.accessPolicies().values()) {
            for (AccessPolicy accessPolicy : accessPoliciesByScope) {
                if (!this.bindingScopes.isKnownScope(accessPolicy.bindingScope())) {
                    throw new InvalidRoleDefinitionException("Unknown binding scope '" + accessPolicy.bindingScope() + "' defined for " + role);
                }
                accessPolicy.allowedOperations().forEach(resourceOp -> {
                    if (resourceOp.resourceType() == null || resourceOp.resourceType().isEmpty()) {
                        throw new InvalidRoleDefinitionException("Resource type not specified in role definition ops for " + role);
                    }
                    resourceOp.operations().forEach(op -> {
                        if (op.isEmpty()) {
                            throw new InvalidRoleDefinitionException("Operation name not specified in role definition ops for " + role);
                        }
                    });
                });
            }
        }
        if (!this.bindingScopes.isPartialBindingScopePathUnique(role.bindingScopes())) {
            throw new InvalidRoleDefinitionException("Role should have binding scopes that follow a linear path in the tree");
        }
        role.setMostSpecificBindingScope(this.mostSpecificBindingScope(role));
        this.roles.put(role.name(), role);
    }

    public static RbacRoles loadDefaultPolicy(boolean isConfluentCloud) throws InvalidRoleDefinitionException {
        if (isConfluentCloud) {
            return RbacRoles.load(RbacRoles.class.getClassLoader(), CORE_CLOUD_POLICY_FILES);
        }
        return RbacRoles.load(RbacRoles.class.getClassLoader(), CP_POLICY_FILE);
    }

    public static RbacRoles loadCloudPolicyWith(List<String> additionalRoleDefs) {
        ArrayList<String> policyFiles = new ArrayList<String>(CORE_CLOUD_POLICY_FILES);
        if (additionalRoleDefs != null && additionalRoleDefs.size() > 0) {
            policyFiles.addAll(additionalRoleDefs);
        }
        return RbacRoles.load(RbacRoles.class.getClassLoader(), policyFiles);
    }

    public static RbacRoles loadDataPlanePolicy() throws InvalidRoleDefinitionException {
        return RbacRoles.load(RbacRoles.class.getClassLoader(), Collections.singletonList(CLOUD_KAFKA_POLICY_FILE));
    }

    public static RbacRoles loadSDSPolicy() throws InvalidRoleDefinitionException {
        ArrayList<String> policyFiles = new ArrayList<String>();
        policyFiles.add(CLOUD_SDS_SR_POLICY_FILE);
        policyFiles.add(CLOUD_SDS_KSQL_POLICY_FILE);
        return RbacRoles.load(RbacRoles.class.getClassLoader(), policyFiles);
    }

    public static RbacRoles loadCatalogSRResourceLevelPolicy() throws InvalidRoleDefinitionException {
        ArrayList<String> policyFiles = new ArrayList<String>();
        policyFiles.add(CLOUD_CATALOG_SR_RESOURCE_POLICY_FILE);
        return RbacRoles.load(RbacRoles.class.getClassLoader(), policyFiles);
    }

    public static RbacRoles loadCatalogKafkaResourceLevelPolicy() throws InvalidRoleDefinitionException {
        ArrayList<String> policyFiles = new ArrayList<String>();
        policyFiles.add(CLOUD_CATALOG_KAFKA_RESOURCE_POLICY_FILE);
        return RbacRoles.load(RbacRoles.class.getClassLoader(), policyFiles);
    }

    public static RbacRoles loadSDSKsqlPolicy() throws InvalidRoleDefinitionException {
        return RbacRoles.load(RbacRoles.class.getClassLoader(), Collections.singletonList(CLOUD_SDS_KSQL_POLICY_FILE));
    }

    public static RbacRoles loadSDSSchemaRegistryPolicy() throws InvalidRoleDefinitionException {
        return RbacRoles.load(RbacRoles.class.getClassLoader(), Collections.singletonList(CLOUD_SDS_SR_POLICY_FILE));
    }

    public static BindingScopes loadBindingScopes(ClassLoader classLoader, String resourceName) {
        BindingScopes bindingScopes;
        BufferedReader reader = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream(resourceName), StandardCharsets.UTF_8));
        try {
            bindingScopes = (BindingScopes)RbacRoles.objectMapper().readValue((Reader)reader, BindingScopes.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new InvalidRoleDefinitionException("BindingScopes could not be loaded from " + resourceName, e);
            }
        }
        reader.close();
        return bindingScopes;
    }

    public static RbacRoles load(ClassLoader classLoader, String policyResourceName) throws InvalidRoleDefinitionException {
        return RbacRoles.load(classLoader, Collections.singletonList(policyResourceName));
    }

    public static RbacRoles load(ClassLoader classLoader, List<String> policyResourceNames) throws InvalidRoleDefinitionException {
        if (policyResourceNames.size() == 0) {
            throw new InvalidRoleDefinitionException("Invalid RBAC policies");
        }
        if (policyResourceNames.size() == 1) {
            return RbacRoles.parseRbacRoles(classLoader, policyResourceNames.get(0));
        }
        return RbacRoles.mergedRbacRoles(classLoader, policyResourceNames);
    }

    public static RbacRoles loadRbacRolesForTesting(String roleFile, String hierarchyFile) {
        RbacRoles rbacRoles;
        BindingScopes bindingScopes = RbacRoles.loadBindingScopes(BindingScopes.class.getClassLoader(), hierarchyFile);
        BufferedReader reader = new BufferedReader(new InputStreamReader(Roles.class.getClassLoader().getResourceAsStream(roleFile), StandardCharsets.UTF_8));
        try {
            Roles roles = (Roles)RbacRoles.objectMapper().readValue((Reader)reader, Roles.class);
            rbacRoles = new RbacRoles(roles.roles, bindingScopes);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new InvalidRoleDefinitionException("RBAC roles could not be loaded from " + roleFile, e);
            }
        }
        reader.close();
        return rbacRoles;
    }

    private static RbacRoles mergedRbacRoles(ClassLoader classLoader, List<String> policyResourceNames) {
        List rbacRoles = policyResourceNames.stream().map(policy -> RbacRoles.parseRbacRoles(classLoader, policy)).collect(Collectors.toList());
        RbacRoles mergedRbacRoles = (RbacRoles)rbacRoles.remove(0);
        for (RbacRoles rbacRole : rbacRoles) {
            mergedRbacRoles = RbacRoles.merge(mergedRbacRoles, rbacRole);
        }
        return mergedRbacRoles;
    }

    private static RbacRoles parseRbacRoles(ClassLoader classLoader, String policyResourceName) {
        RbacRoles rbacRoles;
        BufferedReader reader = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream(policyResourceName), StandardCharsets.UTF_8));
        try {
            Roles roles = (Roles)RbacRoles.objectMapper().readValue((Reader)reader, Roles.class);
            BindingScopes bindingScopes = policyResourceName.startsWith("cp") ? CP_BINDING_SCOPES : CLOUD_BINDING_SCOPES;
            rbacRoles = new RbacRoles(roles.roles, bindingScopes);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new InvalidRoleDefinitionException("RBAC policies could not be loaded from " + policyResourceName, e);
            }
        }
        reader.close();
        return rbacRoles;
    }

    private String mostSpecificBindingScope(Role role) {
        Set<String> roleBindingScopes = role.bindingScopes();
        return this.bindingScopes.findMostSpecificBindingScope(roleBindingScopes);
    }

    public static RbacRoles merge(RbacRoles roles1, RbacRoles roles2) {
        if (!roles1.bindingScopes.equals(roles2.bindingScopes)) {
            throw new IllegalArgumentException("bindingScopes are not equal");
        }
        HashMap<String, Role> mergedRolesMap = new HashMap<String, Role>(roles1.rolesMap());
        roles2.rolesMap().forEach((key, value) -> mergedRolesMap.merge((String)key, (Role)value, Role::merge));
        return new RbacRoles(new ArrayList<Role>(mergedRolesMap.values()), roles1.bindingScopes);
    }

    public BindingScopes bindingScopes() {
        return this.bindingScopes;
    }

    static {
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        OBJECT_MAPPER.registerModule((Module)new Jdk8Module());
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        CORE_CLOUD_POLICY_FILES = Arrays.asList(CLOUD_CONTROL_PLANE_POLICY_FILE, CLOUD_KAFKA_POLICY_FILE, CLOUD_SDS_SR_POLICY_FILE, CLOUD_SDS_KSQL_POLICY_FILE);
        CP_BINDING_SCOPES = RbacRoles.loadBindingScopes(BindingScopes.class.getClassLoader(), CP_HIERARCHY_FILE);
        CLOUD_BINDING_SCOPES = RbacRoles.loadBindingScopes(BindingScopes.class.getClassLoader(), CLOUD_HIERARCHY_FILE);
    }
}

