/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerProtocolAssignment;
import org.apache.kafka.common.message.ConsumerProtocolSubscription;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupCurrentMemberAssignmentValue;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public class Utils {
    private Utils() {
    }

    public static OptionalInt ofSentinel(int value) {
        return value != -1 ? OptionalInt.of(value) : OptionalInt.empty();
    }

    public static OptionalLong ofSentinel(long value) {
        return value != -1L ? OptionalLong.of(value) : OptionalLong.empty();
    }

    public static String assignmentToString(Map<Uuid, Set<Integer>> assignment) {
        StringBuilder builder = new StringBuilder("[");
        Iterator<Map.Entry<Uuid, Set<Integer>>> topicsIterator = assignment.entrySet().iterator();
        while (topicsIterator.hasNext()) {
            Map.Entry<Uuid, Set<Integer>> entry = topicsIterator.next();
            Iterator<Integer> partitionsIterator = entry.getValue().iterator();
            while (partitionsIterator.hasNext()) {
                builder.append(entry.getKey());
                builder.append("-");
                builder.append(partitionsIterator.next());
                if (!partitionsIterator.hasNext() && !topicsIterator.hasNext()) continue;
                builder.append(", ");
            }
        }
        builder.append("]");
        return builder.toString();
    }

    public static Integer decValue(String key, Integer value) {
        if (value == null) {
            return null;
        }
        return value == 1 ? null : Integer.valueOf(value - 1);
    }

    public static Integer incValue(String key, Integer value) {
        return value == null ? 1 : value + 1;
    }

    public static Long decValue(Object key, Long value) {
        if (value == null) {
            return null;
        }
        return value == 1L ? null : Long.valueOf(value - 1L);
    }

    public static Long incValue(Object key, Long value) {
        return value == null ? 1L : value + 1L;
    }

    public static Optional<String> toOptional(String str) {
        return str == null || str.isEmpty() ? Optional.empty() : Optional.of(str);
    }

    public static ConsumerProtocolAssignment toConsumerProtocolAssignment(Map<Uuid, Set<Integer>> assignment, TopicsImage topicsImage, Function<String, String> transformTopicName) {
        ConsumerProtocolAssignment.TopicPartitionCollection collection = new ConsumerProtocolAssignment.TopicPartitionCollection();
        assignment.forEach((topicId, partitions) -> {
            TopicImage topicImage = topicsImage.getTopic(topicId);
            if (topicImage != null) {
                collection.add((ImplicitLinkedHashCollection.Element)new ConsumerProtocolAssignment.TopicPartition().setTopic((String)transformTopicName.apply(topicImage.name())).setPartitions(new ArrayList(partitions)));
            }
        });
        return new ConsumerProtocolAssignment().setAssignedPartitions(collection);
    }

    public static Map<Uuid, Set<Integer>> toTopicPartitionMap(ConsumerProtocolAssignment consumerProtocolAssignment, TopicsImage topicsImage, Function<String, String> transformTopicName) {
        HashMap<Uuid, Set<Integer>> topicPartitionMap = new HashMap<Uuid, Set<Integer>>();
        consumerProtocolAssignment.assignedPartitions().forEach(topicPartition -> {
            TopicImage topicImage = topicsImage.getTopic((String)transformTopicName.apply(topicPartition.topic()));
            if (topicImage != null) {
                topicPartitionMap.put(topicImage.id(), new HashSet(topicPartition.partitions()));
            }
        });
        return topicPartitionMap;
    }

    public static List<ConsumerGroupHeartbeatRequestData.TopicPartitions> toTopicPartitions(ConsumerProtocolSubscription.TopicPartitionCollection topicPartitionCollection, TopicsImage topicsImage) {
        ArrayList<ConsumerGroupHeartbeatRequestData.TopicPartitions> res = new ArrayList<ConsumerGroupHeartbeatRequestData.TopicPartitions>();
        for (ConsumerProtocolSubscription.TopicPartition tp : topicPartitionCollection) {
            TopicImage topicImage = topicsImage.getTopic(tp.topic());
            if (topicImage == null) continue;
            res.add(new ConsumerGroupHeartbeatRequestData.TopicPartitions().setTopicId(topicImage.id()).setPartitions(tp.partitions()));
        }
        return res;
    }

    public static Map<Uuid, Set<Integer>> assignmentFromTopicPartitions(List<ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions> topicPartitionsList) {
        return topicPartitionsList.stream().collect(Collectors.toMap(ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions::topicId, topicPartitions -> Collections.unmodifiableSet(new HashSet<Integer>(topicPartitions.partitions()))));
    }

    public static Map<Uuid, Set<Integer>> assignmentFromShareGroupTopicPartitions(List<ShareGroupCurrentMemberAssignmentValue.TopicPartitions> topicPartitionsList) {
        return topicPartitionsList.stream().collect(Collectors.toMap(ShareGroupCurrentMemberAssignmentValue.TopicPartitions::topicId, topicPartitions -> Collections.unmodifiableSet(new HashSet<Integer>(topicPartitions.partitions()))));
    }

    public static ApiMessage messageOrNull(ApiMessageAndVersion apiMessageAndVersion) {
        if (apiMessageAndVersion == null) {
            return null;
        }
        return apiMessageAndVersion.message();
    }
}

