/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.classic;

import io.confluent.kafka.multitenant.TenantUtils;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.CoordinatorNotAvailableException;
import org.apache.kafka.common.errors.FencedInstanceIdException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.IllegalGenerationException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.message.ConsumerProtocolAssignment;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecord;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.GroupCoordinatorRecordHelpers;
import org.apache.kafka.coordinator.group.OffsetExpirationCondition;
import org.apache.kafka.coordinator.group.OffsetExpirationConditionImpl;
import org.apache.kafka.coordinator.group.Utils;
import org.apache.kafka.coordinator.group.classic.ClassicGroupMember;
import org.apache.kafka.coordinator.group.classic.ClassicGroupState;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetricsShard;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroup;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroupMember;
import org.apache.kafka.image.MetadataImage;
import org.slf4j.Logger;

public class ClassicGroup
implements Group {
    public static final String NO_LEADER = "";
    private static final String MEMBER_ID_DELIMITER = "-";
    private final Logger log;
    private final String groupId;
    private final Time time;
    private ClassicGroupState state;
    private ClassicGroupState previousState;
    private Optional<Long> currentStateTimestamp;
    private Optional<String> protocolType;
    private Optional<String> protocolName;
    private int generationId;
    private Optional<String> leaderId;
    private final Map<String, ClassicGroupMember> members = new HashMap<String, ClassicGroupMember>();
    private final Map<String, String> staticMembers = new HashMap<String, String>();
    private final Set<String> pendingJoinMembers = new HashSet<String>();
    private int numMembersAwaitingJoinResponse = 0;
    private final Map<String, Integer> supportedProtocols = new HashMap<String, Integer>();
    private final Set<String> pendingSyncMembers = new HashSet<String>();
    private Optional<Set<String>> subscribedTopics = Optional.empty();
    private boolean newMemberAdded = false;
    private final GroupCoordinatorMetricsShard metrics;
    Optional<Long> rebalanceStartTimestampMs = Optional.empty();
    private static final AtomicLong lastSubscriptionPatternLogTime = new AtomicLong(0L);

    public ClassicGroup(LogContext logContext, String groupId, ClassicGroupState initialState, Time time, GroupCoordinatorMetricsShard metrics) {
        this(logContext, groupId, initialState, time, metrics, 0, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(time.milliseconds()));
    }

    public ClassicGroup(LogContext logContext, String groupId, ClassicGroupState initialState, Time time, GroupCoordinatorMetricsShard metrics, int generationId, Optional<String> protocolType, Optional<String> protocolName, Optional<String> leaderId, Optional<Long> currentStateTimestamp) {
        Objects.requireNonNull(logContext);
        this.log = logContext.logger(ClassicGroup.class);
        this.groupId = Objects.requireNonNull(groupId);
        this.state = Objects.requireNonNull(initialState);
        this.previousState = ClassicGroupState.DEAD;
        this.time = Objects.requireNonNull(time);
        this.metrics = Objects.requireNonNull(metrics);
        this.generationId = generationId;
        this.protocolType = protocolType;
        this.protocolName = protocolName;
        this.leaderId = leaderId;
        this.currentStateTimestamp = currentStateTimestamp;
    }

    @Override
    public Group.GroupType type() {
        return Group.GroupType.CLASSIC;
    }

    @Override
    public String stateAsString() {
        return this.state.toString();
    }

    @Override
    public String stateAsString(long committedOffset) {
        return this.state.toString();
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    public int generationId() {
        return this.generationId;
    }

    public Optional<String> protocolName() {
        return this.protocolName;
    }

    public Optional<String> protocolType() {
        return this.protocolType;
    }

    public boolean isSimpleGroup() {
        return this.protocolType.isEmpty() && this.isEmpty() && this.pendingJoinMembers.isEmpty();
    }

    public ClassicGroupState currentState() {
        return this.state;
    }

    public ClassicGroupState previousState() {
        return this.previousState;
    }

    public boolean newMemberAdded() {
        return this.newMemberAdded;
    }

    public boolean isInState(ClassicGroupState groupState) {
        return this.state == groupState;
    }

    @Override
    public boolean hasMember(String memberId) {
        return this.members.containsKey(memberId);
    }

    public ClassicGroupMember member(String memberId) {
        return this.members.get(memberId);
    }

    @Override
    public int numMembers() {
        return this.members.size();
    }

    public boolean isLeader(String memberId) {
        return this.leaderId.map(id -> id.equals(memberId)).orElse(false);
    }

    public String leaderOrNull() {
        return this.leaderId.orElse(null);
    }

    public long currentStateTimestampOrDefault() {
        return this.currentStateTimestamp.orElse(-1L);
    }

    public Map<String, Integer> supportedProtocols() {
        return this.supportedProtocols;
    }

    public Optional<Long> rebalanceStartTimestampMs() {
        return this.rebalanceStartTimestampMs;
    }

    public void setNewMemberAdded(boolean value) {
        this.newMemberAdded = value;
    }

    public void setSubscribedTopics(Optional<Set<String>> subscribedTopics) {
        this.subscribedTopics = subscribedTopics;
    }

    public void setProtocolName(Optional<String> protocolName) {
        this.protocolName = protocolName;
    }

    public boolean usesConsumerGroupProtocol() {
        return this.protocolType.map(type -> type.equals("consumer")).orElse(false);
    }

    public void add(ClassicGroupMember member) {
        this.add(member, null);
    }

    public void add(ClassicGroupMember member, CompletableFuture<JoinGroupResponseData> future) {
        member.groupInstanceId().ifPresent(instanceId -> {
            if (this.staticMembers.containsKey(instanceId)) {
                throw new IllegalStateException("Static member with groupInstanceId=" + instanceId + " cannot be added to group " + this.groupId + " since it is already a member.");
            }
            this.staticMembers.put((String)instanceId, member.memberId());
        });
        if (this.members.isEmpty()) {
            this.protocolType = Optional.of(member.protocolType());
        }
        if (!Objects.equals(this.protocolType.orElse(null), member.protocolType())) {
            throw new IllegalStateException("The group and member's protocol type must be the same.");
        }
        if (!this.supportsProtocols(member)) {
            throw new IllegalStateException("None of the member's protocols can be supported.");
        }
        if (this.leaderId.isEmpty()) {
            this.leaderId = Optional.of(member.memberId());
        }
        this.members.put(member.memberId(), member);
        this.incrementSupportedProtocols(member);
        member.setAwaitingJoinFuture(future);
        if (member.isAwaitingJoin()) {
            ++this.numMembersAwaitingJoinResponse;
        }
        this.pendingJoinMembers.remove(member.memberId());
    }

    public void remove(String memberId) {
        ClassicGroupMember removedMember = this.members.remove(memberId);
        if (removedMember != null) {
            this.decrementSupportedProtocols(removedMember);
            if (removedMember.isAwaitingJoin()) {
                --this.numMembersAwaitingJoinResponse;
            }
            removedMember.groupInstanceId().ifPresent(this.staticMembers::remove);
        }
        if (this.isLeader(memberId)) {
            Iterator<String> iter = this.members.keySet().iterator();
            String newLeader = iter.hasNext() ? iter.next() : null;
            this.leaderId = Optional.ofNullable(newLeader);
        }
        this.pendingJoinMembers.remove(memberId);
        this.pendingSyncMembers.remove(memberId);
    }

    public boolean maybeElectNewJoinedLeader() {
        if (this.leaderId.isPresent()) {
            ClassicGroupMember currentLeader = this.member(this.leaderId.get());
            if (!currentLeader.isAwaitingJoin()) {
                for (ClassicGroupMember member : this.members.values()) {
                    if (!member.isAwaitingJoin()) continue;
                    this.leaderId = Optional.of(member.memberId());
                    this.log.info("Group leader [memberId: {}, groupInstanceId: {}] failed to join before the rebalance timeout. Member {} was elected as the new leader.", new Object[]{currentLeader.memberId(), currentLeader.groupInstanceId().orElse("None"), member});
                    return true;
                }
                this.log.info("Group leader [memberId: {}, groupInstanceId: {}] failed to join before the rebalance timeout and the group couldn't proceed to the next generation because no member joined.", (Object)currentLeader.memberId(), (Object)currentLeader.groupInstanceId().orElse("None"));
                return false;
            }
            return true;
        }
        return false;
    }

    public ClassicGroupMember replaceStaticMember(String groupInstanceId, String oldMemberId, String newMemberId) {
        ClassicGroupMember removedMember = this.members.remove(oldMemberId);
        if (removedMember == null) {
            throw new IllegalArgumentException("Cannot replace non-existing member id " + oldMemberId);
        }
        JoinGroupResponseData joinGroupResponse = new JoinGroupResponseData().setMembers(Collections.emptyList()).setMemberId(oldMemberId).setProtocolName(null).setProtocolType(null).setLeader(NO_LEADER).setSkipAssignment(false).setErrorCode(Errors.FENCED_INSTANCE_ID.code());
        this.completeJoinFuture(removedMember, joinGroupResponse);
        SyncGroupResponseData syncGroupResponse = new SyncGroupResponseData().setAssignment(new byte[0]).setProtocolName(null).setProtocolType(null).setErrorCode(Errors.FENCED_INSTANCE_ID.code());
        this.completeSyncFuture(removedMember, syncGroupResponse);
        ClassicGroupMember newMember = new ClassicGroupMember(newMemberId, removedMember.groupInstanceId(), removedMember.clientId(), removedMember.clientHost(), removedMember.rebalanceTimeoutMs(), removedMember.sessionTimeoutMs(), removedMember.protocolType(), removedMember.supportedProtocols(), removedMember.assignment());
        this.members.put(newMemberId, newMember);
        if (this.isLeader(oldMemberId)) {
            this.leaderId = Optional.of(newMemberId);
        }
        this.staticMembers.put(groupInstanceId, newMemberId);
        return newMember;
    }

    public boolean isPendingMember(String memberId) {
        return this.pendingJoinMembers.contains(memberId);
    }

    public boolean addPendingMember(String memberId) {
        if (this.hasMember(memberId)) {
            throw new IllegalStateException("Attempt to add pending member " + memberId + " which is already a stable member of the group.");
        }
        return this.pendingJoinMembers.add(memberId);
    }

    public int numPendingJoinMembers() {
        return this.pendingJoinMembers.size();
    }

    public boolean addPendingSyncMember(String memberId) {
        if (!this.hasMember(memberId)) {
            throw new IllegalStateException("Attempt to add pending sync member " + memberId + " which is already a stable member of the group.");
        }
        return this.pendingSyncMembers.add(memberId);
    }

    public boolean removePendingSyncMember(String memberId) {
        if (!this.hasMember(memberId)) {
            throw new IllegalStateException("Attempt to add pending member " + memberId + " which is already a stable member of the group.");
        }
        return this.pendingSyncMembers.remove(memberId);
    }

    public boolean hasReceivedSyncFromAllMembers() {
        return this.pendingSyncMembers.isEmpty();
    }

    public Set<String> allPendingSyncMembers() {
        return this.pendingSyncMembers;
    }

    public void clearPendingSyncMembers() {
        this.pendingSyncMembers.clear();
    }

    public boolean hasStaticMember(String groupInstanceId) {
        return this.staticMembers.containsKey(groupInstanceId);
    }

    public String staticMemberId(String groupInstanceId) {
        return this.staticMembers.get(groupInstanceId);
    }

    public Map<String, ClassicGroupMember> notYetRejoinedMembers() {
        HashMap<String, ClassicGroupMember> notYetRejoinedMembers = new HashMap<String, ClassicGroupMember>();
        this.members.values().forEach(member -> {
            if (!member.isAwaitingJoin()) {
                notYetRejoinedMembers.put(member.memberId(), (ClassicGroupMember)member);
            }
        });
        return notYetRejoinedMembers;
    }

    public boolean hasAllMembersJoined() {
        return this.members.size() == this.numMembersAwaitingJoinResponse && this.pendingJoinMembers.isEmpty();
    }

    public Set<String> allMemberIds() {
        return this.members.keySet();
    }

    public Set<String> allStaticMemberIds() {
        return new HashSet<String>(this.staticMembers.values());
    }

    public Set<String> allDynamicMemberIds() {
        HashSet<String> dynamicMemberSet = new HashSet<String>(this.allMemberIds());
        this.staticMembers.values().forEach(dynamicMemberSet::remove);
        return dynamicMemberSet;
    }

    public int numAwaitingJoinResponse() {
        return this.numMembersAwaitingJoinResponse;
    }

    public Collection<ClassicGroupMember> allMembers() {
        return this.members.values();
    }

    public int rebalanceTimeoutMs() {
        int maxRebalanceTimeoutMs = 0;
        for (ClassicGroupMember member : this.members.values()) {
            maxRebalanceTimeoutMs = Math.max(maxRebalanceTimeoutMs, member.rebalanceTimeoutMs());
        }
        return maxRebalanceTimeoutMs;
    }

    public String generateMemberId(String clientId, Optional<String> groupInstanceId) {
        return groupInstanceId.map(s -> s + MEMBER_ID_DELIMITER + String.valueOf(UUID.randomUUID())).orElseGet(() -> clientId + MEMBER_ID_DELIMITER + String.valueOf(UUID.randomUUID()));
    }

    public void validateMember(String memberId, String groupInstanceId, String operation) throws UnknownMemberIdException, FencedInstanceIdException {
        if (groupInstanceId != null) {
            String existingMemberId = this.staticMemberId(groupInstanceId);
            if (existingMemberId == null) {
                throw Errors.UNKNOWN_MEMBER_ID.exception();
            }
            if (!existingMemberId.equals(memberId)) {
                this.log.info("Request memberId={} for static member with groupInstanceId={} is fenced by existing memberId={} during operation {}", new Object[]{memberId, groupInstanceId, existingMemberId, operation});
                throw Errors.FENCED_INSTANCE_ID.exception();
            }
        }
        if (!this.hasMember(memberId)) {
            throw Errors.UNKNOWN_MEMBER_ID.exception();
        }
    }

    @Override
    public void validateOffsetCommit(String memberId, String groupInstanceId, int generationId, boolean isTransactional, short apiVersion) throws CoordinatorNotAvailableException, UnknownMemberIdException, IllegalGenerationException, FencedInstanceIdException {
        if (this.isInState(ClassicGroupState.DEAD)) {
            throw Errors.COORDINATOR_NOT_AVAILABLE.exception();
        }
        if (generationId < 0 && this.isInState(ClassicGroupState.EMPTY)) {
            return;
        }
        if (generationId >= 0 || !memberId.isEmpty() || groupInstanceId != null) {
            this.validateMember(memberId, groupInstanceId, isTransactional ? "offset-commit" : "txn-offset-commit");
            if (generationId != this.generationId) {
                throw Errors.ILLEGAL_GENERATION.exception();
            }
        } else if (!isTransactional && !this.isInState(ClassicGroupState.EMPTY)) {
            throw Errors.UNKNOWN_MEMBER_ID.exception();
        }
        if (!isTransactional && this.isInState(ClassicGroupState.COMPLETING_REBALANCE)) {
            throw Errors.REBALANCE_IN_PROGRESS.exception();
        }
    }

    @Override
    public void validateOffsetFetch(String memberId, int memberEpoch, long lastCommittedOffset) throws GroupIdNotFoundException {
        if (this.isInState(ClassicGroupState.DEAD)) {
            throw new GroupIdNotFoundException(String.format("Group %s is in dead state.", this.groupId));
        }
    }

    @Override
    public void validateOffsetDelete() throws ApiException {
        switch (this.currentState()) {
            case DEAD: {
                throw new GroupIdNotFoundException(String.format("Group %s is in dead state.", this.groupId));
            }
            case STABLE: 
            case PREPARING_REBALANCE: 
            case COMPLETING_REBALANCE: {
                if (this.usesConsumerGroupProtocol()) break;
                throw Errors.NON_EMPTY_GROUP.exception();
            }
        }
    }

    @Override
    public void validateDeleteGroup() throws ApiException {
        switch (this.currentState()) {
            case DEAD: {
                throw new GroupIdNotFoundException(String.format("Group %s is in dead state.", this.groupId));
            }
            case STABLE: 
            case PREPARING_REBALANCE: 
            case COMPLETING_REBALANCE: {
                throw Errors.NON_EMPTY_GROUP.exception();
            }
        }
    }

    @Override
    public void createGroupTombstoneRecords(List<CoordinatorRecord> records) {
        records.add(GroupCoordinatorRecordHelpers.newGroupMetadataTombstoneRecord(this.groupId()));
    }

    @Override
    public boolean isEmpty() {
        return this.isInState(ClassicGroupState.EMPTY);
    }

    @Override
    public Optional<OffsetExpirationCondition> offsetExpirationCondition() {
        if (this.protocolType.isPresent()) {
            if (this.isInState(ClassicGroupState.EMPTY)) {
                return Optional.of(new OffsetExpirationConditionImpl(offsetAndMetadata -> this.currentStateTimestamp.orElse(offsetAndMetadata.commitTimestampMs)));
            }
            if (this.usesConsumerGroupProtocol() && this.subscribedTopics.isPresent() && this.isInState(ClassicGroupState.STABLE)) {
                return Optional.of(new OffsetExpirationConditionImpl(offsetAndMetadata -> offsetAndMetadata.commitTimestampMs));
            }
        } else {
            return Optional.of(new OffsetExpirationConditionImpl(offsetAndMetadata -> offsetAndMetadata.commitTimestampMs));
        }
        return Optional.empty();
    }

    @Override
    public boolean isInStates(Set<String> statesFilter, long committedOffset) {
        return statesFilter.contains(this.state.toLowerCaseString());
    }

    public boolean canRebalance() {
        return ClassicGroupState.PREPARING_REBALANCE.validPreviousStates().contains((Object)this.state);
    }

    public void transitionTo(ClassicGroupState groupState) {
        this.assertValidTransition(groupState);
        this.rebalanceStartTimestampMs = this.getRebalanceStartTimestampMs(groupState);
        this.previousState = this.state;
        this.state = groupState;
        this.currentStateTimestamp = Optional.of(this.time.milliseconds());
    }

    public String selectProtocol() {
        if (this.members.isEmpty()) {
            throw new IllegalStateException("Cannot select protocol for empty group");
        }
        Set<String> candidates = this.candidateProtocols();
        HashMap votesByProtocol = new HashMap();
        this.allMembers().stream().map(member -> member.vote(candidates)).forEach(protocolName -> {
            int count = votesByProtocol.getOrDefault(protocolName, 0);
            votesByProtocol.put(protocolName, count + 1);
        });
        return votesByProtocol.entrySet().stream().max(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).orElse(null);
    }

    private void incrementSupportedProtocols(ClassicGroupMember member) {
        member.supportedProtocols().forEach(protocol -> {
            int count = this.supportedProtocols.getOrDefault(protocol.name(), 0);
            this.supportedProtocols.put(protocol.name(), count + 1);
        });
    }

    private void decrementSupportedProtocols(ClassicGroupMember member) {
        member.supportedProtocols().forEach(protocol -> {
            int count = this.supportedProtocols.getOrDefault(protocol.name(), 0);
            this.supportedProtocols.put(protocol.name(), count - 1);
        });
    }

    private Set<String> candidateProtocols() {
        return this.supportedProtocols.entrySet().stream().filter(protocol -> ((Integer)protocol.getValue()).intValue() == this.members.size()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public boolean supportsProtocols(ClassicGroupMember member) {
        return this.supportsProtocols(member.protocolType(), ClassicGroupMember.plainProtocolSet(member.supportedProtocols()));
    }

    public boolean supportsProtocols(String memberProtocolType, JoinGroupRequestData.JoinGroupRequestProtocolCollection memberProtocols) {
        return this.supportsProtocols(memberProtocolType, ClassicGroupMember.plainProtocolSet(memberProtocols));
    }

    public boolean supportsProtocols(String memberProtocolType, Set<String> memberProtocols) {
        if (this.isInState(ClassicGroupState.EMPTY)) {
            return !memberProtocolType.isEmpty() && !memberProtocols.isEmpty();
        }
        return this.protocolType.map(type -> type.equals(memberProtocolType)).orElse(false) != false && memberProtocols.stream().anyMatch(name -> this.supportedProtocols.getOrDefault(name, 0).intValue() == this.members.size());
    }

    public Optional<Set<String>> subscribedTopics() {
        return this.subscribedTopics;
    }

    @Override
    public boolean isSubscribedToTopic(String topic) {
        return this.subscribedTopics.map(topics -> topics.contains(topic)).orElse(this.usesConsumerGroupProtocol());
    }

    public Optional<Set<String>> computeSubscribedTopics() {
        if (this.protocolType.isEmpty()) {
            return Optional.empty();
        }
        String type = this.protocolType.get();
        if (!type.equals("consumer")) {
            return Optional.empty();
        }
        if (this.members.isEmpty()) {
            return Optional.of(Collections.emptySet());
        }
        if (this.protocolName.isPresent()) {
            try {
                HashSet allSubscribedTopics = new HashSet();
                this.members.values().forEach(member -> {
                    ByteBuffer buffer = ByteBuffer.wrap(member.metadata(this.protocolName.get()));
                    ConsumerProtocol.deserializeVersion((ByteBuffer)buffer);
                    allSubscribedTopics.addAll(new HashSet(ConsumerProtocol.deserializeConsumerProtocolSubscription((ByteBuffer)buffer, (short)0).topics()));
                });
                return Optional.of(allSubscribedTopics);
            }
            catch (SchemaException e) {
                this.log.warn("Failed to parse Consumer Protocol consumer:" + this.protocolName.get() + " of group " + this.groupId + ". Consumer group coordinator is not aware of the subscribed topics.", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    public void maybeLogSubscriptionPattern(int logInterval) {
        if (!this.subscribedTopics.isPresent()) {
            return;
        }
        ClassicGroup.maybeLogSubscriptionPattern(arg_0 -> ((Logger)this.log).info(arg_0), this.time, logInterval, this.groupId, (Collection<String>)this.subscribedTopics.get(), this.members.values().stream().map(member -> member.metadata(this.protocolName.get())).collect(Collectors.toList()));
    }

    public static void maybeLogSubscriptionPattern(Consumer<String> log, Time time, int logInterval, String groupId, Collection<String> allSubscribedTopics, Iterable<byte[]> memberMetadata) {
        long lastLogTimeMs;
        if (logInterval < 0) {
            return;
        }
        long currentTimeMs = time.hiResClockMs();
        do {
            if (currentTimeMs - (lastLogTimeMs = lastSubscriptionPatternLogTime.get()) > (long)logInterval) continue;
            return;
        } while (!lastSubscriptionPatternLogTime.compareAndSet(lastLogTimeMs, currentTimeMs));
        HashMap<String, Integer> topicIndices = new HashMap<String, Integer>();
        for (String topic : allSubscribedTopics) {
            topicIndices.put(topic, topicIndices.size());
        }
        boolean shouldLog = false;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Consumer group ");
        stringBuilder.append(groupId);
        stringBuilder.append(" has heterogeneous subscriptions: ");
        boolean needsComma = false;
        for (byte[] metadata : memberMetadata) {
            ByteBuffer buffer = ByteBuffer.wrap(metadata);
            ConsumerProtocol.deserializeVersion((ByteBuffer)buffer);
            List topics = ConsumerProtocol.deserializeConsumerProtocolSubscription((ByteBuffer)buffer, (short)0).topics();
            if (topics.size() < allSubscribedTopics.size()) {
                shouldLog = true;
            }
            if (needsComma) {
                stringBuilder.append(", ");
            }
            needsComma = true;
            stringBuilder.append("[");
            stringBuilder.append(topics.stream().map(topicIndices::get).map(Object::toString).collect(Collectors.joining(", ")));
            stringBuilder.append("]");
        }
        if (shouldLog) {
            log.accept(stringBuilder.toString());
        }
    }

    public void updateMember(ClassicGroupMember member, JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols, int rebalanceTimeoutMs, int sessionTimeoutMs, CompletableFuture<JoinGroupResponseData> future) {
        this.decrementSupportedProtocols(member);
        member.setSupportedProtocols(protocols);
        this.incrementSupportedProtocols(member);
        member.setRebalanceTimeoutMs(rebalanceTimeoutMs);
        member.setSessionTimeoutMs(sessionTimeoutMs);
        if (future != null && !member.isAwaitingJoin()) {
            ++this.numMembersAwaitingJoinResponse;
        } else if (future == null && member.isAwaitingJoin()) {
            --this.numMembersAwaitingJoinResponse;
        }
        member.setAwaitingJoinFuture(future);
    }

    public boolean completeJoinFuture(ClassicGroupMember member, JoinGroupResponseData response) {
        if (member.isAwaitingJoin()) {
            member.awaitingJoinFuture().complete(response);
            member.setAwaitingJoinFuture(null);
            --this.numMembersAwaitingJoinResponse;
            return true;
        }
        return false;
    }

    public void completeAllJoinFutures(Errors error) {
        this.members.forEach((memberId, member) -> this.completeJoinFuture((ClassicGroupMember)member, new JoinGroupResponseData().setMemberId(memberId).setErrorCode(error.code())));
    }

    public boolean completeSyncFuture(ClassicGroupMember member, SyncGroupResponseData response) {
        if (member.isAwaitingSync()) {
            member.awaitingSyncFuture().complete(response);
            member.setAwaitingSyncFuture(null);
            return true;
        }
        return false;
    }

    public void completeAllSyncFutures(Errors error) {
        this.members.forEach((__, member) -> this.completeSyncFuture((ClassicGroupMember)member, new SyncGroupResponseData().setErrorCode(error.code())));
    }

    public void initNextGeneration() {
        ++this.generationId;
        if (!this.members.isEmpty()) {
            this.setProtocolName(Optional.of(this.selectProtocol()));
            this.subscribedTopics = this.computeSubscribedTopics();
            this.transitionTo(ClassicGroupState.COMPLETING_REBALANCE);
        } else {
            this.setProtocolName(Optional.empty());
            this.subscribedTopics = this.computeSubscribedTopics();
            this.transitionTo(ClassicGroupState.EMPTY);
        }
        this.clearPendingSyncMembers();
    }

    private Optional<Long> getRebalanceStartTimestampMs(ClassicGroupState nextState) {
        switch (nextState) {
            case PREPARING_REBALANCE: {
                if (this.isInState(ClassicGroupState.COMPLETING_REBALANCE)) {
                    return this.rebalanceStartTimestampMs;
                }
                return Optional.of(this.time.milliseconds());
            }
            case COMPLETING_REBALANCE: {
                return this.rebalanceStartTimestampMs;
            }
        }
        return Optional.empty();
    }

    public List<JoinGroupResponseData.JoinGroupResponseMember> currentClassicGroupMembers() {
        if (this.isInState(ClassicGroupState.DEAD) || this.isInState(ClassicGroupState.PREPARING_REBALANCE)) {
            throw new IllegalStateException("Cannot obtain classic member metadata for group " + this.groupId + " in state " + String.valueOf((Object)this.state));
        }
        return this.members.values().stream().map(member -> new JoinGroupResponseData.JoinGroupResponseMember().setMemberId(member.memberId()).setGroupInstanceId((String)member.groupInstanceId().orElse(null)).setMetadata(member.metadata(this.protocolName.orElse(null)))).collect(Collectors.toList());
    }

    @Override
    public ListGroupsResponseData.ListedGroup asListedGroup(long committedOffset) {
        return new ListGroupsResponseData.ListedGroup().setGroupId(this.groupId).setProtocolType(this.protocolType.orElse(NO_LEADER)).setGroupState(this.state.toString()).setGroupType(this.type().toString());
    }

    public Map<String, byte[]> groupAssignment() {
        return this.allMembers().stream().collect(Collectors.toMap(ClassicGroupMember::memberId, ClassicGroupMember::assignment));
    }

    public static ClassicGroup fromConsumerGroup(ConsumerGroup consumerGroup, Set<ConsumerGroupMember> leavingMembers, ConsumerGroupMember joiningMember, LogContext logContext, Time time, GroupCoordinatorMetricsShard metrics, MetadataImage metadataImage) {
        ClassicGroup classicGroup = new ClassicGroup(logContext, consumerGroup.groupId(), ClassicGroupState.STABLE, time, metrics, consumerGroup.groupEpoch(), Optional.of("consumer"), Optional.empty(), Optional.empty(), Optional.of(time.milliseconds()));
        consumerGroup.members().forEach((memberId, member) -> {
            if (!(leavingMembers.contains(member) || joiningMember != null && joiningMember.instanceId() != null && joiningMember.instanceId().equals(member.instanceId()))) {
                classicGroup.add(new ClassicGroupMember((String)memberId, Optional.ofNullable(member.instanceId()), member.clientId(), member.clientHost(), member.rebalanceTimeoutMs(), member.classicProtocolSessionTimeout().get(), "consumer", member.supportedJoinGroupRequestProtocols(), null));
            }
        });
        if (joiningMember != null) {
            classicGroup.add(new ClassicGroupMember(joiningMember.memberId(), Optional.ofNullable(joiningMember.instanceId()), joiningMember.clientId(), joiningMember.clientHost(), joiningMember.rebalanceTimeoutMs(), joiningMember.classicProtocolSessionTimeout().get(), "consumer", joiningMember.supportedJoinGroupRequestProtocols(), null));
        }
        classicGroup.setProtocolName(Optional.of(classicGroup.selectProtocol()));
        classicGroup.setSubscribedTopics(classicGroup.computeSubscribedTopics());
        Function tenantUnprefixer = TenantUtils.tenantUnprefixer((String)consumerGroup.groupId());
        classicGroup.allMembers().forEach(classicGroupMember -> {
            String memberId = classicGroupMember.memberId();
            if (joiningMember != null && memberId.equals(joiningMember.memberId())) {
                ConsumerGroupMember replacedMember = consumerGroup.staticMember(joiningMember.instanceId());
                if (replacedMember == null) {
                    throw new IllegalArgumentException("joiningMember must be a static member when not null.");
                }
                memberId = replacedMember.memberId();
            }
            byte[] assignment = org.apache.kafka.common.utils.Utils.toArray((ByteBuffer)ConsumerProtocol.serializeAssignment((ConsumerProtocolAssignment)Utils.toConsumerProtocolAssignment(consumerGroup.targetAssignment().get(memberId).partitions(), metadataImage.topics(), tenantUnprefixer), (short)ConsumerProtocol.deserializeVersion((ByteBuffer)ByteBuffer.wrap(classicGroupMember.metadata(classicGroup.protocolName().orElse(NO_LEADER))))));
            classicGroupMember.setAssignment(assignment);
        });
        return classicGroup;
    }

    public void createClassicGroupRecords(List<CoordinatorRecord> records) {
        HashMap<String, byte[]> assignments = new HashMap<String, byte[]>();
        this.allMembers().forEach(classicGroupMember -> assignments.put(classicGroupMember.memberId(), classicGroupMember.assignment()));
        records.add(GroupCoordinatorRecordHelpers.newGroupMetadataRecord(this, assignments));
    }

    private void assertValidTransition(ClassicGroupState targetState) {
        if (!targetState.validPreviousStates().contains((Object)this.state)) {
            throw new IllegalStateException("Group " + this.groupId + " should be in one of " + String.valueOf(targetState.validPreviousStates()) + " states before moving to " + String.valueOf((Object)targetState) + " state. Instead it is in " + String.valueOf((Object)this.state) + " state.");
        }
    }

    public void setLeaderId(Optional<String> leaderId) {
        this.leaderId = leaderId;
    }

    public String toString() {
        return "ClassicGroupMetadata(groupId=" + this.groupId + ", generation=" + this.generationId + ", protocolType=" + String.valueOf(this.protocolType) + ", currentState=" + String.valueOf((Object)this.currentState()) + ", members=" + String.valueOf(this.members) + ")";
    }
}

