/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.network.netty;

import io.confluent.kafka.network.netty.ReadableByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import org.apache.kafka.common.network.InvalidReceiveException;

public class ByteBufReceive
implements AutoCloseable {
    private final CompositeByteBuf compositeBuf;
    private final int maxReceivedSize;
    private final ByteBuf size;
    private int requestSize = 0;

    public ByteBufReceive(ByteBufAllocator alloc, int maxReceivedSize) {
        this.maxReceivedSize = maxReceivedSize;
        this.size = alloc.buffer(4, 4);
        this.compositeBuf = alloc.compositeBuffer(Integer.MAX_VALUE);
    }

    @Override
    public void close() {
        this.size.release();
        this.compositeBuf.release();
    }

    public boolean readFrom(ByteBuf byteBuf) {
        boolean bufferFullyConsumed;
        if (this.size.isWritable() && (bufferFullyConsumed = this.readSize(byteBuf))) {
            return true;
        }
        int remainingBytesToRead = this.requestSize - this.compositeBuf.capacity();
        boolean bufferConsumed = false;
        if (remainingBytesToRead < byteBuf.readableBytes()) {
            this.compositeBuf.addComponent(byteBuf.readRetainedSlice(remainingBytesToRead));
        } else {
            this.compositeBuf.addComponent(byteBuf);
            bufferConsumed = true;
        }
        this.compositeBuf.writerIndex(this.compositeBuf.capacity());
        return bufferConsumed;
    }

    private boolean readSize(ByteBuf byteBuf) {
        int byteToRead = Math.min(byteBuf.readableBytes(), this.size.writableBytes());
        byteBuf.readBytes(this.size, byteToRead);
        if (this.size.isWritable()) {
            byteBuf.release();
            return true;
        }
        this.requestSize = this.size.readInt();
        if (this.requestSize < 0) {
            throw new InvalidReceiveException("Invalid request size: " + this.requestSize);
        }
        if (this.requestSize > this.maxReceivedSize) {
            throw new InvalidReceiveException("Request size is too large: " + this.requestSize);
        }
        if (byteBuf.readableBytes() == 0) {
            byteBuf.release();
            return true;
        }
        return false;
    }

    public boolean complete() {
        return !this.size.isWritable() && this.requestSize == this.compositeBuf.capacity();
    }

    public int size() {
        return this.requestSize + this.size.capacity();
    }

    public int requestSize() {
        return this.requestSize;
    }

    public int bytesRead() {
        if (this.size.isWritable()) {
            return this.size.writerIndex();
        }
        return this.compositeBuf.readableBytes() + this.size.capacity();
    }

    public ReadableByteBuf payload() {
        return new ReadableByteBuf(this.compositeBuf);
    }

    public int refCnt() {
        return this.compositeBuf.refCnt();
    }
}

