/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.authorizer.Authorizer;

public interface DeletionEventHandler
extends Configurable,
MetadataPublisher {
    public CompletableFuture<Void> start(Boolean var1);

    public static DeletionEventHandler buildUserDeletionEventHandler(AbstractConfig config, Map<String, ?> interBrokerClientConfig, Metrics metrics, Optional<Authorizer> authorizer, int controllerNodeID) {
        DeletionEventHandler deletionEventHandler;
        Boolean enableDeletionHandler = false;
        if (interBrokerClientConfig.containsKey("confluent.cdc.user.deletion.handler.enable")) {
            enableDeletionHandler = Boolean.parseBoolean(interBrokerClientConfig.get("confluent.cdc.user.deletion.handler.enable").toString());
        }
        if (enableDeletionHandler == null || !enableDeletionHandler.booleanValue()) {
            return null;
        }
        String topic = config.getString("confluent.cdc.user.metadata.topic");
        if (topic == null || topic.isEmpty()) {
            throw new ConfigException("Value for config confluent.cdc.user.metadata.topic can not be empty when user metadata store are enabled");
        }
        HashMap<String, Object> interBrokerClientConfigForUserDeletionHandler = new HashMap<String, Object>(interBrokerClientConfig);
        DeletionEventHandler.setConfigs(config, interBrokerClientConfigForUserDeletionHandler);
        try {
            deletionEventHandler = (DeletionEventHandler)Utils.newParameterizedInstance("io.confluent.kafka.server.plugins.auth.UserDeletionEventHandler", Map.class, interBrokerClientConfigForUserDeletionHandler, Optional.class, authorizer, Metrics.class, metrics, Integer.TYPE, controllerNodeID);
        }
        catch (ClassNotFoundException e) {
            throw new KafkaException(e);
        }
        deletionEventHandler.configure(config.values());
        return deletionEventHandler;
    }

    public static Map<String, Object> setConfigs(AbstractConfig config, Map<String, Object> interBrokerClientConfigForUserDeletionHandler) {
        Object processRoles = config.originals().get("process.roles");
        if (processRoles != null && processRoles.toString().equalsIgnoreCase("controller")) {
            String metadataSecurityProtocol;
            Object metadataBootstrapServersObject = config.originals().get("confluent.metadata.bootstrap.servers");
            Object metadataSecurityProtocolObject = config.originals().get("confluent.metadata.security.protocol");
            String metadataBootstrapServers = metadataBootstrapServersObject == null ? null : metadataBootstrapServersObject.toString();
            String string = metadataSecurityProtocol = metadataSecurityProtocolObject == null ? null : metadataSecurityProtocolObject.toString();
            if (metadataBootstrapServers != null && !metadataBootstrapServers.trim().isEmpty()) {
                interBrokerClientConfigForUserDeletionHandler.put("bootstrap.servers", metadataBootstrapServers);
            }
            if (metadataSecurityProtocol != null && !metadataSecurityProtocol.trim().isEmpty()) {
                interBrokerClientConfigForUserDeletionHandler.put("security.protocol", metadataSecurityProtocol);
            }
            ConfluentConfigs.updatePrefixedConfigs(config.originals(), interBrokerClientConfigForUserDeletionHandler, "confluent.cdc.topic.metadata.", false);
        }
        return interBrokerClientConfigForUserDeletionHandler;
    }

    public Metrics metrics();

    @Override
    public String name();

    @Override
    public void onControllerChange(LeaderAndEpoch var1);
}

