/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.events.broker;

import com.google.flatbuffers.FlatBufferBuilder;
import io.confluent.kafka.durability.events.broker.serdes.MirrorStateChange;
import io.confluent.kafka.durability.events.serdes.BaseInfo;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import kafka.durability.DurabilityAuditMirrorState;
import kafka.durability.events.DurabilityEventType$;
import kafka.durability.events.broker.AbstractBrokerDurabilityEvent;
import kafka.durability.events.broker.EpochChangeEvent;
import kafka.durability.events.broker.MirrorStateChangeEvent$;
import org.apache.kafka.common.TopicIdPartition;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Set;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005]c\u0001B\r\u001b\u0001\rB\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A1\b\u0001B\u0001B\u0003%Q\u0007\u0003\u0005=\u0001\t\u0015\r\u0011\"\u0001>\u0011!\t\u0005A!A!\u0002\u0013q\u0004\u0002\u0003\"\u0001\u0005\u000b\u0007I\u0011A\u001f\t\u0011\r\u0003!\u0011!Q\u0001\nyB\u0001\u0002\u0012\u0001\u0003\u0006\u0004%\t!\u0012\u0005\t#\u0002\u0011\t\u0011)A\u0005\r\"A!\u000b\u0001BC\u0002\u0013\u00051\u000b\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003U\u0011!Y\u0006A!b\u0001\n\u0003b\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011B\u001b\t\u000by\u0003A\u0011A0\t\u000b%\u0004A\u0011\t6\t\u000b-\u0004A\u0011\u00027\t\u0011U\u0004\u0001R1A\u0005BYDQa\u001e\u0001\u0005BaDq!!\u0004\u0001\t\u0003\nyaB\u0004\u0002\u0012iA\t!a\u0005\u0007\reQ\u0002\u0012AA\u000b\u0011\u0019qV\u0003\"\u0001\u0002\u001e!9\u0011qD\u000b\u0005\u0002\u0005\u0005\u0002bBA\u0010+\u0011\u0005\u00111\u0007\u0002\u0017\u001b&\u0014(o\u001c:Ti\u0006$Xm\u00115b]\u001e,WI^3oi*\u00111\u0004H\u0001\u0007EJ|7.\u001a:\u000b\u0005uq\u0012AB3wK:$8O\u0003\u0002 A\u0005QA-\u001e:bE&d\u0017\u000e^=\u000b\u0003\u0005\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001IA\u0011QEJ\u0007\u00025%\u0011qE\u0007\u0002\u001e\u0003\n\u001cHO]1di\n\u0013xn[3s\tV\u0014\u0018MY5mSRLXI^3oi\u0006\u0001Bo\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\t\u0003UIj\u0011a\u000b\u0006\u0003Y5\naaY8n[>t'BA\u0011/\u0015\ty\u0003'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002c\u0005\u0019qN]4\n\u0005MZ#\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0003\u001d1XM]:j_:\u0004\"AN\u001d\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u00121!\u00138u\u0003\u0015)\u0007o\\2i\u00035A\u0017n\u001a5XCR,'/\\1sWV\ta\b\u0005\u00027\u007f%\u0011\u0001i\u000e\u0002\u0005\u0019>tw-\u0001\biS\u001eDw+\u0019;fe6\f'o\u001b\u0011\u0002\u001d1|wm\u0015;beR|eMZ:fi\u0006yAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$\b%A\u0002jgJ,\u0012A\u0012\t\u0004\u000f:+dB\u0001%M!\tIu'D\u0001K\u0015\tY%%\u0001\u0004=e>|GOP\u0005\u0003\u001b^\na\u0001\u0015:fI\u00164\u0017BA(Q\u0005\r\u0019V\r\u001e\u0006\u0003\u001b^\nA![:sA\u0005YQ.\u001b:s_J\u001cF/\u0019;f+\u0005!\u0006c\u0001\u001cV/&\u0011ak\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u001dC\u0016BA-Q\u0005\u0019\u0019FO]5oO\u0006aQ.\u001b:s_J\u001cF/\u0019;fA\u00051an\u001c3f\u0013\u0012,\u0012!N\u0001\b]>$W-\u00133!\u0003\u0019a\u0014N\\5u}QI\u0001-\u00192dI\u00164w\r\u001b\t\u0003K\u0001AQ\u0001\u000b\bA\u0002%BQ\u0001\u000e\bA\u0002UBQa\u000f\bA\u0002UBQ\u0001\u0010\bA\u0002yBQA\u0011\bA\u0002yBQ\u0001\u0012\bA\u0002\u0019CQA\u0015\bA\u0002QCQa\u0017\bA\u0002U\n!\u0002\\8hO\u0016\u0014h*Y7f+\u00059\u0016!C:fe&\fG.\u001b>f)\u0005i\u0007C\u00018t\u001b\u0005y'B\u00019r\u0003\rq\u0017n\u001c\u0006\u0002e\u0006!!.\u0019<b\u0013\t!xN\u0001\u0006CsR,')\u001e4gKJ\fQ\u0002]1zY>\fGMQ;gM\u0016\u0014X#A7\u0002\u0013\u00154XM\u001c;UsB,W#A=\u0011\u0007i\f9AD\u0002|\u0003\u0007q1\u0001`A\u0001\u001d\tixP\u0004\u0002J}&\t\u0011%\u0003\u0002 A%\u0011QDH\u0005\u0004\u0003\u000ba\u0012a\u0005#ve\u0006\u0014\u0017\u000e\\5us\u00163XM\u001c;UsB,\u0017\u0002BA\u0005\u0003\u0017\u00111\u0003R;sC\nLG.\u001b;z\u000bZ,g\u000e\u001e+za\u0016T1!!\u0002\u001d\u0003!!xn\u0015;sS:<G#A,\u0002-5K'O]8s'R\fG/Z\"iC:<W-\u0012<f]R\u0004\"!J\u000b\u0014\u0007U\t9\u0002E\u00027\u00033I1!a\u00078\u0005\u0019\te.\u001f*fMR\u0011\u00111C\u0001\u0006CB\u0004H.\u001f\u000b\u0010A\u0006\r\u0012qEA\u0015\u0003W\ti#a\f\u00022!1\u0011QE\fA\u0002%\n!!\u001b3\t\u000bm:\u0002\u0019A\u001b\t\u000bq:\u0002\u0019\u0001 \t\u000b\t;\u0002\u0019\u0001 \t\u000b\u0011;\u0002\u0019\u0001$\t\u000bI;\u0002\u0019\u0001+\t\u000bm;\u0002\u0019A\u001b\u0015\u000b\u0001\f)$a\u000e\t\r\u0005\u0015\u0002\u00041\u0001*\u0011\u001d\tI\u0004\u0007a\u0001\u0003w\tA\u0001Z1uCB!\u0011QHA*\u001b\t\tyD\u0003\u0003\u0002B\u0005\r\u0013AB:fe\u0012,7OC\u0002\u001c\u0003\u000bR1!HA$\u0015\ry\u0012\u0011\n\u0006\u0004C\u0005-#\u0002BA'\u0003\u001f\n\u0011bY8oM2,XM\u001c;\u000b\u0005\u0005E\u0013AA5p\u0013\u0011\t)&a\u0010\u0003#5K'O]8s'R\fG/Z\"iC:<W\r")
public class MirrorStateChangeEvent
extends AbstractBrokerDurabilityEvent {
    private ByteBuffer payloadBuffer;
    private final TopicIdPartition topicIdPartition;
    private final int version;
    private final int epoch;
    private final long highWatermark;
    private final long logStartOffset;
    private final Set<Object> isr;
    private final Option<String> mirrorState;
    private final int nodeId;
    private volatile boolean bitmap$0;

    public static MirrorStateChangeEvent apply(TopicIdPartition id, MirrorStateChange data) {
        return MirrorStateChangeEvent$.MODULE$.apply(id, data);
    }

    public static MirrorStateChangeEvent apply(TopicIdPartition id, int epoch, long highWatermark, long logStartOffset, Set<Object> isr, Option<String> mirrorState, int nodeId) {
        return MirrorStateChangeEvent$.MODULE$.apply(id, epoch, highWatermark, logStartOffset, isr, mirrorState, nodeId);
    }

    public long highWatermark() {
        return this.highWatermark;
    }

    public long logStartOffset() {
        return this.logStartOffset;
    }

    public Set<Object> isr() {
        return this.isr;
    }

    public Option<String> mirrorState() {
        return this.mirrorState;
    }

    @Override
    public int nodeId() {
        return this.nodeId;
    }

    @Override
    public String loggerName() {
        return EpochChangeEvent.class.getName();
    }

    private ByteBuffer serialize() {
        FlatBufferBuilder builder = new FlatBufferBuilder(this.KEY_INITIAL_LENGTH()).forceDefaults(true);
        int isrSerialized = MirrorStateChange.createIsrVector(builder, (int[])this.isr().toArray(ClassTag$.MODULE$.Int()));
        int mirrorStateValue = BoxesRunTime.unboxToInt(this.mirrorState().flatMap((Function1<String, Option> & Serializable)mirror -> OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(DurabilityAuditMirrorState.fromString(Optional.ofNullable(mirror))))).map((Function1<DurabilityAuditMirrorState, Object> & Serializable)x$1 -> BoxesRunTime.boxToInteger(x$1.getValue())).getOrElse(() -> 0));
        MirrorStateChange.startMirrorStateChange(builder);
        int infoOffset = BaseInfo.createBaseInfo(builder, this.version, this.epoch, this.highWatermark(), this.logStartOffset());
        MirrorStateChange.addInfo(builder, infoOffset);
        MirrorStateChange.addIsr(builder, isrSerialized);
        MirrorStateChange.addMirrorState(builder, mirrorStateValue);
        MirrorStateChange.addNodeId(builder, this.nodeId());
        int entryId = MirrorStateChange.endMirrorStateChange(builder);
        builder.finish(entryId);
        return MirrorStateChange.getRootAsMirrorStateChange(builder.dataBuffer()).getByteBuffer().duplicate();
    }

    private ByteBuffer payloadBuffer$lzycompute() {
        MirrorStateChangeEvent mirrorStateChangeEvent = this;
        synchronized (mirrorStateChangeEvent) {
            if (!this.bitmap$0) {
                this.payloadBuffer = this.serialize();
                this.bitmap$0 = true;
            }
        }
        return this.payloadBuffer;
    }

    @Override
    public ByteBuffer payloadBuffer() {
        if (!this.bitmap$0) {
            return this.payloadBuffer$lzycompute();
        }
        return this.payloadBuffer;
    }

    @Override
    public Enumeration.Value eventType() {
        return DurabilityEventType$.MODULE$.MirrorStateChangeType();
    }

    public String toString() {
        return "[TopicIdPartition: " + this.topicIdPartition + ", version: " + this.version + ", epoch: " + this.epoch + ", highWatermark: " + this.highWatermark() + ", logStartOffset: " + this.logStartOffset() + ", isr: " + this.isr() + ", mirrorState: " + this.mirrorState() + ", nodeId: " + this.nodeId() + "]";
    }

    public MirrorStateChangeEvent(TopicIdPartition topicIdPartition, int version, int epoch, long highWatermark, long logStartOffset, Set<Object> isr, Option<String> mirrorState, int nodeId) {
        this.topicIdPartition = topicIdPartition;
        this.version = version;
        this.epoch = epoch;
        this.highWatermark = highWatermark;
        this.logStartOffset = logStartOffset;
        this.isr = isr;
        this.mirrorState = mirrorState;
        this.nodeId = nodeId;
        super(topicIdPartition, epoch, nodeId, version);
    }
}

