/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.tools;

import java.util.Properties;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.events.CurrentVersion$;
import kafka.durability.events.broker.InjectStateEvent;
import kafka.tier.tools.RecoveryUtils;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import scala.Predef$;
import scala.collection.StringOps$;

public final class UpdateDB$ {
    public static final UpdateDB$ MODULE$ = new UpdateDB$();

    public int partitioner(TopicPartition topicPartition, int numPartitions) {
        return Math.abs(topicPartition.hashCode()) % numPartitions;
    }

    public Properties toProducerProperties(String clientId) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", "localhost:9071");
        properties.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        properties.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        properties.put("acks", "all");
        properties.put("enable.idempotence", "false");
        properties.put("retry.backoff.ms", Integer.toString(2000));
        properties.put("delivery.timeout.ms", Integer.toString(Integer.MAX_VALUE));
        properties.put("client.id", clientId);
        properties.put("request.timeout.ms", Integer.toString(1000));
        properties.put("max.in.flight.requests.per.connection", "1");
        properties.put("enable.metrics.push", "false");
        properties.remove("metric.reporters");
        return properties;
    }

    public void queueInjectStateEvent(TopicIdPartition topicIdPartition, InjectStateEvent event) {
        KafkaProducer<byte[], byte[]> producer = new KafkaProducer<byte[], byte[]>(this.toProducerProperties("DurabilityAuditToolClient"));
        int numPartitions = RecoveryUtils.getNumPartitions(producer, DurabilityAuditConstants$.MODULE$.TOPIC_NAME());
        int dbPartitionId = this.partitioner(topicIdPartition.topicPartition(), numPartitions);
        RecordMetadata injectedRecord = producer.send(new ProducerRecord<byte[], byte[]>(DurabilityAuditConstants$.MODULE$.TOPIC_NAME(), Predef$.MODULE$.int2Integer(dbPartitionId), event.serializeKey(), event.serializeValue())).get();
        Predef$.MODULE$.println("Record append for durability topic partition: " + Integer.toString(dbPartitionId) + " offset: " + Long.toString(injectedRecord.offset()));
        producer.close();
    }

    public void deletePartition(String topic, String partition) {
        block4: {
            try {
                if (topic == null || topic.trim().isEmpty() || partition == null || partition.trim().isEmpty()) {
                    Predef$.MODULE$.println("Cannot process: Empty topicPartition input");
                    break block4;
                }
                String userTopic = topic.trim();
                int userPartition = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partition.trim()));
                TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), userPartition, userTopic);
                InjectStateEvent event = new InjectStateEvent(topicIdPartition, CurrentVersion$.MODULE$.version(), -1, -1L, -1L, -1L, true, -1);
                this.queueInjectStateEvent(topicIdPartition, event);
            }
            catch (NumberFormatException e) {
                Predef$.MODULE$.println("Invalid format of input: " + e);
            }
            catch (Exception e) {
                Predef$.MODULE$.println("Caught the exception while injecting event: " + e);
            }
        }
    }

    public String deletePartition$default$1() {
        return "";
    }

    public String deletePartition$default$2() {
        return "";
    }

    public void updatePartition(String topic, String partition, String epoch, String hwm, String startOffset, String config) {
        block4: {
            try {
                if (topic == null || topic.trim().isEmpty() || partition == null || partition.trim().isEmpty()) {
                    Predef$.MODULE$.println("Cannot process: Empty topicIdPartition input");
                    break block4;
                }
                String userTopic = topic.trim();
                int userPartition = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partition.trim()));
                int eventEpoch = epoch == null || epoch.trim().isEmpty() ? -1 : StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(epoch.trim()));
                long eventHwm = hwm == null || hwm.trim().isEmpty() ? -1L : StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(hwm.trim()));
                long eventStartOffset = startOffset == null || startOffset.trim().isEmpty() ? -1L : StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(startOffset.trim()));
                long eventConfig = config == null || config.trim().isEmpty() ? -1L : StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(config.trim()));
                TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), userPartition, userTopic);
                InjectStateEvent event = new InjectStateEvent(topicIdPartition, CurrentVersion$.MODULE$.version(), eventEpoch, eventHwm, eventStartOffset, eventConfig, false, -1);
                this.queueInjectStateEvent(topicIdPartition, event);
            }
            catch (NumberFormatException e) {
                Predef$.MODULE$.println("Invalid format of input: " + e);
            }
            catch (Exception e) {
                Predef$.MODULE$.println("Caught the exception while injecting event: " + e);
            }
        }
    }

    public String updatePartition$default$1() {
        return "";
    }

    public String updatePartition$default$2() {
        return "";
    }

    public String updatePartition$default$3() {
        return "";
    }

    public String updatePartition$default$4() {
        return "";
    }

    public String updatePartition$default$5() {
        return "";
    }

    public String updatePartition$default$6() {
        return "";
    }

    private UpdateDB$() {
    }
}

