/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import kafka.log.AbstractLog;
import kafka.log.OffsetsToClean;
import kafka.utils.Logging;
import org.apache.kafka.storage.internals.log.LogSegment;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcJJ$sp;
import scala.Tuple2$mcJZ$sp;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class LogCleanerManager$
implements Logging {
    public static final LogCleanerManager$ MODULE$ = new LogCleanerManager$();
    private static final String kafka$log$LogCleanerManager$$UncleanablePartitionsCountMetricName;
    private static final String kafka$log$LogCleanerManager$$UncleanableBytesMetricName;
    private static final String kafka$log$LogCleanerManager$$TimeSinceLastRunMsMetricName;
    private static final String kafka$log$LogCleanerManager$$AchievedCleaningRatio;
    private static final String kafka$log$LogCleanerManager$$CompactedPartitionBytes;
    private static final String kafka$log$LogCleanerManager$$CompactedPartitionLocalBytes;
    private static final String kafka$log$LogCleanerManager$$CompactedPartitionTieredBytes;
    private static final Set<String> GaugeMetricNameNoTag;
    private static final Set<String> HistogramMetricNames;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
        kafka$log$LogCleanerManager$$UncleanablePartitionsCountMetricName = "uncleanable-partitions-count";
        kafka$log$LogCleanerManager$$UncleanableBytesMetricName = "uncleanable-bytes";
        kafka$log$LogCleanerManager$$TimeSinceLastRunMsMetricName = "time-since-last-run-ms";
        kafka$log$LogCleanerManager$$AchievedCleaningRatio = "AchievedCleaningRatio";
        kafka$log$LogCleanerManager$$CompactedPartitionBytes = "compacted-partition-bytes";
        kafka$log$LogCleanerManager$$CompactedPartitionLocalBytes = "compacted-partition-local-bytes";
        kafka$log$LogCleanerManager$$CompactedPartitionTieredBytes = "compacted-partition-tiered-bytes";
        GaugeMetricNameNoTag = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.kafka$log$LogCleanerManager$$TimeSinceLastRunMsMetricName()}));
        HistogramMetricNames = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.kafka$log$LogCleanerManager$$AchievedCleaningRatio()}));
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LogCleanerManager$ logCleanerManager$ = this;
        synchronized (logCleanerManager$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public String kafka$log$LogCleanerManager$$UncleanablePartitionsCountMetricName() {
        return kafka$log$LogCleanerManager$$UncleanablePartitionsCountMetricName;
    }

    public String kafka$log$LogCleanerManager$$UncleanableBytesMetricName() {
        return kafka$log$LogCleanerManager$$UncleanableBytesMetricName;
    }

    public String kafka$log$LogCleanerManager$$TimeSinceLastRunMsMetricName() {
        return kafka$log$LogCleanerManager$$TimeSinceLastRunMsMetricName;
    }

    public String kafka$log$LogCleanerManager$$AchievedCleaningRatio() {
        return kafka$log$LogCleanerManager$$AchievedCleaningRatio;
    }

    public String kafka$log$LogCleanerManager$$CompactedPartitionBytes() {
        return kafka$log$LogCleanerManager$$CompactedPartitionBytes;
    }

    public String kafka$log$LogCleanerManager$$CompactedPartitionLocalBytes() {
        return kafka$log$LogCleanerManager$$CompactedPartitionLocalBytes;
    }

    public String kafka$log$LogCleanerManager$$CompactedPartitionTieredBytes() {
        return kafka$log$LogCleanerManager$$CompactedPartitionTieredBytes;
    }

    public Set<String> GaugeMetricNameNoTag() {
        return GaugeMetricNameNoTag;
    }

    public Set<String> HistogramMetricNames() {
        return HistogramMetricNames;
    }

    private boolean isCompactAndDelete(AbstractLog log) {
        return log.config().compact() && log.config().delete();
    }

    public long localEarliestDirtyBatchTimestamp(AbstractLog log, long firstDirtyOffset) {
        Collection<LogSegment> dirtyNonActiveSegments = log.localNonActiveLogSegmentsFrom(firstDirtyOffset);
        return Predef$.MODULE$.Long2long(log.getFirstBatchTimestampForSegments(dirtyNonActiveSegments).stream().filter(x$10 -> Predef$.MODULE$.Long2long((Long)x$10) > 0L).min(Comparator.naturalOrder()).orElse(Predef$.MODULE$.long2Long(Long.MAX_VALUE)));
    }

    public long maxCompactionDelay(AbstractLog log, Function0<Object> earliestDirtyTimestamp, long now) {
        long maxCompactionLagMs = package$.MODULE$.max(log.config().maxCompactionLagMs(), 0L);
        long cleanUntilTime = now - maxCompactionLagMs;
        if (cleanUntilTime < 0L) {
            return 0L;
        }
        long earliestDirtySegmentTimestamp = earliestDirtyTimestamp.apply$mcJ$sp();
        if (earliestDirtySegmentTimestamp < cleanUntilTime) {
            return cleanUntilTime - earliestDirtySegmentTimestamp;
        }
        return 0L;
    }

    public OffsetsToClean cleanableOffsets(AbstractLog log, Option<Object> lastCleanOffset, long now) {
        Option option;
        Tuple2$mcJZ$sp tuple2$mcJZ$sp;
        long localLogStartOffset = log.localLogStartOffset();
        long checkpointDirtyOffset = BoxesRunTime.unboxToLong(lastCleanOffset.getOrElse(() -> localLogStartOffset));
        if (checkpointDirtyOffset < localLogStartOffset) {
            if (!this.isCompactAndDelete(log)) {
                this.warn((Function0<String> & Serializable)() -> "Resetting first dirty offset of " + log.name() + " to local log start offset " + localLogStartOffset + " since the checkpointed offset " + checkpointDirtyOffset + " is invalid.");
            }
            v0 = new Tuple2$mcJZ$sp(localLogStartOffset, true);
        } else if (checkpointDirtyOffset > log.logEndOffset()) {
            this.warn((Function0<String> & Serializable)() -> "The last checkpoint dirty offset for partition " + log.name() + " is " + checkpointDirtyOffset + ", which is larger than the log end offset " + log.logEndOffset() + ". Resetting to the local log start offset " + localLogStartOffset + ".");
            v0 = new Tuple2$mcJZ$sp(localLogStartOffset, true);
        } else {
            v0 = tuple2$mcJZ$sp = new Tuple2$mcJZ$sp(checkpointDirtyOffset, false);
        }
        if (tuple2$mcJZ$sp == null) {
            throw new MatchError(tuple2$mcJZ$sp);
        }
        long firstDirtyOffset = ((Tuple2)tuple2$mcJZ$sp)._1$mcJ$sp();
        boolean forceUpdateCheckpoint = ((Tuple2)tuple2$mcJZ$sp)._2$mcZ$sp();
        Tuple2$mcJZ$sp tuple2$mcJZ$sp2 = new Tuple2$mcJZ$sp(firstDirtyOffset, forceUpdateCheckpoint);
        long firstDirtyOffset2 = ((Tuple2)tuple2$mcJZ$sp2)._1$mcJ$sp();
        boolean forceUpdateCheckpoint2 = ((Tuple2)tuple2$mcJZ$sp2)._2$mcZ$sp();
        long minCompactionLagMs = package$.MODULE$.max(log.config().compactionLagMs(), 0L);
        Some<Long> some = new Some<Long>(BoxesRunTime.boxToLong(log.lastStableOffset()));
        Option<Long> option2 = Option$.MODULE$.apply(BoxesRunTime.boxToLong(log.activeSegment().baseOffset()));
        if (minCompactionLagMs > 0L) {
            Collection<LogSegment> dirtyNonActiveSegments = log.localNonActiveLogSegmentsFrom(firstDirtyOffset2);
            option = CollectionConverters$.MODULE$.CollectionHasAsScala(dirtyNonActiveSegments).asScala().find((Function1<LogSegment, Object> & Serializable)s -> BoxesRunTime.boxToBoolean(LogCleanerManager$.$anonfun$cleanableOffsets$4(now, minCompactionLagMs, log, s))).map((Function1<LogSegment, Object> & Serializable)x$12 -> BoxesRunTime.boxToLong(x$12.baseOffset()));
        } else {
            option = None$.MODULE$;
        }
        long firstUncleanableDirtyOffset = BoxesRunTime.unboxToLong(((IterableOnceOps)new $colon$colon<Nothing$>((Nothing$)((Object)some), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)option2), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)option), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.dualCompactionCleaningBound(log)), Nil$.MODULE$)))).flatten(Predef$.MODULE$.$conforms())).min(Ordering.Long$.MODULE$));
        this.debug((Function0<String> & Serializable)() -> "Finding range of cleanable offsets for log=" + log.name() + ". Last clean offset=" + lastCleanOffset + " now=" + now + " => firstDirtyOffset=" + firstDirtyOffset2 + " firstUncleanableOffset=" + firstUncleanableDirtyOffset + " activeSegment.baseOffset=" + log.activeSegment().baseOffset());
        return new OffsetsToClean(firstDirtyOffset2, package$.MODULE$.max(firstDirtyOffset2, firstUncleanableDirtyOffset), forceUpdateCheckpoint2);
    }

    public Tuple2<Object, Object> calculateCleanableBytes(AbstractLog log, long firstDirtyOffset, long uncleanableOffset) {
        LogSegment firstUncleanableSegment = (LogSegment)CollectionConverters$.MODULE$.CollectionHasAsScala(log.localNonActiveLogSegmentsFrom(uncleanableOffset)).asScala().headOption().getOrElse((Function0<LogSegment> & Serializable)() -> log.activeSegment());
        long firstUncleanableOffset = firstUncleanableSegment.baseOffset();
        long cleanableBytes = log.localLogSegments(package$.MODULE$.min(firstDirtyOffset, firstUncleanableOffset), firstUncleanableOffset).stream().mapToLong(x$13 -> x$13.size()).sum();
        return new Tuple2$mcJJ$sp(firstUncleanableOffset, cleanableBytes);
    }

    public Option<Object> dualCompactionCleaningBound(AbstractLog log) {
        if (log.tierPartitionState().isTieringEnabled() && log.config().confluentLogConfig().tierCleanerDualCompaction) {
            return new Some<Object>(BoxesRunTime.boxToLong(log.tierPartitionState().committedEndOffset() + 1L));
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$cleanableOffsets$4(long now$3, long minCompactionLagMs$1, AbstractLog log$3, LogSegment s) {
        boolean isUncleanable = s.largestTimestamp() > now$3 - minCompactionLagMs$1;
        MODULE$.debug((Function0<String> & Serializable)() -> "Checking if log segment may be cleaned: log='" + log$3.name() + "' segment.baseOffset=" + s.baseOffset() + " segment.largestTimestamp=" + s.largestTimestamp() + "; now - compactionLag=" + (now$3 - minCompactionLagMs$1) + "; is uncleanable=" + isUncleanable);
        return isUncleanable;
    }

    private LogCleanerManager$() {
    }
}

