/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import kafka.metrics.LinuxCpuMetricsCollector$;
import kafka.metrics.LinuxCpuMetricsCollector$SystemCpuTime$;
import net.jcip.annotations.GuardedBy;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.slf4j.Logger;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u00115baBA\u0001\u0003\u0007\u0001\u0011Q\u0002\u0005\u000b\u00037\u0001!\u0011!Q\u0001\n\u0005u\u0001BCA\u001a\u0001\t\u0015\r\u0011\"\u0001\u00026!Q\u0011\u0011\u000b\u0001\u0003\u0002\u0003\u0006I!a\u000e\t\u0015\u0005M\u0003A!b\u0001\n\u0003\t)\u0006\u0003\u0006\u0002d\u0001\u0011\t\u0011)A\u0005\u0003/B!\"!\u001a\u0001\u0005\u000b\u0007I\u0011AA4\u0011)\ty\u0007\u0001B\u0001B\u0003%\u0011\u0011\u000e\u0005\u000b\u0003c\u0002!Q1A\u0005\u0002\u0005\u001d\u0004BCA:\u0001\t\u0005\t\u0015!\u0003\u0002j!9\u0011Q\u000f\u0001\u0005\u0002\u0005]\u0004\"CAD\u0001\t\u0007I\u0011BAE\u0011!\ty\n\u0001Q\u0001\n\u0005-\u0005\"CAQ\u0001\t\u0007I\u0011BAE\u0011!\t\u0019\u000b\u0001Q\u0001\n\u0005-\u0005\"CAS\u0001\t\u0007I\u0011BAE\u0011!\t9\u000b\u0001Q\u0001\n\u0005-\u0005\"CAU\u0001\t\u0007I\u0011BAV\u0011!\t\t\r\u0001Q\u0001\n\u00055\u0006\"CAb\u0001\u0001\u0007I\u0011BAc\u0011%\ti\r\u0001a\u0001\n\u0013\ty\r\u0003\u0005\u0002\\\u0002\u0001\u000b\u0015BAd\u0011%\t9\u0010\u0001a\u0001\n\u0013\tI\u0010C\u0005\u0003\u0002\u0001\u0001\r\u0011\"\u0003\u0003\u0004!A!q\u0001\u0001!B\u0013\tY\u0010C\u0005\u0003\f\u0001\u0001\r\u0011\"\u0003\u0002z\"I!Q\u0002\u0001A\u0002\u0013%!q\u0002\u0005\t\u0005'\u0001\u0001\u0015)\u0003\u0002|\"I!q\u0003\u0001A\u0002\u0013%\u0011\u0011 \u0005\n\u00053\u0001\u0001\u0019!C\u0005\u00057A\u0001Ba\b\u0001A\u0003&\u00111 \u0005\n\u0005G\u0001!\u0019!C\u0005\u0003WC\u0001B!\n\u0001A\u0003%\u0011Q\u0016\u0005\n\u0005O\u0001\u0001\u0019!C\u0005\u0003\u000bD\u0011B!\u000b\u0001\u0001\u0004%IAa\u000b\t\u0011\t=\u0002\u0001)Q\u0005\u0003\u000fD\u0011B!\u000e\u0001\u0001\u0004%I!!2\t\u0013\t]\u0002\u00011A\u0005\n\te\u0002\u0002\u0003B\u001f\u0001\u0001\u0006K!a2\t\u0013\t\u0005\u0003A1A\u0005\n\u0005-\u0006\u0002\u0003B\"\u0001\u0001\u0006I!!,\t\u0013\t\u0015\u0003\u00011A\u0005\n\u0005\u0015\u0007\"\u0003B$\u0001\u0001\u0007I\u0011\u0002B%\u0011!\u0011i\u0005\u0001Q!\n\u0005\u001d\u0007\"\u0003B*\u0001\u0001\u0007I\u0011BAc\u0011%\u0011)\u0006\u0001a\u0001\n\u0013\u00119\u0006\u0003\u0005\u0003\\\u0001\u0001\u000b\u0015BAd\u0011%\u0011y\u0006\u0001a\u0001\n\u0013\tI\u0010C\u0005\u0003b\u0001\u0001\r\u0011\"\u0003\u0003d!A!q\r\u0001!B\u0013\tY\u0010C\u0005\u0003l\u0001\u0011\r\u0011\"\u0003\u0003n!A!1\u0010\u0001!\u0002\u0013\u0011y\u0007C\u0005\u0003~\u0001\u0011\r\u0011\"\u0003\u0003n!A!q\u0010\u0001!\u0002\u0013\u0011y\u0007C\u0005\u0003\u0002\u0002\u0011\r\u0011\"\u0003\u0002,\"A!1\u0011\u0001!\u0002\u0013\ti\u000bC\u0005\u0003\u0006\u0002\u0001\r\u0011\"\u0003\u0002F\"I!q\u0011\u0001A\u0002\u0013%!\u0011\u0012\u0005\t\u0005\u001b\u0003\u0001\u0015)\u0003\u0002H\"I!1\u0013\u0001A\u0002\u0013%\u0011Q\u0019\u0005\n\u0005+\u0003\u0001\u0019!C\u0005\u0005/C\u0001Ba'\u0001A\u0003&\u0011q\u0019\u0004\u0007\u0005?\u0003\u0001I!)\t\u0015\tmfH!f\u0001\n\u0003\t)\r\u0003\u0006\u0003>z\u0012\t\u0012)A\u0005\u0003\u000fD!Ba0?\u0005+\u0007I\u0011AAc\u0011)\u0011\tM\u0010B\tB\u0003%\u0011q\u0019\u0005\u000b\u0005\u0007t$Q3A\u0005\u0002\u0005\u0015\u0007B\u0003Bc}\tE\t\u0015!\u0003\u0002H\"Q!q\u0019 \u0003\u0016\u0004%\t!!2\t\u0015\t%gH!E!\u0002\u0013\t9\r\u0003\u0006\u0003Lz\u0012)\u001a!C\u0001\u0003\u000bD!B!4?\u0005#\u0005\u000b\u0011BAd\u0011)\u0011yM\u0010BK\u0002\u0013\u0005\u0011Q\u0019\u0005\u000b\u0005#t$\u0011#Q\u0001\n\u0005\u001d\u0007B\u0003Bj}\tU\r\u0011\"\u0001\u0002F\"Q!Q\u001b \u0003\u0012\u0003\u0006I!a2\t\u0015\t]gH!f\u0001\n\u0003\t)\r\u0003\u0006\u0003Zz\u0012\t\u0012)A\u0005\u0003\u000fD!Ba7?\u0005+\u0007I\u0011AAc\u0011)\u0011iN\u0010B\tB\u0003%\u0011q\u0019\u0005\u000b\u0005?t$Q3A\u0005\u0002\u0005\u0015\u0007B\u0003Bq}\tE\t\u0015!\u0003\u0002H\"9\u0011Q\u000f \u0005\u0002\t\r\b\"\u0003B\u007f}\t\u0007I\u0011AAc\u0011!\u0011yP\u0010Q\u0001\n\u0005\u001d\u0007\"CB\u0001}\u0005\u0005I\u0011AB\u0002\u0011%\u0019IBPI\u0001\n\u0003\u0019Y\u0002C\u0005\u00042y\n\n\u0011\"\u0001\u0004\u001c!I11\u0007 \u0012\u0002\u0013\u000511\u0004\u0005\n\u0007kq\u0014\u0013!C\u0001\u00077A\u0011ba\u000e?#\u0003%\taa\u0007\t\u0013\reb(%A\u0005\u0002\rm\u0001\"CB\u001e}E\u0005I\u0011AB\u000e\u0011%\u0019iDPI\u0001\n\u0003\u0019Y\u0002C\u0005\u0004@y\n\n\u0011\"\u0001\u0004\u001c!I1\u0011\t \u0012\u0002\u0013\u000511\u0004\u0005\n\u0007\u0007r\u0014\u0011!C!\u0007\u000bB\u0011b!\u0015?\u0003\u0003%\t!a\u001a\t\u0013\rMc(!A\u0005\u0002\rU\u0003\"CB0}\u0005\u0005I\u0011IB1\u0011%\u0019yGPA\u0001\n\u0003\u0019\t\bC\u0005\u0004|y\n\t\u0011\"\u0011\u0004~!I1\u0011\u0011 \u0002\u0002\u0013\u000531\u0011\u0005\n\u0007\u000bs\u0014\u0011!C!\u0007\u000fC\u0011b!#?\u0003\u0003%\tea#\b\u0013\r=\u0005!!A\t\u0002\rEe!\u0003BP\u0001\u0005\u0005\t\u0012ABJ\u0011\u001d\t)h\u001bC\u0001\u0007WC\u0011b!\"l\u0003\u0003%)ea\"\t\u0013\r56.!A\u0005\u0002\u000e=\u0006\"CBcW\u0006\u0005I\u0011QBd\u0011\u001d\u0019I\u000e\u0001C\u0001\u00077Dqa!8\u0001\t\u0003\u0019Y\u000eC\u0004\u0004`\u0002!\taa7\t\u000f\r\u0005\b\u0001\"\u0003\u0004d\"I1\u0011\u001e\u0001\u0005\u0002\u0005\r11\u001e\u0005\b\u0007[\u0004A\u0011ABn\u0011\u001d\u0019y\u000f\u0001C\u0001\u00077Dqa!=\u0001\t\u0003\u0019Y\u000eC\u0004\u0004t\u0002!Ia!>\t\u000f\rm\b\u0001\"\u0001\u0004~\"91q \u0001\u0005\u0002\u0011\u0005qA\u0003C\u000f\u0003\u0007\t\t\u0011#\u0001\u0005 \u0019Q\u0011\u0011AA\u0002\u0003\u0003E\t\u0001\"\t\t\u000f\u0005UD\u0010\"\u0001\u0005$!IAQ\u0005?\u0012\u0002\u0013\u0005Aq\u0005\u0005\n\tWa\u0018\u0013!C\u0001\tO\u0011\u0001\u0004T5okb\u001c\u0005/^'fiJL7m]\"pY2,7\r^8s\u0015\u0011\t)!a\u0002\u0002\u000f5,GO]5dg*\u0011\u0011\u0011B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0011q\u0002\t\u0005\u0003#\t9\"\u0004\u0002\u0002\u0014)\u0011\u0011QC\u0001\u0006g\u000e\fG.Y\u0005\u0005\u00033\t\u0019B\u0001\u0004B]f\u0014VMZ\u0001\taJ|7MU8piB!\u0011qDA\u0017\u001d\u0011\t\t#!\u000b\u0011\t\u0005\r\u00121C\u0007\u0003\u0003KQA!a\n\u0002\f\u00051AH]8pizJA!a\u000b\u0002\u0014\u00051\u0001K]3eK\u001aLA!a\f\u00022\t11\u000b\u001e:j]\u001eTA!a\u000b\u0002\u0014\u0005!A/[7f+\t\t9\u0004\u0005\u0003\u0002:\u00055SBAA\u001e\u0015\u0011\ti$a\u0010\u0002\u000bU$\u0018\u000e\\:\u000b\t\u0005\u0005\u00131I\u0001\u0007G>lWn\u001c8\u000b\t\u0005%\u0011Q\t\u0006\u0005\u0003\u000f\nI%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u0017\n1a\u001c:h\u0013\u0011\ty%a\u000f\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\u0007Y><w-\u001a:\u0016\u0005\u0005]\u0003\u0003BA-\u0003?j!!a\u0017\u000b\t\u0005u\u0013\u0011J\u0001\u0006g24GG[\u0005\u0005\u0003C\nYF\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003!*\u0007\u0010]8oK:$\u0018.\u00197ms\u0012+7-Y=j]\u001e<\u0016N\u001c3poNK'0Z%o'\u0016\u001cwN\u001c3t+\t\tI\u0007\u0005\u0003\u0002\u0012\u0005-\u0014\u0002BA7\u0003'\u00111!\u00138u\u0003%*\u0007\u0010]8oK:$\u0018.\u00197ms\u0012+7-Y=j]\u001e<\u0016N\u001c3poNK'0Z%o'\u0016\u001cwN\u001c3tA\u0005\u0001\".\u001b4gS\u0016\u001c\b+\u001a:TK\u000e|g\u000eZ\u0001\u0012U&4g-[3t!\u0016\u00148+Z2p]\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0007\u0002z\u0005u\u0014qPAA\u0003\u0007\u000b)\tE\u0002\u0002|\u0001i!!a\u0001\t\u000f\u0005m!\u00021\u0001\u0002\u001e!9\u00111\u0007\u0006A\u0002\u0005]\u0002bBA*\u0015\u0001\u0007\u0011q\u000b\u0005\n\u0003KR\u0001\u0013!a\u0001\u0003SB\u0011\"!\u001d\u000b!\u0003\u0005\r!!\u001b\u0002\u00171|\u0017\rZ!wOB\u000bG\u000f[\u000b\u0003\u0003\u0017\u0003B!!$\u0002\u001c6\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b\u0019*\u0001\u0003gS2,'\u0002BAK\u0003/\u000b1A\\5p\u0015\t\tI*\u0001\u0003kCZ\f\u0017\u0002BAO\u0003\u001f\u0013A\u0001U1uQ\u0006aAn\\1e\u0003Z<\u0007+\u0019;iA\u0005A1\u000f^1u!\u0006$\b.A\u0005ti\u0006$\b+\u0019;iA\u0005Y\u0001/\u001b3Ti\u0006$\b+\u0019;i\u00031\u0001\u0018\u000eZ*uCR\u0004\u0016\r\u001e5!\u0003-aw.\u00193Bm\u001edunY6\u0016\u0005\u00055\u0006\u0003BAX\u0003{k!!!-\u000b\t\u0005M\u0016QW\u0001\u0006Y>\u001c7n\u001d\u0006\u0005\u0003o\u000bI,\u0001\u0006d_:\u001cWO\u001d:f]RTA!a/\u0002\u0018\u0006!Q\u000f^5m\u0013\u0011\ty,!-\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u00031aw.\u00193Bm\u001edunY6!\u0003Ma\u0017m\u001d;M_\u0006$\u0017I^4Va\u0012\fG/Z't+\t\t9\r\u0005\u0003\u0002\u0012\u0005%\u0017\u0002BAf\u0003'\u0011A\u0001T8oO\u00069B.Y:u\u0019>\fG-\u0011<h+B$\u0017\r^3Ng~#S-\u001d\u000b\u0005\u0003#\f9\u000e\u0005\u0003\u0002\u0012\u0005M\u0017\u0002BAk\u0003'\u0011A!\u00168ji\"I\u0011\u0011\u001c\u000b\u0002\u0002\u0003\u0007\u0011qY\u0001\u0004q\u0012\n\u0014\u0001\u00067bgRdu.\u00193Bm\u001e,\u0006\u000fZ1uK6\u001b\b\u0005K\u0004\u0016\u0003?\f\u00190!>\u0011\t\u0005\u0005\u0018q^\u0007\u0003\u0003GTA!!:\u0002h\u0006Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015\u0011\tI/a;\u0002\t)\u001c\u0017\u000e\u001d\u0006\u0003\u0003[\f1A\\3u\u0013\u0011\t\t0a9\u0003\u0013\u001d+\u0018M\u001d3fI\nK\u0018!\u0002<bYV,\u0017EAAU\u00035aw.\u00193Bm\u001e|e.Z'j]V\u0011\u00111 \t\u0005\u0003#\ti0\u0003\u0003\u0002\u0000\u0006M!A\u0002#pk\ndW-A\tm_\u0006$\u0017I^4P]\u0016l\u0015N\\0%KF$B!!5\u0003\u0006!I\u0011\u0011\\\f\u0002\u0002\u0003\u0007\u00111`\u0001\u000fY>\fG-\u0011<h\u001f:,W*\u001b8!Q\u001dA\u0012q\\Az\u0003k\fa\u0002\\8bI\u00063xMR5wK6Kg.\u0001\nm_\u0006$\u0017I^4GSZ,W*\u001b8`I\u0015\fH\u0003BAi\u0005#A\u0011\"!7\u001b\u0003\u0003\u0005\r!a?\u0002\u001f1|\u0017\rZ!wO\u001aKg/Z'j]\u0002BsaGAp\u0003g\f)0A\tm_\u0006$\u0017I^4GS\u001a$X-\u001a8NS:\fQ\u0003\\8bI\u00063xMR5gi\u0016,g.T5o?\u0012*\u0017\u000f\u0006\u0003\u0002R\nu\u0001\"CAm;\u0005\u0005\t\u0019AA~\u0003Iaw.\u00193Bm\u001e4\u0015N\u001a;fK:l\u0015N\u001c\u0011)\u000fy\ty.a=\u0002v\u0006i1/_:uK6\u001c\u0005/\u001e'pG.\fab]=ti\u0016l7\t];M_\u000e\\\u0007%\u0001\u0007u_R\fGn\u00119v)&lW-\u0001\tu_R\fGn\u00119v)&lWm\u0018\u0013fcR!\u0011\u0011\u001bB\u0017\u0011%\tINIA\u0001\u0002\u0004\t9-A\u0007u_R\fGn\u00119v)&lW\r\t\u0015\bG\u0005}\u00171\u001fB\u001aC\t\u0011\u0019#A\u0007u_R\fG.\u00133mKRKW.Z\u0001\u0012i>$\u0018\r\\%eY\u0016$\u0016.\\3`I\u0015\fH\u0003BAi\u0005wA\u0011\"!7&\u0003\u0003\u0005\r!a2\u0002\u001dQ|G/\u00197JI2,G+[7fA!:a%a8\u0002t\nM\u0012aD3e'f\u001cH/Z7D!VcunY6\u0002!\u0015$7+_:uK6\u001c\u0005+\u0016'pG.\u0004\u0013!D5eY&twMS5gM&,7/A\tjI2Lgn\u001a&jM\u001aLWm]0%KF$B!!5\u0003L!I\u0011\u0011\u001c\u0016\u0002\u0002\u0003\u0007\u0011qY\u0001\u000fS\u0012d\u0017N\\4KS\u001a4\u0017.Z:!Q\u001dY\u0013q\\Az\u0005#\n#A!\u0011\u0002\u0019Q|G/\u00197KS\u001a4\u0017.Z:\u0002!Q|G/\u00197KS\u001a4\u0017.Z:`I\u0015\fH\u0003BAi\u00053B\u0011\"!7.\u0003\u0003\u0005\r!a2\u0002\u001bQ|G/\u00197KS\u001a4\u0017.Z:!Q\u001dq\u0013q\\Az\u0005#\na\u0004\\1ti&#G.Z*zgR,W.\u0016;jY&T\u0018\r^5p]Z\u000bG.^3\u0002E1\f7\u000f^%eY\u0016\u001c\u0016p\u001d;f[V#\u0018\u000e\\5{CRLwN\u001c,bYV,w\fJ3r)\u0011\t\tN!\u001a\t\u0013\u0005e\u0007'!AA\u0002\u0005m\u0018a\b7bgRLE\r\\3TsN$X-\\+uS2L'0\u0019;j_:4\u0016\r\\;fA!:\u0011'a8\u0002t\nE\u0013\u0001D:qC\u000e,\u0007+\u0019;uKJtWC\u0001B8!\u0011\u0011\tHa\u001e\u000e\u0005\tM$\u0002\u0002B;\u0003s\u000bQA]3hKbLAA!\u001f\u0003t\t9\u0001+\u0019;uKJt\u0017!D:qC\u000e,\u0007+\u0019;uKJt\u0007%\u0001\u000eqCJ,g\u000e\u001e5fg&\u001cXI\\2m_N,G\rU1ui\u0016\u0014h.A\u000eqCJ,g\u000e\u001e5fg&\u001cXI\\2m_N,G\rU1ui\u0016\u0014h\u000eI\u0001\u000faJ|7-Z:t\u0007B,Hj\\2l\u0003=\u0001(o\\2fgN\u001c\u0005/\u001e'pG.\u0004\u0013!\u00057bgR\u001c\u0016p\u001d;f[*KgMZ5fg\u0006)B.Y:u'f\u001cH/Z7KS\u001a4\u0017.Z:`I\u0015\fH\u0003BAi\u0005\u0017C\u0011\"!7:\u0003\u0003\u0005\r!a2\u0002%1\f7\u000f^*zgR,WNS5gM&,7\u000f\t\u0015\bu\u0005}\u00171\u001fBIC\t\u0011\t)\u0001\nmCN$\bK]8dKN\u001c(*\u001b4gS\u0016\u001c\u0018A\u00067bgR\u0004&o\\2fgNT\u0015N\u001a4jKN|F%Z9\u0015\t\u0005E'\u0011\u0014\u0005\n\u00033d\u0014\u0011!a\u0001\u0003\u000f\f1\u0003\\1tiB\u0013xnY3tg*KgMZ5fg\u0002Bs!PAp\u0003g\u0014\tJA\u0007TsN$X-\\\"qkRKW.Z\n\b}\u0005=!1\u0015BU!\u0011\t\tB!*\n\t\t\u001d\u00161\u0003\u0002\b!J|G-^2u!\u0011\u0011YK!.\u000f\t\t5&\u0011\u0017\b\u0005\u0003G\u0011y+\u0003\u0002\u0002\u0016%!!1WA\n\u0003\u001d\u0001\u0018mY6bO\u0016LAAa.\u0003:\na1+\u001a:jC2L'0\u00192mK*!!1WA\n\u0003\u0011)8/\u001a:\u0002\u000bU\u001cXM\u001d\u0011\u0002\t9L7-Z\u0001\u0006]&\u001cW\rI\u0001\u0007gf\u001cH/Z7\u0002\u000fML8\u000f^3nA\u0005!\u0011\u000e\u001a7f\u0003\u0015IG\r\\3!\u0003\u0019IwnV1ji\u00069\u0011n\\,bSR\u0004\u0013aA5sc\u0006!\u0011N]9!\u0003\u001d\u0019xN\u001a;JeF\f\u0001b]8gi&\u0013\u0018\u000fI\u0001\u0006gR,\u0017\r\\\u0001\u0007gR,\u0017\r\u001c\u0011\u0002\u000b\u001d,Xm\u001d;\u0002\r\u001d,Xm\u001d;!\u0003%9W/Z:u\u001d&\u001cW-\u0001\u0006hk\u0016\u001cHOT5dK\u0002\"bC!:\u0003j\n-(Q\u001eBx\u0005c\u0014\u0019P!>\u0003x\ne(1 \t\u0004\u0005OtT\"\u0001\u0001\t\u000f\tm6\u000b1\u0001\u0002H\"9!qX*A\u0002\u0005\u001d\u0007b\u0002Bb'\u0002\u0007\u0011q\u0019\u0005\b\u0005\u000f\u001c\u0006\u0019AAd\u0011\u001d\u0011Ym\u0015a\u0001\u0003\u000fDqAa4T\u0001\u0004\t9\rC\u0004\u0003TN\u0003\r!a2\t\u000f\t]7\u000b1\u0001\u0002H\"9!1\\*A\u0002\u0005\u001d\u0007b\u0002Bp'\u0002\u0007\u0011qY\u0001\u0006i>$\u0018\r\\\u0001\u0007i>$\u0018\r\u001c\u0011\u0002\t\r|\u0007/\u001f\u000b\u0017\u0005K\u001c)aa\u0002\u0004\n\r-1QBB\b\u0007#\u0019\u0019b!\u0006\u0004\u0018!I!1\u0018,\u0011\u0002\u0003\u0007\u0011q\u0019\u0005\n\u0005\u007f3\u0006\u0013!a\u0001\u0003\u000fD\u0011Ba1W!\u0003\u0005\r!a2\t\u0013\t\u001dg\u000b%AA\u0002\u0005\u001d\u0007\"\u0003Bf-B\u0005\t\u0019AAd\u0011%\u0011yM\u0016I\u0001\u0002\u0004\t9\rC\u0005\u0003TZ\u0003\n\u00111\u0001\u0002H\"I!q\u001b,\u0011\u0002\u0003\u0007\u0011q\u0019\u0005\n\u000574\u0006\u0013!a\u0001\u0003\u000fD\u0011Ba8W!\u0003\u0005\r!a2\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u00111Q\u0004\u0016\u0005\u0003\u000f\u001cyb\u000b\u0002\u0004\"A!11EB\u0017\u001b\t\u0019)C\u0003\u0003\u0004(\r%\u0012!C;oG\",7m[3e\u0015\u0011\u0019Y#a\u0005\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00040\r\u0015\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU\nabY8qs\u0012\"WMZ1vYR$c'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001c\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%q\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012J\u0014aD2paf$C-\u001a4bk2$H%\r\u0019\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u00199\u0005\u0005\u0003\u0004J\r=SBAB&\u0015\u0011\u0019i%a&\u0002\t1\fgnZ\u0005\u0005\u0003_\u0019Y%\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\r]3Q\f\t\u0005\u0003#\u0019I&\u0003\u0003\u0004\\\u0005M!aA!os\"I\u0011\u0011\\2\u0002\u0002\u0003\u0007\u0011\u0011N\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u001111\r\t\u0007\u0007K\u001aYga\u0016\u000e\u0005\r\u001d$\u0002BB5\u0003'\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019iga\u001a\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0007g\u001aI\b\u0005\u0003\u0002\u0012\rU\u0014\u0002BB<\u0003'\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002Z\u0016\f\t\u00111\u0001\u0004X\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u00199ea \t\u0013\u0005eg-!AA\u0002\u0005%\u0014\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005%\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\r\u001d\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0004t\r5\u0005\"CAmS\u0006\u0005\t\u0019AB,\u00035\u0019\u0016p\u001d;f[\u000e\u0003X\u000fV5nKB\u0019!q]6\u0014\u000b-\u001c)j!)\u00115\r]5QTAd\u0003\u000f\f9-a2\u0002H\u0006\u001d\u0017qYAd\u0003\u000f\f9M!:\u000e\u0005\re%\u0002BBN\u0003'\tqA];oi&lW-\u0003\u0003\u0004 \u000ee%AE!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocA\u0002Baa)\u0004*6\u00111Q\u0015\u0006\u0005\u0007O\u000b9*\u0001\u0002j_&!!qWBS)\t\u0019\t*A\u0003baBd\u0017\u0010\u0006\f\u0003f\u000eE61WB[\u0007o\u001bIla/\u0004>\u000e}6\u0011YBb\u0011\u001d\u0011YL\u001ca\u0001\u0003\u000fDqAa0o\u0001\u0004\t9\rC\u0004\u0003D:\u0004\r!a2\t\u000f\t\u001dg\u000e1\u0001\u0002H\"9!1\u001a8A\u0002\u0005\u001d\u0007b\u0002Bh]\u0002\u0007\u0011q\u0019\u0005\b\u0005't\u0007\u0019AAd\u0011\u001d\u00119N\u001ca\u0001\u0003\u000fDqAa7o\u0001\u0004\t9\rC\u0004\u0003`:\u0004\r!a2\u0002\u000fUt\u0017\r\u001d9msR!1\u0011ZBk!\u0019\t\tba3\u0004P&!1QZA\n\u0005\u0019y\u0005\u000f^5p]BA\u0012\u0011CBi\u0003\u000f\f9-a2\u0002H\u0006\u001d\u0017qYAd\u0003\u000f\f9-a2\n\t\rM\u00171\u0003\u0002\b)V\u0004H.Z\u00191\u0011%\u00199n\\A\u0001\u0002\u0004\u0011)/A\u0002yIA\nAc]=ti\u0016l7\t];Vi&d\u0017N_1uS>tGCAA~\u0003A*\u0007\u0010]8oK:$\u0018.\u00197ms\u0012+7-Y=j]\u001e\u001c\u0016p\u001d;f[\u000e\u0003X/\u0016;jY&T\u0018\r^5p]\u00063XM]1hK\u0006)\u0002O]8dKN\u001c8\t];Vi&d\u0017N_1uS>t\u0017!F2veJ,g\u000e\u001e)s_\u000e,7o\u001d&jM\u001aLWm\u001d\u000b\u0005\u0003\u000f\u001c)\u000fC\u0004\u0004hN\u0004\r!a#\u0002\tA\fG\u000f[\u0001\u0015GV\u0014(/\u001a8u'f\u001cH/Z7KS\u001a4\u0017.Z:\u0015\u0005\t\u0015\u0018!D8oK6Kg\u000eT8bI\u00063x-\u0001\bgSZ,W*\u001b8M_\u0006$\u0017I^4\u0002#\u0019Lg\r^3f]6Kg\u000eT8bI\u00063x-A\u0007va\u0012\fG/\u001a'pC\u0012\feo\u001a\u000b\u0005\u0007g\u001a9\u0010C\u0004\u0004zb\u0004\r!a2\u0002\u00079|w/\u0001\u0004vg\u0006\u0014G.\u001a\u000b\u0003\u0007g\nA#\\1zE\u0016\u0014VmZ5ti\u0016\u0014X*\u001a;sS\u000e\u001cH\u0003BAi\t\u0007Aq\u0001\"\u0002{\u0001\u0004!9!\u0001\u0005sK\u001eL7\u000f\u001e:z!\u0011!I\u0001\"\u0007\u000e\u0005\u0011-!\u0002\u0002C\u0007\t\u001f\tAaY8sK*!\u0011Q\u0001C\t\u0015\u0011!\u0019\u0002\"\u0006\u0002\re\fW.\\3s\u0015\t!9\"A\u0002d_6LA\u0001b\u0007\u0005\f\tyQ*\u001a;sS\u000e\u001c(+Z4jgR\u0014\u00180\u0001\rMS:,\bp\u00119v\u001b\u0016$(/[2t\u0007>dG.Z2u_J\u00042!a\u001f}'\ra\u0018q\u0002\u000b\u0003\t?\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"TC\u0001C\u0015U\u0011\tIga\b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0001")
public class LinuxCpuMetricsCollector {
    private volatile LinuxCpuMetricsCollector$SystemCpuTime$ SystemCpuTime$module;
    private final Time time;
    private final Logger logger;
    private final int exponentiallyDecayingWindowSizeInSeconds;
    private final int jiffiesPerSecond;
    private final Path loadAvgPath;
    private final Path statPath;
    private final Path pidStatPath;
    private final ReentrantLock loadAvgLock;
    @GuardedBy(value="loadAvgLock")
    private long lastLoadAvgUpdateMs;
    @GuardedBy(value="loadAvgLock")
    private double loadAvgOneMin;
    @GuardedBy(value="loadAvgLock")
    private double loadAvgFiveMin;
    @GuardedBy(value="loadAvgLock")
    private double loadAvgFifteenMin;
    private final ReentrantLock systemCpuLock;
    @GuardedBy(value="systemCpuLock")
    private long totalCpuTime;
    @GuardedBy(value="systemCpuLock")
    private long totalIdleTime;
    private final ReentrantLock edSystemCPULock;
    @GuardedBy(value="edSystemCPULock")
    private long idlingJiffies;
    @GuardedBy(value="edSystemCPULock")
    private long totalJiffies;
    @GuardedBy(value="edSystemCPULock")
    private double lastIdleSystemUtilizationValue;
    private final Pattern spacePattern;
    private final Pattern parenthesisEnclosedPattern;
    private final ReentrantLock processCpuLock;
    @GuardedBy(value="processCpuLock")
    private long lastSystemJiffies;
    @GuardedBy(value="processCpuLock")
    private long lastProcessJiffies;

    public static int $lessinit$greater$default$5() {
        return LinuxCpuMetricsCollector$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return LinuxCpuMetricsCollector$.MODULE$.$lessinit$greater$default$4();
    }

    public LinuxCpuMetricsCollector$SystemCpuTime$ SystemCpuTime() {
        if (this.SystemCpuTime$module == null) {
            this.SystemCpuTime$lzycompute$1();
        }
        return this.SystemCpuTime$module;
    }

    public Time time() {
        return this.time;
    }

    public Logger logger() {
        return this.logger;
    }

    public int exponentiallyDecayingWindowSizeInSeconds() {
        return this.exponentiallyDecayingWindowSizeInSeconds;
    }

    public int jiffiesPerSecond() {
        return this.jiffiesPerSecond;
    }

    private Path loadAvgPath() {
        return this.loadAvgPath;
    }

    private Path statPath() {
        return this.statPath;
    }

    private Path pidStatPath() {
        return this.pidStatPath;
    }

    private ReentrantLock loadAvgLock() {
        return this.loadAvgLock;
    }

    private long lastLoadAvgUpdateMs() {
        return this.lastLoadAvgUpdateMs;
    }

    private void lastLoadAvgUpdateMs_$eq(long x$1) {
        this.lastLoadAvgUpdateMs = x$1;
    }

    private double loadAvgOneMin() {
        return this.loadAvgOneMin;
    }

    private void loadAvgOneMin_$eq(double x$1) {
        this.loadAvgOneMin = x$1;
    }

    private double loadAvgFiveMin() {
        return this.loadAvgFiveMin;
    }

    private void loadAvgFiveMin_$eq(double x$1) {
        this.loadAvgFiveMin = x$1;
    }

    private double loadAvgFifteenMin() {
        return this.loadAvgFifteenMin;
    }

    private void loadAvgFifteenMin_$eq(double x$1) {
        this.loadAvgFifteenMin = x$1;
    }

    private ReentrantLock systemCpuLock() {
        return this.systemCpuLock;
    }

    private long totalCpuTime() {
        return this.totalCpuTime;
    }

    private void totalCpuTime_$eq(long x$1) {
        this.totalCpuTime = x$1;
    }

    private long totalIdleTime() {
        return this.totalIdleTime;
    }

    private void totalIdleTime_$eq(long x$1) {
        this.totalIdleTime = x$1;
    }

    private ReentrantLock edSystemCPULock() {
        return this.edSystemCPULock;
    }

    private long idlingJiffies() {
        return this.idlingJiffies;
    }

    private void idlingJiffies_$eq(long x$1) {
        this.idlingJiffies = x$1;
    }

    private long totalJiffies() {
        return this.totalJiffies;
    }

    private void totalJiffies_$eq(long x$1) {
        this.totalJiffies = x$1;
    }

    private double lastIdleSystemUtilizationValue() {
        return this.lastIdleSystemUtilizationValue;
    }

    private void lastIdleSystemUtilizationValue_$eq(double x$1) {
        this.lastIdleSystemUtilizationValue = x$1;
    }

    private Pattern spacePattern() {
        return this.spacePattern;
    }

    private Pattern parenthesisEnclosedPattern() {
        return this.parenthesisEnclosedPattern;
    }

    private ReentrantLock processCpuLock() {
        return this.processCpuLock;
    }

    private long lastSystemJiffies() {
        return this.lastSystemJiffies;
    }

    private void lastSystemJiffies_$eq(long x$1) {
        this.lastSystemJiffies = x$1;
    }

    private long lastProcessJiffies() {
        return this.lastProcessJiffies;
    }

    private void lastProcessJiffies_$eq(long x$1) {
        this.lastProcessJiffies = x$1;
    }

    public double systemCpuUtilization() {
        double d;
        block7: {
            double d2;
            block6: {
                try {
                    try {
                        this.systemCpuLock().lock();
                        SystemCpuTime systemJiffies = this.currentSystemJiffies();
                        long total = systemJiffies.total();
                        long idleTime = systemJiffies.idle() + systemJiffies.ioWait();
                        if (this.totalCpuTime() == 0L) {
                            this.totalCpuTime_$eq(total);
                            this.totalIdleTime_$eq(idleTime);
                            d2 = 0.0;
                            break block6;
                        }
                        long currWindowCpuTime = total - this.totalCpuTime();
                        long currWindowIdleTime = idleTime - this.totalIdleTime();
                        this.totalCpuTime_$eq(total);
                        this.totalIdleTime_$eq(idleTime);
                        double idlePercentage = (double)currWindowIdleTime * 100.0 / (double)currWindowCpuTime;
                        d = 100.0 - idlePercentage;
                    }
                    catch (Throwable t) {
                        this.logger().warn("Unable to update CPU metrics", t);
                        d = -1.0;
                    }
                    break block7;
                }
                finally {
                    this.systemCpuLock().unlock();
                }
            }
            return d2;
        }
        return d;
    }

    public double exponentiallyDecayingSystemCpuUtilizationAverage() {
        double d;
        block7: {
            double d2;
            block6: {
                try {
                    try {
                        this.edSystemCPULock().lock();
                        SystemCpuTime systemJiffies = this.currentSystemJiffies();
                        long total = systemJiffies.total();
                        long idle = systemJiffies.idle() + systemJiffies.ioWait();
                        long totalJiffiesElapsed = total - this.totalJiffies();
                        if (totalJiffiesElapsed == 0L) {
                            d2 = 100.0 - this.lastIdleSystemUtilizationValue();
                            break block6;
                        }
                        long idlingJiffiesElapsed = idle - this.idlingJiffies();
                        double elapsedTime = (double)totalJiffiesElapsed / (double)this.jiffiesPerSecond();
                        double correction = 1.0 - Math.exp(-elapsedTime / (double)this.exponentiallyDecayingWindowSizeInSeconds());
                        double currentIdleSystemUtilisationAverage = (double)idlingJiffiesElapsed * 100.0 / (double)totalJiffiesElapsed;
                        this.lastIdleSystemUtilizationValue_$eq(this.lastIdleSystemUtilizationValue() + correction * (currentIdleSystemUtilisationAverage - this.lastIdleSystemUtilizationValue()));
                        this.idlingJiffies_$eq(idle);
                        this.totalJiffies_$eq(total);
                        d = 100.0 - this.lastIdleSystemUtilizationValue();
                    }
                    catch (Throwable t) {
                        this.logger().warn("Unable to update CPU metrics", t);
                        d = -1.0;
                    }
                    break block7;
                }
                finally {
                    this.edSystemCPULock().unlock();
                }
            }
            return d2;
        }
        return d;
    }

    public double processCpuUtilization() {
        double d;
        block8: {
            double d2;
            block7: {
                try {
                    try {
                        this.processCpuLock().lock();
                        SystemCpuTime systemJiffies = this.currentSystemJiffies();
                        long processJiffies = this.currentProcessJiffies(this.pidStatPath());
                        if (this.lastProcessJiffies() == 0L || this.lastSystemJiffies() == 0L) {
                            this.lastSystemJiffies_$eq(systemJiffies.total());
                            this.lastProcessJiffies_$eq(processJiffies);
                            d2 = 0.0;
                            break block7;
                        }
                        long currentWindowSystemJiffies = systemJiffies.total() - this.lastSystemJiffies();
                        long currentWindowProcessJiffies = processJiffies - this.lastProcessJiffies();
                        this.lastSystemJiffies_$eq(systemJiffies.total());
                        this.lastProcessJiffies_$eq(processJiffies);
                        if (currentWindowSystemJiffies == 0L) {
                            d2 = 0.0;
                            break block7;
                        }
                        d = (double)currentWindowProcessJiffies * 100.0 / (double)currentWindowSystemJiffies;
                    }
                    catch (Throwable t) {
                        this.logger().warn("Unable to update CPU metrics for the process", t);
                        d = -1.0;
                    }
                    break block8;
                }
                finally {
                    this.processCpuLock().unlock();
                }
            }
            return d2;
        }
        return d;
    }

    private long currentProcessJiffies(Path path) {
        String line = (String)CollectionConverters$.MODULE$.ListHasAsScala(Files.readAllLines(path)).asScala().head();
        line = this.parenthesisEnclosedPattern().matcher(line).replaceFirst("process_name");
        String[] cpu = this.spacePattern().split(line);
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(cpu[13])) + StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(cpu[14]));
    }

    public SystemCpuTime currentSystemJiffies() {
        String line = (String)CollectionConverters$.MODULE$.ListHasAsScala(Files.readAllLines(this.statPath())).asScala().head();
        String[] cpu = this.spacePattern().split(line);
        return new SystemCpuTime(this, StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(cpu[1])), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(cpu[2])), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(cpu[3])), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(cpu[4])), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(cpu[5])), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(cpu[6])), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(cpu[7])), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(cpu[8])), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(cpu[9])), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(cpu[10])));
    }

    public double oneMinLoadAvg() {
        double d;
        try {
            this.loadAvgLock().lock();
            long curMs = this.time().milliseconds();
            Serializable serializable = curMs != this.lastLoadAvgUpdateMs() ? BoxesRunTime.boxToBoolean(this.updateLoadAvg(curMs)) : BoxedUnit.UNIT;
            d = this.loadAvgOneMin();
        }
        finally {
            this.loadAvgLock().unlock();
        }
        return d;
    }

    public double fiveMinLoadAvg() {
        double d;
        try {
            this.loadAvgLock().lock();
            long curMs = this.time().milliseconds();
            Serializable serializable = curMs != this.lastLoadAvgUpdateMs() ? BoxesRunTime.boxToBoolean(this.updateLoadAvg(curMs)) : BoxedUnit.UNIT;
            d = this.loadAvgFiveMin();
        }
        finally {
            this.loadAvgLock().unlock();
        }
        return d;
    }

    public double fifteenMinLoadAvg() {
        double d;
        try {
            this.loadAvgLock().lock();
            long curMs = this.time().milliseconds();
            Serializable serializable = curMs != this.lastLoadAvgUpdateMs() ? BoxesRunTime.boxToBoolean(this.updateLoadAvg(curMs)) : BoxedUnit.UNIT;
            d = this.loadAvgFifteenMin();
        }
        finally {
            this.loadAvgLock().unlock();
        }
        return d;
    }

    private boolean updateLoadAvg(long now) {
        boolean bl;
        try {
            this.loadAvgOneMin_$eq(-1.0);
            this.loadAvgFiveMin_$eq(-1.0);
            this.loadAvgFifteenMin_$eq(-1.0);
            String line = (String)CollectionConverters$.MODULE$.ListHasAsScala(Files.readAllLines(this.loadAvgPath())).asScala().apply(false);
            String[] loadAvgArr = line.split("\\s+");
            this.loadAvgOneMin_$eq(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(loadAvgArr[0])));
            this.loadAvgFiveMin_$eq(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(loadAvgArr[1])));
            this.loadAvgFifteenMin_$eq(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(loadAvgArr[2])));
            this.lastLoadAvgUpdateMs_$eq(now);
            bl = true;
        }
        catch (Throwable t) {
            this.logger().warn("Unable to update CPU metrics", t);
            bl = false;
        }
        return bl;
    }

    public boolean usable() {
        return this.loadAvgPath().toFile().exists() && this.statPath().toFile().exists();
    }

    public void maybeRegisterMetrics(MetricsRegistry registry) {
        if (this.usable()) {
            LinuxCpuMetricsCollector.registerGauge$1("linux-load-avg-1m", new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    return this.$outer.kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$1();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            LinuxCpuMetricsCollector.registerGauge$1("linux-load-avg-5m", new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    return this.$outer.kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$3();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            LinuxCpuMetricsCollector.registerGauge$1("linux-load-avg-15m", new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    return this.$outer.kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$5();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            LinuxCpuMetricsCollector.registerGauge$1("linux-system-cpu-utilization", new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    return this.$outer.kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$7();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            LinuxCpuMetricsCollector.registerGauge$1("linux-system-cpu-utilization-1m", new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    return this.$outer.kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$9();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            LinuxCpuMetricsCollector.registerGauge$1("linux-process-cpu-utilization", new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    return this.$outer.kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$11();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            return;
        }
    }

    private final void SystemCpuTime$lzycompute$1() {
        LinuxCpuMetricsCollector linuxCpuMetricsCollector = this;
        synchronized (linuxCpuMetricsCollector) {
            if (this.SystemCpuTime$module == null) {
                this.SystemCpuTime$module = new LinuxCpuMetricsCollector$SystemCpuTime$(this);
            }
        }
    }

    private static final void registerGauge$1(String name, Gauge gauge, MetricsRegistry registry$1) {
        MetricName metricName = KafkaYammerMetrics.getMetricName("kafka.server", "KafkaServer", name);
        registry$1.newGauge(metricName, gauge);
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$1() {
        return this.oneMinLoadAvg();
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$3() {
        return this.fiveMinLoadAvg();
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$5() {
        return this.fifteenMinLoadAvg();
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$7() {
        return this.systemCpuUtilization();
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$9() {
        return this.exponentiallyDecayingSystemCpuUtilizationAverage();
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$11() {
        return this.processCpuUtilization();
    }

    public LinuxCpuMetricsCollector(String procRoot, Time time, Logger logger, int exponentiallyDecayingWindowSizeInSeconds, int jiffiesPerSecond) {
        this.time = time;
        this.logger = logger;
        this.exponentiallyDecayingWindowSizeInSeconds = exponentiallyDecayingWindowSizeInSeconds;
        this.jiffiesPerSecond = jiffiesPerSecond;
        this.loadAvgPath = Paths.get(procRoot, "loadavg");
        this.statPath = Paths.get(procRoot, "stat");
        this.pidStatPath = Paths.get(procRoot, "self", "stat");
        this.loadAvgLock = new ReentrantLock();
        this.lastLoadAvgUpdateMs = -1L;
        this.loadAvgOneMin = -1.0;
        this.loadAvgFiveMin = -1.0;
        this.loadAvgFifteenMin = -1.0;
        this.systemCpuLock = new ReentrantLock();
        this.totalCpuTime = 0L;
        this.totalIdleTime = 0L;
        this.edSystemCPULock = new ReentrantLock();
        this.idlingJiffies = 0L;
        this.totalJiffies = 0L;
        this.lastIdleSystemUtilizationValue = 0.0;
        this.spacePattern = Pattern.compile("\\s+");
        this.parenthesisEnclosedPattern = Pattern.compile("\\(.*?\\)");
        this.processCpuLock = new ReentrantLock();
        this.lastSystemJiffies = 0L;
        this.lastProcessJiffies = 0L;
    }

    public class SystemCpuTime
    implements Product,
    Serializable {
        private final long user;
        private final long nice;
        private final long system;
        private final long idle;
        private final long ioWait;
        private final long irq;
        private final long softIrq;
        private final long steal;
        private final long guest;
        private final long guestNice;
        private final long total;
        public final /* synthetic */ LinuxCpuMetricsCollector $outer;

        @Override
        public Iterator<String> productElementNames() {
            return Product.productElementNames$(this);
        }

        public long user() {
            return this.user;
        }

        public long nice() {
            return this.nice;
        }

        public long system() {
            return this.system;
        }

        public long idle() {
            return this.idle;
        }

        public long ioWait() {
            return this.ioWait;
        }

        public long irq() {
            return this.irq;
        }

        public long softIrq() {
            return this.softIrq;
        }

        public long steal() {
            return this.steal;
        }

        public long guest() {
            return this.guest;
        }

        public long guestNice() {
            return this.guestNice;
        }

        public long total() {
            return this.total;
        }

        public SystemCpuTime copy(long user, long nice, long system, long idle, long ioWait, long irq, long softIrq, long steal, long guest, long guestNice) {
            return new SystemCpuTime(this.kafka$metrics$LinuxCpuMetricsCollector$SystemCpuTime$$$outer(), user, nice, system, idle, ioWait, irq, softIrq, steal, guest, guestNice);
        }

        public long copy$default$1() {
            return this.user();
        }

        public long copy$default$10() {
            return this.guestNice();
        }

        public long copy$default$2() {
            return this.nice();
        }

        public long copy$default$3() {
            return this.system();
        }

        public long copy$default$4() {
            return this.idle();
        }

        public long copy$default$5() {
            return this.ioWait();
        }

        public long copy$default$6() {
            return this.irq();
        }

        public long copy$default$7() {
            return this.softIrq();
        }

        public long copy$default$8() {
            return this.steal();
        }

        public long copy$default$9() {
            return this.guest();
        }

        @Override
        public String productPrefix() {
            return "SystemCpuTime";
        }

        @Override
        public int productArity() {
            return 10;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToLong(this.user());
                }
                case 1: {
                    return BoxesRunTime.boxToLong(this.nice());
                }
                case 2: {
                    return BoxesRunTime.boxToLong(this.system());
                }
                case 3: {
                    return BoxesRunTime.boxToLong(this.idle());
                }
                case 4: {
                    return BoxesRunTime.boxToLong(this.ioWait());
                }
                case 5: {
                    return BoxesRunTime.boxToLong(this.irq());
                }
                case 6: {
                    return BoxesRunTime.boxToLong(this.softIrq());
                }
                case 7: {
                    return BoxesRunTime.boxToLong(this.steal());
                }
                case 8: {
                    return BoxesRunTime.boxToLong(this.guest());
                }
                case 9: {
                    return BoxesRunTime.boxToLong(this.guestNice());
                }
            }
            return Statics.ioobe(x$1);
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof SystemCpuTime;
        }

        @Override
        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "user";
                }
                case 1: {
                    return "nice";
                }
                case 2: {
                    return "system";
                }
                case 3: {
                    return "idle";
                }
                case 4: {
                    return "ioWait";
                }
                case 5: {
                    return "irq";
                }
                case 6: {
                    return "softIrq";
                }
                case 7: {
                    return "steal";
                }
                case 8: {
                    return "guest";
                }
                case 9: {
                    return "guestNice";
                }
            }
            return (String)Statics.ioobe(x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.longHash(this.user()));
            n = Statics.mix(n, Statics.longHash(this.nice()));
            n = Statics.mix(n, Statics.longHash(this.system()));
            n = Statics.mix(n, Statics.longHash(this.idle()));
            n = Statics.mix(n, Statics.longHash(this.ioWait()));
            n = Statics.mix(n, Statics.longHash(this.irq()));
            n = Statics.mix(n, Statics.longHash(this.softIrq()));
            n = Statics.mix(n, Statics.longHash(this.steal()));
            n = Statics.mix(n, Statics.longHash(this.guest()));
            n = Statics.mix(n, Statics.longHash(this.guestNice()));
            return Statics.finalizeHash(n, 10);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SystemCpuTime)) return false;
            if (((SystemCpuTime)object).kafka$metrics$LinuxCpuMetricsCollector$SystemCpuTime$$$outer() != this.kafka$metrics$LinuxCpuMetricsCollector$SystemCpuTime$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            SystemCpuTime systemCpuTime = (SystemCpuTime)x$1;
            if (this.user() != systemCpuTime.user()) return false;
            if (this.nice() != systemCpuTime.nice()) return false;
            if (this.system() != systemCpuTime.system()) return false;
            if (this.idle() != systemCpuTime.idle()) return false;
            if (this.ioWait() != systemCpuTime.ioWait()) return false;
            if (this.irq() != systemCpuTime.irq()) return false;
            if (this.softIrq() != systemCpuTime.softIrq()) return false;
            if (this.steal() != systemCpuTime.steal()) return false;
            if (this.guest() != systemCpuTime.guest()) return false;
            if (this.guestNice() != systemCpuTime.guestNice()) return false;
            if (!systemCpuTime.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ LinuxCpuMetricsCollector kafka$metrics$LinuxCpuMetricsCollector$SystemCpuTime$$$outer() {
            return this.$outer;
        }

        public SystemCpuTime(LinuxCpuMetricsCollector $outer, long user, long nice, long system, long idle, long ioWait, long irq, long softIrq, long steal, long guest, long guestNice) {
            this.user = user;
            this.nice = nice;
            this.system = system;
            this.idle = idle;
            this.ioWait = ioWait;
            this.irq = irq;
            this.softIrq = softIrq;
            this.steal = steal;
            this.guest = guest;
            this.guestNice = guestNice;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$(this);
            this.total = user + nice + system + idle + ioWait + irq + softIrq + steal;
        }
    }
}

