/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kafka.network.RequestChannel;
import kafka.utils.Logging;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u001d4Q!\u0003\u0006\u0002\u0002=AQ\u0001\b\u0001\u0005\u0002uAq\u0001\t\u0001C\u0002\u0013\u0005\u0011\u0005\u0003\u00046\u0001\u0001\u0006IA\t\u0005\u0006m\u00011\ta\u000e\u0005\u0006\u000b\u0002!\tA\u0012\u0005\u00063\u00021\tB\u0017\u0005\u0006;\u0002!\tA\u0018\u0005\u0006I\u0002!\t!\u001a\u0002\u0013%\u0016\fX/Z:u\u0013:$XM]2faR|'O\u0003\u0002\f\u0019\u00059a.\u001a;x_J\\'\"A\u0007\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t9\"$D\u0001\u0019\u0015\tIB\"A\u0003vi&d7/\u0003\u0002\u001c1\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001\u001f!\ty\u0002!D\u0001\u000b\u0003=\u0011XM[3di\u0016$G+\u001a8b]R\u001cX#\u0001\u0012\u0011\u0007\rB#&D\u0001%\u0015\t)c%\u0001\u0003vi&d'\"A\u0014\u0002\t)\fg/Y\u0005\u0003S\u0011\u00121aU3u!\tY#G\u0004\u0002-aA\u0011QFE\u0007\u0002])\u0011qFD\u0001\u0007yI|w\u000e\u001e \n\u0005E\u0012\u0012A\u0002)sK\u0012,g-\u0003\u00024i\t11\u000b\u001e:j]\u001eT!!\r\n\u0002!I,'.Z2uK\u0012$VM\\1oiN\u0004\u0013a\u0003:fcV,7\u000f\u001e+za\u0016,\u0012\u0001\u000f\t\u0003s\rk\u0011A\u000f\u0006\u0003wq\n\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\u0006\u0003{y\naaY8n[>t'BA\u0007@\u0015\t\u0001\u0015)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0005\u0006\u0019qN]4\n\u0005\u0011S$aB!qS.+\u0017p]\u0001\u0016[\u0006L(-Z%oi\u0016\u00148-\u001a9u%\u0016\fX/Z:u)\t9\u0005\u000bE\u0002\u0012\u0011*K!!\u0013\n\u0003\r=\u0003H/[8o!\tYe*D\u0001M\u0015\tiE(\u0001\u0005sKF,Xm\u001d;t\u0013\tyEJ\u0001\tBEN$(/Y2u%\u0016\u001c\bo\u001c8tK\")\u0011+\u0002a\u0001%\u0006\u0019!/Z9\u0011\u0005M3fBA\u0010U\u0013\t)&\"\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\n\u0005]C&a\u0002*fcV,7\u000f\u001e\u0006\u0003+*\tQB]3kK\u000e$(+Z9vKN$HC\u0001&\\\u0011\u0015af\u00011\u0001S\u0003\u001d\u0011X-];fgR\f\u0001$[4o_J,'+Z9vKN$8O\u0012:p[R+g.\u00198u)\ty&\r\u0005\u0002\u0012A&\u0011\u0011M\u0005\u0002\u0005+:LG\u000fC\u0003d\u000f\u0001\u0007!&\u0001\u0004uK:\fg\u000e^\u0001\u0019C\u000e\u001cW\r\u001d;SKF,Xm\u001d;t\rJ|W\u000eV3oC:$HCA0g\u0011\u0015\u0019\u0007\u00021\u0001+\u0001")
public abstract class RequestInterceptor
implements Logging {
    private final Set<String> rejectedTenants;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        RequestInterceptor requestInterceptor = this;
        synchronized (requestInterceptor) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Set<String> rejectedTenants() {
        return this.rejectedTenants;
    }

    public abstract ApiKeys requestType();

    public Option<AbstractResponse> maybeInterceptRequest(RequestChannel.Request req) {
        KafkaPrincipal kafkaPrincipal = req.context().principal;
        if (kafkaPrincipal instanceof MultiTenantPrincipal) {
            MultiTenantPrincipal multiTenantPrincipal = (MultiTenantPrincipal)kafkaPrincipal;
            String tenant = multiTenantPrincipal.tenantMetadata().tenantName;
            if (this.rejectedTenants().contains(tenant)) {
                if (req.header().apiKey().equals((Object)this.requestType())) {
                    return new Some<AbstractResponse>(this.rejectRequest(req));
                }
            }
        }
        return None$.MODULE$;
    }

    public abstract AbstractResponse rejectRequest(RequestChannel.Request var1);

    public void ignoreRequestsFromTenant(String tenant) {
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Ignoring future {} requests from tenant {}", new Object[]{this.requestType().name(), tenant});
            v0 = BoxedUnit.UNIT;
        } else {
            v0 = BoxedUnit.UNIT;
        }
        this.rejectedTenants().add(tenant);
    }

    public void acceptRequestsFromTenant(String tenant) {
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Ignoring future {} requests from tenant {}", new Object[]{this.requestType().name(), tenant});
            v0 = BoxedUnit.UNIT;
        } else {
            v0 = BoxedUnit.UNIT;
        }
        this.rejectedTenants().remove(tenant);
    }

    public RequestInterceptor() {
        Logging.$init$(this);
        this.rejectedTenants = ConcurrentHashMap.newKeySet();
    }
}

