/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.schedulers;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletableFutureRetryer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompletableFutureRetryer.class);
    private final ThreadPoolExecutor executor;
    private final Duration waitBetween;
    private final Time time;

    public CompletableFutureRetryer(ThreadPoolExecutor executor, Duration waitBetween, Time time) {
        this.executor = executor;
        this.waitBetween = waitBetween;
        this.time = time;
    }

    public <T> CompletableFuture<T> withRetries(Supplier<CompletableFuture<T>> attempter, Predicate<Throwable> shouldRetry, int attempts) {
        return this.withTimedRetries(attempter, shouldRetry, attempts, null, null);
    }

    private <T> CompletableFuture<T> retry(Supplier<CompletableFuture<T>> attempter, int attemptsSoFar, Throwable throwable, Predicate<Throwable> shouldRetry, int maxAttempts, Consumer<Long> runTimeReporter, long startTimeMs, Consumer<Long> numFailuresReporter) {
        int nextAttempt;
        if (numFailuresReporter != null) {
            numFailuresReporter.accept(1L);
        }
        if ((nextAttempt = attemptsSoFar + 1) > maxAttempts || !shouldRetry.test(throwable.getCause())) {
            LOGGER.warn("exhaust retry, completed exceptionally: " + throwable.getMessage(), throwable);
            return this.failedFuture(throwable);
        }
        LOGGER.debug("retrying: #" + attemptsSoFar + ", sleeping " + this.waitBetween.toMillis() + " ms before retrying");
        this.time.sleep(this.waitBetween.toMillis());
        return this.flatten((CompletableFuture<CompletableFuture<T>>)((CompletableFuture)this.flatten(CompletableFuture.supplyAsync(attempter, this.executor)).thenApply(result -> {
            if (runTimeReporter != null) {
                runTimeReporter.accept(this.time.hiResClockMs() - startTimeMs);
            }
            return CompletableFuture.completedFuture(result);
        })).exceptionally(nextThrowable -> this.retry(attempter, nextAttempt, (Throwable)nextThrowable, shouldRetry, maxAttempts, runTimeReporter, startTimeMs, numFailuresReporter)));
    }

    public <T> CompletableFuture<T> withTimedRetries(Supplier<CompletableFuture<T>> attempter, Predicate<Throwable> shouldRetry, int attempts, Consumer<Long> runTimeReporter, Consumer<Long> numFailuresReporter) {
        long startTimeMs = runTimeReporter != null ? this.time.hiResClockMs() : -1L;
        CompletableFuture<T> firstAttempt = attempter.get();
        return this.flatten((CompletableFuture<CompletableFuture<T>>)((CompletableFuture)firstAttempt.thenApply(result -> {
            if (runTimeReporter != null) {
                runTimeReporter.accept(this.time.hiResClockMs() - startTimeMs);
            }
            return CompletableFuture.completedFuture(result);
        })).exceptionally(throwable -> this.retry(attempter, 1, (Throwable)throwable, shouldRetry, attempts, runTimeReporter, startTimeMs, numFailuresReporter)));
    }

    private <T> CompletableFuture<T> flatten(CompletableFuture<CompletableFuture<T>> completableCompletable) {
        return completableCompletable.thenCompose(Function.identity());
    }

    private <U> CompletableFuture<U> failedFuture(Throwable ex) {
        CompletableFuture completableFuture = new CompletableFuture();
        completableFuture.completeExceptionally(ex);
        return completableFuture;
    }
}

