/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.schedulers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.restore.configmap.NodeConfig;
import kafka.restore.schedulers.RetryableException;
import kafka.restore.schedulers.SchedulerUtil;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionLogRangeValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionLogRangeValidator.class);
    private CloseableHttpClient httpClient;
    private final String topic;
    private final int partition;
    private final NodeConfig broker;
    private final long logStartOffset;
    private final long logEndOffset;
    private final ThreadPoolExecutor executor;

    public PartitionLogRangeValidator(CloseableHttpClient httpClient, String topic, int partition, NodeConfig broker, long logStartOffset, long logEndOffset, ThreadPoolExecutor executor) {
        this.httpClient = httpClient;
        this.topic = topic;
        this.partition = partition;
        this.broker = broker;
        this.logStartOffset = logStartOffset;
        this.logEndOffset = logEndOffset;
        this.executor = executor;
    }

    public CompletableFuture<Integer> validateLogRange() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Map<String, String> attributes = Stream.of({"topic_name", this.topic}, {"partition", String.valueOf(this.partition)}, {"log_start_offset", String.valueOf(this.logStartOffset)}, {"log_end_offset", String.valueOf(this.logEndOffset)}).collect(Collectors.toMap(d -> d[0], d -> d[1]));
                HttpPost post = SchedulerUtil.buildKafkaHttpRequest(this.broker, "/v1/restore/validate-log-range", attributes);
                LOGGER.debug("execute request: " + post.toString());
                CloseableHttpResponse response = null;
                try {
                    response = this.httpClient.execute(post);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.warn(e.getMessage());
                    throw e;
                }
                int statusCode = response.getStatusLine().getStatusCode();
                String responseBody = EntityUtils.toString(response.getEntity());
                if (statusCode >= 300) {
                    String errorMessage = String.format("[%s-%s]: http response error with statusCode: %s, response body: %s", this.topic, this.partition, statusCode, responseBody);
                    LOGGER.error(errorMessage);
                    throw new RetryableException(errorMessage);
                }
                ObjectMapper mapper = new ObjectMapper();
                JsonNode rootNode = mapper.readTree(responseBody);
                LOGGER.debug("return rootNode: " + rootNode.toPrettyString());
                int status = rootNode.get("data").get("attributes").get("response").asInt();
                LOGGER.debug("return status: " + status);
                if (status == -1 || status == 1) {
                    return status;
                }
                String errorMessage = String.format("[%s-%s]: Partition status is not match: expected 1, got %s", this.topic, this.partition, status);
                LOGGER.warn(errorMessage);
                throw new RetryableException(errorMessage);
            }
            catch (Exception e) {
                LOGGER.error(String.format("[%s-%s]: Exception in validateLogRange", this.topic, this.partition), e);
                return -1;
            }
        }, this.executor);
    }
}

