/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkConfig$;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.controller.ConfigurationValidator;
import org.apache.kafka.coordinator.group.GroupConfigManager;
import org.apache.kafka.metadata.TopicPlacement;
import org.apache.kafka.metadata.TopicType;
import org.apache.kafka.metadata.placement.TopicPlacementReplicaPlacer;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.interceptor.RecordInterceptor;
import org.apache.kafka.server.metrics.ClientMetricsConfigs;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005}c\u0001B\t\u0013\u0001]A\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001\f\u0005\tc\u0001\u0011\t\u0011)A\u0005[!A!\u0007\u0001BC\u0002\u0013\u00051\u0007\u0003\u0005D\u0001\t\u0005\t\u0015!\u00035\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u001dI\u0005A1A\u0005\u0002)Ca!\u0015\u0001!\u0002\u0013Y\u0005\"\u0002*\u0001\t\u0013\u0019\u0006\"B4\u0001\t\u0013A\u0007\"\u00026\u0001\t\u0013Y\u0007\"B7\u0001\t\u0013q\u0007\"\u0002=\u0001\t\u0013I\bBB@\u0001\t\u0003\n\t\u0001\u0003\u0004\u0000\u0001\u0011\u0005\u0013Q\u0001\u0005\b\u0003#\u0001A\u0011IA\n\u0011\u001d\t\t\u0005\u0001C\u0005\u0003\u0007\u0012\u0001eQ8oiJ|G\u000e\\3s\u0007>tg-[4ve\u0006$\u0018n\u001c8WC2LG-\u0019;pe*\u00111\u0003F\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003U\tQa[1gW\u0006\u001c\u0001aE\u0002\u00011\u0001\u0002\"!\u0007\u0010\u000e\u0003iQ!a\u0007\u000f\u0002\t1\fgn\u001a\u0006\u0002;\u0005!!.\u0019<b\u0013\ty\"D\u0001\u0004PE*,7\r\u001e\t\u0003C%j\u0011A\t\u0006\u0003G\u0011\n!bY8oiJ|G\u000e\\3s\u0015\t)RE\u0003\u0002'O\u00051\u0011\r]1dQ\u0016T\u0011\u0001K\u0001\u0004_J<\u0017B\u0001\u0016#\u0005Y\u0019uN\u001c4jOV\u0014\u0018\r^5p]Z\u000bG.\u001b3bi>\u0014\u0018aC6bM.\f7i\u001c8gS\u001e,\u0012!\f\t\u0003]=j\u0011AE\u0005\u0003aI\u00111bS1gW\u0006\u001cuN\u001c4jO\u0006a1.\u00194lC\u000e{gNZ5hA\u0005yQ.\u001a;bI\u0006$\u0018MV3sg&|g.F\u00015!\r)$\bP\u0007\u0002m)\u0011q\u0007O\u0001\tMVt7\r^5p]*\u0011\u0011\bH\u0001\u0005kRLG.\u0003\u0002<m\tA1+\u001e9qY&,'\u000f\u0005\u0002>\u00036\taH\u0003\u0002@\u0001\u000611m\\7n_:T!a\u0005\u0013\n\u0005\ts$aD'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u0002!5,G/\u00193bi\u00064VM]:j_:\u0004\u0013A\u0002\u001fj]&$h\bF\u0002G\u000f\"\u0003\"A\f\u0001\t\u000b-*\u0001\u0019A\u0017\t\u000bI*\u0001\u0019\u0001\u001b\u0002\r1|wmZ3s+\u0005Y\u0005C\u0001'P\u001b\u0005i%B\u0001((\u0003\u0015\u0019HN\u001a\u001bk\u0013\t\u0001VJ\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003E1\u0018\r\\5eCR,Gk\u001c9jG:\u000bW.\u001a\u000b\u0003)j\u0003\"!\u0016-\u000e\u0003YS\u0011aV\u0001\u0006g\u000e\fG.Y\u0005\u00033Z\u0013A!\u00168ji\")1\f\u0003a\u00019\u0006!a.Y7f!\tiFM\u0004\u0002_EB\u0011qLV\u0007\u0002A*\u0011\u0011MF\u0001\u0007yI|w\u000e\u001e \n\u0005\r4\u0016A\u0002)sK\u0012,g-\u0003\u0002fM\n11\u000b\u001e:j]\u001eT!a\u0019,\u0002%Y\fG.\u001b3bi\u0016\u0014%o\\6fe:\u000bW.\u001a\u000b\u0003)&DQaW\u0005A\u0002q\u000b\u0011C^1mS\u0012\fG/Z$s_V\u0004h*Y7f)\t!F\u000eC\u0003\\\u0015\u0001\u0007A,\u0001\u0013uQJ|w/\u0012=dKB$\u0018n\u001c8G_J,fn\u001b8po:\u0014Vm]8ve\u000e,G+\u001f9f)\t!v\u000eC\u0003q\u0017\u0001\u0007\u0011/\u0001\u0005sKN|WO]2f!\t\u0011h/D\u0001t\u0015\t!X/\u0001\u0004d_:4\u0017n\u001a\u0006\u0003\u007f\u0011J!a^:\u0003\u001d\r{gNZ5h%\u0016\u001cx.\u001e:dK\u0006)c/\u00197jI\u0006$XM\u0011:pW\u0016\u00148k\u00195f[\u00064\u0016\r\\5eCRLwN\\\"p]\u001aLwm\u001d\u000b\u0003)jDQ\u0001\u001e\u0007A\u0002m\u0004B\u0001`?]96\t\u0001(\u0003\u0002\u007fq\t\u0019Q*\u00199\u0002\u0011Y\fG.\u001b3bi\u0016$2\u0001VA\u0002\u0011\u0015\u0001X\u00021\u0001r)\u001d!\u0016qAA\u0005\u0003\u001bAQ\u0001\u001d\bA\u0002EDa!a\u0003\u000f\u0001\u0004Y\u0018A\u00038fo\u000e{gNZ5hg\"1\u0011q\u0002\bA\u0002m\f!b\u001c7e\u0007>tg-[4t\u0003e1\u0018\r\\5eCR,Gk\u001c9jG\u000e{gNZ5h\u0007\"\fgnZ3\u0015\u0013Q\u000b)\"!\u0007\u0002\u001e\u0005]\u0002BBA\f\u001f\u0001\u000710\u0001\nqe\u00164(+Z:pYZ,GmQ8oM&<\u0007BBA\u000e\u001f\u0001\u000710A\toK^\u0014Vm]8mm\u0016$7i\u001c8gS\u001eDq!a\b\u0010\u0001\u0004\t\t#A\u0004ce>\\WM]:\u0011\u000bq\f\u0019#a\n\n\u0007\u0005\u0015\u0002H\u0001\u0005Ji\u0016\u0014\u0018\r^8s!\u0011\tI#a\r\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\t\u0011\u0002\u001d7bG\u0016lWM\u001c;\u000b\u0007\u0005EB%\u0001\u0005nKR\fG-\u0019;b\u0013\u0011\t)$a\u000b\u0003\u0019U\u001b\u0018M\u00197f\u0005J|7.\u001a:\t\u000f\u0005er\u00021\u0001\u0002<\u0005I\u0012n\u001d+pa&\u001c\u0007\u000b\\1dK6,g\u000e^*vaB|'\u000f^3e!\r)\u0016QH\u0005\u0004\u0003\u007f1&a\u0002\"p_2,\u0017M\\\u0001*m\u0006d\u0017\u000eZ1uKR{\u0007/[2QY\u0006\u001cW-\\3oi\u000e{gNZ5hkJ\fG/[8o\u0007\"\fgnZ3\u0015\u0013Q\u000b)%a\u0016\u0002\\\u0005u\u0003bBA$!\u0001\u0007\u0011\u0011J\u0001\u0013aJ,g\u000fV8qS\u000e\u0004F.Y2f[\u0016tG\u000fE\u0003}\u0003\u0017\ny%C\u0002\u0002Na\u0012\u0001b\u00149uS>t\u0017\r\u001c\t\u0005\u0003#\n\u0019&\u0004\u0002\u00020%!\u0011QKA\u0018\u00059!v\u000e]5d!2\f7-Z7f]RDq!!\u0017\u0011\u0001\u0004\tI%A\toK^$v\u000e]5d!2\f7-Z7f]RDq!a\b\u0011\u0001\u0004\t\t\u0003C\u0004\u0002:A\u0001\r!a\u000f")
public class ControllerConfigurationValidator
implements ConfigurationValidator {
    private final KafkaConfig kafkaConfig;
    private final Supplier<MetadataVersion> metadataVersion;
    private final Logger logger;

    public KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public Supplier<MetadataVersion> metadataVersion() {
        return this.metadataVersion;
    }

    public Logger logger() {
        return this.logger;
    }

    private void validateTopicName(String name) {
        if (name.isEmpty()) {
            throw new InvalidRequestException("Default topic resources are not allowed.");
        }
        Topic.validate(name);
    }

    private void validateBrokerName(String name) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(name))) {
            Integer n;
            try {
                n = Integer.valueOf(name);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidRequestException("Unable to parse broker name as a base 10 number.");
            }
            Integer brokerId = n;
            if (Predef$.MODULE$.Integer2int(brokerId) < 0) {
                throw new InvalidRequestException("Invalid negative broker ID.");
            }
            return;
        }
    }

    private void validateGroupName(String name) {
        if (name.isEmpty()) {
            throw new InvalidRequestException("Default group resources are not allowed.");
        }
    }

    private void throwExceptionForUnknownResourceType(ConfigResource resource) {
        throw new InvalidRequestException("Unknown resource type " + resource.type());
    }

    private void validateBrokerSchemaValidationConfigs(Map<String, String> config) {
        HashMap<String, Object> allConfigs = new HashMap<String, Object>(this.kafkaConfig().originals());
        allConfigs.putAll(config);
        Optional<RecordInterceptor> interceptor = LogConfig.createSchemaValidationInterceptorIfNeeded(allConfigs, this.logger());
        try {
            interceptor.ifPresent(x$1 -> x$1.close());
        }
        catch (Exception e) {
            this.logger().error("Error closing schema validation interceptor", e);
        }
    }

    @Override
    public void validate(ConfigResource resource) {
        ConfigResource.Type type = resource.type();
        if (((Object)((Object)ConfigResource.Type.TOPIC)).equals((Object)type)) {
            this.validateTopicName(resource.name());
            return;
        }
        if (((Object)((Object)ConfigResource.Type.BROKER)).equals((Object)type)) {
            this.validateBrokerName(resource.name());
            return;
        }
        if (((Object)((Object)ConfigResource.Type.CLUSTER_LINK)).equals((Object)type)) {
            return;
        }
        this.throwExceptionForUnknownResourceType(resource);
    }

    @Override
    public void validate(ConfigResource resource, Map<String, String> newConfigs, Map<String, String> oldConfigs) {
        ConfigResource.Type type = resource.type();
        if (((Object)((Object)ConfigResource.Type.TOPIC)).equals((Object)type)) {
            this.validateTopicName(resource.name());
            Properties properties = new Properties();
            ArrayBuffer nullTopicConfigs = new ArrayBuffer();
            newConfigs.forEach((key, value) -> {
                if (value == null) {
                    nullTopicConfigs.$plus$eq(key);
                    return;
                }
                properties.setProperty((String)key, (String)value);
            });
            if (nullTopicConfigs.nonEmpty()) {
                throw new InvalidConfigurationException("Null value not supported for topic configs: " + nullTopicConfigs.mkString(","));
            }
            LogConfig.validate(oldConfigs, properties, this.kafkaConfig().extractLogConfigMap(), this.kafkaConfig().remoteLogManagerConfig().isRemoteStorageSystemEnabled(), Predef$.MODULE$.Boolean2boolean(this.kafkaConfig().isVirtualTopicCreationEnabled()));
            this.validateBrokerSchemaValidationConfigs(newConfigs);
            return;
        }
        if (((Object)((Object)ConfigResource.Type.BROKER)).equals((Object)type)) {
            this.validateBrokerName(resource.name());
            return;
        }
        if (((Object)((Object)ConfigResource.Type.CLUSTER_LINK)).equals((Object)type)) {
            ClusterLinkConfig$.MODULE$.create(newConfigs, new Some<KafkaConfig>(this.kafkaConfig()), ClusterLinkConfig$.MODULE$.create$default$3());
            return;
        }
        if (((Object)((Object)ConfigResource.Type.CLIENT_METRICS)).equals((Object)type)) {
            Properties properties = new Properties();
            newConfigs.forEach((key, value) -> properties.setProperty((String)key, (String)value));
            ClientMetricsConfigs.validate(resource.name(), properties);
            return;
        }
        if (((Object)((Object)ConfigResource.Type.GROUP)).equals((Object)type)) {
            this.validateGroupName(resource.name());
            Properties properties = new Properties();
            ArrayBuffer nullGroupConfigs = new ArrayBuffer();
            newConfigs.forEach((key, value) -> {
                if (value == null) {
                    nullGroupConfigs.$plus$eq(key);
                    return;
                }
                properties.setProperty((String)key, (String)value);
            });
            if (nullGroupConfigs.nonEmpty()) {
                throw new InvalidConfigurationException("Null value not supported for group configs: " + nullGroupConfigs.mkString(","));
            }
            GroupConfigManager.validate(properties, this.kafkaConfig().groupCoordinatorConfig(), this.kafkaConfig().shareGroupConfig());
            return;
        }
        this.throwExceptionForUnknownResourceType(resource);
    }

    @Override
    public void validateTopicConfigChange(Map<String, String> prevResolvedConfig, Map<String, String> newResolvedConfig, Iterator<UsableBroker> brokers, boolean isTopicPlacementSupported) {
        LogConfig nextLogConfig;
        LogConfig curLogConfig = LogConfig.fromProps(prevResolvedConfig, new Properties());
        if (!curLogConfig.equals(nextLogConfig = LogConfig.fromProps(newResolvedConfig, new Properties())) && curLogConfig.topicType().equals((Object)TopicType.VIRTUAL)) {
            throw new InvalidConfigurationException("Altering configs for VIRTUAL topics is not supported.");
        }
        LogConfig.validateChange(curLogConfig, nextLogConfig, this.metadataVersion().get(), Predef$.MODULE$.Boolean2boolean(this.kafkaConfig().confluentConfig().tierFeature()), Predef$.MODULE$.Boolean2boolean(this.kafkaConfig().confluentConfig().tierCleanerFeatureEnable()));
        this.validateBrokerSchemaValidationConfigs(newResolvedConfig);
        this.validateTopicPlacementConfigurationChange(curLogConfig.confluentLogConfig().topicPlacementConstraints, nextLogConfig.confluentLogConfig().topicPlacementConstraints, brokers, isTopicPlacementSupported);
    }

    private void validateTopicPlacementConfigurationChange(Optional<TopicPlacement> prevTopicPlacement, Optional<TopicPlacement> newTopicPlacement, Iterator<UsableBroker> brokers, boolean isTopicPlacementSupported) {
        if (!Objects.equals(prevTopicPlacement, newTopicPlacement)) {
            newTopicPlacement.ifPresent(topicPlacement -> {
                if (!isTopicPlacementSupported) {
                    throw new InvalidConfigurationException("Topic placement is not supported.");
                }
                TopicPlacementReplicaPlacer.validateTopicPlacementConfigurationChange(topicPlacement, brokers, this.logger(), x$2 -> DirectoryId.MIGRATING);
            });
            return;
        }
    }

    public ControllerConfigurationValidator(KafkaConfig kafkaConfig, Supplier<MetadataVersion> metadataVersion) {
        this.kafkaConfig = kafkaConfig;
        this.metadataVersion = metadataVersion;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

