/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.availability.BrokerHealthManager$;
import kafka.availability.NetworkHealthManager$;
import kafka.coordinator.quota.QuotaCoordinator$;
import kafka.log.LogCleaner$;
import kafka.log.SegmentDeletionThrottlerConfig$;
import kafka.network.SocketServer$;
import kafka.raft.KafkaRaftManager;
import kafka.server.BrokerConfigHandler;
import kafka.server.DynamicBackpressure$;
import kafka.server.DynamicBalancerConfig$;
import kafka.server.DynamicBrokerLoad$;
import kafka.server.DynamicClusterLinkConfig$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicDefaultDataPolicyConfig$;
import kafka.server.DynamicDurabilityAuditConfig$;
import kafka.server.DynamicE2EChecksumConfig$;
import kafka.server.DynamicKafkaApiConfig$;
import kafka.server.DynamicLeaderEpochCheckpointFileConfig$;
import kafka.server.DynamicListenerConfig$;
import kafka.server.DynamicLogConfig$;
import kafka.server.DynamicMinUsageReportingEnableConfig$;
import kafka.server.DynamicObservabilityConfig$;
import kafka.server.DynamicQuotaConfig$;
import kafka.server.DynamicRemoteLogConfig$;
import kafka.server.DynamicReplicaManagerConfig$;
import kafka.server.DynamicReplicationModeConfig$;
import kafka.server.DynamicThreadPool$;
import kafka.server.DynamicTransactionCoordinator$;
import kafka.server.DynamicZkControllerConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory;
import kafka.server.StorageProbe$;
import kafka.server.resource.DiskIOManager;
import kafka.tier.TierDeletedPartitionsCoordinator$;
import kafka.tier.backupObjectLifecycle.BackupObjectLifecycleManagerCoordinator$;
import kafka.tier.fetcher.TierFetcher;
import kafka.tier.snapshot.TierTopicSnapshotCoordinator$;
import kafka.tier.tasks.TierTasks$;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicDataLossValidator;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.config.ReplicationQuotaManagerConfig;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.snapshot.RecordsSnapshotReader;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.LinearSeqOps;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.SetOps;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class DynamicBrokerConfig$ {
    public static final DynamicBrokerConfig$ MODULE$ = new DynamicBrokerConfig$();
    private static final scala.collection.mutable.Set<String> DynamicSecurityConfigs = CollectionConverters$.MODULE$.SetHasAsScala(SslConfigs.RECONFIGURABLE_CONFIGS).asScala();
    private static final Set<String> DynamicProducerStateManagerConfig = (Set)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"producer.id.expiration.ms", "transaction.partition.verification.enable"}));
    private static final scala.collection.mutable.Set<String> AllDynamicConfigs = (scala.collection.mutable.Set)MODULE$.DynamicSecurityConfigs().$plus$plus(LogCleaner$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicLogConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicThreadPool$.MODULE$.ReconfigurableConfigs()).$plus$plus((IterableOnce)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"metric.reporters"}))).$plus$plus(DynamicListenerConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(SocketServer$.MODULE$.ReconfigurableConfigs()).$plus$plus(MODULE$.DynamicProducerStateManagerConfig()).$plus$plus(DynamicBackpressure$.MODULE$.ReconfigurableConfigs()).$plus$plus(TierFetcher.reconfigurableConfigs).$plus$plus((IterableOnce)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.TierMaxPartitionFetchBytesOverrideProp()}))).$plus$plus((IterableOnce)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.AuditLogRouterConfigProp()}))).$plus$plus((IterableOnce)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.AuthenticationAuditLogEnableProp()}))).$plus$plus((IterableOnce)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.AuditLogEnableProp()}))).$plus$plus((IterableOnce)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.ClusterRegistryConfigProp()}))).$plus$plus((IterableOnce)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.security.event.logger.authentication.event.rate.limit"}))).$plus$plus((IterableOnce)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.security.event.logger.authorization.event.rate.limit"}))).$plus$plus((IterableOnce)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.security.event.logger.kafka.request.rate.limit"}))).$plus$plus(DynamicBalancerConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus((IterableOnce)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.traffic.network.id"}))).$plus$plus(DynamicClusterLinkConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicDurabilityAuditConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicE2EChecksumConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicLeaderEpochCheckpointFileConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(StorageProbe$.MODULE$.ReconfigurableConfigs()).$plus$plus(SegmentDeletionThrottlerConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(CollectionConverters$.MODULE$.SetHasAsScala(ReplicationQuotaManagerConfig.RECONFIGURABLE_CONFIGS).asScala()).$plus$plus((IterableOnce)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"auto.create.topics.enable", "num.partitions", "fetch.max.bytes"}))).$plus$plus((IterableOnce)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.reporters.telemetry.auto.enable"}))).$plus$plus((IterableOnce)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.telemetry.enabled"}))).$plus$plus((IterableOnce)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.catalog.collector.enable"}))).$plus$plus(TierDeletedPartitionsCoordinator$.MODULE$.ReconfigurableConfigs()).$plus$plus(TierTopicSnapshotCoordinator$.MODULE$.ReconfigurableConfigs()).$plus$plus(BrokerHealthManager$.MODULE$.ReconfigurableConfigs()).$plus$plus(NetworkHealthManager$.MODULE$.ReconfigurableConfigs()).$plus$plus(BackupObjectLifecycleManagerCoordinator$.MODULE$.ReconfigurableConfigs()).$plus$plus((IterableOnce)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.plugins.topic.policy.max.partitions.per.tenant", "confluent.plugins.topic.policy.max.partitions.per.cluster", "confluent.plugins.topic.policy.max.topics.per.cluster", "confluent.plugins.topic.policy.max.replicas.per.broker"}))).$plus$plus((IterableOnce)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.cells.enable", "confluent.cells.implicit.creation.enable", "confluent.cells.load.refresher.enable", "confluent.topic.partition.default.placement", "confluent.cells.k2.base.broker.index"}))).$plus$plus((IterableOnce)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.quota.tenant.default.controller.mutation.rate", "confluent.quota.tenant.internal.throttling.enable", "confluent.quota.tenant.internal.broker.max.producer.rate", "confluent.quota.tenant.internal.broker.max.consumer.rate", "confluent.quota.tenant.internal.broker.max.controller.mutation.rate", "confluent.quota.tenant.default.producer.id.rate", "confluent.quota.tenant.produce.multiplier", "confluent.quota.tenant.fetch.multiplier", "confluent.quota.tenant.user.quotas.enable"}))).$plus$plus((IterableOnce)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.plugins.cluster.link.policy.max.destination.links.per.tenant"}))).$plus$plus((IterableOnce)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.plugins.cluster.link.policy.max.source.links.per.tenant"}))).$plus$plus((IterableOnce)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.dataflow.policy.watch.monitor.ms"}))).$plus$plus((IterableOnce)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.min.acks"}))).$plus$plus(DynamicBrokerLoad$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicReplicaManagerConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicReplicationModeConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicZkControllerConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicTransactionCoordinator$.MODULE$.ReconfigurableConfigs()).$plus$plus(TierTasks$.MODULE$.ReconfigurableConfigs()).$plus$plus(TierTopicDataLossValidator.RECONFIGURABLE_CONFIGS).$plus$plus(TierTopicConsumer.RECONFIGURABLE_CONFIGS).$plus$plus(QuotaCoordinator$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicQuotaConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus((IterableOnce)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.request.pipelining.enable"}))).$plus$plus((IterableOnce)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"multitenant.authorizer.support.resource.ids"}))).$plus$plus((IterableOnce)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.track.api.key.per.ip", "confluent.track.tenant.id.per.ip", "confluent.track.per.ip.max.size"}))).$plus$plus(DiskIOManager.reconfigurableConfigs).$plus$plus((IterableOnce)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.heap.tenured.notify.bytes"}))).$plus$plus(DynamicRemoteLogConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicKafkaApiConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicObservabilityConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicMinUsageReportingEnableConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus((IterableOnce)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.traffic.network.type"}))).$plus$plus(DynamicDefaultDataPolicyConfig$.MODULE$.ReconfigurableConfigs());
    private static final Set<String> ClusterLevelListenerConfigs = (Set)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"max.connections", "max.connection.creation.rate", KafkaConfig$.MODULE$.MaxConnectionCreationRateFloorProp(), KafkaConfig$.MODULE$.MaxConnectionCreationThrottleMsProp(), KafkaConfig$.MODULE$.MinConnectionCreationThrottleMsProp(), "num.network.threads", KafkaConfig$.MODULE$.SslCipherSuitesProp(), KafkaConfig$.MODULE$.SslEnabledProtocolsProp(), KafkaConfig$.MODULE$.ConnectionsMaxAgeMsProp(), "connections.max.idle.ms", KafkaConfig$.MODULE$.ListenerConnectionRatePerIpMaxProp(), KafkaConfig$.MODULE$.ListenerConnectionRatePerIpFloorProp(), KafkaConfig$.MODULE$.ListenerConnectionRatePerIpStepProp(), "confluent.max.connection.rate.per.tenant", "confluent.floor.connection.rate.per.tenant", "confluent.step.connection.rate.per.tenant", "max.connections.reap.amount"}));
    private static final scala.collection.mutable.Set<String> PerBrokerConfigs = (scala.collection.mutable.Set)((SetOps)MODULE$.DynamicSecurityConfigs().$plus$plus(DynamicListenerConfig$.MODULE$.ReconfigurableConfigs())).diff(MODULE$.ClusterLevelListenerConfigs());
    private static final Set<String> DefaultOnlyBrokerConfigs = (Set)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.eligible.controllers"}));
    private static final Set<String> ListenerMechanismConfigs = (Set)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sasl.jaas.config", "sasl.login.callback.handler.class", "sasl.login.class", "sasl.server.callback.handler.class", "connections.max.reauth.ms"}));
    private static final Set<String> kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs = (Set)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ssl.keystore.location", "ssl.truststore.location"}));
    private static final Regex ListenerConfigRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("listener\\.name\\.[^.]*\\.(.*)"));
    private static final scala.collection.mutable.Set<String> DynamicPasswordConfigs;
    private static final ConfigDef SecurityConfigDef;

    static {
        Set passwordConfigs = ((MapOps)KafkaConfig$.MODULE$.configKeys().filter((Function1<Tuple2, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(DynamicBrokerConfig$.$anonfun$DynamicPasswordConfigs$1(x$1)))).keySet();
        DynamicPasswordConfigs = (scala.collection.mutable.Set)MODULE$.AllDynamicConfigs().intersect(passwordConfigs);
        SecurityConfigDef = new ConfigDef().withClientSslSupport().withClientSaslSupport();
    }

    public scala.collection.mutable.Set<String> DynamicSecurityConfigs() {
        return DynamicSecurityConfigs;
    }

    public Set<String> DynamicProducerStateManagerConfig() {
        return DynamicProducerStateManagerConfig;
    }

    public scala.collection.mutable.Set<String> AllDynamicConfigs() {
        return AllDynamicConfigs;
    }

    private Set<String> ClusterLevelListenerConfigs() {
        return ClusterLevelListenerConfigs;
    }

    private scala.collection.mutable.Set<String> PerBrokerConfigs() {
        return PerBrokerConfigs;
    }

    private Set<String> DefaultOnlyBrokerConfigs() {
        return DefaultOnlyBrokerConfigs;
    }

    private Set<String> ListenerMechanismConfigs() {
        return ListenerMechanismConfigs;
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs() {
        return kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs;
    }

    private Regex ListenerConfigRegex() {
        return ListenerConfigRegex;
    }

    private scala.collection.mutable.Set<String> DynamicPasswordConfigs() {
        return DynamicPasswordConfigs;
    }

    public ConfigDef SecurityConfigDef() {
        return SecurityConfigDef;
    }

    public boolean isPasswordConfig(String name) {
        return this.DynamicPasswordConfigs().exists((Function1<String, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(name.endsWith(x$1)));
    }

    public List<String> brokerConfigSynonyms(String name, boolean matchListenerOverride) {
        Option<List<String>> option;
        String string = name;
        String string2 = ServerLogConfigs.LOG_ROLL_TIME_MILLIS_CONFIG;
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null) ? true : "log.roll.hours".equals(string)) {
            return new $colon$colon<Nothing$>((Nothing$)((Object)ServerLogConfigs.LOG_ROLL_TIME_MILLIS_CONFIG), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"log.roll.hours"), Nil$.MODULE$));
        }
        String string4 = ServerLogConfigs.LOG_ROLL_TIME_JITTER_MILLIS_CONFIG;
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null) ? true : "log.roll.jitter.hours".equals(string)) {
            return new $colon$colon<Nothing$>((Nothing$)((Object)ServerLogConfigs.LOG_ROLL_TIME_JITTER_MILLIS_CONFIG), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"log.roll.jitter.hours"), Nil$.MODULE$));
        }
        String string6 = ServerLogConfigs.LOG_FLUSH_INTERVAL_MS_CONFIG;
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return new $colon$colon<Nothing$>((Nothing$)((Object)ServerLogConfigs.LOG_FLUSH_INTERVAL_MS_CONFIG), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"log.flush.scheduler.interval.ms"), Nil$.MODULE$));
        }
        String string8 = ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG;
        String string9 = string;
        if (!(string8 != null ? !string8.equals(string9) : string9 != null) ? true : ("log.retention.minutes".equals(string) ? true : "log.retention.hours".equals(string))) {
            return new $colon$colon<Nothing$>((Nothing$)((Object)ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"log.retention.minutes"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"log.retention.hours"), Nil$.MODULE$)));
        }
        if (string != null && !(option = this.ListenerConfigRegex().unapplySeq(string)).isEmpty() && option.get() != null && option.get().lengthCompare(1) == 0) {
            String baseName = (String)((LinearSeqOps)option.get()).apply(0);
            if (matchListenerOverride) {
                Option mechanismConfig = this.ListenerMechanismConfigs().find((Function1<String, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(baseName.endsWith(x$1)));
                return new $colon$colon<Nothing$>((Nothing$)((Object)name), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)((String)mechanismConfig.getOrElse((Function0<String> & Serializable)() -> baseName))), Nil$.MODULE$));
            }
        }
        return new $colon$colon<Nothing$>((Nothing$)((Object)name), Nil$.MODULE$);
    }

    public void validateConfigs(Properties props, boolean perBrokerConfig) {
        DynamicBrokerConfig$.checkInvalidProps$1(this.kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(props), "Cannot update these configs dynamically");
        DynamicBrokerConfig$.checkInvalidProps$1(this.kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(props), "These security configs can be dynamically updated only per-listener using the listener prefix");
        this.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props);
        if (!perBrokerConfig) {
            DynamicBrokerConfig$.checkInvalidProps$1(this.kafka$server$DynamicBrokerConfig$$perBrokerConfigs(props), "Cannot update these configs at default cluster level, broker id must be specified");
            return;
        }
        DynamicBrokerConfig$.checkInvalidProps$1(this.defaultOnlyBrokerConfigs(props), "Cannot update these configs at the broker level; only the default cluster level is supported");
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$perBrokerConfigs(Properties props) {
        Set configNames = CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().keySet();
        return (Set)configNames.intersect(this.PerBrokerConfigs()).$plus$plus((IterableOnce)configNames.filter((Function1<String, Object> & Serializable)name -> BoxesRunTime.boxToBoolean(this.perBrokerListenerConfig$1(name))));
    }

    private Set<String> defaultOnlyBrokerConfigs(Properties props) {
        Set configNames = CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().keySet();
        return (Set)configNames.intersect(this.DefaultOnlyBrokerConfigs());
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(Properties props) {
        return (Set)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().keySet().intersect(DynamicConfig$Broker$.MODULE$.nonDynamicProps());
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(Properties props) {
        return (Set)this.DynamicSecurityConfigs().filter((Function1<Object, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(props.containsKey(x$1)));
    }

    public void kafka$server$DynamicBrokerConfig$$validateConfigTypes(Properties props) {
        Properties baseProps = new Properties();
        CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option<List<String>> option;
                String string = (String)tuple2._1();
                String v = (String)tuple2._2();
                if (string != null && !(option = MODULE$.ListenerConfigRegex().unapplySeq(string)).isEmpty() && option.get() != null && option.get().lengthCompare(1) == 0) {
                    String baseName = (String)((LinearSeqOps)option.get()).apply(0);
                    return baseProps.put(baseName, v);
                }
            }
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return baseProps.put(k, v);
            }
            throw new MatchError(tuple2);
        });
        DynamicConfig$Broker$.MODULE$.validate(baseProps);
    }

    public Map<String, String> dynamicConfigUpdateModes() {
        return CollectionConverters$.MODULE$.MapHasAsJava(((IterableOnceOps)this.AllDynamicConfigs().map((Function1<String, Tuple2> & Serializable)name -> {
            String mode = MODULE$.PerBrokerConfigs().contains((String)name) ? "per-broker" : "cluster-wide";
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), mode);
        })).toMap($less$colon$less$.MODULE$.refl())).asJava();
    }

    public Properties resolveVariableConfigs(Properties propsOriginal) {
        Properties props = new Properties();
        AbstractConfig config = new AbstractConfig(new ConfigDef(), propsOriginal, Utils.castToStringObjectMap(propsOriginal), false);
        config.originals().forEach((key, value) -> {
            if (!key.startsWith("config.providers")) {
                props.put(key, value);
                return;
            }
        });
        return props;
    }

    public void readDynamicBrokerConfigsFromSnapshot(KafkaRaftManager<ApiMessageAndVersion> raftManager, KafkaConfig config, QuotaFactory.QuotaManagers quotaManagers) {
        raftManager.replicatedLog().latestSnapshotId().ifPresent(latestSnapshotId -> raftManager.replicatedLog().readSnapshot((OffsetAndEpoch)latestSnapshotId).ifPresent(rawSnapshotReader -> {
            RecordsSnapshotReader reader = RecordsSnapshotReader.of(rawSnapshotReader, raftManager.recordSerde(), BufferSupplier.create(), 0x800000, true);
            Properties dynamicPerBrokerConfigs = new Properties();
            Properties dynamicDefaultConfigs = new Properties();
            while (reader.hasNext()) {
                Object batch = reader.next();
                batch.forEach(record -> {
                    if (record.message().apiKey() == MetadataRecordType.CONFIG_RECORD.id()) {
                        ConfigRecord configRecord = (ConfigRecord)record.message();
                        if (MODULE$.AllDynamicConfigs().contains(configRecord.name()) && configRecord.resourceType() == ConfigResource.Type.BROKER.id()) {
                            if (configRecord.resourceName().isEmpty()) {
                                DynamicBrokerConfig$.putOrRemoveIfNull$1(dynamicDefaultConfigs, configRecord.name(), configRecord.value());
                                return;
                            }
                            String string = configRecord.resourceName();
                            String string2 = Integer.toString(config.brokerId());
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                DynamicBrokerConfig$.putOrRemoveIfNull$1(dynamicPerBrokerConfigs, configRecord.name(), configRecord.value());
                                return;
                            }
                            return;
                        }
                        return;
                    }
                });
            }
            BrokerConfigHandler configHandler = new BrokerConfigHandler(config, quotaManagers);
            configHandler.processConfigChanges("", dynamicPerBrokerConfigs);
            configHandler.processConfigChanges(Integer.toString(config.brokerId()), dynamicPerBrokerConfigs);
        }));
    }

    public static final /* synthetic */ boolean $anonfun$DynamicPasswordConfigs$1(Tuple2 x$1) {
        ConfigDef.Type type = ((ConfigDef.ConfigKey)x$1._2()).type;
        ConfigDef.Type type2 = ConfigDef.Type.PASSWORD;
        return !(type != null ? !((Object)((Object)type)).equals((Object)type2) : type2 != null);
    }

    private static final void checkInvalidProps$1(Set invalidPropNames, String errorMessage) {
        if (invalidPropNames.nonEmpty()) {
            throw new ConfigException(errorMessage + ": " + invalidPropNames);
        }
    }

    private final boolean perBrokerListenerConfig$1(String name) {
        Option<List<String>> option;
        String string = name;
        if (string != null && !(option = this.ListenerConfigRegex().unapplySeq(string)).isEmpty() && option.get() != null && option.get().lengthCompare(1) == 0) {
            String baseName = (String)((LinearSeqOps)option.get()).apply(0);
            return !this.ClusterLevelListenerConfigs().contains(baseName);
        }
        return false;
    }

    private static final void putOrRemoveIfNull$1(Properties props, String key, String value) {
        if (value == null) {
            props.remove(key);
            return;
        }
        props.put(key, value);
    }

    private DynamicBrokerConfig$() {
    }
}

