/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.coordinator.quota.QuotaCoordinator;
import kafka.server.AbstractQuotaChannelManager;
import kafka.server.DynamicQuotaChannelManager$;
import kafka.server.DynamicQuotaPublishingRequestThread;
import kafka.server.DynamicQuotaReportingRequestThread;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.KafkaScheduler;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015r!B\n\u0015\u0011\u0003Ib!B\u000e\u0015\u0011\u0003a\u0002\"B\u0012\u0002\t\u0003!\u0003\"B\u0013\u0002\t\u00031c\u0001B\u000e\u0015\u0001aC\u0001b\u000b\u0003\u0003\u0002\u0003\u0006I\u0001\f\u0005\ta\u0011\u0011\t\u0011)A\u0005c!Aa\b\u0002B\u0001B\u0003%q\b\u0003\u0005D\t\t\u0005\t\u0015!\u0003E\u0011!YEA!A!\u0002\u0013a\u0005\u0002\u0003+\u0005\u0005\u0003\u0005\u000b\u0011B+\t\u000b\r\"A\u0011A-\t\u000f\u0005$!\u0019!C!E\"1a\r\u0002Q\u0001\n\rDqa\u001a\u0003C\u0002\u0013\u0005\u0003\u000e\u0003\u0004m\t\u0001\u0006I!\u001b\u0005\u0006[\u0012!\tE\u001c\u0005\u0006w\u0012!\t\u0005 \u0005\u0006{\u0012!IA`\u0001\u001b\tft\u0017-\\5d#V|G/Y\"iC:tW\r\\'b]\u0006<WM\u001d\u0006\u0003+Y\taa]3sm\u0016\u0014(\"A\f\u0002\u000b-\fgm[1\u0004\u0001A\u0011!$A\u0007\u0002)\tQB)\u001f8b[&\u001c\u0017+^8uC\u000eC\u0017M\u001c8fY6\u000bg.Y4feN\u0011\u0011!\b\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005I\u0012!B1qa2LHcB\u0014+_u\u0012%j\u0015\t\u00035!J!!\u000b\u000b\u00037\u0005\u00137\u000f\u001e:bGR\fVo\u001c;b\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0011\u0015Y3\u00011\u0001-\u0003\u0019\u0019wN\u001c4jOB\u0011!$L\u0005\u0003]Q\u00111bS1gW\u0006\u001cuN\u001c4jO\")\u0001g\u0001a\u0001c\u00059Q.\u001a;sS\u000e\u001c\bC\u0001\u001a<\u001b\u0005\u0019$B\u0001\u00195\u0015\t)d'\u0001\u0004d_6lwN\u001c\u0006\u0003/]R!\u0001O\u001d\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0014aA8sO&\u0011Ah\r\u0002\b\u001b\u0016$(/[2t\u0011\u0015q4\u00011\u0001@\u00035iW\r^1eCR\f7)Y2iKB\u0011!\u0004Q\u0005\u0003\u0003R\u0011Q\"T3uC\u0012\fG/Y\"bG\",\u0007\"B\"\u0004\u0001\u0004!\u0015\u0001\u0002;j[\u0016\u0004\"!\u0012%\u000e\u0003\u0019S!a\u0012\u001b\u0002\u000bU$\u0018\u000e\\:\n\u0005%3%\u0001\u0002+j[\u0016DQaS\u0002A\u00021\u000bab[1gW\u0006\u001c6\r[3ek2,'\u000f\u0005\u0002N#6\taJ\u0003\u0002P!\u0006!Q\u000f^5m\u0015\t)b'\u0003\u0002S\u001d\nq1*\u00194lCN\u001b\u0007.\u001a3vY\u0016\u0014\b\"\u0002+\u0004\u0001\u0004)\u0016A\u00037pO\u000e{g\u000e^3yiB\u0011QIV\u0005\u0003/\u001a\u0013!\u0002T8h\u0007>tG/\u001a=u'\r!Qd\n\u000b\b5ncVLX0a!\tQB\u0001C\u0003,\u0017\u0001\u0007A\u0006C\u00031\u0017\u0001\u0007\u0011\u0007C\u0003?\u0017\u0001\u0007q\bC\u0003D\u0017\u0001\u0007A\tC\u0003L\u0017\u0001\u0007A\nC\u0003U\u0017\u0001\u0007Q+\u0001\fhKR\u0014V\r]8siJ+\u0017/^3tiRC'/Z1e+\u0005\u0019\u0007C\u0001\u000ee\u0013\t)GC\u0001\u0012Es:\fW.[2Rk>$\u0018MU3q_J$\u0018N\\4SKF,Xm\u001d;UQJ,\u0017\rZ\u0001\u0018O\u0016$(+\u001a9peR\u0014V-];fgR$\u0006N]3bI\u0002\nqcZ3u!V\u0014G.[:i%\u0016\fX/Z:u)\"\u0014X-\u00193\u0016\u0003%\u0004\"A\u00076\n\u0005-$\"a\t#z]\u0006l\u0017nY)v_R\f\u0007+\u001e2mSND\u0017N\\4SKF,Xm\u001d;UQJ,\u0017\rZ\u0001\u0019O\u0016$\b+\u001e2mSND'+Z9vKN$H\u000b\u001b:fC\u0012\u0004\u0013!B:uCJ$HCA8s!\tq\u0002/\u0003\u0002r?\t!QK\\5u\u0011\u0015\u0019\b\u00031\u0001u\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u0011\u0005ULX\"\u0001<\u000b\u0005]D\u0018!B9v_R\f'BA:\u0017\u0013\tQhO\u0001\tRk>$\u0018mQ8pe\u0012Lg.\u0019;pe\u0006A1\u000f[;uI><h\u000eF\u0001p\u0003U9WM\\3sCR,g*\u001a;x_J\\7\t\\5f]R$2a`A\u0006!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003m\u000591\r\\5f]R\u001c\u0018\u0002BA\u0005\u0003\u0007\u0011QBT3uo>\u00148n\u00117jK:$\bbBA\u0007%\u0001\u0007\u0011qB\u0001\u000b]\u0006lW\r\u0015:fM&D\b\u0003BA\t\u0003?qA!a\u0005\u0002\u001cA\u0019\u0011QC\u0010\u000e\u0005\u0005]!bAA\r1\u00051AH]8pizJ1!!\b \u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011EA\u0012\u0005\u0019\u0019FO]5oO*\u0019\u0011QD\u0010")
public class DynamicQuotaChannelManager
implements AbstractQuotaChannelManager {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final Time time;
    private final LogContext logContext;
    private final DynamicQuotaReportingRequestThread getReportRequestThread;
    private final DynamicQuotaPublishingRequestThread getPublishRequestThread;

    public static AbstractQuotaChannelManager apply(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, Time time, KafkaScheduler kafkaScheduler, LogContext logContext) {
        return DynamicQuotaChannelManager$.MODULE$.apply(config, metrics, metadataCache, time, kafkaScheduler, logContext);
    }

    @Override
    public DynamicQuotaReportingRequestThread getReportRequestThread() {
        return this.getReportRequestThread;
    }

    @Override
    public DynamicQuotaPublishingRequestThread getPublishRequestThread() {
        return this.getPublishRequestThread;
    }

    @Override
    public void start(QuotaCoordinator coordinator) {
        this.getReportRequestThread().start(coordinator);
        this.getPublishRequestThread().start(coordinator);
    }

    @Override
    public void shutdown() {
        this.getPublishRequestThread().shutdown();
        this.getReportRequestThread().shutdown();
    }

    private NetworkClient generateNetworkClient(String namePrefix) {
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder(this.config.interBrokerSecurityProtocol(), JaasContext.Type.SERVER, this.config, this.config.interBrokerListenerName(), this.config.saslMechanismInterBrokerProtocol(), this.time, this.logContext);
        ChannelBuilder channelBuilder2 = channelBuilder;
        if (channelBuilder2 instanceof Reconfigurable) {
            ChannelBuilder channelBuilder3 = channelBuilder2;
            this.config.addReconfigurable((Reconfigurable)((Object)channelBuilder3));
        }
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), this.metrics, this.time, "dynamic-quota-" + namePrefix + "-channel", CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("BrokerId"), Integer.toString(this.config.brokerId()))}))).asJava(), false, channelBuilder, this.logContext);
        return new NetworkClient((Selectable)selector, new ManualMetadataUpdater(), "broker-" + this.config.brokerId() + "-dynamic-quota-" + namePrefix + "-sender", 1, 50L, 30000L, -1, Predef$.MODULE$.Integer2int(this.config.socketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(this.config.requestTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, false, new ApiVersions(), this.logContext, MetadataRecoveryStrategy.NONE);
    }

    public DynamicQuotaChannelManager(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, Time time, KafkaScheduler kafkaScheduler, LogContext logContext) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        this.logContext = logContext;
        this.getReportRequestThread = new DynamicQuotaReportingRequestThread(config, metrics, metadataCache, this.generateNetworkClient("reporting"), kafkaScheduler, time);
        this.getPublishRequestThread = new DynamicQuotaPublishingRequestThread(config, metrics, metadataCache, this.generateNetworkClient("publishing"), kafkaScheduler, time);
    }
}

