/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import kafka.coordinator.quota.QuotaEntity;
import kafka.server.ClientQuotaManager;
import kafka.server.FlexFanoutQuotaManager$;
import kafka.server.KafkaConfig;
import kafka.server.QuotaFactory;
import kafka.server.ReplicationQuotaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.server.config.FlexFanoutManagerConfig;
import org.apache.kafka.server.config.FlexFanoutMode;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.apache.kafka.server.util.Scheduler;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.mutable.Seq;
import scala.collection.mutable.Seq$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t5u!\u0002 @\u0011\u0003!e!\u0002$@\u0011\u00039\u0005\"\u0002(\u0002\t\u0003y\u0005b\u0002)\u0002\u0005\u0004%\t!\u0015\u0005\u0007A\u0006\u0001\u000b\u0011\u0002*\t\u000b\u0005\fA\u0011\u00012\t\u000f\t5\u0014\u0001\"\u0001\u0003p!I!QO\u0001\u0012\u0002\u0013\u0005!q\u000f\u0004\u0005\r~\u0002A\r\u0003\u0005l\u0011\t\u0015\r\u0011\"\u0003m\u0011!A\bB!A!\u0002\u0013i\u0007\u0002C=\t\u0005\u000b\u0007I\u0011\u0002>\t\u0013\u0005\u0015\u0001B!A!\u0002\u0013Y\bBCA\u0004\u0011\t\u0015\r\u0011\"\u0003\u0002\n!Q\u0011q\u0003\u0005\u0003\u0002\u0003\u0006I!a\u0003\t\u0015\u0005e\u0001B!b\u0001\n\u0013\tY\u0002\u0003\u0006\u00028!\u0011\t\u0011)A\u0005\u0003;A!\"!\u000f\t\u0005\u000b\u0007I\u0011BA\u001e\u0011)\t\u0019\u0006\u0003B\u0001B\u0003%\u0011Q\b\u0005\u0007\u001d\"!\t!!\u0016\t\u0013\u0005\u0005\u0004B1A\u0005\n\u0005\r\u0004\u0002CA6\u0011\u0001\u0006I!!\u001a\t\u0013\u00055\u0004B1A\u0005\n\u0005=\u0004\u0002CA<\u0011\u0001\u0006I!!\u001d\t\u0013\u0005e\u0004B1A\u0005\n\u0005m\u0004\u0002CAB\u0011\u0001\u0006I!! \t\u0013\u0005\u0015\u0005B1A\u0005\n\u0005\u001d\u0005\u0002CAH\u0011\u0001\u0006I!!#\t\u0013\u0005E\u0005B1A\u0005\n\u0005\u001d\u0005\u0002CAJ\u0011\u0001\u0006I!!#\t\u0013\u0005U\u0005B1A\u0005\n\u0005\u001d\u0005\u0002CAL\u0011\u0001\u0006I!!#\t\u0013\u0005e\u0005B1A\u0005\n\u0005m\u0004\u0002CAN\u0011\u0001\u0006I!! \t\u0013\u0005u\u0005B1A\u0005\n\u0005\u001d\u0005\u0002CAP\u0011\u0001\u0006I!!#\t\u0013\u0005\u0005\u0006B1A\u0005\n\u0005\u001d\u0005\u0002CAR\u0011\u0001\u0006I!!#\t\u0013\u0005\u0015\u0006B1A\u0005\n\u0005\u001d\u0006\u0002CAX\u0011\u0001\u0006I!!+\t\u0013\u0005E\u0006B1A\u0005\n\u0005\u001d\u0006\u0002CAZ\u0011\u0001\u0006I!!+\t\u0013\u0005U\u0006B1A\u0005\n\u0005]\u0006\u0002CA`\u0011\u0001\u0006I!!/\t\u0013\u0005\u0005\u0007B1A\u0005\n\u0005]\u0006\u0002CAb\u0011\u0001\u0006I!!/\t\u0013\u0005\u0015\u0007\u00021A\u0005\u0002\u0005\u001d\u0007\"CAe\u0011\u0001\u0007I\u0011AAf\u0011!\t9\u000e\u0003Q!\n\u0005-\u0002bBAm\u0011\u0011\u0005\u00111\u001c\u0005\b\u0003;DA\u0011BAp\u0011\u001d\ti\u000f\u0003C\u0001\u00037Dq!a<\t\t\u0003\t\u0019\u0007C\u0004\u0002r\"!I!a=\t\u000f\u0005=\b\u0002\"\u0003\u0003\f!9!\u0011\u0003\u0005\u0005\n\tM\u0001b\u0002B\u000e\u0011\u0011%!Q\u0004\u0005\b\u0005CAA\u0011\u0002B\u0012\u0011\u001d\u0011i\u0003\u0003C\u0005\u0005_AqA!\u0010\t\t\u0003\u0011y\u0004C\u0004\u0003F!!\tAa\u0012\t\u000f\tm\u0003\u0002\"\u0001\u0002|\u00051b\t\\3y\r\u0006tw.\u001e;Rk>$\u0018-T1oC\u001e,'O\u0003\u0002A\u0003\u000611/\u001a:wKJT\u0011AQ\u0001\u0006W\u000647.Y\u0002\u0001!\t)\u0015!D\u0001@\u0005Y1E.\u001a=GC:|W\u000f^)v_R\fW*\u00198bO\u0016\u00148CA\u0001I!\tIE*D\u0001K\u0015\u0005Y\u0015!B:dC2\f\u0017BA'K\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001R\u0001\u0016%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t+\u0005\u0011\u0006cA*[;:\u0011A\u000b\u0017\t\u0003+*k\u0011A\u0016\u0006\u0003/\u000e\u000ba\u0001\u0010:p_Rt\u0014BA-K\u0003\u0019\u0001&/\u001a3fM&\u00111\f\u0018\u0002\u0004'\u0016$(BA-K!\t\u0019f,\u0003\u0002`9\n11\u000b\u001e:j]\u001e\faCU3d_:4\u0017nZ;sC\ndWmQ8oM&<7\u000fI\u0001\u0006CB\u0004H.\u001f\u000b\fG\nu#Q\rB4\u0005S\u0012Y\u0007\u0005\u0002F\u0011M\u0019\u0001\u0002S3\u0011\u0005\u0019LW\"A4\u000b\u0005!\f\u0015!B;uS2\u001c\u0018B\u00016h\u0005\u001daunZ4j]\u001e\faaY8oM&<W#A7\u0011\u000594X\"A8\u000b\u0005-\u0004(B\u0001!r\u0015\t\u0011%O\u0003\u0002ti\u00061\u0011\r]1dQ\u0016T\u0011!^\u0001\u0004_J<\u0017BA<p\u0005]1E.\u001a=GC:|W\u000f^'b]\u0006<WM]\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\u000f5,GO]5dgV\t1\u0010E\u0002}\u0003\u0003i\u0011! \u0006\u0003szT!a`9\u0002\r\r|W.\\8o\u0013\r\t\u0019! \u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013!C:dQ\u0016$W\u000f\\3s+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005MQBAA\b\u0015\r\t\t\u0002]\u0001\u0005kRLG.\u0003\u0003\u0002\u0016\u0005=!!C*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u0001\u0014G2LWM\u001c;Rk>$\u0018mQ1mY\n\f7m[\u000b\u0003\u0003;\u0001b!a\b\u0002(\u0005-RBAA\u0011\u0015\u0011\t\t\"a\t\u000b\u0005\u0005\u0015\u0012\u0001\u00026bm\u0006LA!!\u000b\u0002\"\tAq\n\u001d;j_:\fG\u000e\u0005\u0003\u0002.\u0005MRBAA\u0018\u0015\r\t\t\u0004]\u0001\u0006cV|G/Y\u0005\u0005\u0003k\tyCA\nDY&,g\u000e^)v_R\f7)\u00197mE\u0006\u001c7.\u0001\u000bdY&,g\u000e^)v_R\f7)\u00197mE\u0006\u001c7\u000eI\u0001\u000ecV|G/Y'b]\u0006<WM]:\u0016\u0005\u0005u\u0002\u0003BA \u0003\u001brA!!\u0011\u0002J9!\u00111IA$\u001d\r)\u0016QI\u0005\u0002\u0005&\u0011\u0001)Q\u0005\u0004\u0003\u0017z\u0014\u0001D)v_R\fg)Y2u_JL\u0018\u0002BA(\u0003#\u0012Q\"U;pi\u0006l\u0015M\\1hKJ\u001c(bAA&\u007f\u0005q\u0011/^8uC6\u000bg.Y4feN\u0004CcC2\u0002X\u0005e\u00131LA/\u0003?BQa[\nA\u00025DQ!_\nA\u0002mDq!a\u0002\u0014\u0001\u0004\tY\u0001C\u0005\u0002\u001aM\u0001\n\u00111\u0001\u0002\u001e!9\u0011\u0011H\nA\u0002\u0005u\u0012!\u00064mKbL'\r\\3GC:|W\u000f^#oC\ndW\rZ\u000b\u0003\u0003K\u00022!SA4\u0013\r\tIG\u0013\u0002\b\u0005>|G.Z1o\u0003Y1G.\u001a=jE2,g)\u00198pkR,e.\u00192mK\u0012\u0004\u0013A\u00054mKbL'\r\\3GC:|W\u000f^'pI\u0016,\"!!\u001d\u0011\u00079\f\u0019(C\u0002\u0002v=\u0014aB\u00127fq\u001a\u000bgn\\;u\u001b>$W-A\ngY\u0016D\u0018N\u00197f\r\u0006tw.\u001e;N_\u0012,\u0007%A\u0013gY\u0016D\u0018N\u00197f\r\u0006tw.\u001e;MCjLXI^1mk\u0006$\u0018n\u001c8UQJ,7\u000f[8mIV\u0011\u0011Q\u0010\t\u0004\u0013\u0006}\u0014bAAA\u0015\n1Ai\\;cY\u0016\faE\u001a7fq&\u0014G.\u001a$b]>,H\u000fT1{s\u00163\u0018\r\\;bi&|g\u000e\u00165sKNDw\u000e\u001c3!\u0003\u001d2G.\u001a=jE2,g)\u00198pkR\u0014%o\\6fe:+Go^8sW>+HOQ1oI^LG\r\u001e5\u0016\u0005\u0005%\u0005cA%\u0002\f&\u0019\u0011Q\u0012&\u0003\t1{gnZ\u0001)M2,\u00070\u001b2mK\u001a\u000bgn\\;u\u0005J|7.\u001a:OKR<xN]6PkR\u0014\u0015M\u001c3xS\u0012$\b\u000eI\u0001%M2,\u00070\u001b2mK\u001a\u000bgn\\;u\u0005J|7.\u001a:Ti>\u0014\u0018mZ3CC:$w/\u001b3uQ\u0006)c\r\\3yS\ndWMR1o_V$(I]8lKJ\u001cFo\u001c:bO\u0016\u0014\u0015M\u001c3xS\u0012$\b\u000eI\u0001/M2,\u00070\u001b2mK\u001a\u000bgn\\;u\u0005J|7.\u001a:SCRLwNU3DC2\u001cW\u000f\\1uK&sG/\u001a:wC2l5/A\u0018gY\u0016D\u0018N\u00197f\r\u0006tw.\u001e;Ce>\\WM\u001d*bi&|'+Z\"bY\u000e,H.\u0019;f\u0013:$XM\u001d<bY6\u001b\b%A\u0015gY\u0016D\u0018N\u00197f\r\u0006tw.\u001e;Ce>\\WM]'j]B\u0013x\u000eZ;dKJ\u0004VM]2f]R\fw-Z\u0001+M2,\u00070\u001b2mK\u001a\u000bgn\\;u\u0005J|7.\u001a:NS:\u0004&o\u001c3vG\u0016\u0014\b+\u001a:dK:$\u0018mZ3!\u0003\r2G.\u001a=jE2,g)\u00198pkR\u0014%o\\6fe6\u000b\u0007\u0010\u0015:pIV\u001cW\rT5nSR\fAE\u001a7fq&\u0014G.\u001a$b]>,HO\u0011:pW\u0016\u0014X*\u0019=Qe>$WoY3MS6LG\u000fI\u0001\"M2,\u00070\u001b2mK\u001a\u000bgn\\;u\u0005J|7.\u001a:NCb4U\r^2i\u0019&l\u0017\u000e^\u0001#M2,\u00070\u001b2mK\u001a\u000bgn\\;u\u0005J|7.\u001a:NCb4U\r^2i\u0019&l\u0017\u000e\u001e\u0011\u0002'A\u0014x\u000eZ;dKF+x\u000e^1NC:\fw-\u001a:\u0016\u0005\u0005%\u0006cA#\u0002,&\u0019\u0011QV \u0003%\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM]\u0001\u0015aJ|G-^2f#V|G/Y'b]\u0006<WM\u001d\u0011\u0002#\u0019,Go\u00195Rk>$\u0018-T1oC\u001e,'/\u0001\ngKR\u001c\u0007.U;pi\u0006l\u0015M\\1hKJ\u0004\u0013A\u00057fC\u0012,'/U;pi\u0006l\u0015M\\1hKJ,\"!!/\u0011\u0007\u0015\u000bY,C\u0002\u0002>~\u0012qCU3qY&\u001c\u0017\r^5p]F+x\u000e^1NC:\fw-\u001a:\u0002'1,\u0017\rZ3s#V|G/Y'b]\u0006<WM\u001d\u0011\u0002)\u0019|G\u000e\\8xKJ\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0003U1w\u000e\u001c7po\u0016\u0014\u0018+^8uC6\u000bg.Y4fe\u0002\nQ\"];pi\u0006\u001c\u0015\r\u001c7cC\u000e\\WCAA\u0016\u0003E\tXo\u001c;b\u0007\u0006dGNY1dW~#S-\u001d\u000b\u0005\u0003\u001b\f\u0019\u000eE\u0002J\u0003\u001fL1!!5K\u0005\u0011)f.\u001b;\t\u0013\u0005Uw&!AA\u0002\u0005-\u0012a\u0001=%c\u0005q\u0011/^8uC\u000e\u000bG\u000e\u001c2bG.\u0004\u0013!B:uCJ$HCAAg\u0003e\u00198\r[3ek2,W\u000b\u001d3bi\u0016\u0014%o\\6fe2KW.\u001b;\u0015\u0005\u0005\u0005\b\u0003BAr\u0003Sl!!!:\u000b\t\u0005\u001d\u00181E\u0001\u0005Y\u0006tw-\u0003\u0003\u0002l\u0006\u0015(\u0001\u0003*v]:\f'\r\\3\u0002?U\u0004H-\u0019;f\u0005J|7.\u001a:MS6LGoV5uQ\u001acW\r\u001f$b]>,H/\u0001\u0015jg\u0006\u0013wN^3GY\u0016Dh)\u00198pkRd\u0015M_=Fm\u0006dW/\u0019;j_:$\u0006N]3tQ>dG-\u0001\rhKR$v\u000e\u001d'fm\u0016d\u0017+^8uC\u0016sG/\u001b;jKN,\"!!>\u0011\r\u0005](\u0011\u0001B\u0003\u001b\t\tIP\u0003\u0003\u0002|\u0006u\u0018aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u007fT\u0015AC2pY2,7\r^5p]&!!1AA}\u0005\r\u0019V-\u001d\t\u0006'\n\u001dQ,X\u0005\u0004\u0005\u0013a&aA'baR!\u0011Q\rB\u0007\u0011\u001d\u0011yA\u000ea\u0001\u0003k\f\u0001\"\u001a8uSRLWm]\u0001\u0014O\u0016$Hk\u001c;bYV\u001b\u0018mZ3CsRK\b/\u001a\u000b\u0007\u0003\u0013\u0013)Ba\u0006\t\u000f\t=q\u00071\u0001\u0002v\"9!\u0011D\u001cA\u0002\u0005%\u0016aB7b]\u0006<WM]\u0001\u0015O\u0016$(I]8lKJ4\u0015M\\8viJ\u000bG/[8\u0015\t\u0005u$q\u0004\u0005\b\u0005\u001fA\u0004\u0019AA{\u0003Y)\b\u000fZ1uKJ+\u0007\u000f\\5dCRLwN\\)v_R\fGCBAg\u0005K\u0011I\u0003C\u0004\u0003(e\u0002\r!! \u0002!1,\u0017\rZ3s#V|G/\u0019'j[&$\bb\u0002B\u0016s\u0001\u0007\u0011QP\u0001\u0013M>dGn\\<feF+x\u000e^1MS6LG/\u0001\rva\u0012\fG/\u001a+f]\u0006tG\u000fR=oC6L7-U;pi\u0006$\u0002\"!4\u00032\tU\"\u0011\b\u0005\b\u0005gQ\u0004\u0019AA{\u0003U!x\u000e\u001d'fm\u0016d\u0017+^8uC\u0016sG/\u001b;jKNDqAa\u000e;\u0001\u0004\tI)\u0001\u0007qe>$WoY3MS6LG\u000fC\u0004\u0003<i\u0002\r!!#\u0002\u0015\u0019,Go\u00195MS6LG/A\njg\u001acW\r\u001f$b]>,H/\u00128bE2,G\r\u0006\u0003\u0002f\t\u0005\u0003b\u0002B\"w\u0001\u0007!QA\u0001\u0007K:$\u0018\u000e^=\u0002E%\u001cH)\u001f8b[&\u001c\u0017+^8uC\u000e{W\u000e];uK\u0012\u0014\u0015P\u00127fq\u001a\u000bgn\\;u)\u0011\t)G!\u0013\t\u000f\t-C\b1\u0001\u0003N\u0005Y\u0011/^8uC\u0016sG/\u001b;z!\u0011\u0011yEa\u0016\u000e\u0005\tE#\u0002BA\u0019\u0005'R1A!\u0016B\u0003-\u0019wn\u001c:eS:\fGo\u001c:\n\t\te#\u0011\u000b\u0002\f#V|G/Y#oi&$\u00180\u0001\nhKRl\u0015N\u001c)s_\u0012,8-\u001a'j[&$\bBB6\u0006\u0001\u0004\u0011y\u0006E\u0002F\u0005CJ1Aa\u0019@\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000be,\u0001\u0019A>\t\u000f\u0005\u001dQ\u00011\u0001\u0002\f!9\u0011\u0011D\u0003A\u0002\u0005u\u0001bBA\u001d\u000b\u0001\u0007\u0011QH\u0001\u0018M2,\u0007PR1o_V$X*\u00198bO\u0016\u00148i\u001c8gS\u001e$2!\u001cB9\u0011\u001d\u0011\u0019H\u0002a\u0001\u0005?\n1a\u00194h\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!\u0011\u0010\u0016\u0005\u0003;\u0011Yh\u000b\u0002\u0003~A!!q\u0010BE\u001b\t\u0011\tI\u0003\u0003\u0003\u0004\n\u0015\u0015!C;oG\",7m[3e\u0015\r\u00119IS\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002BF\u0005\u0003\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class FlexFanoutQuotaManager
implements Logging {
    private final FlexFanoutManagerConfig config;
    private final Metrics metrics;
    private final Scheduler scheduler;
    private final Optional<ClientQuotaCallback> clientQuotaCallback;
    private final QuotaFactory.QuotaManagers quotaManagers;
    private final boolean flexibleFanoutEnabled;
    private final FlexFanoutMode flexibleFanoutMode;
    private final double flexibleFanoutLazyEvaluationThreshold;
    private final long flexibleFanoutBrokerNetworkOutBandwidth;
    private final long flexibleFanoutBrokerStorageBandwidth;
    private final long flexibleFanoutBrokerRatioReCalculateIntervalMs;
    private final double flexibleFanoutBrokerMinProducerPercentage;
    private final long flexibleFanoutBrokerMaxProduceLimit;
    private final long flexibleFanoutBrokerMaxFetchLimit;
    private final ClientQuotaManager produceQuotaManager;
    private final ClientQuotaManager fetchQuotaManager;
    private final ReplicationQuotaManager leaderQuotaManager;
    private final ReplicationQuotaManager followerQuotaManager;
    private ClientQuotaCallback quotaCallback;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Optional<ClientQuotaCallback> $lessinit$greater$default$4() {
        return FlexFanoutQuotaManager$.MODULE$.$lessinit$greater$default$4();
    }

    public static FlexFanoutManagerConfig flexFanoutManagerConfig(KafkaConfig cfg) {
        return FlexFanoutQuotaManager$.MODULE$.flexFanoutManagerConfig(cfg);
    }

    public static FlexFanoutQuotaManager apply(KafkaConfig config, Metrics metrics, Scheduler scheduler, Optional<ClientQuotaCallback> clientQuotaCallback, QuotaFactory.QuotaManagers quotaManagers) {
        return FlexFanoutQuotaManager$.MODULE$.apply(config, metrics, scheduler, clientQuotaCallback, quotaManagers);
    }

    public static scala.collection.immutable.Set<String> ReconfigurableConfigs() {
        return FlexFanoutQuotaManager$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        FlexFanoutQuotaManager flexFanoutQuotaManager = this;
        synchronized (flexFanoutQuotaManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private FlexFanoutManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private Scheduler scheduler() {
        return this.scheduler;
    }

    private Optional<ClientQuotaCallback> clientQuotaCallback() {
        return this.clientQuotaCallback;
    }

    private QuotaFactory.QuotaManagers quotaManagers() {
        return this.quotaManagers;
    }

    private boolean flexibleFanoutEnabled() {
        return this.flexibleFanoutEnabled;
    }

    private FlexFanoutMode flexibleFanoutMode() {
        return this.flexibleFanoutMode;
    }

    private double flexibleFanoutLazyEvaluationThreshold() {
        return this.flexibleFanoutLazyEvaluationThreshold;
    }

    private long flexibleFanoutBrokerNetworkOutBandwidth() {
        return this.flexibleFanoutBrokerNetworkOutBandwidth;
    }

    private long flexibleFanoutBrokerStorageBandwidth() {
        return this.flexibleFanoutBrokerStorageBandwidth;
    }

    private long flexibleFanoutBrokerRatioReCalculateIntervalMs() {
        return this.flexibleFanoutBrokerRatioReCalculateIntervalMs;
    }

    private double flexibleFanoutBrokerMinProducerPercentage() {
        return this.flexibleFanoutBrokerMinProducerPercentage;
    }

    private long flexibleFanoutBrokerMaxProduceLimit() {
        return this.flexibleFanoutBrokerMaxProduceLimit;
    }

    private long flexibleFanoutBrokerMaxFetchLimit() {
        return this.flexibleFanoutBrokerMaxFetchLimit;
    }

    private ClientQuotaManager produceQuotaManager() {
        return this.produceQuotaManager;
    }

    private ClientQuotaManager fetchQuotaManager() {
        return this.fetchQuotaManager;
    }

    private ReplicationQuotaManager leaderQuotaManager() {
        return this.leaderQuotaManager;
    }

    private ReplicationQuotaManager followerQuotaManager() {
        return this.followerQuotaManager;
    }

    public ClientQuotaCallback quotaCallback() {
        return this.quotaCallback;
    }

    public void quotaCallback_$eq(ClientQuotaCallback x$1) {
        this.quotaCallback = x$1;
    }

    public void start() {
        if (!this.flexibleFanoutEnabled() || this.clientQuotaCallback().isEmpty()) {
            this.info((Function0<String> & Serializable)() -> "FlexFanout is not enabled or there is no ClientQuotaCallback so does not start FlexFanoutQuotaManager.");
            return;
        }
        FlexFanoutMode flexFanoutMode = this.flexibleFanoutMode();
        FlexFanoutMode flexFanoutMode2 = FlexFanoutMode.BROKER_QUOTA;
        if (flexFanoutMode == null ? flexFanoutMode2 != null : !((Object)((Object)flexFanoutMode)).equals((Object)flexFanoutMode2)) {
            this.info((Function0<String> & Serializable)() -> "FlexFanout is not configured to run in BROKER_QUOTA mode so does not start FlexFanoutQuotaManager.");
            return;
        }
        this.quotaCallback_$eq(this.clientQuotaCallback().get());
        this.scheduler().schedule("flex-fanout-update-broker-limit", this.scheduleUpdateBrokerLimit(), 0L, this.flexibleFanoutBrokerRatioReCalculateIntervalMs());
    }

    private Runnable scheduleUpdateBrokerLimit() {
        return () -> {
            try {
                this.info((Function0<String> & Serializable)() -> "Update broker limit with Flex Fanout");
                this.updateBrokerLimitWithFlexFanout();
            }
            catch (Exception ex) {
                this.error((Function0<String> & Serializable)() -> "Received exception while updating broker quota limit in FlexFanoutManager: " + ex);
            }
        };
    }

    public void updateBrokerLimitWithFlexFanout() {
        Seq<Map<String, String>> topLevelQuotaEntities = this.getTopLevelQuotaEntities();
        if (topLevelQuotaEntities.isEmpty()) {
            this.debug((Function0<String> & Serializable)() -> "Skipping flex fanout interval, no top level quota entities found");
            return;
        }
        java.util.Set<String> tenantWithFlexFanoutEnabled = this.quotaCallback().getTenantWithFlexFanoutEnabled();
        if (!tenantWithFlexFanoutEnabled.isEmpty() && this.isAboveFlexFanoutLazyEvaluationThreshold(topLevelQuotaEntities)) {
            double brokerFanoutRatio = this.getBrokerFanoutRatio(topLevelQuotaEntities);
            double calculatedProduceLimit = package$.MODULE$.min((double)(this.flexibleFanoutBrokerStorageBandwidth() / 3L), (double)this.flexibleFanoutBrokerNetworkOutBandwidth() / ((double)3 + brokerFanoutRatio));
            double produceLimit = package$.MODULE$.min(package$.MODULE$.max(calculatedProduceLimit, this.getMinProduceLimit()), (double)this.flexibleFanoutBrokerMaxProduceLimit());
            double fetchLimit = package$.MODULE$.min((double)this.flexibleFanoutBrokerNetworkOutBandwidth() - produceLimit * (double)3, (double)this.flexibleFanoutBrokerMaxFetchLimit());
            double leaderReplicationLimit = Math.max((double)this.leaderQuotaManager().upperBound(), (double)3 * produceLimit);
            double followerReplicationLimit = Math.max((double)this.followerQuotaManager().upperBound(), (double)3 * produceLimit);
            this.info((Function0<String> & Serializable)() -> "Broker fanout ratio=" + brokerFanoutRatio + ", new broker produce limit=" + produceLimit + ", new broker fetch limit=" + fetchLimit + ", leader replication broker quota to " + leaderReplicationLimit + ", follower replication broker quota to " + followerReplicationLimit);
            this.produceQuotaManager().setBrokerQuotaLimit(produceLimit);
            this.fetchQuotaManager().setBrokerQuotaLimit(fetchLimit);
            this.updateReplicationQuota(leaderReplicationLimit, followerReplicationLimit);
            this.updateTenantDynamicQuota(topLevelQuotaEntities, (long)produceLimit, (long)fetchLimit);
            return;
        }
        this.info((Function0<String> & Serializable)() -> "Reset produce/fetch/leader replication/follower replication broker quota to default.");
        this.produceQuotaManager().resetBrokerQuotaLimit();
        this.fetchQuotaManager().resetBrokerQuotaLimit();
        this.updateReplicationQuota(this.leaderQuotaManager().config().quotaBytesPerSecondDefault, this.followerQuotaManager().config().quotaBytesPerSecondDefault);
        this.quotaCallback().cleanUpTenantDynamicQuotas(CollectionConverters$.MODULE$.MutableSeqHasAsJava((Seq)topLevelQuotaEntities.map((Function1<Map, java.util.Map> & Serializable)x$1 -> CollectionConverters$.MODULE$.MapHasAsJava(x$1).asJava())).asJava(), tenantWithFlexFanoutEnabled);
    }

    public boolean isAboveFlexFanoutLazyEvaluationThreshold() {
        return this.isAboveFlexFanoutLazyEvaluationThreshold(this.getTopLevelQuotaEntities());
    }

    private Seq<Map<String, String>> getTopLevelQuotaEntities() {
        Seq<Map<String, String>> activeTenants = this.produceQuotaManager().getActiveQuotaEntities();
        Map groupedQuotaEntities = activeTenants.groupBy((Function1<Map, Map> & Serializable)tags -> CollectionConverters$.MODULE$.MapHasAsScala(this.quotaCallback().parentQuotaMetricTags(this.produceQuotaManager().clientQuotaType(), CollectionConverters$.MODULE$.MapHasAsJava(tags).asJava())).asScala().toMap($less$colon$less$.MODULE$.refl()));
        Seq topLevelQuotaEntities = (Seq)groupedQuotaEntities.getOrElse(Predef$.MODULE$.Map().empty(), (Function0<Seq> & Serializable)() -> (Seq)Seq$.MODULE$.empty());
        return topLevelQuotaEntities;
    }

    private boolean isAboveFlexFanoutLazyEvaluationThreshold(Seq<Map<String, String>> entities) {
        long produceTotalUsage = this.getTotalUsageByType(entities, this.produceQuotaManager());
        long fetchTotalUsage = this.getTotalUsageByType(entities, this.fetchQuotaManager());
        double produceLazyEvaluationThreshold = this.flexibleFanoutLazyEvaluationThreshold() * this.produceQuotaManager().getBrokerQuotaLimit();
        double fetchLazyEvaluationThreshold = this.flexibleFanoutLazyEvaluationThreshold() * this.fetchQuotaManager().getBrokerQuotaLimit();
        this.info((Function0<String> & Serializable)() -> "Broker produce total usage=" + produceTotalUsage + ", produce lazy evaluation threshold=" + produceLazyEvaluationThreshold + ", fetch total usage=" + fetchTotalUsage + ", fetch lazy evaluation threshold=" + fetchLazyEvaluationThreshold);
        return (double)produceTotalUsage >= produceLazyEvaluationThreshold || (double)fetchTotalUsage >= fetchLazyEvaluationThreshold;
    }

    private long getTotalUsageByType(Seq<Map<String, String>> entities, ClientQuotaManager manager) {
        DoubleRef totalUsage = DoubleRef.create(0.0);
        entities.foreach((Function1<Map, Object> & Serializable)metricTags -> {
            FlexFanoutQuotaManager.$anonfun$getTotalUsageByType$1(this, manager, totalUsage, metricTags);
            return BoxedUnit.UNIT;
        });
        return (long)totalUsage.elem;
    }

    private double getBrokerFanoutRatio(Seq<Map<String, String>> entities) {
        DoubleRef totalProduceUsage = DoubleRef.create(0.0);
        DoubleRef totalFetchUsage = DoubleRef.create(0.0);
        entities.foreach((Function1<Map, Object> & Serializable)metricTags -> {
            FlexFanoutQuotaManager.$anonfun$getBrokerFanoutRatio$1(this, totalProduceUsage, totalFetchUsage, metricTags);
            return BoxedUnit.UNIT;
        });
        if (totalProduceUsage.elem == 0.0) {
            return Double.MAX_VALUE;
        }
        return totalFetchUsage.elem / totalProduceUsage.elem;
    }

    private void updateReplicationQuota(double leaderQuotaLimit, double followerQuotaLimit) {
        this.leaderQuotaManager().updateQuota(Quota.upperBound(leaderQuotaLimit));
        this.followerQuotaManager().updateQuota(Quota.upperBound(followerQuotaLimit));
    }

    private void updateTenantDynamicQuota(Seq<Map<String, String>> topLevelQuotaEntities, long produceLimit, long fetchLimit) {
        HashMap<java.util.Map<String, String>, java.util.Map<String, Long>> dynamicQuotas = new HashMap<java.util.Map<String, String>, java.util.Map<String, Long>>();
        HashMap<String, Long> quotas = new HashMap<String, Long>();
        quotas.put(ClientQuotaType.PRODUCE.toString(), produceLimit);
        quotas.put(ClientQuotaType.FETCH.toString(), fetchLimit);
        java.util.Set<String> tenantsWithFlexFanoutEnabled = this.quotaCallback().getTenantWithFlexFanoutEnabled();
        if (!tenantsWithFlexFanoutEnabled.isEmpty()) {
            topLevelQuotaEntities.foreach((Function1<Map, Object> & Serializable)entity -> {
                FlexFanoutQuotaManager.$anonfun$updateTenantDynamicQuota$1(tenantsWithFlexFanoutEnabled, dynamicQuotas, quotas, entity);
                return BoxedUnit.UNIT;
            });
        }
        if (!dynamicQuotas.isEmpty()) {
            this.quotaCallback().updateDynamicQuotas(dynamicQuotas);
            return;
        }
    }

    public boolean isFlexFanoutEnabled(Map<String, String> entity) {
        return this.quotaCallback().getTenantWithFlexFanoutEnabled().contains(entity.getOrElse("tenant", (Function0<String> & Serializable)() -> "")) && entity.keySet().diff((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tenant"}))).isEmpty();
    }

    public boolean isDynamicQuotaComputedByFlexFanout(QuotaEntity quotaEntity) {
        FlexFanoutMode flexFanoutMode = this.flexibleFanoutMode();
        FlexFanoutMode flexFanoutMode2 = FlexFanoutMode.BROKER_QUOTA;
        if (!(flexFanoutMode != null ? !((Object)((Object)flexFanoutMode)).equals((Object)flexFanoutMode2) : flexFanoutMode2 != null)) {
            if (this.isFlexFanoutEnabled(quotaEntity.entityTypes().toMap($less$colon$less$.MODULE$.refl())) && this.isAboveFlexFanoutLazyEvaluationThreshold()) {
                return true;
            }
        }
        return false;
    }

    public double getMinProduceLimit() {
        return this.produceQuotaManager().getBrokerQuotaLimitByPercent(this.flexibleFanoutBrokerMinProducerPercentage() * 0.01);
    }

    public static final /* synthetic */ void $anonfun$getTotalUsageByType$1(FlexFanoutQuotaManager $this, ClientQuotaManager manager$1, DoubleRef totalUsage$1, Map metricTags) {
        KafkaMetric metric = $this.metrics().metrics().get(manager$1.clientRateMetricName(metricTags));
        if (metric != null) {
            totalUsage$1.elem += BoxesRunTime.unboxToDouble(metric.metricValue());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$getBrokerFanoutRatio$1(FlexFanoutQuotaManager $this, DoubleRef totalProduceUsage$1, DoubleRef totalFetchUsage$1, Map metricTags) {
        KafkaMetric fetchMetric;
        KafkaMetric produceMetric = $this.metrics().metrics().get($this.produceQuotaManager().clientRateMetricName(metricTags));
        if (produceMetric != null) {
            totalProduceUsage$1.elem += BoxesRunTime.unboxToDouble(produceMetric.metricValue());
        }
        if ((fetchMetric = $this.metrics().metrics().get($this.fetchQuotaManager().clientRateMetricName(metricTags))) != null) {
            totalFetchUsage$1.elem += BoxesRunTime.unboxToDouble(fetchMetric.metricValue());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateTenantDynamicQuota$1(java.util.Set tenantsWithFlexFanoutEnabled$1, java.util.Map dynamicQuotas$1, java.util.Map quotas$1, Map entity) {
        entity.values().foreach((Function1<String, Object> & Serializable)tenant -> {
            if (tenantsWithFlexFanoutEnabled$1.contains(tenant)) {
                return dynamicQuotas$1.put(CollectionConverters$.MODULE$.MapHasAsJava(entity).asJava(), quotas$1);
            }
            return BoxedUnit.UNIT;
        });
    }

    public FlexFanoutQuotaManager(FlexFanoutManagerConfig config, Metrics metrics, Scheduler scheduler, Optional<ClientQuotaCallback> clientQuotaCallback, QuotaFactory.QuotaManagers quotaManagers) {
        this.config = config;
        this.metrics = metrics;
        this.scheduler = scheduler;
        this.clientQuotaCallback = clientQuotaCallback;
        this.quotaManagers = quotaManagers;
        Logging.$init$(this);
        this.flexibleFanoutEnabled = config.flexibleFanoutEnabled;
        this.flexibleFanoutMode = FlexFanoutMode.forName(config.flexibleFanoutMode);
        this.flexibleFanoutLazyEvaluationThreshold = config.flexibleFanoutLazyEvaluationThreshold;
        this.flexibleFanoutBrokerNetworkOutBandwidth = config.flexibleFanoutBrokerNetworkOutBandwidth;
        this.flexibleFanoutBrokerStorageBandwidth = config.flexibleFanoutBrokerStorageBandwidth;
        this.flexibleFanoutBrokerRatioReCalculateIntervalMs = config.flexibleFanoutBrokerRatioReCalculateIntervalMs;
        this.flexibleFanoutBrokerMinProducerPercentage = config.flexibleFanoutBrokerMinProducerPercentage;
        this.flexibleFanoutBrokerMaxProduceLimit = config.flexibleFanoutBrokerMaxProduceLimit;
        this.flexibleFanoutBrokerMaxFetchLimit = config.flexibleFanoutBrokerMaxFetchLimit;
        this.produceQuotaManager = quotaManagers.produce();
        this.fetchQuotaManager = quotaManagers.fetch();
        this.leaderQuotaManager = quotaManagers.leader();
        this.followerQuotaManager = quotaManagers.follower();
        this.quotaCallback = null;
    }
}

