/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import kafka.cluster.EndPoint;
import kafka.server.BrokerServer;
import kafka.server.BrokerServer$;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.Server;
import kafka.server.Server$;
import kafka.server.SharedServer;
import kafka.server.StandardFaultHandlerFactory;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Mx4jLoader$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.raft.QuorumConfig;
import org.apache.kafka.server.ProcessRole;
import org.apache.kafka.server.ServerSocketFactory;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015g\u0001\u0002\u0013&\u0001)B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\")A\n\u0001C\u0001\u001b\"Q\u0011\u000b\u0001I\u0001\u0002\u0007\u0005\u000b\u0011\u0002*\t\u000f\r\u0004!\u0019!C\u0005I\"1Q\r\u0001Q\u0001\nUCqA\u001a\u0001C\u0002\u0013%q\r\u0003\u0004i\u0001\u0001\u0006I!\u0018\u0005\bS\u0002\u0011\r\u0011\"\u0003k\u0011\u0019\u0001\b\u0001)A\u0005W\"9\u0011\u000f\u0001b\u0001\n\u0003\u0011\bBB?\u0001A\u0003%1\u000fC\u0004\u007f\u0001\t\u0007I\u0011A@\t\u0011\u0005\r\u0002\u0001)A\u0005\u0003\u0003A\u0011\"!\n\u0001\u0005\u0004%I!a\n\t\u0011\u0005=\u0002\u0001)A\u0005\u0003SA\u0011\"!\r\u0001\u0005\u0004%I!a\r\t\u0011\u0005u\u0002\u0001)A\u0005\u0003kA\u0011\"a\u0010\u0001\u0005\u0004%I!!\u0011\t\u0011\u0005-\u0003\u0001)A\u0005\u0003\u0007Bq!!\u0014\u0001\t\u0003\ny\u0005C\u0004\u0002X\u0001!\t%a\u0014\t\u000f\u0005e\u0003\u0001\"\u0011\u0002P\u001d9\u00111L\u0013\t\u0002\u0005ucA\u0002\u0013&\u0011\u0003\ty\u0006\u0003\u0004M3\u0011\u0005\u0011\u0011\r\u0005\n\u0003GJ\"\u0019!C\u0001\u0003KB\u0001\"!\u001c\u001aA\u0003%\u0011q\r\u0005\n\u0003_J\"\u0019!C\u0001\u0003cB\u0001\"a\u001f\u001aA\u0003%\u00111\u000f\u0005\n\u0003{J\"\u0019!C\u0001\u0003\u007fB\u0001\"a\"\u001aA\u0003%\u0011\u0011\u0011\u0005\b\u0003\u0013KB\u0011AAF\u0011%\t9,\u0007b\u0001\n\u0003\tI\f\u0003\u0005\u0002Df\u0001\u000b\u0011BA^\u0005=Y\u0015MZ6b%\u00064GoU3sm\u0016\u0014(B\u0001\u0014(\u0003\u0019\u0019XM\u001d<fe*\t\u0001&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001Y\u0013'\u000e\t\u0003Y=j\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005I\u001aT\"A\u0013\n\u0005Q*#AB*feZ,'\u000f\u0005\u00027s5\tqG\u0003\u00029O\u0005)Q\u000f^5mg&\u0011!h\u000e\u0002\b\u0019><w-\u001b8h\u0003\u0019\u0019wN\u001c4jOB\u0011!'P\u0005\u0003}\u0015\u00121bS1gW\u0006\u001cuN\u001c4jO\u0006!A/[7f!\t\t%*D\u0001C\u0015\tA4I\u0003\u0002E\u000b\u000611m\\7n_:T!\u0001\u000b$\u000b\u0005\u001dC\u0015AB1qC\u000eDWMC\u0001J\u0003\ry'oZ\u0005\u0003\u0017\n\u0013A\u0001V5nK\u00061A(\u001b8jiz\"2AT(Q!\t\u0011\u0004\u0001C\u0003<\u0007\u0001\u0007A\bC\u0003@\u0007\u0001\u0007\u0001)A\u0002yIE\u0002B\u0001L*V;&\u0011A+\f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005Y[V\"A,\u000b\u0005aK\u0016A\u00039s_B,'\u000f^5fg*\u0011!,R\u0001\t[\u0016$\u0018\rZ1uC&\u0011Al\u0016\u0002\u0017\u001b\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3t\u000b:\u001cX-\u001c2mKB\u0011a,Y\u0007\u0002?*\u0011\u0001-W\u0001\nE>|Go\u001d;sCBL!AY0\u0003#\t{w\u000e^:ue\u0006\u0004X*\u001a;bI\u0006$\u0018-A\tnKR\f\u0007K]8qg\u0016s7/Z7cY\u0016,\u0012!V\u0001\u0013[\u0016$\u0018\r\u0015:paN,en]3nE2,\u0007%A\tc_>$8\u000f\u001e:ba6+G/\u00193bi\u0006,\u0012!X\u0001\u0013E>|Go\u001d;sCBlU\r^1eCR\f\u0007%A\u0004nKR\u0014\u0018nY:\u0016\u0003-\u0004\"\u0001\u001c8\u000e\u00035T!![\"\n\u0005=l'aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u0005\u0019R.\u001e7uSR+g.\u00198u\u001b\u0016$\u0018\rZ1uCV\t1\u000fE\u0002-iZL!!^\u0017\u0003\r=\u0003H/[8o!\t980D\u0001y\u0015\tI(0A\u0006nk2$\u0018\u000e^3oC:$(B\u0001\u0014F\u0013\ta\bPA\nNk2$\u0018\u000eV3oC:$X*\u001a;bI\u0006$\u0018-\u0001\u000bnk2$\u0018\u000eV3oC:$X*\u001a;bI\u0006$\u0018\rI\u0001\u0016S:$XM\u001d\"s_.,'\u000fU8si\u001a+H/\u001e:f+\t\t\t\u0001\u0005\u0003-i\u0006\r\u0001CBA\u0003\u0003'\t9\"\u0004\u0002\u0002\b)!\u0011\u0011BA\u0006\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003\u001b\ty!\u0001\u0003vi&d'BAA\t\u0003\u0011Q\u0017M^1\n\t\u0005U\u0011q\u0001\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007\u0003BA\r\u0003?i!!a\u0007\u000b\t\u0005u\u0011qB\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\"\u0005m!aB%oi\u0016<WM]\u0001\u0017S:$XM\u001d\"s_.,'\u000fU8si\u001a+H/\u001e:fA\u0005a1\u000f[1sK\u0012\u001cVM\u001d<feV\u0011\u0011\u0011\u0006\t\u0004e\u0005-\u0012bAA\u0017K\ta1\u000b[1sK\u0012\u001cVM\u001d<fe\u0006i1\u000f[1sK\u0012\u001cVM\u001d<fe\u0002\naA\u0019:pW\u0016\u0014XCAA\u001b!\u0011aC/a\u000e\u0011\u0007I\nI$C\u0002\u0002<\u0015\u0012AB\u0011:pW\u0016\u00148+\u001a:wKJ\fqA\u0019:pW\u0016\u0014\b%\u0001\u0006d_:$(o\u001c7mKJ,\"!a\u0011\u0011\t1\"\u0018Q\t\t\u0004e\u0005\u001d\u0013bAA%K\t\u00012i\u001c8ue>dG.\u001a:TKJ4XM]\u0001\fG>tGO]8mY\u0016\u0014\b%A\u0004ti\u0006\u0014H/\u001e9\u0015\u0005\u0005E\u0003c\u0001\u0017\u0002T%\u0019\u0011QK\u0017\u0003\tUs\u0017\u000e^\u0001\tg\",H\u000fZ8x]\u0006i\u0011m^1jiNCW\u000f\u001e3po:\fqbS1gW\u0006\u0014\u0016M\u001a;TKJ4XM\u001d\t\u0003ee\u0019\"!G\u0016\u0015\u0005\u0005u\u0013!D'fi\u0006$\u0017\r^1U_BL7-\u0006\u0002\u0002hA!\u0011\u0011DA5\u0013\u0011\tY'a\u0007\u0003\rM#(/\u001b8h\u00039iU\r^1eCR\fGk\u001c9jG\u0002\n\u0011#T3uC\u0012\fG/\u0019)beRLG/[8o+\t\t\u0019\b\u0005\u0003\u0002v\u0005]T\"A\"\n\u0007\u0005e4I\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002%5+G/\u00193bi\u0006\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0010\u001b\u0016$\u0018\rZ1uCR{\u0007/[2JIV\u0011\u0011\u0011\u0011\t\u0005\u0003k\n\u0019)C\u0002\u0002\u0006\u000e\u0013A!V;jI\u0006\u0001R*\u001a;bI\u0006$\u0018\rV8qS\u000eLE\rI\u0001\u0012S:LG/[1mSj,Gj\\4ESJ\u001cHc\u0002*\u0002\u000e\u0006=\u0015q\u0014\u0005\u0006w\u0005\u0002\r\u0001\u0010\u0005\b\u0003#\u000b\u0003\u0019AAJ\u0003\rawn\u001a\t\u0005\u0003+\u000bY*\u0004\u0002\u0002\u0018*\u0019\u0011\u0011\u0014%\u0002\u000bMdg\r\u000e6\n\t\u0005u\u0015q\u0013\u0002\u0007\u0019><w-\u001a:\t\u000f\u0005\u0005\u0016\u00051\u0001\u0002$\u0006IAn\\4Qe\u00164\u0017\u000e\u001f\t\u0005\u0003K\u000b\u0019L\u0004\u0003\u0002(\u0006=\u0006cAAU[5\u0011\u00111\u0016\u0006\u0004\u0003[K\u0013A\u0002\u001fs_>$h(C\u0002\u000226\na\u0001\u0015:fI\u00164\u0017\u0002BA6\u0003kS1!!-.\u00031\u0019wN\u001c4jON\u001b\u0007.Z7b+\t\tY\f\u0005\u0003\u0002>\u0006}V\"A-\n\u0007\u0005\u0005\u0017LA\tLC\u001a\\\u0017mQ8oM&<7k\u00195f[\u0006\fQbY8oM&<7k\u00195f[\u0006\u0004\u0003")
public class KafkaRaftServer
implements Server,
Logging {
    private final KafkaConfig config;
    private final Time time;
    private final /* synthetic */ Tuple2 x$1;
    private final MetaPropertiesEnsemble metaPropsEnsemble;
    private final BootstrapMetadata bootstrapMetadata;
    private final Metrics metrics;
    private final Option<MultiTenantMetadata> multiTenantMetadata;
    private final Option<CompletableFuture<Integer>> interBrokerPortFuture;
    private final SharedServer sharedServer;
    private final Option<BrokerServer> broker;
    private final Option<ControllerServer> controller;
    private com.typesafe.scalalogging.Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static KafkaConfigSchema configSchema() {
        return KafkaRaftServer$.MODULE$.configSchema();
    }

    public static Tuple2<MetaPropertiesEnsemble, BootstrapMetadata> initializeLogDirs(KafkaConfig config, Logger log, String logPrefix) {
        return KafkaRaftServer$.MODULE$.initializeLogDirs(config, log, logPrefix);
    }

    public static Uuid MetadataTopicId() {
        return KafkaRaftServer$.MODULE$.MetadataTopicId();
    }

    public static TopicPartition MetadataPartition() {
        return KafkaRaftServer$.MODULE$.MetadataPartition();
    }

    public static String MetadataTopic() {
        return KafkaRaftServer$.MODULE$.MetadataTopic();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private com.typesafe.scalalogging.Logger logger$lzycompute() {
        KafkaRaftServer kafkaRaftServer = this;
        synchronized (kafkaRaftServer) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public com.typesafe.scalalogging.Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private MetaPropertiesEnsemble metaPropsEnsemble() {
        return this.metaPropsEnsemble;
    }

    private BootstrapMetadata bootstrapMetadata() {
        return this.bootstrapMetadata;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    public Option<MultiTenantMetadata> multiTenantMetadata() {
        return this.multiTenantMetadata;
    }

    public Option<CompletableFuture<Integer>> interBrokerPortFuture() {
        return this.interBrokerPortFuture;
    }

    private SharedServer sharedServer() {
        return this.sharedServer;
    }

    private Option<BrokerServer> broker() {
        return this.broker;
    }

    private Option<ControllerServer> controller() {
        return this.controller;
    }

    @Override
    public void startup() {
        Mx4jLoader$.MODULE$.maybeLoad();
        this.controller().foreach((Function1<ControllerServer, Object> & Serializable)x$2 -> {
            x$2.startup();
            return BoxedUnit.UNIT;
        });
        this.broker().foreach((Function1<BrokerServer, Object> & Serializable)x$3 -> {
            x$3.startup();
            return BoxedUnit.UNIT;
        });
        AppInfoParser.registerAppInfo(Server$.MODULE$.MetricsPrefix(), Integer.toString(this.config.brokerId()), this.metrics(), this.time.milliseconds());
        this.info((Function0<String> & Serializable)() -> KafkaBroker$.MODULE$.STARTED_MESSAGE());
    }

    @Override
    public void shutdown() {
        this.broker().foreach((Function1<BrokerServer, Object> & Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        this.controller().foreach((Function1<ControllerServer, Object> & Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        CoreUtils$.MODULE$.swallow(() -> AppInfoParser.unregisterAppInfo(Server$.MODULE$.MetricsPrefix(), Integer.toString($this.config.brokerId()), this.metrics()), this, CoreUtils$.MODULE$.swallow$default$3());
        this.multiTenantMetadata().foreach((Function1<MultiTenantMetadata, Object> & Serializable)x$6 -> {
            x$6.close(this.config.brokerSessionUuid());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void awaitShutdown() {
        this.broker().foreach((Function1<BrokerServer, Object> & Serializable)x$7 -> {
            x$7.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        this.controller().foreach((Function1<ControllerServer, Object> & Serializable)x$8 -> {
            x$8.awaitShutdown();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$interBrokerPortFuture$1(KafkaRaftServer $this, EndPoint endpoint) {
        return endpoint.listenerName().equals($this.config.interBrokerListenerName());
    }

    public static final /* synthetic */ void $anonfun$interBrokerPortFuture$2(KafkaRaftServer $this, ObjectRef future$1, EndPoint listener) {
        if (listener.port() != 0) {
            future$1.elem = new Some<CompletableFuture<Integer>>(CompletableFuture.completedFuture($this.config.interBrokerPortFromEffectiveAdvertisedListeners()));
            return;
        }
    }

    public KafkaRaftServer(KafkaConfig config, Time time) {
        this.config = config;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq("[KafkaRaftServer nodeId=" + config.nodeId() + "] ");
        Tuple2<MetaPropertiesEnsemble, BootstrapMetadata> tuple2 = KafkaRaftServer$.MODULE$.initializeLogDirs(config, this.logger().underlying(), this.logIdent());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        MetaPropertiesEnsemble metaPropsEnsemble = tuple2._1();
        BootstrapMetadata bootstrapMetadata = tuple2._2();
        this.x$1 = new Tuple2<MetaPropertiesEnsemble, BootstrapMetadata>(metaPropsEnsemble, bootstrapMetadata);
        this.metaPropsEnsemble = (MetaPropertiesEnsemble)this.x$1._1();
        this.bootstrapMetadata = (BootstrapMetadata)this.x$1._2();
        this.metrics = Server$.MODULE$.initializeMetrics(config, time, this.metaPropsEnsemble().clusterId().get());
        this.multiTenantMetadata = Option$.MODULE$.apply(ConfluentConfigs.buildMultitenantMetadata(config.values(), this.metrics()));
        ObjectRef<None$> future = ObjectRef.create(None$.MODULE$);
        config.listeners().find((Function1<EndPoint, Object> & Serializable)endpoint -> BoxesRunTime.boxToBoolean(KafkaRaftServer.$anonfun$interBrokerPortFuture$1(this, endpoint))).foreach((Function1<EndPoint, Object> & Serializable)listener -> {
            KafkaRaftServer.$anonfun$interBrokerPortFuture$2(this, future, listener);
            return BoxedUnit.UNIT;
        });
        this.interBrokerPortFuture = (Option)future.elem;
        this.sharedServer = new SharedServer(config, this.metaPropsEnsemble(), time, this.metrics(), CompletableFuture.completedFuture(QuorumConfig.parseVoterConnections(config.quorumConfig().voters())), QuorumConfig.parseBootstrapServers(config.quorumConfig().bootstrapServers()), new StandardFaultHandlerFactory(), ServerSocketFactory.INSTANCE, this.multiTenantMetadata(), KafkaRaftServer$.MODULE$.configSchema(), this.interBrokerPortFuture());
        this.broker = config.processRoles().contains(ProcessRole.BrokerRole) ? new Some<BrokerServer>(new BrokerServer(this.sharedServer(), BrokerServer$.MODULE$.$lessinit$greater$default$2())) : None$.MODULE$;
        this.controller = config.processRoles().contains(ProcessRole.ControllerRole) ? new Some<ControllerServer>(new ControllerServer(this.sharedServer(), KafkaRaftServer$.MODULE$.configSchema(), this.bootstrapMetadata())) : None$.MODULE$;
    }
}

