/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkData;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ConnectionMode$Inbound$;
import kafka.server.link.LazyResource;
import kafka.utils.Logging;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ClusterLinkPausedException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.metrics.Sensor;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0005\u0005Eg!\u0002\u0015*\u0003\u0003\u0001\u0004\u0002C#\u0001\u0005\u000b\u0007I\u0011\u0001$\t\u0011)\u0003!\u0011!Q\u0001\n\u001dC\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t\u001f\u0002\u0011)\u0019!C\u0001!\"AA\f\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003_\u0011!\t\u0007A!A!\u0002\u0013\u0011\u0007\u0002C3\u0001\u0005\u0003\u0005\u000b\u0011\u00024\t\u000b)\u0004A\u0011A6\t\u000fM\u0004!\u0019!C\ti\"9\u0011\u0011\u0001\u0001!\u0002\u0013)\b\"CA\u0002\u0001\t\u0007I\u0011CA\u0003\u0011!\t9\u0002\u0001Q\u0001\n\u0005\u001d\u0001\"CA\r\u0001\u0001\u0007I\u0011BA\u000e\u0011%\ti\u0002\u0001a\u0001\n\u0013\ty\u0002C\u0004\u0002,\u0001\u0001\u000b\u0015\u0002'\t\u0015\u0005U\u0002\u00011A\u0005\u0012%\n9\u0004\u0003\u0006\u0002@\u0001\u0001\r\u0011\"\u0005*\u0003\u0003B\u0001\"!\u0012\u0001A\u0003&\u0011\u0011\b\u0005\n\u0003\u0013\u0002\u0001\u0019!C\t\u0003oA\u0011\"a\u0013\u0001\u0001\u0004%\t\"!\u0014\t\u0011\u0005E\u0003\u0001)Q\u0005\u0003sA\u0011\"!\u0016\u0001\u0005\u0004%\t!a\u0016\t\u0011\u0005u\u0004\u0001)A\u0005\u00033Bq!a \u0001\t\u0003\n\t\t\u0003\u0005\u0002\u0004\u0002!\t%KAC\u0011\u001d\tY\n\u0001C!\u0003;Cq!a)\u0001\t\u0003\n\t\tC\u0004\u0002&\u0002!\t\"!!\t\u000f\u0005\u001d\u0006\u0001\"\u0011\u00028!9\u0011\u0011\u0016\u0001\u0005B\u0005m\u0001bBAV\u0001\u0011\u0005\u0011Q\u0016\u0005\b\u0003k\u0003A\u0011CAA\u0011\u001d\t9\f\u0001C\t\u0003\u0003Cq!!/\u0001\r#\t\t\tC\u0004\u0002<\u00021\t\"!!\t\u000f\u0005u\u0006\u0001\"\u0005\u0002\u0002\"9\u0011q\u0018\u0001\u0005B\u0005]\u0002bBAa\u0001\u0011\u0005\u00131\u0019\u0002\u001d\u00072,8\u000f^3s\u0019&t7nQ8o]\u0016\u001cG/[8o\u001b\u0006t\u0017mZ3s\u0015\tQ3&\u0001\u0003mS:\\'B\u0001\u0017.\u0003\u0019\u0019XM\u001d<fe*\ta&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001\ttg\u0010\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005abdBA\u001d;\u001b\u0005I\u0013BA\u001e*\u0003I\u0019E.^:uKJd\u0015N\\6GC\u000e$xN]=\n\u0005ur$!E\"p]:,7\r^5p]6\u000bg.Y4fe*\u00111(\u000b\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u00056\nQ!\u001e;jYNL!\u0001R!\u0003\u000f1{wmZ5oO\u0006AA.\u001b8l\t\u0006$\u0018-F\u0001H!\tI\u0004*\u0003\u0002JS\ty1\t\\;ti\u0016\u0014H*\u001b8l\t\u0006$\u0018-A\u0005mS:\\G)\u0019;bA\u0005i\u0011N\\5uS\u0006d7i\u001c8gS\u001e\u0004\"!O'\n\u00059K#!E\"mkN$XM\u001d'j].\u001cuN\u001c4jO\u0006\u0019Bn\\2bY2{w-[2bY\u000ecWo\u001d;feV\t\u0011\u000b\u0005\u0002S3:\u00111k\u0016\t\u0003)Nj\u0011!\u0016\u0006\u0003->\na\u0001\u0010:p_Rt\u0014B\u0001-4\u0003\u0019\u0001&/\u001a3fM&\u0011!l\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005a\u001b\u0014\u0001\u00067pG\u0006dGj\\4jG\u0006d7\t\\;ti\u0016\u0014\b%A\bnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s!\tIt,\u0003\u0002aS\tQ2\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u00069Q.\u001a;sS\u000e\u001c\bCA\u001dd\u0013\t!\u0017F\u0001\nDYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001c\u0018\u0001\u00042s_.,'oQ8oM&<\u0007CA4i\u001b\u0005Y\u0013BA5,\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\rqJg.\u001b;?)\u001daWN\\8qcJ\u0004\"!\u000f\u0001\t\u000b\u0015K\u0001\u0019A$\t\u000b-K\u0001\u0019\u0001'\t\u000b=K\u0001\u0019A)\t\u000buK\u0001\u0019\u00010\t\u000b\u0005L\u0001\u0019\u00012\t\u000b\u0015L\u0001\u0019\u00014\u0002\r1Lgn[%e+\u0005)\bC\u0001<\u007f\u001b\u00059(B\u0001=z\u0003\u0019\u0019w.\\7p]*\u0011aF\u001f\u0006\u0003wr\fa!\u00199bG\",'\"A?\u0002\u0007=\u0014x-\u0003\u0002\u0000o\n!Q+^5e\u0003\u001da\u0017N\\6JI\u0002\nqb\u001d;bi\u0016\u001c\u0005.\u00198hK2{7m[\u000b\u0003\u0003\u000f\u0001B!!\u0003\u0002\u00145\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!\u0001\u0003mC:<'BAA\t\u0003\u0011Q\u0017M^1\n\t\u0005U\u00111\u0002\u0002\u0007\u001f\nTWm\u0019;\u0002!M$\u0018\r^3DQ\u0006tw-\u001a'pG.\u0004\u0013!E2mkN$XM\u001d'j].\u001cuN\u001c4jOV\tA*A\u000bdYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e|F%Z9\u0015\t\u0005\u0005\u0012q\u0005\t\u0004e\u0005\r\u0012bAA\u0013g\t!QK\\5u\u0011!\tIcDA\u0001\u0002\u0004a\u0015a\u0001=%c\u0005\u00112\r\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4!Q\r\u0001\u0012q\u0006\t\u0004e\u0005E\u0012bAA\u001ag\tAao\u001c7bi&dW-\u0001\rsKZ,'o]3D_:tWm\u0019;j_:,e.\u00192mK\u0012,\"!!\u000f\u0011\u0007I\nY$C\u0002\u0002>M\u0012qAQ8pY\u0016\fg.\u0001\u000fsKZ,'o]3D_:tWm\u0019;j_:,e.\u00192mK\u0012|F%Z9\u0015\t\u0005\u0005\u00121\t\u0005\n\u0003S\u0011\u0012\u0011!a\u0001\u0003s\t\u0011D]3wKJ\u001cXmQ8o]\u0016\u001cG/[8o\u000b:\f'\r\\3eA!\u001a1#a\f\u0002\u0011%\u001c\u0018i\u0019;jm\u0016\fA\"[:BGRLg/Z0%KF$B!!\t\u0002P!I\u0011\u0011F\u000b\u0002\u0002\u0003\u0007\u0011\u0011H\u0001\nSN\f5\r^5wK\u0002B3AFA\u0018\u0003-i\u0017\r\u001f'pO2+g/\u001a7\u0016\u0005\u0005e\u0003CBA.\u0003S\ni'\u0004\u0002\u0002^)!\u0011qLA1\u0003\u0019\tGo\\7jG*!\u00111MA3\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003O\ny!\u0001\u0003vi&d\u0017\u0002BA6\u0003;\u0012q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-\u001a\t\u0005\u0003_\nI(\u0004\u0002\u0002r)!\u00111OA;\u0003\u0015)g/\u001a8u\u0015\r\t9\b`\u0001\u0006g24GG[\u0005\u0005\u0003w\n\tHA\u0003MKZ,G.\u0001\u0007nCbdun\u001a'fm\u0016d\u0007%A\u0004ti\u0006\u0014H/\u001e9\u0015\u0005\u0005\u0005\u0012a\u0003:fG>tg-[4ve\u0016$b!!\t\u0002\b\u0006-\u0005BBAE5\u0001\u0007A*A\u0005oK^\u001cuN\u001c4jO\"9\u0011Q\u0012\u000eA\u0002\u0005=\u0015aC;qI\u0006$X\rZ&fsN\u0004R!!%\u0002\u0018Fk!!a%\u000b\u0007\u0005U5'\u0001\u0006d_2dWm\u0019;j_:LA!!'\u0002\u0014\n\u00191+\u001a;\u0002)=t\u0017I^1jY\u0006\u0014\u0017\u000e\\5us\u000eC\u0017M\\4f)\u0011\t\t#a(\t\u000f\u0005\u00056\u00041\u0001\u0002:\u0005Y\u0011n]!wC&d\u0017M\u00197f\u0003!\u0019\b.\u001e;e_^t\u0017\u0001D2m_N,7\t\\5f]R\u001c\u0018AB1di&4X-A\u0007dkJ\u0014XM\u001c;D_:4\u0017nZ\u0001\rY&t7n\u00117vgR,'o]\u000b\u0003\u0003_\u0003R!!%\u00022FKA!a-\u0002\u0014\n\u00191+Z9\u0002?\u0015t7/\u001e:f%\u00164XM]:f\u0007>tg.Z2uS>t7/\u00128bE2,G-A\u000esKN,GOU3wKJ\u001cXmQ8o]\u0016\u001cG/[8o\u0003\u0012l\u0017N\\\u0001\u001dGJ,\u0017\r^3SKZ,'o]3D_:tWm\u0019;j_:\fE-\\5o\u0003m\u0019Gn\\:f%\u00164XM]:f\u0007>tg.Z2uS>t\u0017\tZ7j]\u0006)R\u000f\u001d3bi\u0016\f5\r^5wK2Kgn[\"pk:$\u0018!E5t\u0019&t7nQ8pe\u0012Lg.\u0019;pe\u0006\tB.\u001b8l\u0007>|'\u000fZ5oCR|'/\u00133\u0016\u0005\u0005\u0015\u0007#\u0002\u001a\u0002H\u0006-\u0017bAAeg\t1q\n\u001d;j_:\u00042AMAg\u0013\r\tym\r\u0002\u0004\u0013:$\b")
public abstract class ClusterLinkConnectionManager
implements ClusterLinkFactory.ConnectionManager,
Logging {
    private final ClusterLinkData linkData;
    private final String localLogicalCluster;
    private final ClusterLinkMetadataManager metadataManager;
    private final ClusterLinkMetrics metrics;
    private final KafkaConfig brokerConfig;
    private final Uuid linkId;
    private final Object stateChangeLock;
    private volatile ClusterLinkConfig clusterLinkConfig;
    private volatile boolean reverseConnectionEnabled;
    private volatile boolean isActive;
    private final AtomicReference<Level> maxLogLevel;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public void onControllerChange(boolean isActive) {
        ClusterLinkFactory.ConnectionManager.onControllerChange$(this, isActive);
    }

    @Override
    public void onLinkMetadataPartitionLeaderChange() {
        ClusterLinkFactory.ConnectionManager.onLinkMetadataPartitionLeaderChange$(this);
    }

    @Override
    public int persistentConnectionCount() {
        return ClusterLinkFactory.ConnectionManager.persistentConnectionCount$(this);
    }

    @Override
    public int reverseConnectionCount() {
        return ClusterLinkFactory.ConnectionManager.reverseConnectionCount$(this);
    }

    @Override
    public Seq<LazyResource<?>> lazyResources() {
        return ClusterLinkFactory.ConnectionManager.lazyResources$(this);
    }

    private Logger logger$lzycompute() {
        ClusterLinkConnectionManager clusterLinkConnectionManager = this;
        synchronized (clusterLinkConnectionManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public ClusterLinkData linkData() {
        return this.linkData;
    }

    @Override
    public String localLogicalCluster() {
        return this.localLogicalCluster;
    }

    public Uuid linkId() {
        return this.linkId;
    }

    public Object stateChangeLock() {
        return this.stateChangeLock;
    }

    private ClusterLinkConfig clusterLinkConfig() {
        return this.clusterLinkConfig;
    }

    private void clusterLinkConfig_$eq(ClusterLinkConfig x$1) {
        this.clusterLinkConfig = x$1;
    }

    public boolean reverseConnectionEnabled() {
        return this.reverseConnectionEnabled;
    }

    public void reverseConnectionEnabled_$eq(boolean x$1) {
        this.reverseConnectionEnabled = x$1;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void isActive_$eq(boolean x$1) {
        this.isActive = x$1;
    }

    public AtomicReference<Level> maxLogLevel() {
        return this.maxLogLevel;
    }

    @Override
    public void startup() {
        Object object = this.stateChangeLock();
        synchronized (object) {
            this.info((Function0<String> & Serializable)() -> "Cluster link connection manager has started up.");
            if (!Predef$.MODULE$.Boolean2boolean(this.clusterLinkConfig().clusterLinkPaused())) {
                this.isActive_$eq(true);
                this.updateActiveLinkCount();
            } else {
                this.isActive_$eq(false);
            }
            this.resetReverseConnectionAdmin();
        }
    }

    @Override
    public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        Object object = this.stateChangeLock();
        synchronized (object) {
            this.debug((Function0<String> & Serializable)() -> "Reconfiguring link connection manager with new configs updated=" + updatedKeys + " newConfig=" + newConfig.values());
            this.clusterLinkConfig_$eq(newConfig);
            if (Predef$.MODULE$.Boolean2boolean(newConfig.clusterLinkPaused())) {
                if (this.isActive()) {
                    this.info((Function0<String> & Serializable)() -> "Closing clients from cluster link connection manager because link has been paused");
                }
                this.isActive_$eq(false);
                this.closeClients();
            } else {
                this.isActive_$eq(true);
                this.resetReverseConnectionAdmin();
            }
            this.updateActiveLinkCount();
            this.debug((Function0<String> & Serializable)() -> "Completed reconfiguration of cluster link");
        }
    }

    @Override
    public void onAvailabilityChange(boolean isAvailable) {
        if (isAvailable) {
            this.maxLogLevel().set(null);
            return;
        }
        this.maxLogLevel().set(Level.DEBUG);
    }

    @Override
    public void shutdown() {
        Object object = this.stateChangeLock();
        synchronized (object) {
            this.isActive_$eq(false);
            this.closeClients();
            this.lazyResources().foreach((Function1<LazyResource, Object> & Serializable)x$1 -> {
                x$1.shutdown();
                return BoxedUnit.UNIT;
            });
            this.info((Function0<String> & Serializable)() -> "Shutdown of ClusterLinkConnectionManager with cluster link data " + this.linkData());
        }
    }

    public void closeClients() {
        Object object = this.stateChangeLock();
        synchronized (object) {
            this.debug((Function0<String> & Serializable)() -> "Closing clients ");
            this.closeReverseConnectionAdmin();
            this.updateActiveLinkCount();
        }
    }

    @Override
    public boolean active() {
        return this.isActive();
    }

    @Override
    public ClusterLinkConfig currentConfig() {
        return this.clusterLinkConfig();
    }

    @Override
    public Seq<String> linkClusters() {
        return (Seq)new $colon$colon<Nothing$>((Nothing$)((Object)this.localLogicalCluster()), Nil$.MODULE$).$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(this.linkData().clusterId()).toSeq());
    }

    public void ensureReverseConnectionsEnabled() {
        if (!this.isActive() || Predef$.MODULE$.Boolean2boolean(this.clusterLinkConfig().clusterLinkPaused())) {
            throw new ClusterLinkPausedException("Cluster link " + this.linkData().linkName() + " is not active, paused=" + this.clusterLinkConfig().clusterLinkPaused());
        }
        if (!this.reverseConnectionEnabled()) {
            throw new InvalidRequestException("Cluster link '" + this.linkData().linkName() + "' is not a source initiated link");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void resetReverseConnectionAdmin() {
        var1_1 = this.stateChangeLock();
        synchronized (var1_1) {
            block8: {
                config = this.currentConfig();
                if (!this.isActive() || Predef$.MODULE$.Boolean2boolean(config.clusterLinkPaused())) ** GOTO lbl-1000
                if (!config.linkMode().mayActAsDestination()) break block8;
                v0 = config.connectionMode();
                var3_3 = ConnectionMode$Inbound$.MODULE$;
                if (!(v0 == null ? var3_3 != null : v0.equals(var3_3) == false)) ** GOTO lbl-1000
            }
            if (config.linkMode().mayActAsSource()) {
                v1 = config.remoteLinkConnectionMode();
                var4_4 = ConnectionMode$Inbound$.MODULE$;
                ** if (v1 != null ? v1.equals((Object)var4_4) == false : var4_4 != null) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                v2 = true;
                ** GOTO lbl19
            }
lbl-1000:
            // 3 sources

            {
                v2 = false;
            }
lbl19:
            // 2 sources

            this.reverseConnectionEnabled_$eq(v2);
            this.closeReverseConnectionAdmin();
            if (this.reverseConnectionEnabled()) {
                this.debug((Function0<String> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$resetReverseConnectionAdmin$1(kafka.server.link.ClusterLinkConnectionManager ), ()Ljava/lang/String;)((ClusterLinkConnectionManager)this));
                this.createReverseConnectionAdmin();
            } else {
                this.debug((Function0<String> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$resetReverseConnectionAdmin$2(kafka.server.link.ClusterLinkConfig ), ()Ljava/lang/String;)((ClusterLinkConfig)config));
            }
        }
    }

    public abstract void createReverseConnectionAdmin();

    public abstract void closeReverseConnectionAdmin();

    public void updateActiveLinkCount() {
        int count = this.isActive() ? 1 : 0;
        Option$.MODULE$.apply(this.metrics.activeLinkCountSensor()).foreach((Function1<Sensor, Object> & Serializable)x$2 -> {
            x$2.record(count);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public boolean isLinkCoordinator() {
        return this.metadataManager.isLinkCoordinator(this.linkData().linkName());
    }

    @Override
    public Option<Object> linkCoordinatorId() {
        return this.metadataManager.linkCoordinator(this.linkData().linkName(), this.brokerConfig.interBrokerListenerName()).map((Function1<Node, Object> & Serializable)x$3 -> BoxesRunTime.boxToInteger(x$3.id()));
    }

    public static final /* synthetic */ String $anonfun$resetReverseConnectionAdmin$1(ClusterLinkConnectionManager $this) {
        return "Recreating reverse connection clients reverseConnectionEnabled=" + $this.reverseConnectionEnabled();
    }

    public static final /* synthetic */ String $anonfun$resetReverseConnectionAdmin$2(ClusterLinkConfig config$1) {
        return "Not creating reverse connection clients with linkMode=" + config$1.linkMode() + ", connMode=" + config$1.connectionMode() + ", remoteConnMode=" + config$1.remoteLinkConnectionMode();
    }

    public ClusterLinkConnectionManager(ClusterLinkData linkData, ClusterLinkConfig initialConfig, String localLogicalCluster, ClusterLinkMetadataManager metadataManager, ClusterLinkMetrics metrics, KafkaConfig brokerConfig) {
        this.linkData = linkData;
        this.localLogicalCluster = localLogicalCluster;
        this.metadataManager = metadataManager;
        this.metrics = metrics;
        this.brokerConfig = brokerConfig;
        ClusterLinkFactory.ConnectionManager.$init$(this);
        Logging.$init$(this);
        this.linkId = new Uuid(linkData.linkId().getMostSignificantBits(), linkData.linkId().getLeastSignificantBits());
        this.stateChangeLock = new Object();
        this.clusterLinkConfig = initialConfig;
        this.reverseConnectionEnabled = false;
        this.isActive = true;
        this.maxLogLevel = new AtomicReference();
    }
}

