/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkData;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkTopicInfo;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils;
import kafka.server.link.ClusterLinkUtils$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.metadata.TopicType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class MirrorTopicRequestHelperKraft$ {
    public static final MirrorTopicRequestHelperKraft$ MODULE$ = new MirrorTopicRequestHelperKraft$();
    private static final int CreateTopicsVersionWithSourceTopicIdSupport = 7;

    public int CreateTopicsVersionWithSourceTopicIdSupport() {
        return CreateTopicsVersionWithSourceTopicIdSupport;
    }

    public void transformCreatableTopic(ClusterLinkFactory.LinkManager linkManager, CreateTopicsRequestData.CreatableTopic topic, Option<CompletableFuture<ClusterLinkTopicInfo>> sourceTopicInfo, boolean validateOnly, short version) {
        Properties configs = new Properties();
        topic.configs().forEach(entry -> {
            String topicType;
            if (entry.name().equals("confluent.topic.type") && ((topicType = entry.value()).equals(TopicType.VIRTUAL.logConfigValue()) || topicType.equals(TopicType.UNKNOWN.logConfigValue()))) {
                throw new ConfigException("Topic with type: " + entry.value() + " cannot be mirrored");
            }
            configs.setProperty(entry.name(), entry.value());
        });
        ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)linkManager.clusterLinkMetadataManager().getOrElse((Function0<Nothing$> & Serializable)() -> {
            throw new ClusterLinkNotFoundException("Unable to resolve cluster link information for " + topic.name());
        });
        ClusterLinkData linkData = (ClusterLinkData)Option$.MODULE$.apply(topic.linkName()).flatMap((Function1<String, Option> & Serializable)linkName -> metadataManager.getClusterLinkData((String)linkName)).getOrElse((Function0<Nothing$> & Serializable)() -> {
            throw new ClusterLinkNotFoundException("Unable to resolve cluster link information for " + topic.name());
        });
        Uuid linkId = linkData.linkId();
        String tenantPrefix = (String)linkData.tenantPrefix().getOrElse((Function0<String> & Serializable)() -> "");
        ClusterLinkConfig linkConfig = linkManager.linkConfigFromMetadataProps(linkId);
        ClusterLinkUtils.ResolveCreateTopic resolvedMirrorTopic = ClusterLinkUtils$.MODULE$.resolveCreateTopic(topic, new Some<Uuid>(linkId), configs, validateOnly, new Some<ClusterLinkConfig>(linkConfig), sourceTopicInfo, tenantPrefix);
        CreateTopicsRequestData.CreatableTopicConfigCollection finalizedConfigs = new CreateTopicsRequestData.CreatableTopicConfigCollection(resolvedMirrorTopic){
            {
                resolvedMirrorTopic$1.configs().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(x0$1, x1$1) -> {
                    Tuple2<Object, Object> tuple2 = new Tuple2<Object, Object>(x0$1, x1$1);
                    if (tuple2 != null) {
                        Object name = tuple2._1();
                        Object value = tuple2._2();
                        this.add(new CreateTopicsRequestData.CreatableTopicConfig().setName(name.toString()).setValue(value.toString()));
                        return;
                    }
                    throw new MatchError(tuple2);
                }));
            }
        };
        topic.setConfigs(finalizedConfigs);
        topic.setStoppedSequenceNumber(BoxesRunTime.unboxToLong(resolvedMirrorTopic.topicState().map((Function1<ClusterLinkTopicState, Object> & Serializable)x$1 -> BoxesRunTime.boxToLong(x$1.stoppedSequenceNumber())).getOrElse(() -> 0L)));
        Object object = resolvedMirrorTopic.numPartitions() != -1 ? topic.setNumPartitions(resolvedMirrorTopic.numPartitions()) : BoxedUnit.UNIT;
        if (version >= this.CreateTopicsVersionWithSourceTopicIdSupport()) {
            resolvedMirrorTopic.topicState().foreach((Function1<ClusterLinkTopicState, CreateTopicsRequestData.CreatableTopic> & Serializable)state -> topic.setSourceTopicId(state.sourceTopicId()));
        }
        if (resolvedMirrorTopic.topicState().exists((Function1<ClusterLinkTopicState, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(MirrorTopicRequestHelperKraft$.$anonfun$transformCreatableTopic$9(x$2)))) {
            resolvedMirrorTopic.topicState().foreach((Function1<ClusterLinkTopicState, CreateTopicsRequestData.CreatableTopic> & Serializable)state -> topic.setMirrorStartOffsets(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)state.mirrorStartOffsets().map((Function1<Object, Long> & Serializable)x -> Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong(x)))).asJava()));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$transformCreatableTopic$9(ClusterLinkTopicState x$2) {
        return x$2.mirrorStartOffsets().exists(x$3 -> x$3 > 0L);
    }

    private MirrorTopicRequestHelperKraft$() {
    }
}

