/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.client;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import kafka.tier.client.TierTopicClient;
import kafka.tier.topic.TierTopicManagerConfig;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;

public class TierTopicConsumerSupplier
implements Supplier<Consumer<byte[], byte[]>> {
    private static final String CLIENT_TYPE = "consumer";
    private static final String SEPARATOR = "-";
    private final Supplier<Map<String, Object>> interBrokerClientConfigs;
    private final String clusterId;
    private final int brokerId;
    private final String clientIdSuffix;
    private final AtomicInteger instanceId = new AtomicInteger(0);

    public TierTopicConsumerSupplier(TierTopicManagerConfig config, String clientIdSuffix) {
        this.interBrokerClientConfigs = config.interBrokerClientConfigs;
        this.clusterId = config.clusterId;
        this.brokerId = config.brokerId;
        this.clientIdSuffix = clientIdSuffix;
    }

    public TierTopicConsumerSupplier(Supplier<Map<String, Object>> clientConfigs, String clusterId, int brokerId, String clientIdSuffix) {
        this.interBrokerClientConfigs = clientConfigs;
        this.clusterId = clusterId;
        this.brokerId = brokerId;
        this.clientIdSuffix = clientIdSuffix;
    }

    @Override
    public Consumer<byte[], byte[]> get() {
        String clientId = TierTopicConsumerSupplier.clientId(this.clusterId, this.brokerId, this.instanceId.getAndIncrement(), this.clientIdSuffix);
        return new KafkaConsumer<byte[], byte[]>(TierTopicConsumerSupplier.properties(this.interBrokerClientConfigs, clientId));
    }

    static Properties properties(TierTopicManagerConfig config, String clientId) {
        return TierTopicConsumerSupplier.properties(config.interBrokerClientConfigs, clientId);
    }

    static Properties properties(Supplier<Map<String, Object>> clientConfigs, String clientId) {
        Properties properties = new Properties();
        for (Map.Entry<String, Object> configEntry : clientConfigs.get().entrySet()) {
            properties.put(configEntry.getKey(), configEntry.getValue());
        }
        properties.put("auto.offset.reset", "earliest");
        properties.put("client.id", clientId);
        properties.put("enable.auto.commit", "false");
        properties.put("key.deserializer", ByteArrayDeserializer.class.getName());
        properties.put("value.deserializer", ByteArrayDeserializer.class.getName());
        properties.put("confluent.configs.logging.enabled", "false");
        properties.put("enable.metrics.push", "false");
        properties.remove("metric.reporters");
        return properties;
    }

    static String clientId(String clusterId, int brokerId, int instanceId, String clientIdSuffix) {
        return TierTopicClient.clientIdPrefix(CLIENT_TYPE) + SEPARATOR + clusterId + SEPARATOR + brokerId + SEPARATOR + instanceId + SEPARATOR + clientIdSuffix;
    }
}

