/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.encryption;

import com.google.crypto.tink.proto.AesGcmKey;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.KeyStatusType;
import com.google.crypto.tink.proto.Keyset;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;
import kafka.tier.store.encryption.IncompatibleKeysetException;

class Util {
    private static final String AES256_KEY_URL = "type.googleapis.com/google.crypto.tink.AesGcmKey";

    Util() {
    }

    static byte[] extractRawAes256GCMKey(Keyset keyset) {
        AesGcmKey parsed;
        List<Keyset.Key> keys = keyset.getKeyList();
        if (keys.size() != 1) {
            throw new IncompatibleKeysetException("extracting raw key from keyset requires exactly one key, found " + keys.size());
        }
        Keyset.Key key = keys.get(0);
        if (key.getStatus() != KeyStatusType.ENABLED) {
            throw new IncompatibleKeysetException("Key is not enabled");
        }
        if (key.getOutputPrefixType() != OutputPrefixType.RAW) {
            throw new IncompatibleKeysetException("GcsKeysetWriter only supports keys with the RAW prefix");
        }
        KeyData keyData = key.getKeyData();
        if (!keyData.getTypeUrl().equals(AES256_KEY_URL)) {
            throw new IncompatibleKeysetException(String.format("Expected key type '%s', found '%s'", AES256_KEY_URL, keyData.getTypeUrl()));
        }
        ByteString keyValue = key.getKeyData().getValue();
        try {
            parsed = AesGcmKey.parseFrom(keyValue);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IncompatibleKeysetException("Malformed key representation", e);
        }
        return parsed.getKeyValue().toByteArray();
    }
}

