/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects.metadata;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;

public class LifecycleManagerStateMetadata
implements ObjectStoreMetadata {
    private String clusterId;

    public LifecycleManagerStateMetadata(String clusterId) {
        this.clusterId = clusterId;
    }

    @Override
    public Optional<FragmentLocation> toFragmentLocation(String keyPrefix, FragmentType fragmentType) {
        if (fragmentType != FragmentType.LIFECYCLE_MANAGER_STATE) {
            throw new UnsupportedOperationException(String.format("LifecycleManagerStateMetadata cannot get FragmentLocation for fragment type of type %s", fragmentType.name()));
        }
        ObjectType defaultObjectType = ObjectType.getDefaultObjectTypeForFragmentType(fragmentType).get();
        return Optional.of(new FragmentLocation(this.toPath(keyPrefix, defaultObjectType), defaultObjectType));
    }

    private String toPath(String keyPrefix, ObjectType objectType) {
        return keyPrefix + TierObjectStore.DataTypePathPrefix.LIFECYCLE_MANAGER_STATE.prefix + "/" + this.clusterId + "." + objectType.suffix();
    }

    @Override
    public Map<String, String> objectMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("clusterId", this.clusterId());
        return metadata;
    }

    @Override
    public OpaqueData opaqueData() {
        return OpaqueData.ZEROED;
    }

    public String toString() {
        return "LifecycleManagerStateMetadata(clusterId=" + this.clusterId + ")";
    }

    public String clusterId() {
        return this.clusterId;
    }
}

