/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.server.ReplicaManager;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.TierTask;
import kafka.tier.tasks.TierTaskQueue;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.utils.Throttler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005mb\u0001\u0002\b\u0010\u0001YA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A1\b\u0001B\u0001B\u0003%A\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011!I\u0005A!A!\u0002\u0013Q\u0005\u0002\u0003,\u0001\u0005\u0003\u0005\u000b1B,\t\u000bu\u0003A\u0011\u00010\t\u000f\u001d\u0004\u0001\u0019!C\u0005Q\"9\u0001\u0010\u0001a\u0001\n\u0013I\bBB@\u0001A\u0003&\u0011\u000eC\u0004\u0002\u0002\u0001!I!a\u0001\t\u000f\u0005=\u0002\u0001\"\u0003\u00022!9\u00111\u0007\u0001\u0005\u0002\u0005U\"A\u0005+jKJ$\u0016m]6X_J\\\u0017N\\4TKRT!\u0001E\t\u0002\u000bQ\f7o[:\u000b\u0005I\u0019\u0012\u0001\u0002;jKJT\u0011\u0001F\u0001\u0006W\u000647.Y\u0002\u0001+\t92fE\u0002\u00011y\u0001\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011a!\u00118z%\u00164\u0007CA\u0010#\u001b\u0005\u0001#BA\u0011\u0014\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0003EA\u0004M_\u001e<\u0017N\\4\u0002\u0013Q\f7o[)vKV,\u0007c\u0001\u0014(S5\tq\"\u0003\u0002)\u001f\tiA+[3s)\u0006\u001c8.U;fk\u0016\u0004\"AK\u0016\r\u0001\u0011)A\u0006\u0001b\u0001[\t\tA+\u0005\u0002/cA\u0011\u0011dL\u0005\u0003ai\u0011qAT8uQ&tw\rE\u0002'e%J!aM\b\u0003\u0011QKWM\u001d+bg.\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u00027s5\tqG\u0003\u00029'\u000511/\u001a:wKJL!AO\u001c\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006\tB/[3s)>\u0004\u0018nY!qa\u0016tG-\u001a:\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}\n\u0012!\u0002;pa&\u001c\u0017BA!?\u0005E!\u0016.\u001a:U_BL7-\u00119qK:$WM]\u0001\u0010i&,'o\u00142kK\u000e$8\u000b^8sKB\u0011AiR\u0007\u0002\u000b*\u0011a)E\u0001\u0006gR|'/Z\u0005\u0003\u0011\u0016\u0013q\u0002V5fe>\u0013'.Z2u'R|'/Z\u0001\u0005i&lW\r\u0005\u0002L)6\tAJ\u0003\u0002\"\u001b*\u0011ajT\u0001\u0007G>lWn\u001c8\u000b\u0005Q\u0001&BA)S\u0003\u0019\t\u0007/Y2iK*\t1+A\u0002pe\u001eL!!\u0016'\u0003\tQKW.Z\u0001\u0003K\u000e\u0004\"\u0001W.\u000e\u0003eS!A\u0017\u000e\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002]3\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\r}\u00137\rZ3g)\t\u0001\u0017\rE\u0002'\u0001%BQAV\u0004A\u0004]CQ\u0001J\u0004A\u0002\u0015BQ\u0001N\u0004A\u0002UBQaO\u0004A\u0002qBQAQ\u0004A\u0002\rCQ!S\u0004A\u0002)\u000b!b^8sW&twmU3u+\u0005I\u0007c\u00016sk:\u00111\u000e\u001d\b\u0003Y>l\u0011!\u001c\u0006\u0003]V\ta\u0001\u0010:p_Rt\u0014\"A\u000e\n\u0005ET\u0012a\u00029bG.\fw-Z\u0005\u0003gR\u0014A\u0001T5ti*\u0011\u0011O\u0007\t\u00041ZL\u0013BA<Z\u0005\u00191U\u000f^;sK\u0006qqo\u001c:lS:<7+\u001a;`I\u0015\fHC\u0001>~!\tI20\u0003\u0002}5\t!QK\\5u\u0011\u001dq\u0018\"!AA\u0002%\f1\u0001\u001f\u00132\u0003-9xN]6j]\u001e\u001cV\r\u001e\u0011\u0002\u001d\u0019LG\u000e\\,pe.LgnZ*fiR)!0!\u0002\u0002\u0014!9\u0011qA\u0006A\u0002\u0005%\u0011AB2p]\u001aLw\r\u0005\u0003\u0002\f\u0005=QBAA\u0007\u0015\r\t9aD\u0005\u0005\u0003#\tiAA\bUS\u0016\u0014H+Y:lg\u000e{gNZ5h\u0011\u001d\t)b\u0003a\u0001\u0003/\t\u0011\u0002\u001e5s_R$H.\u001a:\u0011\u000be\tI\"!\b\n\u0007\u0005m!D\u0001\u0004PaRLwN\u001c\t\u0005\u0003?\tY#\u0004\u0002\u0002\")\u0019\u0011%a\t\u000b\t\u0005\u0015\u0012qE\u0001\nS:$XM\u001d8bYNT1!!\u000bP\u0003\u001d\u0019Ho\u001c:bO\u0016LA!!\f\u0002\"\tIA\u000b\u001b:piRdWM]\u0001\rIJ\f\u0017N\u001c$viV\u0014Xm\u001d\u000b\u0002u\u00061Am\\,pe.$R![A\u001c\u0003sAq!a\u0002\u000e\u0001\u0004\tI\u0001C\u0004\u0002\u00165\u0001\r!a\u0006")
public class TierTaskWorkingSet<T extends TierTask<T>>
implements Logging {
    private final TierTaskQueue<T> taskQueue;
    private final ReplicaManager replicaManager;
    private final TierTopicAppender tierTopicAppender;
    private final TierObjectStore tierObjectStore;
    private final Time time;
    private final ExecutionContext ec;
    private List<Future<T>> workingSet;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TierTaskWorkingSet tierTaskWorkingSet = this;
        synchronized (tierTaskWorkingSet) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private List<Future<T>> workingSet() {
        return this.workingSet;
    }

    private void workingSet_$eq(List<Future<T>> x$1) {
        this.workingSet = x$1;
    }

    private void fillWorkingSet(TierTasksConfig config, Option<Throttler> throttler) {
        Option<List<T>> option = this.taskQueue.poll();
        if (option instanceof Some) {
            Some some = (Some)option;
            List newTasks = (List)some.value();
            newTasks.foreach((Function1<TierTask, Object> & Serializable)newTask -> {
                this.workingSet_$eq((List)this.workingSet().$colon$plus(newTask.transition(this.time, this.tierTopicAppender, this.tierObjectStore, this.replicaManager, config, throttler, this.ec)));
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    private void drainFutures() {
        Tuple2<List<Future<T>>, List<Future<T>>> tuple2 = this.workingSet().partition((Function1<Future, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.isCompleted()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List<Future<T>> completed = tuple2._1();
        List<Future<T>> inProgress = tuple2._2();
        Tuple2<List<Future<T>>, List<Future<T>>> tuple22 = new Tuple2<List<Future<T>>, List<Future<T>>>(completed, inProgress);
        List completed2 = tuple22._1();
        List inProgress2 = tuple22._2();
        this.workingSet_$eq(inProgress2);
        this.debug((Function0<String> & Serializable)() -> inProgress2.size() + " tasks still in progress");
        this.debug((Function0<String> & Serializable)() -> completed2.size() + " tasks completed");
        completed2.foreach((Function1<Future, Object> & Serializable)taskFuture -> {
            TierTaskWorkingSet.$anonfun$drainFutures$4(this, taskFuture);
            return BoxedUnit.UNIT;
        });
    }

    public List<Future<T>> doWork(TierTasksConfig config, Option<Throttler> throttler) {
        this.fillWorkingSet(config, throttler);
        this.drainFutures();
        return this.workingSet();
    }

    public static final /* synthetic */ void $anonfun$drainFutures$4(TierTaskWorkingSet $this, Future taskFuture) {
        TierTask task = (TierTask)Await$.MODULE$.result(taskFuture, new package.DurationInt(package$.MODULE$.DurationInt(0)).seconds());
        $this.debug((Function0<String> & Serializable)() -> "completing task " + task);
        $this.taskQueue.done(task);
    }

    public TierTaskWorkingSet(TierTaskQueue<T> taskQueue, ReplicaManager replicaManager, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, Time time, ExecutionContext ec) {
        this.taskQueue = taskQueue;
        this.replicaManager = replicaManager;
        this.tierTopicAppender = tierTopicAppender;
        this.tierObjectStore = tierObjectStore;
        this.time = time;
        this.ec = ec;
        Logging.$init$(this);
        this.workingSet = Nil$.MODULE$;
    }
}

