/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.util.Set;
import kafka.tier.TopicIdPartition;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.SelectFileTierPartitionStatePolicyUtils;
import kafka.tier.tools.SelectRemoteFurthestFileTierPartitionStatePolicy;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;

class SelectRemoteFurthestFileTierPartitionStateCommand {
    static final String COMMAND = "select-remote-furthest-ftps";
    static final String RECONCILED_DATA_LOSS_VALIDATOR_OUTPUT = "reconciled-data-loss-validator-output";
    private static final String RECONCILED_DATA_LOSS_VALIDATOR_OUTPUT_DOC = "path to reconciled output of data loss validator";
    static final String NONRECONCILED_DATA_LOSS_VALIDATOR_OUTPUT = "nonreconciled-data-loss-validator-output";
    private static final String NONRECONCILED_DATA_LOSS_VALIDATOR_OUTPUT_DOC = "path to output of data loss validator from one broker (not reconciled)";
    static final String AFFECTED_TOPIC_PARTITIONS_FILE_PATH = "affected-topic-partitions";
    private static final String AFFECTED_TOPIC_PARTITIONS_FILE_PATH_DOC = "path to the file containing raw list of affected topic-partitions";
    static final String REMOTE_RECOVERY_DIR = "remote-recovery-dir";
    private static final String REMOTE_RECOVERY_DIR_DOC = "path to the recovery folder in object store, e.g.: prefix/recovery-rcca-1234";
    static final String SKIP_REPLICATION_FACTOR_CHECK = "skip-replication-factor-check";
    private static final String SKIP_REPLICATION_FACTOR_CHECK_DOC = "skip the replication factor check for the affected topic partitions";
    static final String REPLICATION_FACTOR_OVERRIDE = "replication-factor-override";
    private static final String REPLICATION_FACTOR_OVERRIDE_DOC = "value to override the default replication factor i.e 3";
    static final String OUTPUT_DIR = "output-dir";
    private static final String OUTPUT_DIR_DOC = "output directory path where the output of select ftps is stored";

    private SelectRemoteFurthestFileTierPartitionStateCommand() {
    }

    public static void addCommand(Subparsers subparsers) {
        Subparser parser = subparsers.addParser(COMMAND).help("Fetches the furthest FTPSs for affected topic partitions from the recovery dir on the object store\n");
        MutuallyExclusiveGroup runScopeGroup = parser.addMutuallyExclusiveGroup().required(true);
        runScopeGroup.addArgument(RecoveryUtils.makeArgument(RECONCILED_DATA_LOSS_VALIDATOR_OUTPUT)).dest(RECONCILED_DATA_LOSS_VALIDATOR_OUTPUT).action(Arguments.store()).type(Arguments.fileType().verifyCanRead()).help(RECONCILED_DATA_LOSS_VALIDATOR_OUTPUT_DOC);
        runScopeGroup.addArgument(RecoveryUtils.makeArgument(NONRECONCILED_DATA_LOSS_VALIDATOR_OUTPUT)).dest(NONRECONCILED_DATA_LOSS_VALIDATOR_OUTPUT).action(Arguments.store()).type(Arguments.fileType().verifyCanRead()).help(NONRECONCILED_DATA_LOSS_VALIDATOR_OUTPUT_DOC);
        runScopeGroup.addArgument(RecoveryUtils.makeArgument(AFFECTED_TOPIC_PARTITIONS_FILE_PATH)).dest(AFFECTED_TOPIC_PARTITIONS_FILE_PATH).action(Arguments.store()).type(Arguments.fileType().verifyCanRead()).help(AFFECTED_TOPIC_PARTITIONS_FILE_PATH_DOC);
        parser.addArgument(RecoveryUtils.makeArgument("tier.config")).dest("tier.config").action(Arguments.store()).type(Arguments.fileType().verifyCanRead()).required(true).help("The path to a configuration file containing the required properties");
        parser.addArgument(RecoveryUtils.makeArgument(SKIP_REPLICATION_FACTOR_CHECK)).dest(SKIP_REPLICATION_FACTOR_CHECK).action(Arguments.storeTrue()).help(SKIP_REPLICATION_FACTOR_CHECK_DOC);
        parser.addArgument(RecoveryUtils.makeArgument(REPLICATION_FACTOR_OVERRIDE)).dest(REPLICATION_FACTOR_OVERRIDE).action(Arguments.store()).type(Integer.class).setDefault((Object)3).help(REPLICATION_FACTOR_OVERRIDE_DOC);
        parser.addArgument(RecoveryUtils.makeArgument(REMOTE_RECOVERY_DIR)).dest(REMOTE_RECOVERY_DIR).action(Arguments.store()).type(String.class).required(true).help(REMOTE_RECOVERY_DIR_DOC);
        parser.addArgument(RecoveryUtils.makeArgument(OUTPUT_DIR)).dest(OUTPUT_DIR).action(Arguments.store()).type(String.class).required(true).help(OUTPUT_DIR_DOC);
    }

    public static int execute(Namespace args) throws Exception {
        String reconciledDlvOutputPath = args.getString(RECONCILED_DATA_LOSS_VALIDATOR_OUTPUT);
        String nonReconciledDlvOutputPath = args.getString(NONRECONCILED_DATA_LOSS_VALIDATOR_OUTPUT);
        String affectedTopicPartitionsFilePath = args.getString(AFFECTED_TOPIC_PARTITIONS_FILE_PATH);
        String adminConfigFile = args.getString("admin.config");
        String tierConfigFile = args.getString("tier.config").trim();
        String remoteRecoveryDir = args.getString(REMOTE_RECOVERY_DIR);
        boolean skipReplicationFactorCheck = args.getBoolean(SKIP_REPLICATION_FACTOR_CHECK);
        Integer replicationFactorOverride = args.getInt(REPLICATION_FACTOR_OVERRIDE);
        String bootstrapServers = args.getString("bootstrap-servers");
        String outputDir = args.getString(OUTPUT_DIR);
        Set<TopicIdPartition> affectedTopicPartitions = SelectFileTierPartitionStatePolicyUtils.getAffectedTopicPartitions(reconciledDlvOutputPath, nonReconciledDlvOutputPath, affectedTopicPartitionsFilePath);
        SelectRemoteFurthestFileTierPartitionStatePolicy selectRemoteFurthestFTPS = new SelectRemoteFurthestFileTierPartitionStatePolicy(remoteRecoveryDir, tierConfigFile, adminConfigFile, bootstrapServers, skipReplicationFactorCheck, replicationFactorOverride, outputDir);
        selectRemoteFurthestFTPS.run(affectedTopicPartitions);
        return 0;
    }
}

