/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kafka.tier.TopicIdPartition;
import kafka.tier.tools.TierRecoveryDataUploadJobStatus;

public class TierRecoveryDataUploadResult {
    private final String identifier;
    private TierRecoveryDataUploadJobStatus status = TierRecoveryDataUploadJobStatus.NOT_RUNNING;
    private Map<TopicIdPartition, String> failedPartitions = null;
    private boolean metadataUploadCompleted = false;
    private String metadataUploadFailedExceptionMessage = null;
    private boolean tierOffsetsUploadCompleted = false;
    private String tierOffsetsUploadFailedExceptionMessage = null;

    public static TierRecoveryDataUploadResult makeDummyJobResult() {
        TierRecoveryDataUploadResult res = new TierRecoveryDataUploadResult("unknown-result");
        res.setStatus(TierRecoveryDataUploadJobStatus.UNKNOWN);
        return res;
    }

    public TierRecoveryDataUploadResult(String identifier) {
        this.identifier = identifier;
    }

    public void setStatus(TierRecoveryDataUploadJobStatus status) {
        this.status = status;
    }

    public void setFailedPartitions(Map<TopicIdPartition, String> failedPartitions) {
        this.failedPartitions = failedPartitions;
    }

    public void setMetadataUploadFailed(Exception e) {
        this.metadataUploadCompleted = false;
        this.metadataUploadFailedExceptionMessage = String.format("%s:%s", e.getClass().getName(), e.getMessage());
    }

    public void setMetadataUploadSucceeded() {
        this.metadataUploadCompleted = true;
        this.metadataUploadFailedExceptionMessage = null;
    }

    public void setTierOffsetsUploadFailed(Exception e) {
        this.tierOffsetsUploadCompleted = false;
        this.tierOffsetsUploadFailedExceptionMessage = String.format("%s:%s", e.getClass().getName(), e.getMessage());
    }

    public void setTierOffsetsUploadSucceeded() {
        this.tierOffsetsUploadCompleted = true;
        this.tierOffsetsUploadFailedExceptionMessage = null;
    }

    public String identifier() {
        return this.identifier;
    }

    public TierRecoveryDataUploadJobStatus status() {
        return this.status;
    }

    public Map<TopicIdPartition, String> failedPartitions() {
        return this.failedPartitions;
    }

    public boolean metadataUploadCompleted() {
        return this.metadataUploadCompleted;
    }

    public String metadataUploadFailedExceptionMessage() {
        return this.metadataUploadFailedExceptionMessage;
    }

    public boolean tierOffsetsUploadCompleted() {
        return this.tierOffsetsUploadCompleted;
    }

    public String tierOffsetsUploadFailedExceptionMessage() {
        return this.tierOffsetsUploadFailedExceptionMessage;
    }

    public String toString() {
        return "TierRecoveryDataUploadResult{identifier=" + this.identifier + ", status=" + String.valueOf((Object)this.status) + ", failedPartitions=" + this.failedPartitionsToString() + ", metadataUploadCompleted=" + this.metadataUploadCompleted + ", metadataUploadFailedExceptionMessage=" + this.metadataUploadFailedExceptionMessage + ", tierOffsetsUploadCompleted=" + this.tierOffsetsUploadCompleted + ", tierOffsetsUploadFailedExceptionMessage=" + this.tierOffsetsUploadFailedExceptionMessage + "}";
    }

    private String failedPartitionsToString() {
        return this.failedPartitions.entrySet().stream().map(entry -> String.format("tp=%s -> ex=%s", ((TopicIdPartition)entry.getKey()).toString(), entry.getValue())).collect(Collectors.joining(", "));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TierRecoveryDataUploadResult that = (TierRecoveryDataUploadResult)obj;
        return Objects.equals(this.identifier, that.identifier) && this.status == that.status && Objects.equals(this.failedPartitions, that.failedPartitions) && this.metadataUploadCompleted == that.metadataUploadCompleted && Objects.equals(this.metadataUploadFailedExceptionMessage, that.metadataUploadFailedExceptionMessage) && this.tierOffsetsUploadCompleted == that.tierOffsetsUploadCompleted && Objects.equals(this.tierOffsetsUploadFailedExceptionMessage, that.tierOffsetsUploadFailedExceptionMessage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.status, this.failedPartitions, this.metadataUploadCompleted, this.metadataUploadFailedExceptionMessage, this.tierOffsetsUploadCompleted, this.tierOffsetsUploadFailedExceptionMessage});
    }
}

