/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import kafka.utils.Logging;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$mcJJ$sp;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0005Q3A!\u0004\b\u0001'!Aa\u0004\u0001B\u0001B\u0003%q\u0004C\u0003/\u0001\u0011\u0005q\u0006C\u00043\u0001\u0001\u0007I\u0011B\u001a\t\u000fQ\u0002\u0001\u0019!C\u0005k!11\b\u0001Q!\n-Bq\u0001\u0010\u0001A\u0002\u0013%1\u0007C\u0004>\u0001\u0001\u0007I\u0011\u0002 \t\r\u0001\u0003\u0001\u0015)\u0003,\u0011\u001d\t\u0005A1A\u0005\n\tCa!\u0014\u0001!\u0002\u0013\u0019\u0005\"\u0002(\u0001\t\u0003y\u0005\"B*\u0001\t\u0003y%a\u0004+ie\u0016\fGm]\"qk6+G/\u001a:\u000b\u0005=\u0001\u0012!B;uS2\u001c(\"A\t\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0006\u000e\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\r\u0005s\u0017PU3g!\tYB$D\u0001\u000f\u0013\tibBA\u0004M_\u001e<\u0017N\\4\u0002\u000fQD'/Z1egB\u0019\u0001\u0005K\u0016\u000f\u0005\u00052cB\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\u0013\u0003\u0019a$o\\8u}%\tq#\u0003\u0002(-\u00059\u0001/Y2lC\u001e,\u0017BA\u0015+\u0005\r\u0019V-\u001d\u0006\u0003OY\u0001\"!\u0006\u0017\n\u000552\"\u0001\u0002'p]\u001e\fa\u0001P5oSRtDC\u0001\u00192!\tY\u0002\u0001C\u0003\u001f\u0005\u0001\u0007q$A\u0011dk6,H.\u0019;jm\u0016$\u0006N]3bI\u000e\u0003X\u000fV5nK&sg*\u00198p'\u0016\u001c7/F\u0001,\u0003\u0015\u001aW/\\;mCRLg/\u001a+ie\u0016\fGm\u00119v)&lW-\u00138OC:|7+Z2t?\u0012*\u0017\u000f\u0006\u00027sA\u0011QcN\u0005\u0003qY\u0011A!\u00168ji\"9!\bBA\u0001\u0002\u0004Y\u0013a\u0001=%c\u0005\u00113-^7vY\u0006$\u0018N^3UQJ,\u0017\rZ\"qkRKW.Z%o\u001d\u0006twnU3dg\u0002\nAc]=ti\u0016lG+[7f\u0013:t\u0015M\\8TK\u000e\u001c\u0018\u0001G:zgR,W\u000eV5nK&sg*\u00198p'\u0016\u001c7o\u0018\u0013fcR\u0011ag\u0010\u0005\bu\u001d\t\t\u00111\u0001,\u0003U\u0019\u0018p\u001d;f[RKW.Z%o\u001d\u0006twnU3dg\u0002\na\u0002\u0016%S\u000b\u0006#u,\u0014-`\u0005\u0016\u000be*F\u0001D!\t!5*D\u0001F\u0015\t1u)\u0001\u0006nC:\fw-Z7f]RT!\u0001S%\u0002\t1\fgn\u001a\u0006\u0002\u0015\u0006!!.\u0019<b\u0013\taUI\u0001\u0007UQJ,\u0017\rZ'Y\u0005\u0016\fg.A\bU\u0011J+\u0015\tR0N1~\u0013U)\u0011(!\u0003q\u0019w.\u001c9vi\u0016\u001c\u0005/^+uS2L'0\u0019;j_:\u0004VM]2f]R$\u0012\u0001\u0015\t\u0003+EK!A\u0015\f\u0003\r\u0011{WO\u00197f\u0003i\u0011XO\\\"qkV#\u0018\u000e\\5{CRLwN\u001c\"f]\u000eDW.\u0019:l\u0001")
public class ThreadsCpuMeter
implements Logging {
    private final Seq<Object> threads;
    private long cumulativeThreadCpuTimeInNanoSecs;
    private long systemTimeInNanoSecs;
    private final ThreadMXBean THREAD_MX_BEAN;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ThreadsCpuMeter threadsCpuMeter = this;
        synchronized (threadsCpuMeter) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private long cumulativeThreadCpuTimeInNanoSecs() {
        return this.cumulativeThreadCpuTimeInNanoSecs;
    }

    private void cumulativeThreadCpuTimeInNanoSecs_$eq(long x$1) {
        this.cumulativeThreadCpuTimeInNanoSecs = x$1;
    }

    private long systemTimeInNanoSecs() {
        return this.systemTimeInNanoSecs;
    }

    private void systemTimeInNanoSecs_$eq(long x$1) {
        this.systemTimeInNanoSecs = x$1;
    }

    private ThreadMXBean THREAD_MX_BEAN() {
        return this.THREAD_MX_BEAN;
    }

    public double computeCpuUtilizationPercent() {
        if (!this.THREAD_MX_BEAN().isThreadCpuTimeSupported() || !this.THREAD_MX_BEAN().isThreadCpuTimeEnabled()) {
            return 0.0;
        }
        Tuple2$mcJJ$sp tuple2$mcJJ$sp = new Tuple2$mcJJ$sp(this.cumulativeThreadCpuTimeInNanoSecs(), this.systemTimeInNanoSecs());
        if (tuple2$mcJJ$sp == null) {
            throw new MatchError(tuple2$mcJJ$sp);
        }
        long lastCpuTime = ((Tuple2)tuple2$mcJJ$sp)._1$mcJ$sp();
        long lastSystemTime = ((Tuple2)tuple2$mcJJ$sp)._2$mcJ$sp();
        Tuple2$mcJJ$sp tuple2$mcJJ$sp2 = new Tuple2$mcJJ$sp(lastCpuTime, lastSystemTime);
        long lastCpuTime2 = ((Tuple2)tuple2$mcJJ$sp2)._1$mcJ$sp();
        long lastSystemTime2 = ((Tuple2)tuple2$mcJJ$sp2)._2$mcJ$sp();
        this.cumulativeThreadCpuTimeInNanoSecs_$eq(BoxesRunTime.unboxToLong(((IterableOnceOps)this.threads.map(x$2 -> this.THREAD_MX_BEAN().getThreadCpuTime(x$2))).sum(Numeric.LongIsIntegral$.MODULE$)));
        this.systemTimeInNanoSecs_$eq(System.nanoTime());
        int numProcessors = Runtime.getRuntime().availableProcessors();
        this.debug((Function0<String> & Serializable)() -> "Last-CPU = " + lastCpuTime2 + " Current-Cpu = " + this.cumulativeThreadCpuTimeInNanoSecs());
        if (lastCpuTime2 == 0L || lastSystemTime2 == 0L || this.systemTimeInNanoSecs() == lastSystemTime2) {
            return 0.0;
        }
        return (double)(this.cumulativeThreadCpuTimeInNanoSecs() - lastCpuTime2) / (double)((this.systemTimeInNanoSecs() - lastSystemTime2) * (long)numProcessors);
    }

    public double runCpuUtilizationBenchmark() {
        int iterations = 1000000;
        long begin = System.nanoTime();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), iterations).foreach(x$3 -> {
            int n = x$3;
            return this.computeCpuUtilizationPercent();
        });
        long end = System.nanoTime();
        this.debug((Function0<String> & Serializable)() -> "computeCpuUtilizationPercent Benchmark time " + (end - begin) / (long)iterations);
        return (double)(end - begin) / (double)iterations;
    }

    public ThreadsCpuMeter(Seq<Object> threads) {
        this.threads = threads;
        Logging.$init$(this);
        this.cumulativeThreadCpuTimeInNanoSecs = 0L;
        this.systemTimeInNanoSecs = 0L;
        this.THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    }
}

