/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.rest.datapreview.extension.service;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.connect.rest.datapreview.extension.entities.ConnectorDataPreviewRequest;
import io.confluent.connect.rest.datapreview.extension.service.ConnectorDataPreviewConfig;
import io.confluent.connect.rest.datapreview.extension.util.CreateConnectorRequestTranslator;
import io.confluent.connect.rest.datapreview.extension.util.PreviewRecordTransformer;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.runtime.isolation.PluginType;
import org.apache.kafka.connect.runtime.rest.entities.CreateConnectorRequest;
import org.apache.kafka.connect.runtime.rest.entities.PluginInfo;
import org.apache.kafka.connect.runtime.rest.resources.ConnectorPluginsResource;
import org.apache.kafka.connect.runtime.rest.resources.ConnectorsResource;
import org.apache.kafka.connect.transforms.Filter;
import org.apache.kafka.connect.transforms.predicates.TopicNameMatches;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorDataPreviewService {
    private static final Logger log = LoggerFactory.getLogger(ConnectorDataPreviewService.class);
    public static final String DATA_PREVIEW_ID_PROPERTY = "datapreview.id";
    private static final String DATA_PREVIEW_PREFIX = "data-preview";
    private static final String DELIMITER = "-";
    private static final String DATA_PREVIEW_INTERNAL_PREFIX = "data-preview-internal-";
    private static final String DATA_FILTER_TRANSFORM_NAME = "data-preview-internal-dataFilter";
    private static final String DATA_FILTER_PREDICATE_NAME = "data-preview-internal-dataTopicMatcher";
    private static final String SCHEMA_ENABLE_SUFFIX = ".schemas.enable";
    public static final String DATA_PREVIEW_SCHEMA_ENABLE_CONFIG = "datapreview.schemas.enable";
    private final ConnectorsResource connectorsResource;
    private final ConnectorPluginsResource connectorPluginsResource;
    private final Map<String, String> workerConfigs;
    private final CreateConnectorRequestTranslator createConnectorRequestTranslator;

    public ConnectorDataPreviewService(ConnectorsResource connectorsResource, ConnectorPluginsResource connectorPluginsResource, Map<String, Object> workerConfigs) {
        this.connectorsResource = connectorsResource;
        this.connectorPluginsResource = connectorPluginsResource;
        this.workerConfigs = workerConfigs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)e.getValue()));
        this.createConnectorRequestTranslator = new CreateConnectorRequestTranslator();
    }

    @VisibleForTesting
    ConnectorDataPreviewService(ConnectorsResource connectorsResource, ConnectorPluginsResource connectorPluginsResource, Map<String, String> workerConfigs, CreateConnectorRequestTranslator createConnectorRequestTranslator) {
        this.connectorsResource = connectorsResource;
        this.connectorPluginsResource = connectorPluginsResource;
        this.workerConfigs = workerConfigs;
        this.createConnectorRequestTranslator = createConnectorRequestTranslator;
    }

    public Response createDataPreview(ConnectorDataPreviewRequest request, HttpHeaders headers) throws Throwable {
        String previewId = this.generatePreviewId(request);
        String traceTopicName = this.generateTraceTopicName(request, previewId);
        this.validateTaskLimits(request.config());
        request.config().putIfAbsent(DATA_PREVIEW_ID_PROPERTY, previewId);
        this.applyFilterTransforms(request);
        this.addTraceConfigs(request, traceTopicName);
        CreateConnectorRequest createConnectorRequest = this.createConnectorRequestTranslator.apply(request);
        return this.connectorsResource.putConnectorConfig(createConnectorRequest.name(), headers, null, createConnectorRequest.config(), Boolean.valueOf(false));
    }

    @VisibleForTesting
    void addTraceConfigs(ConnectorDataPreviewRequest createRequest, String traceTopicName) {
        createRequest.config().put("trace.records.enable", "true");
        createRequest.config().putIfAbsent("trace.records.topic", traceTopicName);
        createRequest.config().put("trace.records.value.converter", JsonConverter.class.getName());
        createRequest.config().put("trace.records.key.converter", JsonConverter.class.getName());
        String previewSchemasEnable = createRequest.config().getOrDefault(DATA_PREVIEW_SCHEMA_ENABLE_CONFIG, "false");
        createRequest.config().put("trace.records.value.converter.schemas.enable", previewSchemasEnable);
        createRequest.config().put("trace.records.key.converter.schemas.enable", previewSchemasEnable);
        if (PluginType.SOURCE.toString().equals(this.getConnectorType(createRequest.config().get("connector.class")))) {
            String removeFilterMessagesTransform = "removeDataFilterMessages";
            createRequest.config().put("trace.records.transforms", "removeDataFilterMessages");
            String transformConfigPrefix = "trace.records.transforms.removeDataFilterMessages.";
            createRequest.config().put("trace.records.transforms.removeDataFilterMessages.type", PreviewRecordTransformer.class.getName());
            int expectedRecords = 1;
            if (createRequest.config().containsKey("transforms")) {
                expectedRecords += createRequest.config().get("transforms").split(",").length;
            }
            createRequest.config().put("trace.records.transforms.removeDataFilterMessages.expected.total.steps", Integer.toString(expectedRecords));
        }
    }

    String generateTraceTopicName(ConnectorDataPreviewRequest request, String previewId) {
        String topicName = request.config().get("trace.records.topic");
        return null == topicName ? previewId : topicName;
    }

    @VisibleForTesting
    String generatePreviewId(ConnectorDataPreviewRequest request) {
        String previewId = request.config().getOrDefault(DATA_PREVIEW_ID_PROPERTY, "");
        if (previewId.isEmpty()) {
            String connectorName = request.config().getOrDefault("name", "");
            previewId = String.join((CharSequence)DELIMITER, DATA_PREVIEW_PREFIX, connectorName);
        }
        return previewId;
    }

    @VisibleForTesting
    public String getConnectorType(String connectorClassOrAlias) {
        Optional<PluginInfo> pluginInfo = this.connectorPluginsResource.listConnectorPlugins(true).stream().filter(x -> x.className().equals(connectorClassOrAlias) || ConnectorDataPreviewService.alias(x.className()).equals(connectorClassOrAlias)).findFirst();
        if (pluginInfo.isPresent()) {
            return pluginInfo.get().type();
        }
        log.error("Failed to find any class that implements Connector and which name matches");
        throw new ConnectException("Failed to find any class that implements Connector and which name matches " + connectorClassOrAlias);
    }

    public static String alias(String pluginClassName) {
        String simple = pluginClassName.substring(pluginClassName.lastIndexOf(".") + 1);
        int pos = simple.lastIndexOf("Connector");
        if (pos > 0) {
            return simple.substring(0, pos);
        }
        return simple;
    }

    @VisibleForTesting
    public void applyFilterTransforms(ConnectorDataPreviewRequest createRequest) {
        if (PluginType.SINK.toString().equals(this.getConnectorType(createRequest.config().get("connector.class")))) {
            return;
        }
        Object transforms = createRequest.config().getOrDefault("transforms", "");
        transforms = ((String)transforms).isEmpty() ? DATA_FILTER_TRANSFORM_NAME : (String)transforms + ",data-preview-internal-dataFilter";
        createRequest.config().put("transforms", (String)transforms);
        String filterTransformsPrefix = "transforms.data-preview-internal-dataFilter";
        createRequest.config().putIfAbsent("transforms.data-preview-internal-dataFilter.type", Filter.class.getName());
        createRequest.config().putIfAbsent("transforms.data-preview-internal-dataFilter.predicates", DATA_FILTER_PREDICATE_NAME);
        createRequest.config().putIfAbsent("predicates", DATA_FILTER_PREDICATE_NAME);
        String filterTransformsPredicatePrefix = "predicates.data-preview-internal-dataTopicMatcher";
        createRequest.config().putIfAbsent("predicates.data-preview-internal-dataTopicMatcher.type", TopicNameMatches.class.getName());
        createRequest.config().putIfAbsent("predicates.data-preview-internal-dataTopicMatcher.pattern", ".*");
    }

    public void validateTaskLimits(Map<String, String> config) {
        String maxTasksAllowed = this.workerConfigs.getOrDefault("datapreview.tasks.max", String.valueOf(ConnectorDataPreviewConfig.DATA_PREVIEW_MAX_TASKS_DEFAULT));
        String connectorMaxTasks = config.getOrDefault("tasks.max", String.valueOf(1));
        if (Integer.parseInt(connectorMaxTasks) > Integer.parseInt(maxTasksAllowed)) {
            throw new BadRequestException(String.format("The value of %s should not be greater than %s", "tasks.max", "datapreview.tasks.max"));
        }
    }
}

