/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import io.confluent.kafkarest.KafkaRestApplication;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.rest.RestConfigException;
import java.io.IOException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaRestMain {
    private static final Logger log = LoggerFactory.getLogger(KafkaRestMain.class);

    public static void main(String[] args) throws IOException {
        try {
            KafkaRestConfig config = new KafkaRestConfig(args.length > 0 ? args[0] : null);
            KafkaRestApplication app = new KafkaRestApplication(config);
            app.start();
            log.info("Server started, listening for requests...");
            app.join();
        }
        catch (RestConfigException e) {
            log.error("Server configuration failed: ", (Throwable)e);
            System.exit(1);
        }
        catch (Exception e) {
            log.error("Server died unexpectedly: ", (Throwable)e);
            System.exit(1);
        }
    }

    static {
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession sslSession) {
                return hostname.equals("localhost");
            }
        });
    }
}

