/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy;
import io.confluent.kafkarest.config.ConfigModule;
import io.confluent.kafkarest.controllers.AclManager;
import io.confluent.kafkarest.controllers.AclManagerImpl;
import io.confluent.kafkarest.controllers.BrokerConfigManager;
import io.confluent.kafkarest.controllers.BrokerConfigManagerImpl;
import io.confluent.kafkarest.controllers.BrokerManager;
import io.confluent.kafkarest.controllers.BrokerManagerImpl;
import io.confluent.kafkarest.controllers.ClusterConfigManager;
import io.confluent.kafkarest.controllers.ClusterConfigManagerImpl;
import io.confluent.kafkarest.controllers.ClusterManager;
import io.confluent.kafkarest.controllers.ClusterManagerImpl;
import io.confluent.kafkarest.controllers.ConsumerAssignmentManager;
import io.confluent.kafkarest.controllers.ConsumerAssignmentManagerImpl;
import io.confluent.kafkarest.controllers.ConsumerGroupLagSummaryManager;
import io.confluent.kafkarest.controllers.ConsumerGroupLagSummaryManagerImpl;
import io.confluent.kafkarest.controllers.ConsumerGroupManager;
import io.confluent.kafkarest.controllers.ConsumerGroupManagerImpl;
import io.confluent.kafkarest.controllers.ConsumerLagManager;
import io.confluent.kafkarest.controllers.ConsumerLagManagerImpl;
import io.confluent.kafkarest.controllers.ConsumerManager;
import io.confluent.kafkarest.controllers.ConsumerManagerImpl;
import io.confluent.kafkarest.controllers.NoSchemaRecordSerializer;
import io.confluent.kafkarest.controllers.PartitionManager;
import io.confluent.kafkarest.controllers.PartitionManagerImpl;
import io.confluent.kafkarest.controllers.ProduceController;
import io.confluent.kafkarest.controllers.ProduceControllerImpl;
import io.confluent.kafkarest.controllers.ReassignmentManager;
import io.confluent.kafkarest.controllers.ReassignmentManagerImpl;
import io.confluent.kafkarest.controllers.RecordSerializer;
import io.confluent.kafkarest.controllers.RecordSerializerFacade;
import io.confluent.kafkarest.controllers.ReplicaManager;
import io.confluent.kafkarest.controllers.ReplicaManagerImpl;
import io.confluent.kafkarest.controllers.SchemaManager;
import io.confluent.kafkarest.controllers.SchemaManagerImpl;
import io.confluent.kafkarest.controllers.SchemaManagerThrowing;
import io.confluent.kafkarest.controllers.SchemaRecordSerializer;
import io.confluent.kafkarest.controllers.SchemaRecordSerializerImpl;
import io.confluent.kafkarest.controllers.SchemaRecordSerializerThrowing;
import io.confluent.kafkarest.controllers.TopicConfigManager;
import io.confluent.kafkarest.controllers.TopicConfigManagerImpl;
import io.confluent.kafkarest.controllers.TopicManager;
import io.confluent.kafkarest.controllers.TopicManagerImpl;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

public final class ControllersModule
extends AbstractBinder {
    protected void configure() {
        this.bind(AclManagerImpl.class).to(AclManager.class);
        this.bind(BrokerConfigManagerImpl.class).to(BrokerConfigManager.class);
        this.bind(BrokerManagerImpl.class).to(BrokerManager.class);
        this.bind(ClusterConfigManagerImpl.class).to(ClusterConfigManager.class);
        this.bind(ClusterManagerImpl.class).to(ClusterManager.class);
        this.bind(ConsumerAssignmentManagerImpl.class).to(ConsumerAssignmentManager.class);
        this.bind(ConsumerGroupLagSummaryManagerImpl.class).to(ConsumerGroupLagSummaryManager.class);
        this.bind(ConsumerGroupManagerImpl.class).to(ConsumerGroupManager.class);
        this.bind(ConsumerLagManagerImpl.class).to(ConsumerLagManager.class);
        this.bind(ConsumerManagerImpl.class).to(ConsumerManager.class);
        this.bindAsContract(NoSchemaRecordSerializer.class).in(Singleton.class);
        this.bind(PartitionManagerImpl.class).to(PartitionManager.class);
        this.bind(ProduceControllerImpl.class).to(ProduceController.class);
        this.bind(ReassignmentManagerImpl.class).to(ReassignmentManager.class);
        this.bind(RecordSerializerFacade.class).to(RecordSerializer.class);
        this.bind(ReplicaManagerImpl.class).to(ReplicaManager.class);
        this.bindFactory(SchemaManagerFactory.class).to(SchemaManager.class);
        this.bind(TopicConfigManagerImpl.class).to(TopicConfigManager.class);
        this.bind(TopicManagerImpl.class).to(TopicManager.class);
        this.bindFactory(SchemaRecordSerializerFactory.class).to(SchemaRecordSerializer.class).in(Singleton.class);
    }

    private static final class SchemaManagerFactory
    implements Factory<SchemaManager> {
        private final Optional<SchemaRegistryClient> schemaRegistryClient;
        private final SubjectNameStrategy defaultSubjectNameStrategy;

        @Inject
        private SchemaManagerFactory(Optional<SchemaRegistryClient> schemaRegistryClient, SubjectNameStrategy defaultSubjectNameStrategy) {
            this.schemaRegistryClient = Objects.requireNonNull(schemaRegistryClient);
            this.defaultSubjectNameStrategy = Objects.requireNonNull(defaultSubjectNameStrategy);
        }

        public SchemaManager provide() {
            if (this.schemaRegistryClient.isPresent()) {
                return new SchemaManagerImpl(this.schemaRegistryClient.get(), this.defaultSubjectNameStrategy);
            }
            return new SchemaManagerThrowing();
        }

        public void dispose(SchemaManager schemaRecordSerializer) {
        }
    }

    private static final class SchemaRecordSerializerFactory
    implements Factory<SchemaRecordSerializer> {
        private final Optional<SchemaRegistryClient> schemaRegistryClient;
        private final Map<String, Object> avroSerializerConfigs;
        private final Map<String, Object> jsonschemaSerializerConfigs;
        private final Map<String, Object> protobufSerializerConfigs;
        private final boolean nullRequestBodyAlwaysPublishEmptyRecord;

        @Inject
        private SchemaRecordSerializerFactory(Optional<SchemaRegistryClient> schemaRegistryClient, @ConfigModule.AvroSerializerConfigs Map<String, Object> avroSerializerConfigs, @ConfigModule.JsonschemaSerializerConfigs Map<String, Object> jsonschemaSerializerConfigs, @ConfigModule.ProtobufSerializerConfigs Map<String, Object> protobufSerializerConfigs, @ConfigModule.NullRequestBodyAlwaysPublishEmptyRecordEnabledConfig Boolean nullRequestBodyAlwaysPublishEmptyRecord) {
            this.schemaRegistryClient = Objects.requireNonNull(schemaRegistryClient);
            this.avroSerializerConfigs = Objects.requireNonNull(avroSerializerConfigs);
            this.jsonschemaSerializerConfigs = Objects.requireNonNull(jsonschemaSerializerConfigs);
            this.protobufSerializerConfigs = Objects.requireNonNull(protobufSerializerConfigs);
            this.nullRequestBodyAlwaysPublishEmptyRecord = nullRequestBodyAlwaysPublishEmptyRecord;
        }

        @Singleton
        public SchemaRecordSerializer provide() {
            if (this.schemaRegistryClient.isPresent()) {
                return new SchemaRecordSerializerImpl(this.schemaRegistryClient.get(), this.avroSerializerConfigs, this.jsonschemaSerializerConfigs, this.protobufSerializerConfigs, this.nullRequestBodyAlwaysPublishEmptyRecord);
            }
            return new SchemaRecordSerializerThrowing();
        }

        public void dispose(SchemaRecordSerializer schemaRecordSerializer) {
        }
    }
}

