/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.AutoValue_AlterConfigCommand_DeleteConfigCommand;
import io.confluent.kafkarest.entities.AutoValue_AlterConfigCommand_UpdateConfigCommand;
import jakarta.annotation.Nullable;
import java.util.Optional;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;

public abstract class AlterConfigCommand {
    private AlterConfigCommand() {
    }

    public static AlterConfigCommand set(String name, @Nullable String value) {
        return UpdateConfigCommand.create(name, value);
    }

    public static AlterConfigCommand delete(String name) {
        return DeleteConfigCommand.create(name);
    }

    public abstract String getName();

    public abstract AlterConfigOp toAlterConfigOp();

    @AutoValue
    static abstract class UpdateConfigCommand
    extends AlterConfigCommand {
        UpdateConfigCommand() {
        }

        abstract Optional<String> getValue();

        private static UpdateConfigCommand create(String name, @Nullable String value) {
            return new AutoValue_AlterConfigCommand_UpdateConfigCommand(name, Optional.ofNullable(value));
        }

        @Override
        public final AlterConfigOp toAlterConfigOp() {
            return new AlterConfigOp(new ConfigEntry(this.getName(), (String)this.getValue().orElse(null)), AlterConfigOp.OpType.SET);
        }
    }

    @AutoValue
    static abstract class DeleteConfigCommand
    extends AlterConfigCommand {
        DeleteConfigCommand() {
        }

        private static DeleteConfigCommand create(String name) {
            return new AutoValue_AlterConfigCommand_DeleteConfigCommand(name);
        }

        @Override
        public final AlterConfigOp toAlterConfigOp() {
            return new AlterConfigOp(new ConfigEntry(this.getName(), null), AlterConfigOp.OpType.DELETE);
        }
    }
}

