/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.Broker;
import io.confluent.kafkarest.entities.Consumer;
import io.confluent.kafkarest.entities.ConsumerGroup;
import java.util.List;

final class AutoValue_ConsumerGroup
extends ConsumerGroup {
    private final String clusterId;
    private final String consumerGroupId;
    private final boolean simple;
    private final String partitionAssignor;
    private final ConsumerGroup.State state;
    private final ConsumerGroup.Type type;
    private final boolean mixedConsumerGroup;
    private final Broker coordinator;
    private final ImmutableList<Consumer> consumers;

    private AutoValue_ConsumerGroup(String clusterId, String consumerGroupId, boolean simple, String partitionAssignor, ConsumerGroup.State state, ConsumerGroup.Type type, boolean mixedConsumerGroup, Broker coordinator, ImmutableList<Consumer> consumers) {
        this.clusterId = clusterId;
        this.consumerGroupId = consumerGroupId;
        this.simple = simple;
        this.partitionAssignor = partitionAssignor;
        this.state = state;
        this.type = type;
        this.mixedConsumerGroup = mixedConsumerGroup;
        this.coordinator = coordinator;
        this.consumers = consumers;
    }

    @Override
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    @Override
    public boolean isSimple() {
        return this.simple;
    }

    @Override
    public String getPartitionAssignor() {
        return this.partitionAssignor;
    }

    @Override
    public ConsumerGroup.State getState() {
        return this.state;
    }

    @Override
    public ConsumerGroup.Type getType() {
        return this.type;
    }

    @Override
    public boolean isMixedConsumerGroup() {
        return this.mixedConsumerGroup;
    }

    @Override
    public Broker getCoordinator() {
        return this.coordinator;
    }

    @Override
    public ImmutableList<Consumer> getConsumers() {
        return this.consumers;
    }

    public String toString() {
        return "ConsumerGroup{clusterId=" + this.clusterId + ", consumerGroupId=" + this.consumerGroupId + ", simple=" + this.simple + ", partitionAssignor=" + this.partitionAssignor + ", state=" + String.valueOf(this.state) + ", type=" + String.valueOf(this.type) + ", mixedConsumerGroup=" + this.mixedConsumerGroup + ", coordinator=" + String.valueOf(this.coordinator) + ", consumers=" + String.valueOf(this.consumers) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ConsumerGroup) {
            ConsumerGroup that = (ConsumerGroup)o;
            return this.clusterId.equals(that.getClusterId()) && this.consumerGroupId.equals(that.getConsumerGroupId()) && this.simple == that.isSimple() && this.partitionAssignor.equals(that.getPartitionAssignor()) && this.state.equals(that.getState()) && this.type.equals(that.getType()) && this.mixedConsumerGroup == that.isMixedConsumerGroup() && this.coordinator.equals(that.getCoordinator()) && this.consumers.equals(that.getConsumers());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.consumerGroupId.hashCode();
        h$ *= 1000003;
        h$ ^= this.simple ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.partitionAssignor.hashCode();
        h$ *= 1000003;
        h$ ^= this.state.hashCode();
        h$ *= 1000003;
        h$ ^= this.type.hashCode();
        h$ *= 1000003;
        h$ ^= this.mixedConsumerGroup ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.coordinator.hashCode();
        h$ *= 1000003;
        return h$ ^= this.consumers.hashCode();
    }

    static final class Builder
    extends ConsumerGroup.Builder {
        private String clusterId;
        private String consumerGroupId;
        private Boolean simple;
        private String partitionAssignor;
        private ConsumerGroup.State state;
        private ConsumerGroup.Type type;
        private Boolean mixedConsumerGroup;
        private Broker coordinator;
        private ImmutableList<Consumer> consumers;

        Builder() {
        }

        @Override
        public ConsumerGroup.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public ConsumerGroup.Builder setConsumerGroupId(String consumerGroupId) {
            if (consumerGroupId == null) {
                throw new NullPointerException("Null consumerGroupId");
            }
            this.consumerGroupId = consumerGroupId;
            return this;
        }

        @Override
        public ConsumerGroup.Builder setSimple(boolean simple) {
            this.simple = simple;
            return this;
        }

        @Override
        public ConsumerGroup.Builder setPartitionAssignor(String partitionAssignor) {
            if (partitionAssignor == null) {
                throw new NullPointerException("Null partitionAssignor");
            }
            this.partitionAssignor = partitionAssignor;
            return this;
        }

        @Override
        public ConsumerGroup.Builder setState(ConsumerGroup.State state) {
            if (state == null) {
                throw new NullPointerException("Null state");
            }
            this.state = state;
            return this;
        }

        @Override
        public ConsumerGroup.Builder setType(ConsumerGroup.Type type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        public ConsumerGroup.Builder setMixedConsumerGroup(boolean mixedConsumerGroup) {
            this.mixedConsumerGroup = mixedConsumerGroup;
            return this;
        }

        @Override
        public ConsumerGroup.Builder setCoordinator(Broker coordinator) {
            if (coordinator == null) {
                throw new NullPointerException("Null coordinator");
            }
            this.coordinator = coordinator;
            return this;
        }

        @Override
        public ConsumerGroup.Builder setConsumers(List<Consumer> consumers) {
            this.consumers = ImmutableList.copyOf(consumers);
            return this;
        }

        @Override
        public ConsumerGroup build() {
            Object missing = "";
            if (this.clusterId == null) {
                missing = (String)missing + " clusterId";
            }
            if (this.consumerGroupId == null) {
                missing = (String)missing + " consumerGroupId";
            }
            if (this.simple == null) {
                missing = (String)missing + " simple";
            }
            if (this.partitionAssignor == null) {
                missing = (String)missing + " partitionAssignor";
            }
            if (this.state == null) {
                missing = (String)missing + " state";
            }
            if (this.type == null) {
                missing = (String)missing + " type";
            }
            if (this.mixedConsumerGroup == null) {
                missing = (String)missing + " mixedConsumerGroup";
            }
            if (this.coordinator == null) {
                missing = (String)missing + " coordinator";
            }
            if (this.consumers == null) {
                missing = (String)missing + " consumers";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_ConsumerGroup(this.clusterId, this.consumerGroupId, this.simple, this.partitionAssignor, this.state, this.type, this.mixedConsumerGroup, this.coordinator, this.consumers);
        }
    }
}

